package com.xdja.ra.ennum;

/**
 * @author: ggp
 * @Date: 2019/10/18 11:24
 * @Description:
 */


public enum UserTypeEnum {

    PERSON_USER(1, "个人用户"),

    ORGAN_USER(2, "机构用户"),

    DEVICE_USER(3, "设备用户");


    public int id;
    public String value;

    UserTypeEnum(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static String getValueFromId(int id) {
        for (UserTypeEnum t : UserTypeEnum.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("UserTypeEnum 枚举转换异常[id=%d]", id));
    }
}
