/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.ra.utils.RFC4519StyleUpperCase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtils {
    private static Logger logger = LoggerFactory.getLogger(CertUtils.class);
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";
    public static final String PUBLIC_KEY_HEAD = "-----BEGIN PUBLIC KEY-----";
    public static final String PUBLIC_KEY_TAIL = "-----END PUBLIC KEY-----";
    private static String provider;

    public static X509Certificate getCertFromStr(String str) {
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        X509Certificate x509Cert = CertUtils.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = CertUtils.getCertFromNormalStr(str);
        }
        if (x509Cert == null) {
            x509Cert = CertUtils.getCertFromStr16(str);
        }
        return x509Cert;
    }

    private static synchronized X509Certificate getCertFromB64(String b64) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", provider);
            byte[] bsCert = Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            logger.error("getCertFromB64 error: {}", (Object)e.toString());
            return null;
        }
    }

    private static synchronized X509Certificate getCertFromStr16(String str) {
        byte[] bs = CertUtils.hex2byte(str);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", provider);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            logger.error("getCertFromFullStr error: {}", (Object)e.toString());
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || "".equals(str)) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static synchronized X509Certificate getCertFromNormalStr(String str) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", provider);
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            logger.error("getCertFromFullStr error: {}", (Object)e.toString());
            return null;
        }
    }

    public static PublicKey convertSM2PublicKey(String base64) throws Exception {
        base64 = base64.replace(PUBLIC_KEY_HEAD, "").replace(PUBLIC_KEY_TAIL, "");
        base64 = base64.replace("\r", "").replace("\n", "");
        base64 = base64.replace("\\r", "").replace("\\n", "");
        int digestLen = 32;
        byte[] b = Base64.decode((String)base64);
        byte[] x = new byte[digestLen];
        System.arraycopy(b, 1, x, 0, digestLen);
        byte[] y = new byte[digestLen];
        System.arraycopy(b, digestLen + 1, y, 0, digestLen);
        return CertUtils.convertSM2PublicKey(x, y);
    }

    public static PublicKey convertSM2PublicKey(byte[] x, byte[] y) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)GMSSLX509Utils.ECC_SM2_NAME);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(curve.createPoint(BigIntegers.fromUnsignedByteArray((byte[])x), BigIntegers.fromUnsignedByteArray((byte[])y)), (ECParameterSpec)ecParameterSpec);
        return new BCECPublicKey(GMSSLX509Utils.ECC_SM2_NAME, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static List<X509Certificate> getCertListFromB64(byte[] info) {
        if (null == info) {
            return null;
        }
        CertificateFactory cf = null;
        List certificates = null;
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(info);
            cf = CertificateFactory.getInstance("X.509", "BC");
            certificates = (List)cf.generateCertificates(inStream);
            if (certificates.size() != 0 && null != certificates) {
                List list = certificates = CertUtils.sortCerts(certificates);
                return list;
            }
            String str = new String(info);
            str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
            str = str.replace("\r", "").replace("\n", "");
            byte[] certByte = Base64.decode((String)(str = str.replace("\\r", "").replace("\\n", "")));
            if (certByte == null || certByte.length == 0) {
                certByte = CertUtils.hex2byte(str);
            }
            if (null != (certificates = (List)cf.generateCertificates(inStream = new ByteArrayInputStream(certByte))) && certificates.size() != 0) {
                List list = certificates = CertUtils.sortCerts(certificates);
                return list;
            }
            List list = certificates;
            return list;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8bc1\u4e66\u5217\u8868\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u8bc1\u4e66\u5217\u8868\u5f02\u5e38");
        }
        finally {
            try {
                if (null != inStream) {
                    ((InputStream)inStream).close();
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u8bc1\u4e66\u5217\u8868\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<java.security.cert.Certificate> getSortCertListFromB64(String b64P7b) {
        InputStream inStream = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.decode((String)b64P7b);
            inStream = new ByteArrayInputStream(bsCert);
            List certificates = (List)cf.generateCertificates(inStream);
            Iterator it = certificates.iterator();
            List<java.security.cert.Certificate> list = new ArrayList();
            while (it.hasNext()) {
                java.security.cert.Certificate elem = (java.security.cert.Certificate)it.next();
                list.add(elem);
            }
            List<java.security.cert.Certificate> list2 = list = CertUtils.sortCerts(list);
            return list2;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6392\u5e8f\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            List<java.security.cert.Certificate> list = null;
            return list;
        }
        finally {
            try {
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static List sortCerts(List certs) {
        int i;
        if (certs.size() < 2) {
            return certs;
        }
        X500Principal issuer = ((X509Certificate)certs.get(0)).getIssuerX500Principal();
        boolean okay = true;
        for (int i2 = 1; i2 != certs.size(); ++i2) {
            X509Certificate cert = (X509Certificate)certs.get(i2);
            if (!issuer.equals(cert.getSubjectX500Principal())) {
                okay = false;
                break;
            }
            issuer = ((X509Certificate)certs.get(i2)).getIssuerX500Principal();
        }
        if (okay) {
            return certs;
        }
        ArrayList<X509Certificate> retList = new ArrayList<X509Certificate>(certs.size());
        ArrayList orig = new ArrayList(certs);
        for (i = 0; i < certs.size(); ++i) {
            X509Certificate cert = (X509Certificate)certs.get(i);
            boolean found = false;
            X500Principal subject = cert.getSubjectX500Principal();
            for (int j = 0; j != certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!c.getIssuerX500Principal().equals(subject)) continue;
                found = true;
                break;
            }
            if (found) continue;
            retList.add(cert);
            certs.remove(i);
        }
        block3: for (i = 0; i != retList.size(); ++i) {
            issuer = ((X509Certificate)retList.get(i)).getIssuerX500Principal();
            for (int j = 0; j < certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!issuer.equals(c.getSubjectX500Principal())) continue;
                retList.add(c);
                certs.remove(j);
                continue block3;
            }
        }
        if (certs.size() > 0) {
            return orig;
        }
        return retList;
    }

    public static List<X509Certificate> getCertListFromP7b(byte[] bytes) {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        try {
            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)bytes);
            ContentInfo contentInfo = new ContentInfo(asn1Sequence);
            SignedData instance = SignedData.getInstance((Object)contentInfo.getContent());
            ASN1Set instanceCertificates = instance.getCertificates();
            Enumeration objects = instanceCertificates.getObjects();
            while (objects.hasMoreElements()) {
                ASN1Encodable o = (ASN1Encodable)objects.nextElement();
                ASN1InputStream inStream = new ASN1InputStream(o.toASN1Primitive().getEncoded());
                CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
                X509Certificate certificate = (X509Certificate)cf.generateCertificate((InputStream)inStream);
                list.add(certificate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        List sortCerts = CertUtils.sortCerts(list);
        return sortCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate convertUploadFileToCert(byte[] certder) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        InputStream inStream = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            inStream = new ByteArrayInputStream(certder);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            if (null != x509Cert) {
                X509Certificate x509Certificate = x509Cert;
                return x509Certificate;
            }
            String str = new String(certder);
            str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
            str = str.replace("\r", "").replace("\n", "");
            x509Cert = CertUtils.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
            if (x509Cert == null) {
                x509Cert = CertUtils.getCertFromStr16(str);
            }
        }
        catch (Exception e) {
            logger.error("\u8bc1\u4e66\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        return x509Cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMPCertificate[] getCMPCert(java.security.cert.Certificate cert) throws CertificateEncodingException, IOException {
        try (ASN1InputStream ins = new ASN1InputStream(cert.getEncoded());){
            CMPCertificate[] res;
            ASN1Primitive pcert = ins.readObject();
            Certificate c = Certificate.getInstance((Object)pcert.toASN1Primitive());
            CMPCertificate[] cMPCertificateArray = res = new CMPCertificate[]{new CMPCertificate(c)};
            return cMPCertificateArray;
        }
    }

    public static String writeObject(Object obj) throws Exception {
        StringWriter stringWriter = new StringWriter();
        GMSSLX509Utils.writePEM((Object)obj, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String getIssuerByX509Cert(X509Certificate cert) {
        X500Name x500Name;
        try {
            byte[] encoded = cert.getTBSCertificate();
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)encoded);
            int seqStart = 0;
            if (!(seq.getObjectAt(0) instanceof ASN1TaggedObject)) {
                seqStart = -1;
            }
            ASN1Encodable objectAt = seq.getObjectAt(seqStart + 3);
            x500Name = X500Name.getInstance((X500NameStyle)com.xdja.pki.ra.core.util.cert.RFC4519StyleUpperCase.INSTANCE, (Object)objectAt.toASN1Primitive());
        }
        catch (CertificateEncodingException e) {
            logger.error("\u4ecex509\u8bc1\u4e66\u4e2d\u83b7\u53d6\u7b7e\u53d1\u8005DN\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return x500Name.toString();
    }

    public static String getSubjectByX509Cert(X509Certificate x509Certificate) throws NamingException {
        X500Name x500Name;
        try {
            byte[] encoded = x509Certificate.getTBSCertificate();
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)encoded);
            int seqStart = 0;
            if (!(seq.getObjectAt(0) instanceof ASN1TaggedObject)) {
                seqStart = -1;
            }
            ASN1Encodable objectAt = seq.getObjectAt(seqStart + 5);
            x500Name = X500Name.getInstance((X500NameStyle)RFC4519StyleUpperCase.INSTANCE, (Object)objectAt.toASN1Primitive());
        }
        catch (CertificateEncodingException e) {
            logger.error("\u4ecex509\u8bc1\u4e66\u4e2d\u83b7\u53d6\u4f7f\u7528\u8005DN\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return x500Name.toString();
    }

    public static byte[] writeObjectToByteArray(X509Certificate certificate) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        GMSSLX509Utils.writePEM((Object)certificate, (Writer)outputStreamWriter);
        return byteArrayOutputStream.toByteArray();
    }

    public static int getPublicKeyLength(byte[] base64CertBytes) throws Exception {
        X509Certificate certificate = CertUtils.getCertFromStr(new String(base64CertBytes));
        PublicKey publicKey = null;
        if (null == certificate) {
            throw new Exception();
        }
        publicKey = certificate.getPublicKey();
        KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
        String algorithm = certificate.getPublicKey().getAlgorithm();
        if ("RSA".equalsIgnoreCase(algorithm)) {
            RSAPublicKeySpec keySpec = keyFactory.getKeySpec(certificate.getPublicKey(), RSAPublicKeySpec.class);
            BigInteger modulus = keySpec.getModulus();
            return modulus.bitLength();
        }
        if ("EC".equalsIgnoreCase(algorithm)) {
            return 256;
        }
        throw new Exception();
    }

    public static int getPublicKeyLength(X509Certificate certificate) throws Exception {
        byte[] bytes = CertUtils.writeObjectToByteArray(certificate);
        return CertUtils.getPublicKeyLength(bytes);
    }

    static {
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        provider = bouncyCastleProvider.getName();
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362\u516c\u94a5\u5f02\u5e38", (Throwable)e);
        }
    }
}

