package com.xdja.ra.bean;

/**
 * KeyStore配置类
 * @author syg
 *
 */
public class KeyStoreConfig {

	/**
	 * 客户端证书keyStore保存路径
	 */
	private String clientKeyStorePath;
	/**
	 * 客户端证书keyStore文件密码
	 */
	private String clientKeyStorePwd;
	/**
	 * 信任证书keyStore保存路径
	 */
	private String trustKeyStorePath;
	/**
	 * 信任证书keyStore文件密码
	 */
	private String trustKeyStorePwd;

	public String getClientKeyStorePath() {
		return clientKeyStorePath;
	}

	public KeyStoreConfig() {
	}

	public KeyStoreConfig(String clientKeyStorePath, String clientKeyStorePwd, String trustKeyStorePath, String trustKeyStorePwd) {
		this.clientKeyStorePath = clientKeyStorePath;
		this.clientKeyStorePwd = clientKeyStorePwd;
		this.trustKeyStorePath = trustKeyStorePath;
		this.trustKeyStorePwd = trustKeyStorePwd;
	}

	public void setClientKeyStorePath(String clientKeyStorePath) {
		this.clientKeyStorePath = clientKeyStorePath;
	}

	public String getClientKeyStorePwd() {
		return clientKeyStorePwd;
	}

	public void setClientKeyStorePwd(String clientKeyStorePwd) {
		this.clientKeyStorePwd = clientKeyStorePwd;
	}

	public String getTrustKeyStorePath() {
		return trustKeyStorePath;
	}

	public void setTrustKeyStorePath(String trustKeyStorePath) {
		this.trustKeyStorePath = trustKeyStorePath;
	}

	public String getTrustKeyStorePwd() {
		return trustKeyStorePwd;
	}

	public void setTrustKeyStorePwd(String trustKeyStorePwd) {
		this.trustKeyStorePwd = trustKeyStorePwd;
	}

	@Override
	public String toString() {
		return "ClientKeyStoreConfig{" +
				"clientKeyStorePath='" + clientKeyStorePath + '\'' +
				", clientKeyStorePwd='" + clientKeyStorePwd + '\'' +
				", trustKeyStorePath='" + trustKeyStorePath + '\'' +
				", trustKeyStorePwd='" + trustKeyStorePwd + '\'' +
				'}';
	}
}
