package com.xdja.ra.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.ra.asn1.RsaObjectIdentifiers;
import com.xdja.ra.asn1.SM2ObjectIdentifiers;

import java.security.PublicKey;
import java.security.cert.X509Certificate;

/**
 * @author wly
 */
public class SdkBCUtils {

    /**
     * BC证书链验签
     *
     * @param protectionAlgId 保护密钥算法oid
     * @param publicKey
     * @param sourceData
     * @param signData
     * @return
     * @throws Exception
     */
    public static boolean verifyCertByBC(String protectionAlgId, PublicKey publicKey, byte[] sourceData, byte[] signData) throws Exception {
        boolean verifyResult = false;
        if (SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLSM2SignUtils.verifyByBC(publicKey, sourceData, signData);
        } else if (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC(GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), publicKey, sourceData, signData);
        } else if (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC(GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), publicKey, sourceData, signData);
        }else {
            verifyResult =  GMSSLBCSignUtils.verifySignature(GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), publicKey, sourceData, signData);

        }

        return verifyResult;
    }

    /**
     * 验证证书通过BC
     * @param cert      待验证证书
     * @param publicKey 上级CA证书公钥
     * @return boolean
     * @throws Exception 异常
     */
    public static boolean verifyCertByBC(X509Certificate cert, PublicKey publicKey) throws Exception {
        String sigAlgOID = cert.getSigAlgOID();
        boolean verifyResult = false;
        if (SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLSM2SignUtils.verifyByBC(publicKey, cert.getTBSCertificate(), cert.getSignature());
        } else if (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC(GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), publicKey, cert.getTBSCertificate(), cert.getSignature());
        } else if (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC(GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), publicKey, cert.getTBSCertificate(), cert.getSignature());
        } else {
            verifyResult =  GMSSLBCSignUtils.verifySignature(GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), publicKey, cert.getTBSCertificate(), cert.getSignature());
        }
        return verifyResult;
    }
}
