package com.xdja.pki.ra.service.manager.AkService;

import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.core.util.cert.Asn1Util;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.P10Utils;
import com.xdja.pki.ra.manager.dao.*;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.*;
import com.xdja.pki.ra.service.manager.CommonService;
import com.xdja.pki.ra.service.manager.ak.AkService;
import com.xdja.pki.ra.service.manager.ak.xml.common.*;
import com.xdja.pki.ra.service.manager.ak.xml.request.*;
import com.xdja.pki.ra.service.manager.ak.xml.request.vo.*;
import com.xdja.pki.ra.service.manager.ak.xml.response.vo.*;
import com.xdja.pki.ra.service.manager.certapply.*;
import com.xdja.pki.ra.service.manager.certapply.bean.DoubleCode;
import com.xdja.pki.ra.service.manager.personuser.PersonUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.security.PublicKey;
import java.security.cert.X509Certificate;


/**
 * @Author:ggp
 * @Date:2020-08-24 09:19
 * @Description:
 */
@Service
public class AkServiceImpl implements AkService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SUCCESS_CODE = "0X00000000";

    @Autowired
    private PersonUserService personUserService;

    @Autowired
    private CertTempDao certTempDao;

    @Autowired
    private IssueApplyService issueApplyService;

    @Autowired
    private CommonService commonService;

    @Autowired
    private DoubleCodeDao doubleCodeDao;

    @Autowired
    private CertApplyService certApplyService;

    @Autowired
    private UpdateApplyService updateApplyService;

    @Autowired
    private RevokeApplyService revokeApplyService;

    @Autowired
    private RecoveryApplyService recoveryApplyService;

    @Autowired
    private UserCertDao userCertDao;

    @Autowired
    private CertApplyDao certApplyDao;

    @Autowired
    private BaseUserDao baseUserDao;
    /**
     * 用户注册
     *
     * @param userRegisterReq
     * @return
     */
    @Override
    public Result userRegister(UserRegisterReq userRegisterReq) {
        UserRegisterReqVO reqVO = userRegisterReq.getDatagram().getBody().getConfiguration();
        PersonUserDTO personUserDTO = new PersonUserDTO();
        String userID = String.valueOf(System.nanoTime());
        personUserDTO.setSystemFlag("V2X");
        personUserDTO.setPersonName(reqVO.getUsername());
        personUserDTO.setAddress(reqVO.getAddress());
        personUserDTO.setEmail(reqVO.getEmail());
        personUserDTO.setRemark(reqVO.getRemark());
        personUserDTO.setLicenseType(4);
        personUserDTO.setLicenseNumber(userID);
        Result result = personUserService.savePersonUser(personUserDTO);
        if(!result.isSuccess()){
            logger.error(result.getErrorBean().toString());
            return result;
        }
        UserRegisterRespVO respVO = new UserRegisterRespVO();
        respVO.setUserID(userID);
        ResponseHead responseHead = this.buildHead(userRegisterReq, "User register succeed", true);
        Response<UserRegisterRespVO> resp = new Response(new ResponseDatagram(responseHead, new ResponseBody(respVO)), userRegisterReq.getSignature());
        return Result.success(resp);
    }

    /**
     * 证书申请
     *
     * @param certApplyReq
     * @return
     */
    @Override
    public Result certApply(CertApplyReq certApplyReq) {
        CertApplyReqVO reqVO = certApplyReq.getDatagram().getBody().getConfiguration();
        IssueApplyDTO issueApplyDTO = new IssueApplyDTO();
        issueApplyDTO.setUserId(baseUserDao.getUserId(1,"V2X",4,reqVO.getUserID()));
        issueApplyDTO.setUserType(UserTypeEnum.PERSON_USER.id);
        issueApplyDTO.setLicenseType(4);
        issueApplyDTO.setLicenseNumber(reqVO.getUserID());
        issueApplyDTO.setTempNo(reqVO.getTemplateName());
        issueApplyDTO.setCertDn(reqVO.getCertDN());
        issueApplyDTO.setCertValidity(reqVO.getCertValidLength().intValue());
        CertTempDO certTempDO = certTempDao.getCertTempInfoByTempNo(issueApplyDTO.getTempNo());
        issueApplyDTO.setSignAlg(certTempDO.getSignAlg());
        issueApplyDTO.setPrivateKeyLength(certTempDO.getPrivateKeyLength());
        Result result = issueApplyService.insertUserCertIssueApply("V2X",issueApplyDTO,true,true);
        if(!result.isSuccess()){
            logger.error(result.getErrorBean().toString());
            return result;
        }
        DoubleCode doubleCode = commonService.createDoubleCode(result.getInfo().toString());
        CertApplyRespVO respVO = new CertApplyRespVO();
        respVO.setRefNO(doubleCode.getRefCode());
        respVO.setAuthCode(doubleCode.getAuthCode());
        ResponseHead responseHead = this.buildHead(certApplyReq, "Cert request succeed", true);
        Response<UserRegisterRespVO> resp = new Response(new ResponseDatagram(responseHead, new ResponseBody(respVO)), certApplyReq.getSignature());
        return Result.success(resp);
    }

    /**
     * 证书下载
     *
     * @param certDownReq
     * @return
     */
    @Override
    public Result certDown(CertDownReq certDownReq) {
        CertDownReqVO certDownReqVO = certDownReq.getDatagram().getBody().getConfiguration();
        PublicKey publicKey = P10Utils.p10ToPublicKey(certDownReqVO.getP10Cert());
        String applyNo = certDownReqVO.getAuthCode();
        CertApplyDO certApplyDO = certApplyDao.getCertApplyInfo(applyNo);
        Result result = certApplyService.issueUserCert(null,null,4,certApplyDO.getApplyType(),applyNo,"V2X",null,publicKey.getEncoded(),2,true,false,null,null);
        if(!result.isSuccess()){
            logger.error(result.getErrorBean().toString());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)result.getInfo();
        Certificate certificate = new Certificate();
        certificate.setCertType("env");
        try {
            String signCert = userCertInfo.getSignCert();
            String encCert = userCertInfo.getEncCert();
            certificate.setSignCert(CertUtils.writeObject(CertUtils.getCertFromStr(signCert)));
            certificate.setEncCert(CertUtils.writeObject(CertUtils.getCertFromStr(encCert)));
            certificate.setEnvelope(Asn1Util.convertSignDataEnvelop2Sm2Envelop(userCertInfo.getEncPriKey(),CertUtils.getCertFromStr(encCert).getPublicKey()));
        } catch (Exception e) {
            e.printStackTrace();
        }
        /**
         * 证书确认
         */
        certApplyService.issueUserCertResp(applyNo,"V2X",true);
        /**
         * 让两码失效
         */
        doubleCodeDao.updateStatus(certDownReqVO.getAuthCode());
        CertDownRespVO certDownRespVO = new CertDownRespVO(certificate);
        ResponseHead responseHead = this.buildHead(certDownReq, "Certificate download succeed", true);
        Response<CertDownRespVO> resp = new Response(new ResponseDatagram(responseHead, new ResponseBody(certDownRespVO)), certDownReq.getSignature());
        return Result.success(resp);
    }

    /**
     * 证书更新
     *
     * @param certUpdateReq
     * @return
     */
    @Override
    public Result certUpdate(CertUpdateReq certUpdateReq) {
        CertUpdateReqVO certUpdateReqVO = certUpdateReq.getDatagram().getBody().getConfiguration();
        UpdateApplyDTO updateApplyDTO = new UpdateApplyDTO();
        updateApplyDTO.setUpdateKey(true);
        updateApplyDTO.setUpdateValidity(true);
        updateApplyDTO.setSignSn(certUpdateReqVO.getCertSN());
        UserCertDO userCert = userCertDao.getUserCertBaseInfo(certUpdateReqVO.getCertSN());
        updateApplyDTO.setUserId(userCert.getUserId());
        updateApplyDTO.setTempNo(userCert.getTempNo());
        updateApplyDTO.setCertDn(userCert.getCertDn());
        updateApplyDTO.setCertValidity(Integer.valueOf(certUpdateReqVO.getCertValidLength()));
        CertTempDO certTempDO = certTempDao.getCertTempInfoByTempNo(updateApplyDTO.getTempNo());
        updateApplyDTO.setPrivateKeyLength(certTempDO.getPrivateKeyLength());
        updateApplyDTO.setSignAlg(certTempDO.getSignAlg());
        updateApplyDTO.setEncSn(userCertDao.getEncSnBySignSn(certUpdateReqVO.getCertSN()));
        Result result = updateApplyService.insertUserCertUpdateApply("V2X",updateApplyDTO,true,true);
        if(!result.isSuccess()){
            logger.error(result.getErrorBean().toString());
            return result;
        }
        CertApplyRespVO respVO = new CertApplyRespVO();
        DoubleCode doubleCode = commonService.createDoubleCode(result.getInfo().toString());
        respVO.setRefNO(doubleCode.getRefCode());
        respVO.setAuthCode(doubleCode.getAuthCode());
        ResponseHead responseHead = this.buildHead(certUpdateReq, "Cert update succeed", true);
        Response<UserRegisterRespVO> resp = new Response(new ResponseDatagram(responseHead, new ResponseBody(respVO)), certUpdateReq.getSignature());
        return Result.success(resp);
    }

    /**
     * 证书撤销
     *
     * @param certRevokeReq
     * @return
     */
    @Override
    public Result certRevoke(CertRevokeReq certRevokeReq) {
        CertRevokeReqVO certRevokeReqVO = certRevokeReq.getDatagram().getBody().getConfiguration();
        String signSn = certRevokeReqVO.getCertSN();
        RevokeApplyDTO revokeApplyDTO = new RevokeApplyDTO();
        revokeApplyDTO.setSignSn(certRevokeReqVO.getCertSN());
        revokeApplyDTO.setRevokeReason(Integer.valueOf(certRevokeReqVO.getRevokeReason().substring(2),16));
        UserCertDO userCertDO = userCertDao.getUserCertBaseInfo(signSn);
        revokeApplyDTO.setUserId(userCertDO.getUserId());
        revokeApplyDTO.setTempNo(userCertDO.getTempNo());
        CertTempDO certTempInfo = certTempDao.getCertTempInfoByTempNo(revokeApplyDTO.getTempNo());
        revokeApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength());
        revokeApplyDTO.setSignAlg(certTempInfo.getSignAlg());

        String encSn = userCertDao.getEncSnBySignSn(signSn);
        revokeApplyDTO.setEncSn(encSn == null ? "" : encSn);
        Result result = revokeApplyService.insertUserCertRevokeApply("V2X", revokeApplyDTO, true, true);
        if(!result.isSuccess()){
            logger.error(result.getErrorBean().toString());
            return result;
        }
        ResponseHead responseHead = this.buildHead(certRevokeReq, "Cert Revoke succeed", true);
        Response<UserRegisterRespVO> resp = new Response(new ResponseDatagram(responseHead, new ResponseBody(new CertRevokeRespVO())), certRevokeReq.getSignature());
        return Result.success(resp);
    }

    /**
     * 秘钥恢复
     *
     * @param keyRestoreReq
     * @return
     */
    @Override
    public Result keyRestore(KeyRestoreReq keyRestoreReq) {
        KeyRestoreReqVO keyRestoreReqVO = keyRestoreReq.getDatagram().getBody().getConfiguration();
        RecoveryApplyDTO recoveryApplyDTO = new RecoveryApplyDTO();
        /**
         * 恢复申请
         */
        String signSn = keyRestoreReqVO.getCertSN();
        recoveryApplyDTO.setSignSn(signSn);
        UserCertDO userCertDO = userCertDao.getUserCertBaseInfo(signSn);
        recoveryApplyDTO.setUserId(userCertDO.getUserId());
        recoveryApplyDTO.setTempNo(userCertDO.getTempNo());
        CertTempDO certTempInfo = certTempDao.getCertTempInfoByTempNo(recoveryApplyDTO.getTempNo());
        recoveryApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength());
        recoveryApplyDTO.setSignAlg(certTempInfo.getSignAlg());
        String encSn = userCertDao.getEncSnBySignSn(signSn);
        recoveryApplyDTO.setEncSn(encSn == null ? "" : encSn);
        Result result = recoveryApplyService.insertUserCertRecoveryApply("V2X", recoveryApplyDTO, true);
        if(!result.isSuccess()){
            logger.error(result.getErrorBean().toString());
            return result;
        }
        /**
         * 制证
         */
        PublicKey publicKey = P10Utils.p10ToPublicKey(keyRestoreReqVO.getP10Cert());
        String applyNo = result.getInfo().toString();
        result = certApplyService.issueUserCert(null,null,4,ApplyTypeEnum.RECOVERY_APPLY.id,applyNo,"V2X",null,publicKey.getEncoded(),2,true,false,null,null);
        if(!result.isSuccess()){
            logger.error(result.getErrorBean().toString());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)result.getInfo();
        Restore certificate = new Restore();
        certificate.setCertType("env");
        try {
            String encCert = userCertInfo.getEncCert();
            certificate.setEncCert(CertUtils.writeObject(CertUtils.getCertFromStr(encCert)));
            certificate.setEnvelope(Asn1Util.convertSignDataEnvelop2Sm2Envelop(userCertInfo.getEncPriKey(),CertUtils.getCertFromStr(encCert).getPublicKey()));
        } catch (Exception e) {
            e.printStackTrace();
        }
        /**
         * 证书确认
         */
        certApplyService.issueUserCertResp(applyNo,"V2X",true);
        KeyRestoreRespVO keyRestoreRespVO = new KeyRestoreRespVO(certificate);
        ResponseHead responseHead = this.buildHead(keyRestoreReq, "Key restore succeed", true);
        Response<CertDownRespVO> resp = new Response(new ResponseDatagram(responseHead, new ResponseBody(keyRestoreRespVO)), keyRestoreReq.getSignature());
        return Result.success(resp);
    }
    private ResponseHead buildHead(Request request, String message, boolean isSuccess) {
        RequestHead requestHead = request.getDatagram().getHead();
        ResponseHead responseHead = new ResponseHead();
        responseHead.setVersion(requestHead.getVersion());
        responseHead.setMethod(requestHead.getMethod());
        responseHead.setTransactionCode(requestHead.getTransactionCode());
        if (isSuccess) {
            responseHead.setErrorCode(SUCCESS_CODE);
            responseHead.setErrorMessage(message);
        }
        return responseHead;
    }
}
