package com.xdja.pki.ra.service.manager;

import com.xdja.pki.ra.core.commonenum.DoubleCodeUseEnum;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.DoubleCodeDao;
import com.xdja.pki.ra.manager.dao.model.DoubleCodeDO;
import com.xdja.pki.ra.service.manager.certapply.bean.DoubleCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author: ggp
 * @Date: 2019/10/31 16:44
 * @Description:
 */
@Service
public class CommonServcieImpl implements CommonService {

    @Autowired
    private DoubleCodeDao doubleCodeDao;

    @Autowired
    private CertApplyDao certApplyDao;
    /**
     * 生成两码
     *
     * @param applyNo
     * @return
     */
    @Override
    public DoubleCode createDoubleCode(String applyNo) {
        DoubleCode doubleCode = new DoubleCode();
        Long userId = certApplyDao.getUserIdByApplyNo(applyNo);
        doubleCode.setRefCode(String.valueOf(userId));
        doubleCode.setAuthCode(applyNo);
        /**
         * 存库
         */
        DoubleCodeDO doubleCodeDO = new DoubleCodeDO();
        doubleCodeDO.setRefCode(userId);
        doubleCodeDO.setAuthCode(applyNo);
        doubleCodeDO.setIsUse(DoubleCodeUseEnum.NOT_USE.id);
        doubleCodeDao.InsertDouble(doubleCodeDO);
        return doubleCode;
    }

    @Override
    public DoubleCode createDoubleCode(String applyNo, Long userId) {
        DoubleCodeDO doubleCodeDO = new DoubleCodeDO();
        doubleCodeDO.setRefCode(userId);
        doubleCodeDO.setAuthCode(applyNo);
        doubleCodeDO.setIsUse(DoubleCodeUseEnum.NOT_USE.id);
        doubleCodeDao.InsertDouble(doubleCodeDO);
        
        DoubleCode doubleCode = new DoubleCode();
        doubleCode.setRefCode(String.valueOf(userId));
        doubleCode.setAuthCode(applyNo);
        return doubleCode;
    }
}
