package com.xdja.pki.ra.service.manager;

import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.service.manager.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.File;

/**
 * 加载数据库配置文件
 *
 * @author wly
 */
@Configuration
public class ConfigFileData {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    SystemService systemService;

    @Bean
    public Config configFile(){
        try {
            /**
             * 从数据库获取配置文件内容
             */
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                /**
                 *  迭代升级 读取服务器配置文件
                 */
                config = Config.getConfig(PathConstants.GLOBAL_CONF_FILE_PATH);
                String content = FileUtils.read(PathConstants.DEFAULT_CONTAINER_PATH);
                config.setDefaultContainer(content.substring(21,content.length()-2));

                config.setRaBaseDn("");
//                FileUtils.deleteFile(new File(PathConstants.DEFAULT_CONTAINER_PATH));
//                FileUtils.deleteFile(new File(PathConstants.GLOBAL_CONF_FILE_PATH));
                /**
                 * 存库
                 */
                systemService.saveConfigFile(config);
            }
            logger.info("系统启动加载config.json配置文件" + config);
            return config;
        } catch (Exception e) {
            logger.error("加载config.json配置文件失败", e);
        }
        return null;
    }
}
