package com.xdja.pki.ra.service.manager.auditlog;

import com.xdja.pki.dynamic.task.CronTaskRegistrar;
import com.xdja.pki.dynamic.task.SchedulingRunnable;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.ArchiveConfigBean;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.ra.service.manager.system.bean.ArchiveConfigVO;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @ClassName: ArchiveConfigServiceImpl class
 * @Description: 审计参数服务类
 * @Author: songxuetao
 * @Modifiedby:
 **/
@Service
public class ArchiveConfigServiceImpl implements ArchiveConfigService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    SystemService systemService;

    @Autowired
    private CronTaskRegistrar cronTaskRegistrar;

    @Override
    public Result getArchiveConfig() {
        Result result = new Result();
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            }
            ArchiveConfigBean archiveConfigBean = config.getArchiveConfigBean();
            if(null == archiveConfigBean){
                ArchiveConfigBean archiveConfig = new ArchiveConfigBean();
                config.setArchiveConfigBean(archiveConfig);
                systemService.updateConfigFile(config);
            }
            result.setInfo(archiveConfigBean);
            return result;
        }catch (Exception e){
            logger.error("获取 审计参数 异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
    }

    @Override
    public Result saveArchiveConfig(ArchiveConfigVO archiveConfigVO) {
        Result result = new Result();
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            }
            ArchiveConfigBean archiveConfigBean = config.getArchiveConfigBean();

            BeanUtils.copyProperties(archiveConfigVO, archiveConfigBean);
            config.setArchiveConfigBean(archiveConfigBean);
            systemService.updateConfigFile(config);
            //添加缓存
            CommonVariable.setArchiveConfig(archiveConfigBean);
            //根据配置信息设置定时任务或取消
            if (archiveConfigBean.getAutoArchiveFlag().intValue() == 1) {
                logger.debug("自动归档定时任务设定：" + archiveConfigBean.toCNString());
                //删除已存在的定时任务
                Runnable runnable = new SchedulingRunnable("auditLogServiceImpl", "doAutoArchiveOperateLog");
                cronTaskRegistrar.removeCronTask(runnable);
                //重新设定新的定时任务
                cronTaskRegistrar.addCronTask(new SchedulingRunnable("auditLogServiceImpl", "doAutoArchiveOperateLog"), archiveConfigBean.getAutoArchiveCron());
            }
            if (archiveConfigBean.getAutoArchiveFlag().intValue() == 0) {
                logger.debug("自动归档定时任务设定：" + archiveConfigBean.toCNString());
                Runnable runnable = new SchedulingRunnable("auditLogServiceImpl", "doAutoArchiveOperateLog");
                cronTaskRegistrar.removeCronTask(runnable);
            }
            return Result.success();
        }catch (Exception e){
            logger.error("保存 审计参数 异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
    }
}
