package com.xdja.pki.ra.service.manager.auditlog;


import com.xdja.pki.auditlog.dao.AuditorOperateLogDao;
import com.xdja.pki.auditlog.dao.model.AuditorOperateLogDO;
import com.xdja.pki.auditlog.service.AuditorOperateLogService;
import com.xdja.pki.auditlog.service.bean.AuditorOperateLogListVO;
import com.xdja.pki.auditlog.service.bean.AuditorOperateLogResultEnum;
import com.xdja.pki.auditlog.service.bean.AuditorOperateLogVO;
import com.xdja.pki.auditlog.service.bean.AuditorOperateTypeEnum;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.ra.security.bean.Operator;
import com.xdja.pki.ra.security.util.OperatorUtil;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: AuditorOperateLogServiceImpl class
 * @Description: 审计员操作日志业务实现类
 * @Author: songxuetao
 **/
@Service
public class AuditorOperateLogServiceImpl implements AuditorOperateLogService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Resource
    private AuditorOperateLogDao auditorOperateLogDao;

    @Override
    public boolean saveAuditorOperateLog(int auditType, String auditContext, int auditResult) {
        AuditorOperateLogDO auditorOperateLogDO = new AuditorOperateLogDO();
        Operator operator = OperatorUtil.getOperator();
        CurrentAdminInfo currUser = operator.getCurrUser();
        //审计员证书主体DN
        auditorOperateLogDO.setAuditSubject(currUser.getCertDn());
        //审计员证书序列号SN
        auditorOperateLogDO.setAuditSn(currUser.getCertSn());
        //操作员证书ID
        auditorOperateLogDO.setAuditCertId(currUser.getId());
        logger.info("存库时审计操作者证书ID{}",currUser.getCertSn());
        //操作时间
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        String format = sdf.format(new Date());
        try {
            Date date = sdf.parse(format);
            auditorOperateLogDO.setAuditTime(date);
        } catch (ParseException e) {
            logger.error("时间转换异常", e);
            return false;
        }
        //审计操作类型
        auditorOperateLogDO.setAuditType(String.valueOf(auditType));
        //审计者ip
        auditorOperateLogDO.setAuditClientIp(currUser.getClientIpAddress());
        //审计内容原文
        auditorOperateLogDO.setAuditContent(auditContext);
        //审计操作结果
        auditorOperateLogDO.setAuditResult(auditResult);
        AuditorOperateLogDO backAuditorOperateLogDO = auditorOperateLogDao.save(auditorOperateLogDO);
        if(backAuditorOperateLogDO == null){
            return false;
        }
        return true;
    }

    @Override
    public Object listAuditorOperateLog(Integer pageNo, Integer pageSize, String auditSubject, Integer auditType, String startTime, String endTime, boolean isExport) {
        if(isExport){
            List<AuditorOperateLogDO> auditorOperateLogDOS = (List<AuditorOperateLogDO>)auditorOperateLogDao.listAuditorOperateLog(pageNo, pageSize, auditSubject, auditType, startTime, endTime, isExport);
            return generateListVO(auditorOperateLogDOS);
         } else {
            PageInfo pageInfo = (PageInfo)auditorOperateLogDao.listAuditorOperateLog(pageNo, pageSize, auditSubject, auditType, startTime, endTime, isExport);
            pageInfo.setDatas(generateListVO((List<AuditorOperateLogDO>)pageInfo.getDatas()));
            return pageInfo;
        }
    }

    /**
     * @MethodName: generateListVO
     * @Description: 组装Excel列表数据
     * @Param: auditorOperateLogDOS
     * @Return: java.util.List<com.xdja.pki.ca.securityaudit.service.bean.AuditorOperateLogListVO>
     * @Author: songxuetao
    **/
    private List<AuditorOperateLogListVO> generateListVO(List<AuditorOperateLogDO> auditorOperateLogDOS) {
        List<AuditorOperateLogListVO> auditorOperateLogList = new ArrayList<>();
        for(AuditorOperateLogDO auditorOperateLogDO : auditorOperateLogDOS){
            AuditorOperateLogListVO auditorOperateLogVO = new AuditorOperateLogListVO();
            auditorOperateLogVO.setId(auditorOperateLogDO.getId());
            auditorOperateLogVO.setAuditSubject(auditorOperateLogDO.getAuditSubject());
            auditorOperateLogVO.setAuditType(auditorOperateLogDO.getAuditType());
            auditorOperateLogVO.setAuditTypeString(AuditorOperateTypeEnum.getDescFromType(auditorOperateLogDO.getAuditType()));
            auditorOperateLogVO.setAuditClientIp(auditorOperateLogDO.getAuditClientIp());
            auditorOperateLogVO.setAuditTime(sdf.format(auditorOperateLogDO.getAuditTime()));
            auditorOperateLogVO.setAuditResult(auditorOperateLogDO.getAuditResult());
            auditorOperateLogVO.setAuditResultString(AuditorOperateLogResultEnum.getValueFromId(auditorOperateLogDO.getAuditResult().intValue()));
            auditorOperateLogList.add(auditorOperateLogVO);
        }
        return auditorOperateLogList;
    }

    @Override
    public Object getAuditorOperateLogById(int id) {
        AuditorOperateLogDO auditorOperateLogDO = auditorOperateLogDao.get(id);
        AuditorOperateLogVO auditorOperateLogVO = new AuditorOperateLogVO();
        auditorOperateLogVO.setId(auditorOperateLogDO.getId());
        auditorOperateLogVO.setAuditSubject(auditorOperateLogDO.getAuditSubject());
        auditorOperateLogVO.setAuditSn(auditorOperateLogDO.getAuditSn());
        auditorOperateLogVO.setAuditCertId(auditorOperateLogDO.getAuditCertId());
        auditorOperateLogVO.setAuditType(auditorOperateLogDO.getAuditType());
        auditorOperateLogVO.setAuditTypeString(AuditorOperateTypeEnum.getDescFromType(auditorOperateLogDO.getAuditType()));
        auditorOperateLogVO.setAuditClientIp(auditorOperateLogDO.getAuditClientIp());
        auditorOperateLogVO.setAuditContent(auditorOperateLogDO.getAuditContent());
        auditorOperateLogVO.setAuditResult(auditorOperateLogDO.getAuditResult());
        auditorOperateLogVO.setAuditResultString(AuditorOperateLogResultEnum.getValueFromId(auditorOperateLogDO.getAuditResult().intValue()));
        auditorOperateLogVO.setAuditTime(sdf.format(auditorOperateLogDO.getAuditTime()));
        return auditorOperateLogVO;
    }
}
