package com.xdja.pki.ra.service.manager.baseuser;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.manager.dao.ContactUserDao;
import com.xdja.pki.ra.manager.dao.model.ContactUserDO;
import com.xdja.pki.ra.service.manager.contactuser.ContactUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author wly
 */
@Service
public class ContactUserServiceImpl implements ContactUserService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    ContactUserDao contactUserDao;

    /**
     * 查询contact_user表
     * @param userId
     * @return
     */
    @Override
    public Result getContactUser(Long userId) {
        Result result = new Result();

        ContactUserDO contactUserDO;
        try {
            contactUserDO = contactUserDao.getContactUser(userId);
        }catch (Exception e){
            logger.info("获取联系人表信息异常");
            result.setError(ErrorEnum.GET_CONTACT_USER_INFO_EXCEPTION);
            return result;
        }
        if (contactUserDO == null){
            logger.info("获取contact_user用户表信息为空");
            result.setError(ErrorEnum.GET_CONTACT_USER_INFO_IS_EMPTY);
        }
        result.setInfo(contactUserDO);
        return result;
    }
}
