package com.xdja.pki.ra.service.manager.baseuser;


import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.UserStatusEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.ContactUserDao;
import com.xdja.pki.ra.manager.dao.CustomerDao;
import com.xdja.pki.ra.manager.dao.DeviceUserDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.ContactUserDO;
import com.xdja.pki.ra.manager.dao.model.DeviceUserDO;
import com.xdja.pki.ra.manager.dto.DeviceUserDTO;
import com.xdja.pki.ra.manager.dto.DeviceUserDetailsDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.service.manager.customer.CustomerSysService;
import com.xdja.pki.ra.service.manager.deviceuser.DeviceUserService;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserResp;
import com.xdja.pki.ra.core.util.file.ErrorExcel;
import com.xdja.pki.ra.service.manager.deviceuser.bean.*;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.baseuser.bean.EncryptUserInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.xdja.pki.ra.service.manager.baseuser.bean.EncryptUserInfo.getEncryptString;

/**
 * 设备用户实现类
 *
 * @author cl
 */
@Service
public class DeviceUserServiceImpl implements DeviceUserService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    DeviceUserDao deviceUserDao;

    @Autowired
    BaseUserDao baseUserDao;

    @Autowired
    ContactUserDao contactUserDao;

    @Autowired
    CustomerDao customerDao;

    @Autowired
    CustomerSysService customerSysService;

    @Autowired
    BaseUserService baseUserService;

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public Result registerDeviceUser(DeviceUserInfo deviceUserInfo, UserInfo userInfo, boolean isV2X) {
        Result result = new Result();
        try {
            if(!isV2X) {
                /**
                 * 判断系统标识是否存在
                 */
                result = customerSysService.verifyUserSystemFlag(deviceUserInfo.getSystemFlag());
                if (!result.isSuccess()) {
                    return result;
                }

                //查看设备是否存在
                int count = baseUserService.queryUserExist(deviceUserInfo.getLicenseType(), deviceUserInfo.getLicenseNumber(), UserTypeEnum.DEVICE_USER.id, deviceUserInfo.getSystemFlag());
                if (count > 0) {
                    result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                    return result;
                }
            }
            Date date = new Date(System.currentTimeMillis());
            Timestamp time = new Timestamp(date.getTime());
            BaseUserDO baseUserDO = new BaseUserDO();
            BeanUtils.copyProperties(userInfo, baseUserDO);
            BeanUtils.copyProperties(deviceUserInfo, baseUserDO);
            baseUserDO.setGmtCreate(time);
            baseUserDO.setGmtUpdate(time);
            baseUserDO.setSystemFlag(deviceUserInfo.getSystemFlag());
            baseUserDO = EncryptUserInfo.getEncryptBaseUserDO(baseUserDO);
            BaseUserDO baseUser = baseUserDao.addApplyRecord(baseUserDO);
            if (baseUser == null) {
                logger.info("插入BaseUser失败");
                throw new RuntimeException();
            }
            ContactUserDO contactUserDO = new ContactUserDO();
            BeanUtils.copyProperties(deviceUserInfo, contactUserDO);
            BeanUtils.copyProperties(userInfo, contactUserDO);
            contactUserDO.setUserId(baseUser.getId());
            contactUserDO.setGmtCreate(time);
            contactUserDO.setGmtUpdate(time);
            if (null == contactUserDO.getSex()) {
                contactUserDO.setSex(0);
            }
            contactUserDO = EncryptUserInfo.getEncryptContactUserDO(contactUserDO);
            ContactUserDO contactUser = contactUserDao.addPersonUserInfo(contactUserDO);
            if (contactUser == null) {
                logger.info("插入设备联系人信息失败");
                throw new RuntimeException();
            }
            DeviceUserDO deviceUserDO = new DeviceUserDO();
            BeanUtils.copyProperties(deviceUserInfo, deviceUserDO);
            deviceUserDO.setDeviceName(deviceUserInfo.getUserName());
            deviceUserDO.setDeviceNo(deviceUserInfo.getUserNo());
            deviceUserDO.setRemark(userInfo.getRemark());
            deviceUserDO.setUserId(baseUser.getId());
            deviceUserDO.setPersonId(contactUser.getId());
            deviceUserDO.setGmtCreate(time);
            deviceUserDO.setGmtUpdate(time);
            //已经加密
            deviceUserDO.setLicenseNumber(baseUserDO.getLicenseNumber());
            DeviceUserDO deviceUser = deviceUserDao.addDeviceUser(deviceUserDO);
            if (deviceUser == null) {
                logger.info("插入设备信息失败");
                throw new RuntimeException();
            }
            //审计日志
            result.setLogContent(", 用户ID=" + deviceUser.getId());
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    @Override
    public Result registerBatchDeviceUser(DeviceUserInfo deviceUserInfo, UserInfo userInfo) {
        Result result = new Result();
        try {
            //查看设备是否存在
            int count = baseUserService.queryUserExist(deviceUserInfo.getLicenseType(), deviceUserInfo.getLicenseNumber(), UserTypeEnum.DEVICE_USER.id, deviceUserInfo.getSystemFlag());
            if (count > 0) {
                result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                return result;
            }
            Date date = new Date(System.currentTimeMillis());
            Timestamp time = new Timestamp(date.getTime());
            BaseUserDO baseUserDO = new BaseUserDO();
            BeanUtils.copyProperties(userInfo, baseUserDO);
            BeanUtils.copyProperties(deviceUserInfo, baseUserDO);
            baseUserDO.setGmtCreate(time);
            baseUserDO.setGmtUpdate(time);
            baseUserDO = EncryptUserInfo.getEncryptBaseUserDO(baseUserDO);
            BaseUserDO baseUser = baseUserDao.addApplyRecord(baseUserDO);
            if (baseUser == null) {
                logger.info("插入BaseUser失败");
                throw new RuntimeException();
            }
            ContactUserDO contactUserDO = new ContactUserDO();
            BeanUtils.copyProperties(deviceUserInfo, contactUserDO);
            BeanUtils.copyProperties(userInfo, contactUserDO);
            contactUserDO.setUserId(baseUser.getId());
            contactUserDO.setGmtCreate(time);
            contactUserDO.setGmtUpdate(time);
            if (null == contactUserDO.getSex()) {
                contactUserDO.setSex(0);
            }
            contactUserDO = EncryptUserInfo.getEncryptContactUserDO(contactUserDO);
            ContactUserDO contactUser = contactUserDao.addPersonUserInfo(contactUserDO);
            if (contactUser == null) {
                logger.info("插入设备联系人信息失败");
                throw new RuntimeException();
            }
            DeviceUserDO deviceUserDO = new DeviceUserDO();
            BeanUtils.copyProperties(deviceUserInfo, deviceUserDO);
            deviceUserDO.setDeviceName(deviceUserInfo.getUserName());
            deviceUserDO.setDeviceNo(deviceUserInfo.getUserNo());
            deviceUserDO.setRemark(userInfo.getRemark());
            deviceUserDO.setUserId(baseUser.getId());
            deviceUserDO.setPersonId(contactUser.getId());
            deviceUserDO.setGmtCreate(time);
            deviceUserDO.setGmtUpdate(time);
            deviceUserDO = EncryptUserInfo.getEncryptDeviceUserDO(deviceUserDO);
            DeviceUserDO deviceUser = deviceUserDao.addDeviceUser(deviceUserDO);
            if (deviceUser == null) {
                logger.info("插入设备信息失败");
                throw new RuntimeException();
            }
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return null;
    }

    @Transactional
    @Override
    public Result batchSaveDeviceUserByTemplateFile(ArrayList<ArrayList<String>> lists) {
        Result result = new Result();
        ArrayList<ArrayList<String>> trueList = new ArrayList<>();
        ArrayList<ArrayList<String>> falseList = new ArrayList<>();
        //格式校验
        for (int i = 0; i < lists.size(); i++) {
            result = new DeviceUtils().checkFormat(lists.get(i));
            if (result.getCode() == 0) {
                //格式正确
                trueList.add((ArrayList<String>) result.getInfo());
            } else {
                //格式错误
                falseList.add((ArrayList<String>) result.getInfo());
            }
        }

        ArrayList<ArrayList<String>> trueInfoList = new ArrayList<>();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < trueList.size(); i++) {
            ArrayList<String> listFornt = trueList.get(i);
            String s = listFornt.get(1) + listFornt.get(2);
            if (StringUtils.isNotBlank(listFornt.get(13)) && !Constants.SYSTEM_FLAG_DEFAULT.equals(listFornt.get(13))) {
                s = s + listFornt.get(13);
            }
            //不包含
            if (!hashSet.contains(s)) {
                hashSet.add(s);
                trueInfoList.add(trueList.get(i));
            } else {
                ArrayList<String> list = trueList.get(i);
                list.add("本地上传设备用户重复");
                falseList.add(list);
            }
        }

        //list转实体类
        ArrayList<DeviceInfo> infoList = new ArrayList<DeviceInfo>();
        Iterator<ArrayList<String>> it = trueInfoList.iterator();
        while (it.hasNext()) {
            ArrayList<String> next = it.next();
            DeviceInfo info = DeviceUtils.format(next);

            //系统标识校验 DO 0318
            String systemName = info.getDeviceUserInfo().getSystemName();
            int systemFlagSize = 1; // 系统是否存在
            String systemFlag = null;
            if (StringUtils.isBlank(systemName) || Constants.SYSTEM_FLAG_DEFAULT.equals(systemName)) {
                systemFlag = Constants.SYSTEM_FLAG_DEFAULT;
            } else {
                if (Constants.SYSTEM_FLAG_V2X.equals(systemName)) {
                    systemFlag = Constants.SYSTEM_FLAG_V2X;
                } else {
                    systemFlagSize = baseUserDao.querySystemName(systemName);
                    if (systemFlagSize != 0) {
                        //系统标识一定有
                        systemFlag = baseUserDao.getSystemFlagByName(systemName);
                    }
                }
            }
            info.getDeviceUserInfo().setSystemFlag(systemFlag);
            int count = 0;
            if (null != systemFlag) {
                count = baseUserService.queryUserExist(info.getDeviceUserInfo().getLicenseType(), info.getDeviceUserInfo().getLicenseNumber(), UserTypeEnum.ORGAN_USER.id, systemFlag);
            }
            if (count == 0 && systemFlagSize == 1) {
                infoList.add(info);
            } else {
                falseList.add(next);
                it.remove();
                if (count > 0 && systemFlagSize != 1) {
                    next.add("唯一标识符已存在，所属系统不存在");
                } else if (count > 0) {
                    next.add("唯一标识符已存在");
                } else {
                    next.add("所属系统不存在");
                }

            }

        }


        DeviceRegisterBatch(infoList);//批量插入数据库
        result = generateExcel(Constants.DEVICE_1_ERROR, infoList, falseList);//生成错误数据表格
        //审计日志
        result.setLogContent("，成功条数=" + infoList.size() + "，失败条数=" + falseList.size());
        return result;
    }


    /**
     * 生成错误表格
     *
     * @param templateName 错误文件名
     */
    public Result generateExcel(String templateName, ArrayList<DeviceInfo> infoList, ArrayList<ArrayList<String>> falseList) {
        Result result = new Result();
        try {
            //错误数据文件名
            String filename;
            BatchResp batchResp = null;
            if (falseList.size() > 0) {
                Result res = ErrorExcel.generateExcel(PathConstants.BATCH_REGISTER_FILE_PATH, templateName, falseList);
                batchResp = new BatchResp(String.valueOf(infoList.size()), String.valueOf(falseList.size()), (String) res.getInfo());
            } else {
                batchResp = new BatchResp(String.valueOf(infoList.size()), String.valueOf(falseList.size()), null);
            }
            result.setCode(Constants.FORMAT_DEVICE_USER_SUCESS);
            result.setInfo(batchResp);
            return result;
        } catch (Exception e) {
            result.setError(ErrorEnum.UPDATE_ERROR_EXCEL_IS_ERROR);
            logger.info("生成错误信息文件失败：", e);
            return result;
        }
    }

    /**
     * 批量插入数据库
     *
     * @param infoList
     */
    public void DeviceRegisterBatch(ArrayList<DeviceInfo> infoList) {
        for (int i = 0; i < infoList.size(); i++) {
            registerBatchDeviceUser(infoList.get(i).getDeviceUserInfo(), infoList.get(i).getUserInfo());
        }
    }

    @Transactional
    @Override
    public Result updateDeviceUser(long deviceId, DeviceUserInfo deviceUserInfo, UserInfo userInfo) {
        Result result = new Result();
        try {
            Date date = new Date(System.currentTimeMillis());
            /**
             * 判断系统标识是否存在
             */
            result = customerSysService.verifyUserSystemFlag(deviceUserInfo.getSystemFlag());
            if (!result.isSuccess()) {
                return result;
            }
            Timestamp time = new Timestamp(date.getTime());
            String encryptLicenseNumber = EncryptUserInfo.getEncryptString(deviceUserInfo.getLicenseNumber());
            DeviceUserDO deviceUserDO = deviceUserDao.getDeviceUser(deviceUserInfo.getLicenseType(), encryptLicenseNumber, deviceUserInfo.getSystemFlag());
            if (null != deviceUserDO && deviceUserDO.getUserId().intValue() != deviceId) {
                logger.info("查询设备用户已经注册");
                result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                return result;
            }
            DeviceUserDO deviceInfo = deviceUserDao.getDeviceInfoById(deviceId);
            if (null == deviceInfo) {
                logger.error("更新用户不存在");
                result.setError(ErrorEnum.GET_DEVICE_INFO_EMPTY);
                return result;
            }
            Timestamp timestamp = deviceInfo.getGmtCreate();
            BeanUtils.copyProperties(userInfo, deviceInfo);
            BeanUtils.copyProperties(deviceUserInfo, deviceInfo);
            deviceInfo.setDeviceName(deviceUserInfo.getUserName());
            deviceInfo.setGmtCreate(timestamp);
            deviceInfo.setGmtUpdate(time);
            deviceInfo = EncryptUserInfo.getEncryptDeviceUserDO(deviceInfo);
            int state = deviceUserDao.updateDeviceUser(deviceInfo);
            if (state != 1) {
                logger.info("更新设备信息失败");
                result.setError(ErrorEnum.UPDATE_DEVICE_USER_INFO_ERROR);
                return result;
            }
            //信息不存在
            BaseUserDO baseUser = baseUserDao.getBaseUserInfo(deviceInfo.getUserId());
            if (null == baseUser) {
                logger.info("查询用户表信息为空");
                result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
                return result;
            }
            if (baseUser.getStatus() == UserStatusEnum.DISABLED.id) {
                result.setError(ErrorEnum.USER_STATUS_TYPE_IS_NOT_SUPPORT);
                return result;
            }
            //审计日志
            Long id = baseUser.getId();
            result.setLogContent("，用户ID=" + baseUser.getId());

            BeanUtils.copyProperties(userInfo, baseUser);
            BeanUtils.copyProperties(deviceUserInfo, baseUser);
            baseUser.setGmtCreate(timestamp);
            baseUser.setGmtUpdate(time);
            baseUser.setId(id);
            baseUser = EncryptUserInfo.getEncryptBaseUserDO(baseUser);
            state = baseUserDao.updateBaseUser(baseUser);
            if (state != 1) {
                logger.info("更新设备信息失败");
                result.setError(ErrorEnum.UPDATE_DEVICE_USER_INFO_ERROR);
                return result;
            }
            ContactUserDO contactInfo = deviceUserDao.getDeviceContactById(baseUser.getId());
            BeanUtils.copyProperties(deviceUserInfo, contactInfo);
            BeanUtils.copyProperties(userInfo, contactInfo);
            contactInfo.setGmtUpdate(time);
            contactInfo.setGmtCreate(timestamp);
            if (null == contactInfo.getSex()) {
                contactInfo.setSex(0);
            }
            contactInfo = EncryptUserInfo.getEncryptContactUserDO(contactInfo);
            state = deviceUserDao.updateContactUser(contactInfo);
            if (state != 1) {
                logger.info("更新设备信息失败");
                result.setError(ErrorEnum.UPDATE_DEVICE_USER_INFO_ERROR);
                return result;
            }
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    @Override
    public int getIdByUserNo(String userNo) {
        return deviceUserDao.getIdByUserNo(userNo);

    }

    @Override
    public Result queryDeviceDetails(long deviceId) {
        Result result = new Result();
        DeviceUserDetailsDTO detailsDTO;
        try {
            detailsDTO = deviceUserDao.queryDeviceDetails(deviceId);
            //设备不存在抛此异常
        } catch (EmptyResultDataAccessException e) {
            result.setError(ErrorEnum.GET_DEVICE_INFO_EMPTY);
            return result;
        }
        String systemName = customerDao.getSystemNameByFlag(detailsDTO.getSystemFlag());
        DeviceUserVO deviceUserVO = new DeviceUserVO();
        BeanUtils.copyProperties(detailsDTO, deviceUserVO);
        deviceUserVO.setSystemName(systemName);
        Timestamp gmtCreate = detailsDTO.getGmtCreate();
        deviceUserVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
        try {
            deviceUserVO = DecryptUserInfo.getDecryptOrganUserVO(deviceUserVO);
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        result.setInfo(deviceUserVO);
        return result;
    }

    @Override
    public Result getDevice(Integer identType, String licenseNumber, String systemFlag) {
        Result result = new Result();
        Map<String, Object> map = new HashMap<>();
        String licenseNumberEncrypt;
        try {
            licenseNumberEncrypt = EncryptUserInfo.getEncryptString(licenseNumber);
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        DeviceUserDetailsDTO deviceUserDTO = deviceUserDao.queryDeviceDetails(identType, licenseNumberEncrypt, systemFlag);
        if (null == deviceUserDTO) {
            logger.info("获取设备用户信息为空");
            return Result.failure(ErrorEnum.GET_DEVICE_INFO_EMPTY);
        }
        ContactUserDO contactUserDO = contactUserDao.getContactUser(deviceUserDTO.getPersonId());
        map.put("deviceUser", deviceUserDTO);
        map.put("userInfo", contactUserDO);
        result.setInfo(map);
        return result;
    }

    @Override
    public Result listDeviceUser(String deviceName, String deviceNumber, int status, int pageIndex, int pageSize) {
        DeviceUserResp deviceUserResp = new DeviceUserResp();
        Result result = new Result();
        try {
            String licenseNumberEncrypt = getEncryptString(deviceNumber);
            PageInfo<DeviceUserDTO> deviceUserDTOPageInfo = deviceUserDao.listPageDeviceUser(deviceName, licenseNumberEncrypt, status, pageIndex, pageSize);
            if (deviceUserDTOPageInfo == null) {
                result.setError(ErrorEnum.QUERY_DEVICE_USER_LIST_ERROR);
                return result;
            }
            List<DeviceUserVO> deviceUserVOList = new ArrayList<>();

            List<DeviceUserDTO> deviceUserDTOList = deviceUserDTOPageInfo.getList();
            if (CollectionUtils.isEmpty(deviceUserDTOList)) {
                deviceUserResp.setRecordCount(0);
                deviceUserResp.setPageCount(0);
                deviceUserResp.setDatas(deviceUserVOList);
                result.setInfo(deviceUserResp);
                return result;
            }
            for (DeviceUserDTO deviceUserDTO : deviceUserDTOList) {
                DeviceUserVO deviceUserVO = new DeviceUserVO();
                BeanUtils.copyProperties(deviceUserDTO, deviceUserVO);
                Timestamp gmtCreate = deviceUserDTO.getGmtCreate();
                deviceUserVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
                deviceUserVO = DecryptUserInfo.getDecryptOrganUserVO(deviceUserVO);
                deviceUserVOList.add(deviceUserVO);
            }
            deviceUserResp.setDatas(deviceUserVOList);
            deviceUserResp.setPageCount(deviceUserDTOPageInfo.getPageCount());
            deviceUserResp.setRecordCount(deviceUserDTOPageInfo.getRecordCount());
            result.setInfo(deviceUserResp);
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

}
