package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.ca.constant.SdkConstants;
import com.xdja.ca.utils.DnUtil;
import com.xdja.ca.utils.SdkP10Utils;
import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.ra.core.asn1.NISTObjectIdentifiers;
import com.xdja.pki.ra.core.asn1.RsaObjectIdentifiers;
import com.xdja.pki.ra.core.asn1.SM2ObjectIdentifiers;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.DoubleCodeUseEnum;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.*;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.core.util.spring.SpringUtils;
import com.xdja.pki.ra.manager.dao.*;
import com.xdja.pki.ra.manager.dao.model.*;
import com.xdja.pki.ra.manager.dto.*;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.manager.sdk.business.BaseDn;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.manager.sdk.cmp.bean.CertLifeInfo;
import com.xdja.pki.ra.security.bean.Operator;
import com.xdja.pki.ra.security.util.OperatorUtil;
import com.xdja.pki.ra.service.manager.certapply.bean.ApplyRecordVO;
import com.xdja.pki.ra.service.manager.certapply.bean.ApplyVariable;
import com.xdja.pki.ra.service.manager.certapply.bean.CertApplyResp;
import com.xdja.pki.ra.service.manager.certapply.bean.CertApplyVO;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.naming.NamingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.*;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ThreadLocalRandom;

import static com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils.BKS_KEYSTORE_TYPE;

/**
 * 证书申请服务层-实现类
 *
 * @author syg
 */
@Service
public class CertApplyServiceImpl implements CertApplyService {
    private Logger logger = LoggerFactory.getLogger(CertApplyServiceImpl.class);
    private static final String LOCK_RA_TRANS_ID="raTransId";
    private static final String LOCK_RA_ISSUER_CERT_REQ_ID="raIssuerCertReqId";
    private static final String LOCK_RA_UPDATE_CERT_REQ_ID="raUpdateCertReqId";
    private static final String LOCK_INSERT_PAIR_CERT_INDEX="insertPairCertIndex";
    private static final String LOCK_RECOCERY_PAIR_CERT_INDEX="recoveryPairCertIndex";

    @Autowired
    CertApplyDao certApplyDao;
    @Autowired
    ApplyRecordDao applyRecordDao;
    @Autowired
    CertLifeCycleManager certLifeCycleManager;
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    IssueApplyDao issueApplyDao;
    @Autowired
    UpdateApplyDao updateApplyDao;
    @Autowired
    RevokeApplyDao revokeApplyDao;
    @Autowired
    RecoveryApplyDao recoveryApplyDao;
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    UserCertService userCertService;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    RaCertDao raCertDao;
    @Autowired
    DoubleCodeDao doubleCodeDao;
    @Autowired
    FreezeApplyDao freezeApplyDao;

    @Autowired
    SystemService systemService;

    @Override
    public Result updateCertApplyInfo(String certDn, String applyNo, int applyStatus, Long tempId) {
        Result result = new Result();
        // 更新证书申请的证书状态以及操作管理员信息
        CertApplyDO certApplyInfo = certApplyDao.getCertApplyInfo(applyNo);
        if(null == certApplyInfo){
            logger.info("========================待更新申请信息为空");
            result.setError(ErrorEnum.UPDATE_CERT_APPLY_INFO_FAIL);
            return result;
        }
        if (StringUtils.isNotBlank(certDn)) {
            certApplyInfo.setCertDn(certDn == null ? certApplyInfo.getCertDn() : certDn);
        }
        certApplyInfo.setApplyStatus(applyStatus);
        // 获取当前登录管理员的信息
        long adminId = 666L;
        String adminCertDn = "CN=当前登录的管理员，O=**省公安厅，C=CN";
        certApplyInfo.setAdminId(adminId);
        certApplyInfo.setAdminCertDn(adminCertDn);
        certApplyInfo.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        if (tempId != null) {
            certApplyInfo.setTempId(tempId);
        }
        int updateCertApplyStatusResult = certApplyDao.updateCertApply(certApplyInfo);
        if (updateCertApplyStatusResult <= 0) {
            logger.info("更新申请基本信息失败");
            result.setError(ErrorEnum.UPDATE_CERT_APPLY_INFO_FAIL);
            return result;
        }
        return result;
    }

    @Override
    public Result insertCertApplyRecord(int applyType, int operateType, String applyNo, String systemFlag, int applyStatus, String desc, int operateResultType, boolean isAuto, boolean isOnlineIssue) {
        // 记录申请操作和结果到apply_record表中
        Result result = new Result();
        ApplyRecordDO applyRecordDO = new ApplyRecordDO();
        if (!isOnlineIssue) {
            // 获取当前登录管理员的信息
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            long adminId = currentAdminInfo.getId();
            String adminCertDn = currentAdminInfo.getCertDn();
            applyRecordDO.setAdminId(adminId);
            applyRecordDO.setAdminCertDn(adminCertDn);
        } else {
            applyRecordDO.setAdminId(0L);
            //  applyRecordDO.setAdminCertDn("第三方系统");
            //do 产品：需要显示对应的第三方系统的DN或者T-BOX
            // 通过申请编号查user_id ，关联base_user 查系统标识，关联customer_sys_cert查最新系统dn！如果查不到 （可以认定查不到名称为TBOX ）
            // DO bug修复 撤销无法通过此方式获取
            // DO 20200901 优化 systemFlag 为空可直接认定为V2X
            String dn = null;
            if(StringUtils.isBlank(systemFlag)){
                dn = Constants.SYSTEM_FLAG_V2X;
            }else {
                try {
                    dn = certApplyDao.getSystemCertDn(systemFlag);
                } catch (DataAccessException e) {
                    logger.info("通过在线签发系统标识未获取到系统证书主体认定为V2X");
                    dn = Constants.SYSTEM_FLAG_V2X;
                }
                if (StringUtils.isBlank(dn)) {
                    dn = Constants.SYSTEM_FLAG_V2X;
                }
            }
            applyRecordDO.setAdminCertDn(dn);
        }
        if (isAuto) {
            applyRecordDO.setAdminId(0L);
            applyRecordDO.setAdminCertDn("自动审核");
        }

        applyRecordDO.setApplyNo(applyNo);
        applyRecordDO.setOperateType(operateType);
        applyRecordDO.setApplyType(applyType);
        applyRecordDO.setApplyStatus(applyStatus);
        applyRecordDO.setOperateResult(operateResultType);
        applyRecordDO.setRemark(desc == null ? "" : desc);
        applyRecordDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        applyRecordDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        try {
            applyRecordDao.addApplyRecord(applyRecordDO);
        } catch (Exception e) {
            logger.error("applyNo{}，记录申请操作异常{}", applyNo, e.getMessage());
        }
        return result;
    }

    @Deprecated
    public Result updateCertApplyStatus(int applyType, int operateType, String applyNo, int applyStatus, String desc, int operateResultType) {
        Result result = new Result();
        // 获取当前登录管理员的信息
        Operator operator = OperatorUtil.getOperator();
        if (operator == null || operator.getCurrUser() == null) {
            result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
            return result;
        }
        CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
        long adminId = currentAdminInfo.getId();
        String adminCertDn = currentAdminInfo.getCertDn();
        // 记录申请操作和结果到apply_record表中
        ApplyRecordDO applyRecordDO = new ApplyRecordDO();
        applyRecordDO.setApplyNo(applyNo);
        applyRecordDO.setOperateType(operateType);
        applyRecordDO.setApplyType(applyType);
        applyRecordDO.setApplyStatus(applyStatus);
        applyRecordDO.setAdminId(adminId);
        applyRecordDO.setAdminCertDn(adminCertDn);
        applyRecordDO.setOperateResult(operateResultType);
        applyRecordDO.setRemark(desc);
        applyRecordDO.setGmtUpdate(new Timestamp(new Date().getTime()));
        applyRecordDO.setGmtCreate(new Timestamp(new Date().getTime()));
        ApplyRecordDO applyRecordResult = applyRecordDao.addApplyRecord(applyRecordDO);
        if (applyRecordResult == null) {
            logger.info("添加申请记录失败");
            result.setError(ErrorEnum.INSERT_APPLY_RECORD_FAIL);
            throw new RuntimeException();
        }
        return result;
    }

    @Override
    public Result listUserApply(String userName, int userType, int applyStatus, int pageNo, int pageSize) {
        CertApplyResp certApplyResp = new CertApplyResp();
        Result result = new Result();
        PageInfo<CertApplyDTO> certApplyDTOPageInfo = certApplyDao.listPageUserCert(userName, userType, applyStatus, pageNo, pageSize);
        if (certApplyDTOPageInfo == null) {
            result.setError(ErrorEnum.QUERY_CERT_APPLY_LIST_ERROR);
            return result;
        }
        List<CertApplyVO> certApplyVOList = new ArrayList<>();

        List<CertApplyDTO> certApplyDTOList = certApplyDTOPageInfo.getList();
        if (CollectionUtils.isEmpty(certApplyDTOList)) {
            certApplyResp.setRecordCount(0);
            certApplyResp.setPageCount(0);
            certApplyResp.setDatas(certApplyVOList);
            result.setInfo(certApplyResp);
            return result;
        }
        for (CertApplyDTO certApplyDTO : certApplyDTOList) {
            CertApplyVO certApplyVO = new CertApplyVO();
            BeanUtils.copyProperties(certApplyDTO, certApplyVO);
            /**
             * 同时查询模板信息和系统名称
             */
            UserCertDTO certListInfo = userCertDao.getCertListInfo(certApplyDTO.getSystemFlag(), certApplyDTO.getTempId());
            certApplyVO.setSystemName(certListInfo.getSystemName());
            certApplyVO.setCertPatterm(certListInfo.getCertPatterm());
            certApplyVO.setTempNo(certListInfo.getTempNo());

            Timestamp gmtCreate = certApplyDTO.getGmtCreate();
            certApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
            certApplyVOList.add(certApplyVO);
        }

        certApplyResp.setDatas(certApplyVOList);
        certApplyResp.setPageCount(certApplyDTOPageInfo.getPageCount());
        certApplyResp.setRecordCount(certApplyDTOPageInfo.getRecordCount());
        result.setInfo(certApplyResp);
        return result;
    }

    @Override
    public Result verifyUserCertApplyDn(String certDn) {
        //  证书DN的校验规则
        Result result = new Result();
        X500Name x500Name = null;
        try {
            x500Name = DnUtil.getRFC4519X500Name(certDn);

            String certDnFormat = x500Name.toString();
            logger.info("格式化之后的申请DN:" + certDnFormat);

            // 检验DN关键字系统是否支持
            // DN的每个关键字的值不能超过64字节
            //检查是否包含中文逗号
            Result checkResult = CertDnVerifyUtils.checkDn(x500Name);
            if (!checkResult.isSuccess()) {
                result.setError(checkResult.getError());
                return result;
            }

            // 校验DN的特殊项先后顺序
            checkResult = CertDnVerifyUtils.checkCertDnSort(x500Name);
            if (!checkResult.isSuccess()) {
                logger.info("证书的DN的类型先后顺序有误");
                result.setError(checkResult.getError());
                return result;
            }

        } catch (Exception e) {
            logger.info("certDn不正确{}", e.getMessage());
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }

      /*  // 校验DN的特殊符号  等号和逗号
        checkResult = CertDnVerifyUtils.checkCertDnSymbol(x500Name);
        if (!checkResult.isSuccess()) {
            logger.info("证书的DN的特殊符号校验有误");
            result.setError(checkResult.getError());
            return result;
        }*/

        // DN的每个关键字的值不能超过64字节
       /* checkResult = CertDnVerifyUtils.check64(certDnFormat);
        if (!checkResult.isSuccess()) {
            logger.info("证书的DN关键字的值校验有误" + certDnFormat);
            result.setError(checkResult.getError());
            return result;
        }
        //检验DN的关键字，不能有空格
        checkResult = CertDnVerifyUtils.checkBlankSpace(certDnFormat);
        if (!checkResult.isSuccess()) {
            logger.info("证书的DN关键字与值之间有空格" + certDnFormat);
            result.setError(checkResult.getError());
            return result;
        }
        */

        return result;
    }

    @Override
    public Result verifyUserCertApplyDn(String certDn, long userId, String applyNo) {
        //  证书DN的校验规则
        Result result = verifyUserCertApplyDn(certDn);
        if (!result.isSuccess()) {
            return result;
        }

        // 校验DN的唯一性
        // 不同用户的DN要求唯一
        int userCertByUserIdAndCertDN = userCertDao.getUserCertByUserIdAndCertDN(certDn, userId);
        if (userCertByUserIdAndCertDN >= 1) {
            logger.info("有多个的证书的DN信息同【" + certDn + "】一致");
            result.setError(ErrorEnum.USER_CERT_DN_HAVE_SAME_APPLY_CERT_DN);
            return result;
        }

        // 检测是否存在正在流转的相同DN的申请（同一用户的DN可以相同，不同用户的不同）
        int count = certApplyDao.getCertApplyCountByCertDn(certDn, userId);
        if (count >= 1) {
            // 校验DN是否是修改申请时的DN (同一次申请，DN可以相同)
            if (StringUtils.isNotBlank(applyNo)) {
                String applyCertDn = certApplyDao.getCertDnByApplyNo(applyNo);
                if (certDn.equalsIgnoreCase(applyCertDn)) {
                    return result;
                }
            }
            logger.info("已存在相同证书主体的用户申请 " + certDn);
            result.setError(ErrorEnum.CERT_APPLY_CERT_DN_IS_EXIST);
            return result;
        }
        return result;
    }

    @Override
    public Result verifyUserCertApply(String signSn, int applyType) {
        // 校验证书Sn是否已存在申请记录
        Result result = new Result();
        if (applyType == Constants.CERT_APPLY_TYPE_UPDATE_2) {
            int unClosedApplyNum = updateApplyDao.getUnClosedUpdateApplyNum(signSn);
            if (unClosedApplyNum > 0) {
                result.setError(ErrorEnum.SIGN_SN_HAS_UPDATE_APPLY_NOT_CLOSED);
                return result;
            }
        } else if (applyType == Constants.CERT_APPLY_TYPE_REVOKE_3) {
            //撤销证书申请
            int unClosedRevokeApplyNum = revokeApplyDao.getUnClosedRevokeApplyNum(signSn);
            if (unClosedRevokeApplyNum > 0) {
                result.setError(ErrorEnum.SIGN_SN_HAS_REVOKE_APPLY_NOT_CLOSED);
                return result;
            }
        } else if (applyType == Constants.CERT_APPLY_TYPE_RECOVERY_4) {
            //恢复证书申请
            int unClosedRecoveryApplyNum = recoveryApplyDao.getUnClosedRecoveryApplyNum(signSn);
            if (unClosedRecoveryApplyNum > 0) {
                result.setError(ErrorEnum.SIGN_SN_HAS_RECOVERY_APPLY_NOT_CLOSED);
                return result;
            }
            // 校验是否为单证
            UserCertDO userCertDO = userCertDao.getUserCertBaseInfoBySignSn(signSn);
            if (userCertDO.getCertType() == Constants.CERT_TYPE_SINGLE_1) {
                // BUG 77925
                logger.info("单证不支持密钥恢复");
                result.setError(ErrorEnum.SINGLE_CERT_NOT_RECOVERY_APPLY);
                return result;
            }
        } else if (applyType == Constants.CERT_APPLY_TYPE_FREEZE_5 || applyType == Constants.CERT_APPLY_TYPE_UNFREEZE_6) {
            // 冻结解冻证书申请
            int unClosedFreezeApplyNum = freezeApplyDao.getUnClosedFreezeApplyNum(signSn);
            if (unClosedFreezeApplyNum > 0) {
                logger.info("该sn已存在未结束的冻结解冻申请");
                result.setError(ErrorEnum.SIGN_SN_HAS_FREEZE_APPLY_NOT_CLOSED);
                return result;
            }
        }
        return result;
    }

    @Override
    public Result issueCert(IssueApplyDTO issueApplyDTO, byte[] issueBytes) {
        Result result = new Result();
        Integer applyType = Constants.CERT_APPLY_TYPE_ISSUE_1;
        String applyNo = issueApplyDTO.getApplyNo();
        // 获取当前RA服务器签名证书DN
        String raDN = this.getRAServiceDnName();
        // 获取目标CA证书DN
        String caDN = this.getCAServiceDnName();

        String raTransId;
        synchronized (LOCK_RA_ISSUER_CERT_REQ_ID){
            raTransId = String.valueOf(System.nanoTime() + (ThreadLocalRandom.current().nextLong(0,9999999) + 90000000));
        }
        Map<String, String> raMap = ApplyVariable.getRaMap();
        raMap.put(applyNo, raTransId);

        // 签发证书申请流程
        Result issueResult = certLifeCycleManager.issueUserCert(applyNo, null, issueBytes, raDN, caDN, raTransId, issueApplyDTO.getTempNo(), issueApplyDTO.getTempParas(), issueApplyDTO.getSignAlg(), issueApplyDTO.getCertValidity(), issueApplyDTO.getCertDn(), null);
        if (!issueResult.isSuccess()) {
            // 更新申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(issueApplyDTO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, issueApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作签发失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }
            // 添加申请记录
            certApplyService.insertCertApplyRecord(applyType, Constants.OPERATE_TYPE_ISSUE_5, applyNo, null, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, issueResult.getErrorBean().getErrMsg(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, true);

            logger.error("调用CA，签发证书失败 " + issueResult.getErrorBean().getErrMsg());
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo) issueResult.getInfo();
        // 用户证书入库
        Result certInsertResult = this.insertUserCertInfo(issueApplyDTO.getUserId(), issueApplyDTO.getApplyId(), issueApplyDTO.getTempId(), issueApplyDTO.getTempNo(), issueApplyDTO.getSignAlg(), issueApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            logger.info("将用户证书插入数据库失败");
            result.setError(certInsertResult.getError());
            return result;
        }

        result.setInfo(userCertInfo);
        return result;

    }


    @Override
    public Result updateCert(UpdateApplyDTO updateApplyDTO, byte[] issueBytes) {
        Result result = new Result();
        Integer applyType = Constants.CERT_APPLY_TYPE_UPDATE_2;
        String applyNo = updateApplyDTO.getApplyNo();
        // 获取当前RA服务器签名证书DN
        String raDN = this.getRAServiceDnName();
        // 获取目标CA证书DN
        String caDN = this.getCAServiceDnName();

        String raTransId;
        synchronized (LOCK_RA_UPDATE_CERT_REQ_ID){
            raTransId = String.valueOf(System.nanoTime() + (ThreadLocalRandom.current().nextLong(0,9999999) + 90000000));
        }
        Map<String, String> raMap = ApplyVariable.getRaMap();
        raMap.put(applyNo, raTransId);

        // 更新证书申请流程
        byte[] publicKeyByte = null;
        if (updateApplyDTO.getUpdateKey()) {
            // issueBytes 是个公钥
            if (issueBytes == null) {
                logger.info("更新密钥时，必须上传p10文件");
                result.setError(ErrorEnum.UPDATE_KEY_NEED_P10_FILE);
                return result;
            }
            logger.info("在线更新申请更新秘钥");
            publicKeyByte = issueBytes;
        } else {
            logger.info("在线更新申请不更新秘钥");
            publicKeyByte = null;
        }
        String userCertDN =  updateApplyDTO.getCertDn();
        Result updateResult = certLifeCycleManager.updateUserCert(applyNo, null, publicKeyByte, raDN, caDN, raTransId, updateApplyDTO.getTempNo(), updateApplyDTO.getTempParas(),
                updateApplyDTO.getSignAlg(), updateApplyDTO.getCertValidity(), userCertDN, updateApplyDTO.getSignSn(), updateApplyDTO.getUpdateKey(), null);
        if (!updateResult.isSuccess()) {
            // 更新申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(updateApplyDTO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, updateApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作签发失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }
            // 添加申请记录
            certApplyService.insertCertApplyRecord(applyType, Constants.OPERATE_TYPE_ISSUE_5, applyNo, null, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, updateApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, true);
            logger.info("调用CA，更新证书失败");
            result.setErrorBean(updateResult.getErrorBean());
            return result;
        }

        UserCertInfo userCertInfo = (UserCertInfo) updateResult.getInfo();

        // 用户证书入库
        Result certInsertResult = this.insertUserCertInfo(updateApplyDTO.getUserId(), updateApplyDTO.getApplyId(), updateApplyDTO.getTempId(), updateApplyDTO.getTempNo(), updateApplyDTO.getSignAlg(), updateApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            logger.info("将用户证书插入数据库失败");
            throw new RuntimeException();
        }

        result.setInfo(userCertInfo);
        return result;
    }

    @Override
    public Result issueUserCert(Integer index, String password, Integer certFormatType, int applyType, String applyNo, String systemFlag
            , String cardNo, byte[] issueBytes, int issueType, boolean isOnlineIssue, boolean isTboxIssue
            , Map<String, Object> extParam, Integer keyFormat) {
        Result result = new Result();
        // 获取当前登录管理员的信息
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                logger.warn("[CertApplyServiceImpl#issueUserCert] applyNo:{} can't find current login admin", applyNo);
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有制证员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_ISSUE_5)) {
                logger.warn("[CertApplyServiceImpl#issueUserCert]applyNo:{}current login admin role is error", applyNo);
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }

        // 获取当前RA服务器签名证书DN
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank(raServiceDnName)) {
            logger.error("获取RA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        // 获取目标CA证书DN
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank(caServiceDnName)) {
            logger.error("获取CA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        // 查询申请的状态为待签发时，可以发起签发操作
        CertApplyDO certApplyInfo = certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyInfo == null) {
            logger.info("不存在当前申请编号对应的申请记录 applyNo:{}", applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }

        // 判断只有除RSA算法外的Nist和SM2算法提供0016格式的私钥格式
        if (Constants.KEY_ALG_NAME_RSA.equalsIgnoreCase(CommonVariable.getKeyAlgName()) && Constants.KEY_FORMAT_0016_2 == keyFormat) {
            logger.info("RSA算法不提供0016的私钥格式 keyAlgName:{}", CommonVariable.getKeyAlgName());
            result.setError(ErrorEnum.RSA_ALG_CANNOT_BUILD_0016_KEY_FORMAT);
            return result;
        }

        //审计日志
        result.setLogContent("，证书主体=" + certApplyInfo.getCertDn());

        int applyStatus = certApplyInfo.getApplyStatus();
        if (Constants.CERT_APPLY_STATUS_NOT_ISSUE_3 != applyStatus) {
            logger.info("当前申请状态不可发起签发 applyStatus:{}", applyStatus);
            result.setError(ErrorEnum.APPLY_STATUS_NOT_SUPPORT_ISSUE_CERT);
            return result;
        }
        String raTransId;
        synchronized (LOCK_RA_TRANS_ID){
            raTransId = String.valueOf(System.nanoTime() + (ThreadLocalRandom.current().nextLong(0,9999999) + 90000000));
        }
        Map<String, String> raMap = ApplyVariable.getRaMap();
        raMap.put(applyNo, raTransId);
//        logger.debug("RA缓存applyNo和raTransId的对应关系:{}", JsonUtils.object2Json(raMap));
        String oldCertSignSn = null;
        if (applyType == Constants.CERT_APPLY_TYPE_ISSUE_1) {
            // 签发证书申请流程
            Result issueApplyResult = this.issueApplyHandler(certFormatType, applyNo, systemFlag, cardNo,
                    issueBytes, raServiceDnName, caServiceDnName, raTransId, issueType, isOnlineIssue, isTboxIssue,
                    extParam, keyFormat);
            if (!issueApplyResult.isSuccess()) {
                logger.info("签发证书申请处理失败");
                result.setErrorBean(issueApplyResult.getErrorBean());
                raMap.remove(applyNo);
                return result;
            }
            result.setInfo(issueApplyResult.getInfo());
        } else if (applyType == Constants.CERT_APPLY_TYPE_UPDATE_2) {
            // 更新证书申请流程
            Result updateApplyResult = this.updateApplyHandler(certFormatType, applyNo, systemFlag, cardNo,
                    issueBytes, raServiceDnName, caServiceDnName, raTransId, issueType, isOnlineIssue, isTboxIssue,
                    extParam, keyFormat);
            if (!updateApplyResult.isSuccess()) {
                logger.info("更新证书申请处理失败");
                result.setErrorBean(updateApplyResult.getErrorBean());
                raMap.remove(applyNo);
                return result;
            }
            result.setInfo(updateApplyResult.getInfo());

            UpdateApplyDTO updateApplyDTO = updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
            oldCertSignSn = updateApplyDTO.getSignSn();
        } else if (applyType == Constants.CERT_APPLY_TYPE_RECOVERY_4) {
            Result recoveryApplyResult = this.recoveryApplyHandler(certFormatType, applyNo, systemFlag, cardNo,
                    issueBytes, raServiceDnName, caServiceDnName, raTransId, issueType, isOnlineIssue, keyFormat);
            if (!recoveryApplyResult.isSuccess()) {
                logger.info("恢复证书申请处理失败");
                result.setErrorBean(recoveryApplyResult.getErrorBean());
                raMap.remove(applyNo);
                return result;
            }
            result.setInfo(recoveryApplyResult.getInfo());

            RecoveryApplyDTO recoveryApplyDTO = recoveryApplyDao.getRecoveryApplyInfoByApplyNo(applyNo);
            oldCertSignSn = recoveryApplyDTO.getSignSn();
        }

        logger.info("UserCertInfo>>>>>>result:" + JsonUtils.object2Json(result));
        UserCertInfo certInfo = (UserCertInfo) result.getInfo();
        if (issueType == Constants.APPLY_CERT_TYPE_BY_UKEY_1 || isOnlineIssue) {
            result.setInfo(certInfo);
            return result;
        }

        // 通过申请编号获取模板id 对应的证书机制
        Integer certPatterm = null;
        try {
            certPatterm = certApplyDao.getCertPatterm(applyNo);
        } catch (Exception e) {
            logger.info("获取签发证书申请基本信息为空");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }

        // 通过P10申请书的形式
        List<Map<String, Object>> list = new ArrayList<>();
        if (StringUtils.isNotBlank(certInfo.getEncPriKey())) {
            Map<String, Object> priKeyMap = new HashMap<>();
            priKeyMap.put("name", "EncPrivateKey");
            priKeyMap.put("suffix", "pem");
            byte[] priKeyByte = certInfo.getEncPriKey().getBytes();
            priKeyMap.put("buffer", priKeyByte);
            list.add(priKeyMap);
        }

        if (certFormatType == Constants.P10_ISSUE_TYPE_P7B_4) {

            Map<String, Object> signMap = new HashMap<>();
            signMap.put("name", "UserCert");
            if (certPatterm != SdkConstants.CERT_TYPE_SINGLE_1) {
                Map<String, Object> encMap = new HashMap<>();
                encMap.put("name", "EncCert");
                encMap.put("suffix", "p7b");
                byte[] encByte = certInfo.getEncCert().getBytes();
                encMap.put("buffer", encByte);
                list.add(encMap);

                signMap.put("name", "SignCert");
            }
            signMap.put("suffix", "p7b");
            byte[] signByte = certInfo.getSignCert().getBytes();
            signMap.put("buffer", signByte);
            list.add(signMap);

            Map<String, Object> caCertMap = new HashMap<>();
            caCertMap.put("name", "CACert");
            caCertMap.put("suffix", "p7b");
            caCertMap.put("buffer", FileUtils.readByBinary(PathConstants.CA_TRUST_SERVICE_CERT_FILE_PATH));
            list.add(caCertMap);

        } else {
            try {
                /**
                 * 此时已经签发成功参数校验过 不考虑参数再次异常
                 */
                // DO 将 index  password 存库 取库更新bks证书适用  password可以为空 卡斯柯项目三未信安密码机适配
                if (index == null) {
                    BksIndexDO bksIndexDO = certApplyDao.getBksIndex(oldCertSignSn);
                    if (null != bksIndexDO) {
                        index = bksIndexDO.getBksIndex();
                        password = bksIndexDO.getBksPassword();
                        //DO 解密 20200819
                        password = HsmUtils.getDecrypt(password);
                    } else {
                        String path = PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + oldCertSignSn + "/" + "index.txt";
                        String indexAndPassword = FileUtils.read(path);

                        String[] split = indexAndPassword.split("-");
                        index = Integer.valueOf(split[0]);
                        if (split.length == 2) {
                            password = split[1];
                            password = HsmUtils.getDecrypt(password);
                        } else {
                            password = null;
                        }
                    }
                }
                X509Certificate signCert = CertUtils.getCertFromStr(certInfo.getSignCert());
                String signSn = signCert.getSerialNumber().toString(16).toLowerCase();

                Map<String, Object> caCertMap = new HashMap<>();
                caCertMap.put("name", "CACert");
                caCertMap.put("suffix", "p7b");
                caCertMap.put("buffer", FileUtils.readByBinary(PathConstants.CA_TRUST_SERVICE_CERT_FILE_PATH));
                list.add(caCertMap);

                if (certPatterm != SdkConstants.CERT_TYPE_SINGLE_1) {

                    Map<String, Object> encCertMap = new HashMap<>();
                    encCertMap.put("name", "EncCert");
                    encCertMap.put("suffix", "cer");
                    encCertMap.put("buffer", certInfo.getEncCert().getBytes());
                    list.add(encCertMap);

                    X509Certificate encCert = CertUtils.getCertFromStr(certInfo.getEncCert());

                    // DO  password为空处理
                    SdfPrivateKey sdfPrivateKey;
                    if (StringUtils.isBlank(password)) {
                        sdfPrivateKey = new SdfPrivateKey(index);
                        password = "";
                    } else {
                        sdfPrivateKey = new SdfPrivateKey(index, password.getBytes());
                    }
                    File file = new File(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + applyNo);
                    if (file.exists()) {
                        file.delete();
                    }
                    file.mkdirs();
                    String keyPwd = KeyStoreUtils.getStringRandom(8);
                    //DO  三未信安BKS签发 没有私钥访问控制码
                    KeyStore keyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(keyPwd, CommonVariable.getCaServiceCert(), applyNo + "_sign", sdfPrivateKey, signCert, applyNo + "_enc", sdfPrivateKey, encCert, BKS_KEYSTORE_TYPE);
                    //  KeyStore keyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithBKS(keyPwd, CommonVariable.getCaServiceCert(), index, password, applyNo + "_sign", signCert, applyNo + "_enc", encCert);

                    //保存keyStore文件
                    OutputStream oS = new FileOutputStream(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + applyNo + "/signAndEncCert_" + keyPwd + ".bks");
                    keyStore.store(oS, keyPwd.toCharArray());
                    oS.close();

                    Map<String, Object> signAndEncMap = new HashMap<>();
                    signAndEncMap.put("name", "signAndEncCert_" + keyPwd);
                    signAndEncMap.put("suffix", "bks");
                    signAndEncMap.put("buffer", FileUtils.readByBinary(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + applyNo + "/signAndEncCert_" + keyPwd + ".bks"));
                    list.add(signAndEncMap);

                    // do 新增ca.bks  com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils#generateGMSSLTrustStoreWithBKS(java.security.cert.X509Certificate[])
                    X509Certificate[] rootCACerts = CommonVariable.getSuperCaCerts();
                    KeyStore keyStoreCA = GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithBKS(rootCACerts);
                    String caPwd = KeyStoreUtils.getStringRandom(8);
                    OutputStream caOS = new FileOutputStream(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + applyNo + "/ca_" + caPwd + ".bks");
                    keyStoreCA.store(caOS, caPwd.toCharArray());
                    caOS.close();

                    Map<String, Object> caRootMap = new HashMap<>();
                    caRootMap.put("name", "ca_" + caPwd);
                    caRootMap.put("suffix", "bks");
                    caRootMap.put("buffer", FileUtils.readByBinary(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + applyNo + "/ca_" + caPwd + ".bks"));
                    list.add(caRootMap);

                    FileUtils.deleteFile(new File(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + applyNo));
                    //存 index + password 以备不更新密钥使用 DO 20200716 删除证书文件只存秘钥索引和私钥访问控制码 DO 20200717
                   /* File file2 = new File(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + signSn);
                    if (file2.exists()) {
                        file2.delete();
                    }
                    file2.mkdir();
                    FileUtils.saveFile(index + "-" + password, PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + signSn + "/" + "index.txt");*/
                    BksIndexDO bksIndexDO = new BksIndexDO();
                    bksIndexDO.setBksIndex(index);
                    //DO 加密 20200819
                    if (Constants.DATA_IS_ENCRYPTION_1.equals(CommonVariable.getIsEncrypt())) {
                        password = HsmUtils.getEncrypt(password);
                    }
                    bksIndexDO.setBksPassword(password);
                    bksIndexDO.setSignSn(signSn);
                    bksIndexDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
                    bksIndexDO.setGmtModified(new Timestamp(System.currentTimeMillis()));
                    certApplyDao.insertBksIndex(bksIndexDO);
                }


            } catch (Exception e) {
                logger.error("使用密码机生成keyStore失败", e);
                result.setError(ErrorEnum.USE_HSM_GENERATE_BKS_KEYSTORE_ERROR);
                return result;
            }
        }
        result.setInfo(list);
        return result;
    }

    @Override
    public Result issueUserCertByKeyStore(int certFormatType, String applyNo, int applyType, boolean isOnlineIssue, Integer keyFormat) {
        Result result = new Result();

        // 获取当前登录管理员的信息
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有制证员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_ISSUE_5)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }

        // 获取当前RA服务器签名证书DN
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank(raServiceDnName)) {
            logger.error("获取RA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        // 获取目标CA证书DN
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank(caServiceDnName)) {
            logger.error("获取CA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        // 查询申请的状态为待签发时，可以发起签发操作
        CertApplyDO certApplyInfo = certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyInfo == null) {
            logger.info("不存在当前申请编号对应的申请记录 applyNo:" + applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }

        //审计日志
        result.setLogContent("，证书主体=" + certApplyInfo.getCertDn());

        int applyStatus = certApplyInfo.getApplyStatus();
        if (Constants.CERT_APPLY_STATUS_NOT_ISSUE_3 != applyStatus) {
            logger.info("当前申请状态不可发起签发 applyStatus:" + applyStatus);
            result.setError(ErrorEnum.APPLY_STATUS_NOT_SUPPORT_ISSUE_CERT);
            return result;
        }

        String raTransId = RandomUtils.getUUID();
        Map<String, String> raMap = ApplyVariable.getRaMap();
        raMap.put(applyNo, raTransId);
//        logger.info("RA缓存applyNo和raTransId的对应关系：" + JsonUtils.object2Json(raMap));

        if (applyType == Constants.CERT_APPLY_TYPE_ISSUE_1) {
            Result issueApplyResult = this.issueApplyHandlerByKeyStore(applyNo, raServiceDnName, caServiceDnName, raTransId, certFormatType, isOnlineIssue, keyFormat);
            if (!issueApplyResult.isSuccess()) {
                logger.info("签发证书申请处理失败");
                raMap.remove(applyNo);
                result.setErrorBean(issueApplyResult.getErrorBean());
                return result;
            }
            result.setInfo(issueApplyResult.getInfo());
        } else if (applyType == Constants.CERT_APPLY_TYPE_UPDATE_2) {
            Result updateApplyResult = this.updateApplyHandlerByKeyStore(applyNo, raServiceDnName, caServiceDnName, raTransId, certFormatType, isOnlineIssue, keyFormat);
            if (!updateApplyResult.isSuccess()) {
                logger.info("更新证书申请处理失败");
                raMap.remove(applyNo);
                result.setErrorBean(updateApplyResult.getErrorBean());
                return result;
            }
            result.setInfo(updateApplyResult.getInfo());
        } else if (applyType == Constants.CERT_APPLY_TYPE_RECOVERY_4) {
            Result updateApplyResult = this.recoveryApplyHandlerByKeyStore(applyNo, raServiceDnName, caServiceDnName, raTransId, certFormatType, isOnlineIssue, keyFormat);
            if (!updateApplyResult.isSuccess()) {
                logger.info("恢复证书申请处理失败");
                raMap.remove(applyNo);
                result.setErrorBean(updateApplyResult.getErrorBean());
                return result;
            }
            result.setInfo(updateApplyResult.getInfo());
        }

        // 通过申请编号获取模板id 对应的证书机制
        Integer certPatterm = null;
        try {
            certPatterm = certApplyDao.getCertPatterm(applyNo);
        } catch (Exception e) {
            logger.info("获取签发证书申请基本信息为空");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        Map<String, byte[]> keyStores = (Map<String, byte[]>) result.getInfo();

        String suffix = "jks";
        if (certFormatType == Constants.PFX_PRIVATE_KEY_STORE_TYPE_1) {
            suffix = "p12";
        } else if (certFormatType == Constants.JKS_PRIVATE_KEY_STORE_TYPE_2) {
            suffix = "jks";
        } else if (certFormatType == Constants.JKS_PRIVATE_KEY_STORE_TYPE_3) {
            suffix = "bks";
        }

        List<Map<String, Object>> list = new ArrayList<>();

        Map<String, Object> signMap = new HashMap<>();
        signMap.put("name", "UserCert_" + new String((byte[]) keyStores.get("signStorePwd")));

        if (certPatterm != SdkConstants.CERT_TYPE_SINGLE_1) {
            Map<String, Object> encMap = new HashMap<>();
            encMap.put("name", "EncCert_" + new String((byte[]) keyStores.get("encStorePwd")));
            encMap.put("suffix", suffix);
            byte[] encByte = keyStores.get("encStore");
            encMap.put("buffer", encByte);
            list.add(encMap);

            Map<String, Object> andMap = new HashMap<>();
            andMap.put("name", "signAndEncCert_" + new String((byte[]) keyStores.get("signAndEncPwd")));
            andMap.put("suffix", suffix);
            byte[] andByte = keyStores.get("signAndEncStore");
            andMap.put("buffer", andByte);
            list.add(andMap);

            signMap.put("name", "SignCert_" + new String((byte[]) keyStores.get("signStorePwd")));
        }
        signMap.put("suffix", suffix);
        byte[] signByte = keyStores.get("signStore");
        signMap.put("buffer", signByte);
        list.add(signMap);

        Map<String, Object> caCertMap = new HashMap<>();
        caCertMap.put("name", "CACert");
        caCertMap.put("suffix", "p7b");
        caCertMap.put("buffer", keyStores.get("caCert"));
        list.add(caCertMap);

        //keyStoreCA  caPwd
        Map<String, Object> caCertMap2 = new HashMap<>();
        caCertMap2.put("name", "ca_" + new String((byte[]) keyStores.get("caPwd")));
        caCertMap2.put("suffix", suffix);
        byte[] caByte = keyStores.get("keyStoreCA");
        caCertMap2.put("buffer", caByte);
        list.add(caCertMap2);

        result.setInfo(list);
        return result;
    }

    @Override
    public Result formatUserCertInfo(String userCertInfo) {
        Result result = new Result();
        UserCertInfo certInfo = JsonUtils.json2Object(userCertInfo, UserCertInfo.class);

        List<Map<String, Object>> list = new ArrayList<>();

        Map<String, Object> signMap = new HashMap<>();
        signMap.put("name", "SignCert");
        signMap.put("suffix", "p7b");
        byte[] signByte = certInfo.getSignCert().getBytes();
        signMap.put("buffer", signByte);
        list.add(signMap);

        Map<String, Object> encMap = new HashMap<>();
        encMap.put("name", "EncCert");
        encMap.put("suffix", "p7b");
        byte[] encByte = certInfo.getEncCert().getBytes();
        encMap.put("buffer", encByte);
        list.add(encMap);

        Map<String, Object> priKeyMap = new HashMap<>();
        priKeyMap.put("name", "EncPrivateKey");
        priKeyMap.put("suffix", "pem");
        byte[] priKeyByte = certInfo.getEncPriKey().getBytes();
        priKeyMap.put("buffer", priKeyByte);
        list.add(priKeyMap);
        result.setInfo(list);
        return result;
    }

    @Override
    public Result listApplyRecord(String applyNo) {
        Result result = new Result();
        List<ApplyRecordDO> applyRecordDOS = applyRecordDao.listApplyRecord(applyNo);
        if (CollectionUtils.isEmpty(applyRecordDOS)) {
            logger.info(applyNo + " 该sn不存在申请记录");
            result.setError(ErrorEnum.SIGN_NO_NOT_HAVE_APPLY_RECORD);
            return result;
        }
        List<ApplyRecordVO> list = new ArrayList<>();
        for (ApplyRecordDO applyRecordDO : applyRecordDOS) {
            ApplyRecordVO applyRecordVO = new ApplyRecordVO();
            BeanUtils.copyProperties(applyRecordDO, applyRecordVO);
            applyRecordVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(applyRecordDO.getGmtCreate()));
            applyRecordVO.setRemark(applyRecordDO.getRemark() == null ? "" : applyRecordDO.getRemark());
            list.add(applyRecordVO);
        }
        result.setInfo(list);
        return result;
    }

    @Override
    public Result checkUserCertApply(String applyNo, String systemFlag, int applyType, boolean pass, String checkInfo, boolean isOnlineIssue) {
        Result result = new Result();
        // 获取当前RA服务器签名证书DN
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank(raServiceDnName)) {
            logger.error("获取RA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        // 获取目标CA证书DN
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank(caServiceDnName)) {
            logger.error("获取CA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        if (!isOnlineIssue) {
            // 获取当前登录管理员的信息
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有审核员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_AUDIT_4)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }

        CertApplyDO certApplyInfo = certApplyDao.getCertApplyInfo(applyNo, applyType);
        if (certApplyInfo == null) {
            logger.info("该申请类型下不存在当前申请编号对应的申请记录 applyNo:{}", applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }

        BaseUserDO baseUserInfo = baseUserDao.getBaseUserInfo(certApplyInfo.getUserId());
        //审计日志
        if (baseUserInfo.getId() != null) {
            result.setLogContent("，用户ID=" + baseUserInfo.getId());
        }
        result.setLogContent(result.getLogContent() + "，证书主体=" + certApplyInfo.getCertDn());

        if (Constants.CERT_APPLY_STATUS_NOT_CHECK_1 != certApplyInfo.getApplyStatus()) {
            logger.info("当前申请状态不是待审核状态 status:{}", certApplyInfo.getApplyStatus());
            result.setError(ErrorEnum.CERT_APPLY_TYPE_IS_NOT_NO_CHECK_1);
            return result;
        }

        int applyStatus = 0;
        int operateResultType = 0;
        // 如果审核不通过
        if (!pass) {
            applyStatus = Constants.CERT_APPLY_STATUS_CHECK_FAIL_2;
            operateResultType = Constants.CERT_APPLY_OPERATE_TYPE_CHECK_FAIL_3;
            // 更新申请状态
            result = certApplyService.updateCertApplyInfo(null, applyNo, applyStatus, null);
            if (!result.isSuccess()) {
                return result;
            }
            // 添加申请记录  因为没有带撤销状态  所以无法记录撤销申请时 审核通过的记录
            certApplyService.insertCertApplyRecord(applyType, Constants.OPERATE_TYPE_CHECK_3, applyNo, systemFlag, applyStatus, checkInfo, operateResultType, false, isOnlineIssue);
            return result;
        }
        if (Constants.CERT_APPLY_TYPE_REVOKE_3 == applyType) {
            // 撤销申请流程
            RevokeApplyDTO revokeApplyDTO = null;
            try {
                revokeApplyDTO = revokeApplyDao.getRevokeApplyInfoByApplyNo(applyNo);
            } catch (EmptyResultDataAccessException e) {
                logger.info("getRevokeApplyInfo.applyNo:{} 查询撤销证书申请实体为空", applyNo);
                logger.info("获取撤销证书申请详细信息为空");
                result.setError(ErrorEnum.GET_REVOKE_APPLY_INFO_IS_EMPTY);
                return result;
            }
            // 记录审核通过操作
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_CHECK_3, applyNo, systemFlag, 0, checkInfo, Constants.CERT_APPLY_OPERATE_TYPE_CHECK_SUCCESS_4, false, isOnlineIssue);
            // 调用SDK发起证书撤销申请
            Result revokeResult = certLifeCycleManager.revokeUserCert(applyNo, raServiceDnName, caServiceDnName, revokeApplyDTO.getSignSn(), revokeApplyDTO.getCertDn(), revokeApplyDTO.getRevokeReason(), revokeApplyDTO.getApplyReason());
            if (!revokeResult.isSuccess()) {
                logger.info("发起证书撤销失败 errorCode:{} ", revokeResult.getErrorBean().getErrCode());
                result.setErrorBean(revokeResult.getErrorBean());
                applyStatus = Constants.CERT_APPLY_STATUS_REVOKE_FAIL_6;
                certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_REVOKE_4, applyNo, systemFlag, applyStatus, "证书撤销失败code:" + revokeResult.getErrorBean().getErrCode(), Constants.CERT_APPLY_OPERATE_TYPE_REVOKE_FAIL_5, false, isOnlineIssue);
            } else {
                applyStatus = Constants.CERT_APPLY_STATUS_REVOKED_7;
                certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_REVOKE_4, applyNo, systemFlag, applyStatus, revokeApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_REVOKE_SUCCESS_6, false, isOnlineIssue);

                Result updateStatusResult = userCertService.updateUserCertStatus(Constants.CERT_STATUS_REVOKED_3, revokeApplyDTO.getSignSn());
                if (!updateStatusResult.isSuccess()) {
                    logger.info("更新证书状态错误::{} ", JsonUtils.object2Json(updateStatusResult));
                    result.setError(updateStatusResult.getError());
                    throw new RuntimeException();
                }
            }
            // 更新申请状态
            Result updateResult = certApplyService.updateCertApplyInfo(null, applyNo, applyStatus, null);
            if (!updateResult.isSuccess()) {
                result.setError(updateResult.getError());
                return result;
            }
        } else if (Constants.CERT_APPLY_TYPE_FREEZE_5 == applyType || Constants.CERT_APPLY_TYPE_UNFREEZE_6 == applyType) {
            // 冻结解冻审核流程
            FreezeApplyDTO freezeApplyDTO = freezeApplyDao.getFreezeApplyInfoByApplyNo(applyNo);
            if (freezeApplyDTO == null) {
                logger.info(ErrorEnum.GET_FREEZE_UNFREEZE_APPLY_INFO_IS_EMPTY.desc);
                result.setError(ErrorEnum.GET_FREEZE_UNFREEZE_APPLY_INFO_IS_EMPTY);
                return result;
            }
            // 记录审核通过操作
            certApplyService.insertCertApplyRecord(freezeApplyDTO.getApplyType(), Constants.OPERATE_TYPE_CHECK_3, applyNo, systemFlag, 0, checkInfo, Constants.CERT_APPLY_OPERATE_TYPE_CHECK_SUCCESS_4, false, isOnlineIssue);
            // 调用SDK发起证书撤销申请
            CertLifeInfo certLifeInfo = new CertLifeInfo();
            certLifeInfo.setApplyNo(applyNo);
            certLifeInfo.setRaDN(raServiceDnName);
            certLifeInfo.setCaDN(caServiceDnName);
            certLifeInfo.setSignSn(freezeApplyDTO.getSignSn());
            certLifeInfo.setUserCertDN(freezeApplyDTO.getCertDn());
            Result freezeResult = certLifeCycleManager.freezeUserCert(certLifeInfo, applyType, freezeApplyDTO.getApplyReason());
            int operatorType;
            int operatorRepType;
            if (!freezeResult.isSuccess()) {
                logger.info("发起证书冻结解冻失败 errorCode:{} ", freezeResult.getErrorBean().getErrCode());
                result.setErrorBean(freezeResult.getErrorBean());
                if (applyType == ApplyTypeEnum.FREEZE_APPLY.id) {
                    applyStatus = Constants.CERT_APPLY_STATUS_FREEZE_FAIL_8;
                    operatorType = Constants.OPERATE_TYPE_FREEZE_6;
                    operatorRepType = Constants.CERT_APPLY_OPERATE_TYPE_FREEZE_FAIL_9;
                } else {
                    applyStatus = Constants.CERT_APPLY_STATUS_UNFREEZE_FAIL_10;
                    operatorType = Constants.OPERATE_TYPE_UNFREEZE_7;
                    operatorRepType = Constants.CERT_APPLY_OPERATE_TYPE_UNFREEZE_FAIL_11;
                }
                certApplyService.insertCertApplyRecord(applyType, operatorType, applyNo, systemFlag, applyStatus, "证书冻结/解冻失败code:" + freezeResult.getErrorBean().getErrCode(), operatorRepType, false, isOnlineIssue);
            } else {
                int certStatus;
                if (applyType == ApplyTypeEnum.FREEZE_APPLY.id) {
                    applyStatus = Constants.CERT_APPLY_STATUS_FREEZE_9;
                    operatorType = Constants.OPERATE_TYPE_FREEZE_6;
                    operatorRepType = Constants.CERT_APPLY_OPERATE_TYPE_FREEZE_SUCCESS_10;
                    certStatus = Constants.CERT_STATUS_FREEZE_4;
                } else {
                    applyStatus = Constants.CERT_APPLY_STATUS_UNFREEZE_11;
                    operatorType = Constants.OPERATE_TYPE_UNFREEZE_7;
                    operatorRepType = Constants.CERT_APPLY_OPERATE_TYPE_UNFREEZE_SUCCESS_12;
                    certStatus = Constants.CERT_STATUS_NORMAL_1;
                }
                certApplyService.insertCertApplyRecord(applyType, operatorType, applyNo, systemFlag, applyStatus, freezeApplyDTO.getApplyReason(), operatorRepType, false, isOnlineIssue);
                //BUG #80171 【证书管理】所选证书对应模板的审核策略为人工审核时，提交证书解冻申请并审核通过后，证书列表中的证书状态仍显示为已冻结  yangmenghao -- 2020-04-23
                Result updateStatusResult = userCertService.updateUserCertStatus(certStatus, freezeApplyDTO.getSignSn());
                if (!updateStatusResult.isSuccess()) {
                    logger.info("冻结解冻证书状态错误::{} ", JsonUtils.object2Json(updateStatusResult));
                    result.setError(updateStatusResult.getError());
                    throw new RuntimeException();
                }
            }
            // 更新申请状态
            Result updateResult = certApplyService.updateCertApplyInfo(null, applyNo, applyStatus, null);
            if (!updateResult.isSuccess()) {
                result.setError(updateResult.getError());
                return result;
            }
        } else if (Constants.CERT_APPLY_TYPE_REVOKE_3 != applyType) {
            // 针对与签发和更新申请 || 恢复申请应该也走此流程--yangmenghao@xdja.com
            // 如果用户已被停用则不支持审核通过
            //BaseUserDO baseUserInfo = baseUserDao.getBaseUserInfo(certApplyInfo.getUserId());
            if (baseUserInfo == null || baseUserInfo.getStatus() == Constants.USER_STATUS_STOP_1) {
                logger.info("当前申请状态不是待审核状态 status:{}", certApplyInfo.getApplyStatus());
                result.setError(ErrorEnum.USER_STATUS_CANNOT_CHECK_PASS);
                return result;
            }

            applyStatus = Constants.CERT_APPLY_STATUS_NOT_ISSUE_3;
            operateResultType = Constants.CERT_APPLY_OPERATE_TYPE_CHECK_SUCCESS_4;
            // 更新申请状态
            result = certApplyService.updateCertApplyInfo(null, applyNo, applyStatus, null);
            if (!result.isSuccess()) {
                return result;
            }
            /**
             * 针对第三方发起申请，通过页面审核情况,RA是非第三方系统标识
             */
            if (!baseUserInfo.getSystemFlag().equals(Constants.SYSTEM_FLAG_DEFAULT) && !isOnlineIssue) {
                DoubleCodeDO doubleCodeDO = new DoubleCodeDO();
                doubleCodeDO.setRefCode(baseUserInfo.getId());
                doubleCodeDO.setAuthCode(applyNo);
                doubleCodeDO.setIsUse(DoubleCodeUseEnum.NOT_USE.id);
                doubleCodeDao.InsertDouble(doubleCodeDO);
            }
            // 添加申请记录  因为没有待撤销状态  所以无法记录撤销申请时 审核通过的记录
            certApplyService.insertCertApplyRecord(applyType, Constants.OPERATE_TYPE_CHECK_3, applyNo, systemFlag, applyStatus, checkInfo, operateResultType, false, isOnlineIssue);
        }


        return result;
    }


    @Transactional
    @Override
    public Result issueUserCertResp(String applyNo, String systemFlag, boolean isOnlineIssue) {
        Result result = new Result();
        // 获取当前RA服务器签名证书DN
        // TODO 是否可直接从缓存中获取
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank(raServiceDnName)) {
            logger.error("获取RA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        // 获取目标CA证书DN
        // TODO 是否可直接从缓存中获取
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank(caServiceDnName)) {
            logger.error("获取CA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        if (!isOnlineIssue) {
            // 获取当前登录管理员的信息
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有制证员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_ISSUE_5)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }

        Map<String, String> raMap = ApplyVariable.getRaMap();
        if (CollectionUtils.isEmpty(raMap)) {
            logger.info("获取本地缓存申请信息为空");
            result.setError(ErrorEnum.GET_LOCAL_CACHE_APPLY_INFO_IS_EMPTY);
        }
        String raTransId = raMap.get(applyNo);

        // 获取申请编号对应的生成的证书sn(签名证书)
        CertApplyDO certApplyDO = certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyDO == null) {
            logger.info("不存在当前申请编号对应的申请记录 applyNo:" + applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }
        Result issueResult = certLifeCycleManager.issueCertResp(raServiceDnName, caServiceDnName, Constants.APPLY_USER_TYPE_NORMAL_USER_1, raTransId);
        if (!issueResult.isSuccess()) {
            // 更新申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, certApplyDO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作签发证书确认消息失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }
            raMap.remove(applyNo);
            // 添加申请记录
            certApplyService.insertCertApplyRecord(certApplyDO.getApplyType(), Constants.OPERATE_TYPE_ISSUE_5, applyNo, systemFlag, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, issueResult.getErrorBean().getErrMsg(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, isOnlineIssue);
            logger.info("签发证书确认消息出错");
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }

        raMap.remove(applyNo);
        List<String> certSnList = null;
        //审计日志
        StringBuilder stringBuilder = new StringBuilder();
        // 待正确发送到CA确认消息后，RA才将更新前老证书的状态至为已撤销  //更新
        if (Constants.CERT_APPLY_TYPE_UPDATE_2 == certApplyDO.getApplyType()) {
            UpdateApplyDTO updateApplyDTO = null;
            try {
                updateApplyDTO = updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
            } catch (EmptyResultDataAccessException e) {
                logger.info("getUpdateApplyInfoByApplyNo.applyNo:" + applyNo + " 查询更新证书申请实体为空");
            }
            if (updateApplyDTO == null) {
                logger.info("获取更新证书申请基本信息为空");
                result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
                return result;
            }

            try {
                userCertDao.updateDoubleUserCertStatus(Constants.CERT_STATUS_REVOKED_3, updateApplyDTO.getSignSn());
            } catch (Exception e) {
                logger.error("更新用户证书状态异常{}", e);
                throw new RuntimeException();
            }
            try {
                certSnList = certApplyDao.getCertSnByApplyNo(applyNo);
            } catch (Exception e) {
                logger.error("根据申请编号{}，未找到对应的签发证书sn", applyNo);
                result.setError(ErrorEnum.CANNOT_GET_CERT_SN_BY_APPLY_NO);
                return result;
            }
            // 更新证书状态
            Result updateStatusResult = userCertService.updateUserCertStatus(Constants.CERT_STATUS_NORMAL_1, certSnList.get(0));
            if (!updateStatusResult.isSuccess()) {
                result.setError(updateStatusResult.getError());
                return result;
            }
        } else if (Constants.CERT_APPLY_TYPE_RECOVERY_4 == certApplyDO.getApplyType()) {
            //恢复证书申请确认

            RecoveryApplyDTO recoveryApplyDTO = null;
            try {
                recoveryApplyDTO = recoveryApplyDao.getRecoveryApplyInfoByApplyNo(applyNo);
            } catch (EmptyResultDataAccessException e) {
                logger.info("getIssueApplyInfoByApplyNo.applyNo:" + applyNo + " 查询恢复证书申请实体为空");
            }
            if (recoveryApplyDTO == null) {
                logger.info("获取恢复证书申请基本信息为空");
                result.setError(ErrorEnum.GET_RECOVERY_APPLY_INFO_IS_EMPTY);
                return result;
            }
            UserCertDO oldSignCertInfo = userCertDao.getUserCertBaseInfo(recoveryApplyDTO.getSignSn());

            UserCertDO oldEncCertInfo = userCertDao.getUserCertBaseInfo(recoveryApplyDTO.getEncSn());
            try {
                certSnList = certApplyDao.getCertSnByApplyNo(applyNo);
            } catch (Exception e) {
                logger.error("根据申请编号{}，未找到对应的签发证书sn", applyNo);
                result.setError(ErrorEnum.CANNOT_GET_CERT_SN_BY_APPLY_NO);
                return result;
            }
            UserCertDO newSignCertInfo = userCertDao.getUserCertBaseInfo(certSnList.get(0));

            // 更新老的加密证书信息
            oldEncCertInfo.setPairCertIndex(newSignCertInfo.getPairCertIndex());
            oldEncCertInfo.setApplyId(newSignCertInfo.getApplyId());
            userCertDao.updateUserCert(oldEncCertInfo);

            // 更新老的签名证书
            oldSignCertInfo.setCertStatus(Constants.CERT_STATUS_REVOKED_3);
            oldSignCertInfo.setIsRecovery(Constants.SIGN_CERT_IS_RECOVERY_TRUE_1);
            userCertDao.updateUserCert(oldSignCertInfo);

            // 更新新的签名证书
            newSignCertInfo.setCertStatus(Constants.CERT_STATUS_NORMAL_1);
            userCertDao.updateUserCert(newSignCertInfo);

            stringBuilder.append("，证书的SN=" + certSnList.get(0));
        } else {
            try {
                certSnList = certApplyDao.getCertSnByApplyNo(applyNo);
            } catch (Exception e) {
                logger.error("根据申请编号{}，未找到对应的签发证书sn", applyNo);
                result.setError(ErrorEnum.CANNOT_GET_CERT_SN_BY_APPLY_NO);
                return result;
            }

            // 更新证书状态
            Result updateStatusResult = userCertService.updateUserCertStatus(Constants.CERT_STATUS_NORMAL_1, certSnList.get(0));
            if (!updateStatusResult.isSuccess()) {
                result.setError(updateStatusResult.getError());
                return result;
            }
            stringBuilder.append("，证书的SN=" + certSnList.get(0));
        }
        // 添加申请记录
        certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_ISSUE_1, Constants.OPERATE_TYPE_ISSUE_5, applyNo, systemFlag, Constants.CERT_APPLY_STATUS_ISSUED_5, "用户证书-成功签发", Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_SUCCESS_8, false, isOnlineIssue);

        result.setLogContent(stringBuilder.toString());
        result.setLogContent(stringBuilder.append("，证书主体=" + certApplyDO.getCertDn()).toString());

        // 更新申请状态
        Result issueCertApplyResult = certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUED_5, certApplyDO.getTempId());
        if (issueCertApplyResult.getCode() != 0) {
            logger.info("操作签发失败:" + JsonUtils.object2Json(issueCertApplyResult));
            throw new RuntimeException();
        }
        return result;
    }


    @Override
    public Result getUserCertStatus(String applyNo) {
        Result result = new Result();
        List<String> certSnList = null;
        // 获取申请编号对应的生成的证书sn(签名证书)
        try {
            certSnList = certApplyDao.getCertSnByApplyNo(applyNo);
        } catch (Exception e) {
            logger.error("根据申请编号{}，未找到对应的签发证书sn", applyNo);
            result.setError(ErrorEnum.CANNOT_GET_CERT_SN_BY_APPLY_NO);
            return result;
        }

        String certSn = certSnList.get(0);
        Result certStatusResult = caBusinessManager.getCertStatus(certSn);
        if (!certStatusResult.isSuccess()) {
            return certStatusResult;
        }

        int status = (int) certStatusResult.getInfo();
        // 如果用户证书状态不为0，标识CA已经确认过该证书了
        if (status != Constants.CERT_STATUS_NO_CONFIRM_0) {
            try {
                userCertDao.updateDoubleUserCertStatus(status, certSn);
            } catch (Exception e) {
                logger.error("更新用户证书状态异常", e);
                result.setError(ErrorEnum.UPDATE_USER_CERT_STATUS_EXCEPTION);
                return result;
            }
        }
        result.setInfo(status);
        return result;
    }


    @Override
    public Result genErrorMsgContent(String applyNo, int errorCode, String errorMsg, boolean isOnlineIssue) {
        Result result = new Result();

        if (!isOnlineIssue) {
            // 获取当前登录管理员的信息
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有制证员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_ISSUE_5)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }

        // 获取当前RA服务器签名证书DN
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank(raServiceDnName)) {
            logger.error("获取RA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        // 获取目标CA证书DN
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank(caServiceDnName)) {
            logger.error("获取CA服务器证书DN名字错误");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        Map<String, String> raMap = ApplyVariable.getRaMap();
        if (CollectionUtils.isEmpty(raMap)) {
            logger.info("获取本地缓存申请信息为空");
            result.setError(ErrorEnum.GET_LOCAL_CACHE_APPLY_INFO_IS_EMPTY);
        }
        String raTransId = raMap.get(applyNo);

        // 获取申请编号对应的生成的证书sn(签名证书)
        CertApplyDO certApplyDO = certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyDO == null) {
            logger.info("不存在当前申请编号对应的申请记录 applyNo:" + applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }

        Result errResult = certLifeCycleManager.sendErrorCMPMessage(raServiceDnName, caServiceDnName, Constants.APPLY_USER_TYPE_NORMAL_USER_1, raTransId, errorCode, errorMsg);
        if (!errResult.isSuccess()) {
            // 更新申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, certApplyDO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作签发证书确认消息失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }

            // 添加申请记录
            certApplyService.insertCertApplyRecord(certApplyDO.getApplyType(), Constants.OPERATE_TYPE_ISSUE_5, applyNo, null, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, errResult.getErrorBean().getErrMsg(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, isOnlineIssue);

            logger.info("错误确认消息出错：" + JsonUtils.object2Json(errResult));
            result.setErrorBean(errResult.getErrorBean());
            return result;
        }

        // 更新申请状态
        Result issueCertApplyResult = certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, certApplyDO.getTempId());
        if (issueCertApplyResult.getCode() != 0) {
            logger.info("操作签发证书确认消息失败:" + JsonUtils.object2Json(issueCertApplyResult));
            throw new RuntimeException();
        }

        // 添加申请记录
        certApplyService.insertCertApplyRecord(certApplyDO.getApplyType(), Constants.OPERATE_TYPE_ISSUE_5, applyNo, null, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, errorMsg, Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, isOnlineIssue);

        return result;
    }

    @Override
    public Result defaultContainer(String defaultContainer) {
        Result result = new Result();
        //DO 20200717 将该配置移到config.json
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            config.setDefaultContainer(defaultContainer);
            systemService.updateConfigFile(config);
        } catch (Exception e) {
            logger.error("保存默认容器操作异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        return result;
    }

    @Override
    public Result getDefaultContainer() {
        Result result = new Result();
        //DO 20200717 将该配置移到config.json
        Config config = null;
        try {
            config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                logger.error("获取配置文件为空");
                result.setError(ErrorEnum.GET_DEFAULT_CONTAINER_IS_EMPTY);
                return result;
            }
        } catch (Exception e) {
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }

        String defaultContainer = config.getDefaultContainer();
        logger.info("默认容器为 ： " + defaultContainer);
        result.setInfo(config);
        return result;
    }


    @Override
    public Result getBaseDn(String tempNo) {
        //DO 模板编号 最新同步模板的baseDn  可能模板为旧的没有该值
        String tempBaseDn = null;
        try {
            tempBaseDn = certApplyDao.getBaseDnByTempNo(tempNo);
        } catch (DataAccessException e) {
            logger.info("通过模板编号未获取到模板baseDn");
        }
        Result raBaseDnResult = getRaBaseDn();
        if (!raBaseDnResult.isSuccess()) {
            return raBaseDnResult;
        }
        String raBaseDn = raBaseDnResult.getInfo().toString();

        BaseDn baseDn = new BaseDn(raBaseDn, tempBaseDn);

        return Result.success(baseDn);
    }

    @Override
    public Result getRaBaseDn() {
        // DO 从缓存获取baseDn --> 配置文件读取baseDn -->请求CA获取
        String raBaseDn = CommonVariable.getRaBaseDn();
        if (!StringUtils.isBlank(raBaseDn)) {
            return Result.success(raBaseDn);
        }
        Result result = new Result();

        try {
            Config config = (Config) SpringUtils.getBean("configFile");
            raBaseDn = config.getRaBaseDn();
            if (StringUtils.isNotBlank(raBaseDn)) {
                return Result.success(raBaseDn);
            }else {
                result = caBusinessManager.getRaBaseDN();
                if (!result.isSuccess()) {
                    return result;
                }
                raBaseDn = (String) result.getInfo();

                Config config2 = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
                config2.setRaBaseDn(raBaseDn);
                systemService.updateConfigFile(config2);
            }

            CommonVariable.setRaBaseDn(raBaseDn);
            return Result.success(raBaseDn);

        } catch (Exception e) {
            logger.error("写入raBaseDn服务操作config.json异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
    }


    /**
     * 将CA返回的用户证书插入到数据表中
     *
     * @param userId
     * @param applyId
     * @param tempId
     * @param signAlg
     * @param privateKeyLength
     * @param userCertInfo
     * @return
     */
    private Result insertUserCertInfo(long userId, long applyId, long tempId, String tempNo, String signAlg, int privateKeyLength, UserCertInfo userCertInfo) {

        Result result = new Result();
        String signCert = userCertInfo.getSignCert();
        if (StringUtils.isBlank(signCert)) {
            logger.info("CA返回的用户证书信息中，签名证书为空");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_INFO_IS_EMPTY);
            return result;
        }
        X509Certificate signCertStr = CertUtils.getCertFromStr(signCert);
        if (signCertStr == null) {
            logger.info("CA返回的用户证书信息中，签名证书错误");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
            return result;
        }
        long pairCertIndex;
        synchronized (LOCK_INSERT_PAIR_CERT_INDEX){
            pairCertIndex = System.nanoTime() +(ThreadLocalRandom.current().nextLong(0,9999999) + 90000000);
        }

        UserCertDO signCertDO = new UserCertDO();
        signCertDO.setPairCertIndex(pairCertIndex);
        if (StringUtils.isBlank(userCertInfo.getEncCert())) {
            signCertDO.setCertType(Constants.CERT_TYPE_SINGLE_1);
        } else {
            signCertDO.setCertType(Constants.CERT_TYPE_SIGN_2);
        }
        signCertDO.setCertStatus(Constants.CERT_STATUS_NO_CONFIRM_0);

        signCertDO.setUserId(userId);
        signCertDO.setApplyId(applyId);
        signCertDO.setTempId(tempId);
        signCertDO.setTempNo(tempNo);
        signCertDO.setSignAlg(signAlg);
        signCertDO.setPrivateKeyLength(privateKeyLength);

        CaCertDO newCaCertInfo = caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            logger.info("获取CA证书信息为空");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        signCertDO.setCaCertId(newCaCertInfo.getId());


        signCertDO.setCertSn(signCertStr.getSerialNumber().toString(16).toLowerCase());
        signCertDO.setCertDn(CertUtils.getSubjectByX509Cert(signCertStr));

        Date startDate = signCertStr.getNotBefore();
        Date endDate = signCertStr.getNotAfter();
        signCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        signCertDO.setFailureTime(new Timestamp(endDate.getTime()));

        // 用户证书有效期
        int certDays = (int) ((endDate.getTime() - startDate.getTime()) / (1000 * 3600 * 24));
        signCertDO.setCertValidity(certDays);

        // 用户证书中对应的加密公私钥的有效天数
        int priKeyDays = (int) ((newCaCertInfo.getFailureTime().getTime() - startDate.getTime()) / (1000 * 3600 * 24));
        signCertDO.setEncKeyValidity(priKeyDays);

        Date date = new Date();
        signCertDO.setGmtCreate(new Timestamp(date.getTime()));
        signCertDO.setGmtUpdate((new Timestamp(date.getTime())));
        UserCertDO userSignCertDO = userCertDao.insertUserCertInfo(signCertDO);

        // 加密
        String encCert = userCertInfo.getEncCert();
        if (StringUtils.isNotBlank(encCert)) {

            UserCertDO encCertDO = new UserCertDO();
            encCertDO.setPairCertIndex(pairCertIndex);
            encCertDO.setCertType(Constants.CERT_TYPE_ENC_3);
            encCertDO.setCertStatus(Constants.CERT_STATUS_NO_CONFIRM_0);

            encCertDO.setUserId(userId);
            encCertDO.setApplyId(applyId);
            encCertDO.setTempId(tempId);
            encCertDO.setTempNo(tempNo);
            encCertDO.setSignAlg(signAlg);
            encCertDO.setPrivateKeyLength(privateKeyLength);

            encCertDO.setCaCertId(newCaCertInfo.getId());

            encCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
            encCertDO.setFailureTime(new Timestamp(endDate.getTime()));

            encCertDO.setCertValidity(certDays);
            encCertDO.setEncKeyValidity(priKeyDays);

            X509Certificate encCertStr = CertUtils.getCertFromStr(encCert);
            if (encCertStr == null) {
                logger.info("CA返回的用户证书信息中，加密证书错误");
                result.setError(ErrorEnum.CA_RESPONSE_USER_ENC_CERT_ERROR);
                return result;
            }

            encCertDO.setGmtCreate(new Timestamp(date.getTime()));
            encCertDO.setGmtUpdate((new Timestamp(date.getTime())));

            encCertDO.setCertSn(encCertStr.getSerialNumber().toString(16).toLowerCase());
            encCertDO.setSignCertSn(userSignCertDO.getCertSn());
            try {
                encCertDO.setCertDn(CertUtils.getSubjectByX509Cert(encCertStr));
                userCertDao.insertUserCertInfo(encCertDO);
            } catch (Exception e) {
                logger.info("手动处理manager层的插入异常");
                userCertDao.deleteUserCert(userSignCertDO.getId());
            }
        }
        return result;
    }


    /**
     * 处理签发申请
     *
     * @param certFormatType 证书格式
     * @param applyNo        申请编号
     * @param cardNo         卡号
     * @param issueBytes     签发公钥信息(针对Tbox方式签发做了兼容，如果是Tbox的申请该内容为公钥，否则为P10信息)
     * @param raDN           ra的DN
     * @param caDN           ca的DN
     * @param transId        事务ID
     * @param issueType      签发方式  1 ukey  2 p10
     * @param isOnlineIssue  是否在线签发- issueBytes 在线签发情况下为公钥信息，离线签发为P10信息
     * @param isTboxIssue    是否是TBOX签发(未使用到)
     * @param extParam       扩展参数-> [certDn-用户自定义DN && ...]
     * @return
     */
    private Result issueApplyHandler(Integer certFormatType, String applyNo, String systemFlag,
                                     String cardNo, byte[] issueBytes, String raDN, String caDN, String transId,
                                     int issueType, boolean isOnlineIssue, boolean isTboxIssue,
                                     Map<String, Object> extParam, Integer keyFormat) {
        Result result = new Result();
        // 从签发申请中获取响应内容
        IssueApplyDTO issueApplyDTO;
        try {
            issueApplyDTO = issueApplyDao.getIssueApplyInfoByApplyNo(applyNo);
        } catch (Exception e) {
            logger.info("获取签发证书申请基本信息为空");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }

        int certValidity = issueApplyDTO.getCertValidity();
        String signAlg = issueApplyDTO.getSignAlg();
        String tempNo = issueApplyDTO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank(issueApplyDTO.getTempParas())) {
            tempParas = issueApplyDTO.getTempParas();
        }
        // BEGIN 2020/01/08 RA-签发证书时，支持从证书申请P10 中读取DN生成证书(#5907)  yangmenghao@xdja.com
        String userCertDN = chooseUserCertDn(extParam, issueApplyDTO.getCertDn());
        // END 2020/01/08
        // 获取P10中的公钥信息  bks签发中P10 无申请信息
        byte[] publicKeyByte = null;
        if (!isOnlineIssue) {
            try {
                String userP10Str = new String(issueBytes);
                PublicKey publicKey = SdkP10Utils.p10ToPublicKey(userP10Str);
                publicKeyByte = publicKey.getEncoded();
                // 校验申请信息和上传的P10信息是否一致
                // BEGIN 2020/01/08 方法抽取->判断逻辑与处理更新申请的一致  yangmenghao@xdja.com
                result = this.checkApplyMsgEqualP10(userP10Str, publicKey, issueApplyDTO.getPrivateKeyLength());
                if (!result.isSuccess()) {
                    return result;
                }
                // END 2020/01/08
            } catch (Exception e) {
                logger.info("从P10中获取公钥信息异常", e);
                result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
                return result;
            }
        } else {
            publicKeyByte = issueBytes;
        }
        Result issueResult = certLifeCycleManager.issueUserCert(applyNo, cardNo, publicKeyByte, raDN, caDN, transId, tempNo, tempParas, signAlg, certValidity, userCertDN, keyFormat);
        if (!issueResult.isSuccess()) {
            // 更新申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(issueApplyDTO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, issueApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作签发失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }

            // 添加申请记录
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_ISSUE_1, Constants.OPERATE_TYPE_ISSUE_5, applyNo, systemFlag, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, issueResult.getErrorBean().getErrMsg(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, isOnlineIssue);

            logger.error("调用CA，签发证书失败");
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo) issueResult.getInfo();
        // 用户证书入库
        Result certInsertResult = this.insertUserCertInfo(issueApplyDTO.getUserId(), issueApplyDTO.getApplyId(), issueApplyDTO.getTempId(), issueApplyDTO.getTempNo(), signAlg, issueApplyDTO.getPrivateKeyLength(), userCertInfo);

        if (!certInsertResult.isSuccess()) {
            logger.info("将用户证书插入数据库失败");
            result.setError(certInsertResult.getError());
            return result;
        }
        if (issueType == Constants.APPLY_CERT_TYPE_BY_UKEY_1 || isOnlineIssue || certFormatType == Constants.P10_ISSUE_TYPE_BKS_5) {
            result.setInfo(userCertInfo);
            return result;
        }

        // 将用户证书和信任链拼装成信任证书链
        List<X509Certificate> caTrustCert = CommonVariable.getTrustCaCerts();
        List<X509Certificate> caTrust = new ArrayList<>(caTrustCert);

        try {
            X509Certificate signCert = CertUtils.getCertFromStr(userCertInfo.getSignCert());
            caTrust.add(signCert);
            String signTrustCert = SignedDataUtils.createCertChainByCerts(caTrust);
            userCertInfo.setSignCert(signTrustCert);
            if (issueApplyDTO.getCertPatterm() != SdkConstants.CERT_TYPE_SINGLE_1) {
                caTrust.remove(signCert);
                X509Certificate encCert = CertUtils.getCertFromStr(userCertInfo.getEncCert());
                caTrust.add(encCert);
                String encTrustCert = SignedDataUtils.createCertChainByCerts(caTrust);
                userCertInfo.setEncCert(encTrustCert);
            }
        } catch (Exception e) {
            logger.error("sdk接口-封装证书链异常", e);
            result.setError(ErrorEnum.BUILD_TRAIN_CERT_P7b_IS_ERROR);
            return result;
        }
        result.setInfo(userCertInfo);
        return result;
    }


    /**
     * 处理更新申请
     *
     * @param applyNo
     * @param cardNo
     * @param issueBytes
     * @param raDN
     * @param caDN
     * @param transId
     * @return
     */
    private Result updateApplyHandler(Integer certFormatType, String applyNo, String systemFlag,
                                      String cardNo, byte[] issueBytes, String raDN, String caDN, String transId,
                                      int issueType, boolean isOnlineIssue, boolean isTboxIssue,
                                      Map<String, Object> extParam, Integer keyFormat) {
        Result result = new Result();
        // 从签发申请中获取相应内容
        UpdateApplyDTO updateApplyDTO = null;
        try {
            updateApplyDTO = updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
        } catch (EmptyResultDataAccessException e) {
            logger.info("getUpdateApplyInfo.applyNo:" + applyNo + " 查询更新证书申请实体为空");
        }
        if (updateApplyDTO == null) {
            logger.info("获取更新证书申请基本信息为空");
            result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int certValidity = 0;
        if (updateApplyDTO.getUpdateValidity()) {
            certValidity = updateApplyDTO.getCertValidity();
        }
        String tempNo = updateApplyDTO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank(updateApplyDTO.getTempParas())) {
            tempParas = updateApplyDTO.getTempParas();
        }

        // 获取P10中的公钥信息
        byte[] publicKeyByte = null;
        // 校验申请信息和上传的P10信息是否一致
        if (!isOnlineIssue) {
            //页面更新
            if (updateApplyDTO.getUpdateKey()) {
                try {
                    String userP10Str = new String(issueBytes);
                    PublicKey publicKey = SdkP10Utils.p10ToPublicKey(userP10Str);
                    if (publicKey == null) {
                        logger.info("更新密钥时，必须上传p10文件");
                        result.setError(ErrorEnum.UPDATE_KEY_NEED_P10_FILE);
                        return result;
                    }
                    publicKeyByte = publicKey.getEncoded();
                    // 校验申请信息和上传的P10信息是否一致
                    // BEGIN 2020/01/08 方法抽取->判断逻辑与处理签发申请一致  yangmenghao@xdja.com
                    result = this.checkApplyMsgEqualP10(userP10Str, publicKey, updateApplyDTO.getPrivateKeyLength());
                    if (!result.isSuccess()) {
                        return result;
                    }
                    // END 2020/01/08
                } catch (Exception e) {
                    logger.info("从P10中获取公钥信息异常", e);
                    result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
                    return result;
                }
            }
        } else {
            if (updateApplyDTO.getUpdateKey()) {
                // issueBytes 是个公钥
                if (issueBytes == null) {
                    logger.info("更新密钥时，必须上传p10文件");
                    result.setError(ErrorEnum.UPDATE_KEY_NEED_P10_FILE);
                    return result;
                }
                logger.info("在线更新申请更新秘钥");
                publicKeyByte = issueBytes;
            } else {
                logger.info("在线更新申请不更新秘钥");
                publicKeyByte = null;
            }

        }
        // BEGIN 2020/01/08 RA-签发证书时，支持从证书申请P10 中读取DN生成证书(#5907)  yangmenghao@xdja.com
        String userCertDN = chooseUserCertDn(extParam, updateApplyDTO.getCertDn());
        // END 2020/01/08
        Result updateResult = certLifeCycleManager.updateUserCert(applyNo, cardNo, publicKeyByte, raDN, caDN, transId, tempNo, tempParas, updateApplyDTO.getSignAlg(), certValidity, userCertDN, updateApplyDTO.getSignSn(), updateApplyDTO.getUpdateKey(), keyFormat);
        if (!updateResult.isSuccess()) {
            // 更新申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(updateApplyDTO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, updateApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作签发失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }

            // 添加申请记录
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_UPDATE_2, Constants.OPERATE_TYPE_ISSUE_5, applyNo, systemFlag, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, updateApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, isOnlineIssue);

            logger.info("调用CA，更新证书失败");
            result.setErrorBean(updateResult.getErrorBean());
            return result;
        }

        UserCertInfo userCertInfo = (UserCertInfo) updateResult.getInfo();

        // 用户证书入库
        Result certInsertResult = this.insertUserCertInfo(updateApplyDTO.getUserId(), updateApplyDTO.getApplyId(), updateApplyDTO.getTempId(), updateApplyDTO.getTempNo(), updateApplyDTO.getSignAlg(), updateApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            logger.info("将用户证书插入数据库失败");
            throw new RuntimeException();
        }

        if (issueType == Constants.APPLY_CERT_TYPE_BY_UKEY_1 || isOnlineIssue || certFormatType == Constants.P10_ISSUE_TYPE_BKS_5) {
            result.setInfo(userCertInfo);
            return result;
        }

        // 将用户证书和信任链拼装成信任证书链
        List<X509Certificate> caTrustCert = CommonVariable.getTrustCaCerts();
        List<X509Certificate> caTrust = new ArrayList<>(caTrustCert);

        X509Certificate signCert = CertUtils.getCertFromStr(userCertInfo.getSignCert());
        caTrust.add(signCert);
        try {
            String signTrustCert = SignedDataUtils.createCertChainByCerts(caTrust);
            userCertInfo.setSignCert(signTrustCert);
            if (updateApplyDTO.getCertPatterm() != SdkConstants.CERT_TYPE_SINGLE_1) {
                caTrust.remove(signCert);
                X509Certificate encCert = CertUtils.getCertFromStr(userCertInfo.getEncCert());
                caTrust.add(encCert);
                String encTrustCert = SignedDataUtils.createCertChainByCerts(caTrust);
                userCertInfo.setEncCert(encTrustCert);
            }

        } catch (Exception e) {
            logger.error("sdk接口-封装证书链异常", e);
            result.setError(ErrorEnum.BUILD_TRAIN_CERT_P7b_IS_ERROR);
            return result;
        }
        result.setInfo(userCertInfo);
        return result;
    }

    /**
     * 处理恢复申请
     *
     * @param applyNo
     * @param cardNo
     * @param issueBytes
     * @param raDN
     * @param caDN
     * @return
     */
    private Result recoveryApplyHandler(Integer certFormatType, String applyNo, String systemFlag, String cardNo, byte[] issueBytes, String raDN, String caDN, String transId, int issueType, boolean isOnlineIssue, Integer keyFormat) {
        Result result = new Result();
        // 从恢复申请中获取响应内容
        RecoveryApplyDTO recoveryApplyDTO = null;
        try {
            recoveryApplyDTO = recoveryApplyDao.getRecoveryApplyInfoByApplyNo(applyNo);
        } catch (Exception e) {
            logger.info("获取恢复证书申请基本信息为空");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        byte[] publicKeyByte = null;
        if (!isOnlineIssue) {
            try {
                String userP10Str = new String(issueBytes);
                PublicKey publicKey = SdkP10Utils.p10ToPublicKey(userP10Str);
                publicKeyByte = publicKey.getEncoded();
                // 校验申请信息和上传的P10信息是否一致
                // BEGIN 2020/01/08 方法抽取->判断逻辑与处理更新申请的一致  yangmenghao@xdja.com
                result = this.checkApplyMsgEqualP10(userP10Str, publicKey, recoveryApplyDTO.getPrivateKeyLength());
                if (!result.isSuccess()) {
                    return result;
                }
                // END 2020/01/08
            } catch (Exception e) {
                logger.info("从P10中获取公钥信息异常", e);
                result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
                return result;
            }
        } else {
            publicKeyByte = issueBytes;
        }

        String signAlg = recoveryApplyDTO.getSignAlg();
        String userCertDN = recoveryApplyDTO.getCertDn();
        Result recoveryResult = certLifeCycleManager.recoveryUserCert(applyNo, raDN, caDN, publicKeyByte, recoveryApplyDTO.getSignSn(), transId, signAlg, userCertDN, keyFormat);
        if (!recoveryResult.isSuccess()) {
            // 恢复申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(recoveryApplyDTO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, recoveryApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作恢复失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }

            // 添加申请记录
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_RECOVERY_4, Constants.OPERATE_TYPE_ISSUE_5, applyNo, systemFlag, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, recoveryResult.getErrorBean().getErrMsg(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, isOnlineIssue);

            logger.error("调用CA，签发证书失败");
            result.setErrorBean(recoveryResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo) recoveryResult.getInfo();

        // 用户证书入库
        Result certInsertResult = this.insertUserCertInfoByRecovery(recoveryApplyDTO.getUserId(), recoveryApplyDTO.getApplyId(), recoveryApplyDTO.getTempId(), recoveryApplyDTO.getTempNo(), signAlg, recoveryApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            logger.info("将用户证书插入数据库失败");
            result.setError(certInsertResult.getError());
            return result;
        }
        // 2020-01-17 在线签发时候直接返回 ---> ra-sdk 恢复证书 yangmenghao@xdja.com
        if (issueType == Constants.APPLY_CERT_TYPE_BY_UKEY_1 || isOnlineIssue || certFormatType == Constants.P10_ISSUE_TYPE_BKS_5) {
            result.setInfo(userCertInfo);
            return result;
        }

        // 将用户证书和信任链拼装成信任证书链
        List<X509Certificate> caTrustCert = CommonVariable.getTrustCaCerts();
        List<X509Certificate> caTrust = new ArrayList<>(caTrustCert);

        X509Certificate signCert = CertUtils.getCertFromStr(userCertInfo.getSignCert());
        caTrust.add(signCert);
        try {
            String signTrustCert = SignedDataUtils.createCertChainByCerts(caTrust);
            userCertInfo.setSignCert(signTrustCert);
            caTrust.remove(signCert);
            X509Certificate encCert = CertUtils.getCertFromStr(userCertInfo.getEncCert());
            caTrust.add(encCert);
            String encTrustCert = SignedDataUtils.createCertChainByCerts(caTrust);
            userCertInfo.setEncCert(encTrustCert);

        } catch (Exception e) {
            logger.error("sdk接口-封装证书链异常", e);
            result.setError(ErrorEnum.BUILD_TRAIN_CERT_P7b_IS_ERROR);
            return result;
        }
        result.setInfo(userCertInfo);
        return result;
    }

    /**
     * 选择用户证书DN
     *
     * @param extParam    扩展参数-> [certDn-用户自定义DN && ...]
     * @param applyCertDn 申请书中的CertDn
     * @return 筛选后的 userCertDn
     */
    private String chooseUserCertDn(Map<String, Object> extParam, String applyCertDn) {
        String userCertDN;
        //离线形式的签发证书，判断 是否传入用户自定义的certDn
        if (MapUtils.isNotEmpty(extParam) && extParam.containsKey("certDn")) {
            userCertDN = (String) extParam.get("certDn");
            try {
                userCertDN = DnUtil.getRFC4519X500Name(userCertDN).toString();
            } catch (NamingException e) {
                logger.info("离线签发使用用户自定义的DN格式异常", e);
            }
            logger.info("[CertApplyServiceImpl#chooseUserCertDn] 离线形式的签发证书，使用用户传入的自定义 certDn ={} 制证", userCertDN);
        } else {
            userCertDN = applyCertDn;
            logger.info("[CertApplyServiceImpl#chooseUserCertDn] 使用申请书中 certDn ={} 制证", userCertDN);
        }
        return userCertDN;
    }

    /**
     * 校验申请信息和上传的P10信息是否一致
     *
     * @param p10           P10信息
     * @param publicKey     P10中的公钥
     * @param privateKeyLen 申请书中的私钥长度
     * @return result 结果
     */
    private Result checkApplyMsgEqualP10(String p10, PublicKey publicKey, int privateKeyLen) {
        Result result = new Result();
        String p10FileDnName = SdkP10Utils.p10ToCertDn(p10);
        logger.info("申请书中的用户DN为:{}", p10FileDnName);
        SubjectPublicKeyInfo instance = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        ASN1Encodable asn1Encodable = instance.getAlgorithmId().getParameters();

        String algorithm;
        if (publicKey.getAlgorithm().equals("RSA")) {
            algorithm = Constants.KEY_ALG_NAME_RSA;
        } else {
            ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(asn1Encodable.toString());
            if (oid.equals(SM2ObjectIdentifiers.sm2256)) {
                algorithm = Constants.KEY_ALG_NAME_SM2;
            } else if (oid.equals(NISTObjectIdentifiers.nist256)) {
                algorithm = Constants.KEY_ALG_NAME_NIST;
            } else {
                logger.info("不支持的签名算法");
                result.setError(ErrorEnum.NOT_SUPPORTED_SIGN_ALG);
                return result;
            }
        }

        logger.info("申请书中的用户密钥算法为:{}", algorithm);
        if (!algorithm.equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
            logger.info("用户证书秘钥算法和当前系统密钥算法不一致");
            result.setError(ErrorEnum.USER_CERT_KEY_ALG_NOT_SAME_WITH_SYSTEM);
            return result;
        }
        try {
            X509EncodedKeySpec eks = new X509EncodedKeySpec(new DERBitString(instance).getBytes());
            if (algorithm.equalsIgnoreCase(Constants.KEY_ALG_NAME_SM2) || algorithm.equalsIgnoreCase(Constants.KEY_ALG_NAME_NIST)) {
                //if (algorithm.equalsIgnoreCase("EC")) {
                // if (oid.on(SM2ObjectIdentifiers.sm2Algorithm) || oid.on(NISTObjectIdentifiers.nistAlgorithm)) {
                KeyFactory kf = KeyFactory.getInstance("EC", BouncyCastleProvider.PROVIDER_NAME);
                BCECPublicKey bcecPublicKey = (BCECPublicKey) kf.generatePublic(eks);
                int length = bcecPublicKey.getW().getAffineX().bitLength();
                logger.info("证书密钥算法长度为:{}", length);
                if (privateKeyLen != 256) {
                    logger.info("用户证书秘钥算法长度和申请时的秘钥长度不一致");
                    result.setError(ErrorEnum.USER_CERT_KEY_ALG_LENGTH_NOT_SAME_WITH_APPLY);
                    return result;
                }
            } else {
                KeyFactory kf = KeyFactory.getInstance("RSA", BouncyCastleProvider.PROVIDER_NAME);
                BCRSAPublicKey bcrsaPublicKey = (BCRSAPublicKey) kf.generatePublic(eks);
                if (privateKeyLen != bcrsaPublicKey.getModulus().bitLength()) {
                    logger.info("用户证书秘钥算法长度和申请时的秘钥长度不一致");
                    result.setError(ErrorEnum.USER_CERT_KEY_ALG_LENGTH_NOT_SAME_WITH_APPLY);
                    return result;
                }
            }
        } catch (NoSuchAlgorithmException e) {
            logger.info("[CertApplyServiceImpl#checkApplyMsgEqualP10] 申请信息和P10一致性校验 NoSuchAlgorithmException", e);
            result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
            return result;
        } catch (NoSuchProviderException e) {
            logger.info("[CertApplyServiceImpl#checkApplyMsgEqualP10] 申请信息和P10一致性校验 NoSuchProviderException", e);
            result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
            return result;
        } catch (InvalidKeySpecException e) {
            logger.info("[CertApplyServiceImpl#checkApplyMsgEqualP10] 申请信息和P10一致性校验 InvalidKeySpecException", e);
            result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
            return result;
        } catch (IOException e) {
            logger.info("[CertApplyServiceImpl#checkApplyMsgEqualP10] 申请信息和P10一致性校验 IOException", e);
            result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
            return result;
        }
        return Result.success();
    }

    /**
     * 为无密钥生成能力的用户签发证书
     *
     * @param applyNo
     * @param raDN
     * @param caDN
     * @param transId
     * @param isOnlineIssue
     * @return
     */
    private Result issueApplyHandlerByKeyStore(String applyNo, String raDN, String caDN, String transId, int certFormatType, boolean isOnlineIssue, Integer keyFormat) {
        Result result = new Result();
        // 从签发申请中获取响应内容
        IssueApplyDTO issueApplyDTO = null;
        try {
            issueApplyDTO = issueApplyDao.getIssueApplyInfoByApplyNo(applyNo);
        } catch (Exception e) {
            logger.info("获取签发证书申请基本信息为空");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }

        int certValidity = issueApplyDTO.getCertValidity();
        String signAlg = issueApplyDTO.getSignAlg();
        String tempNo = issueApplyDTO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank(issueApplyDTO.getTempParas())) {
            tempParas = issueApplyDTO.getTempParas();
        }

        String userCertDN = issueApplyDTO.getCertDn();

        String keyAlgName = issueApplyDTO.getKeyAlg();
        int keyLength = issueApplyDTO.getPrivateKeyLength();
        logger.info("密钥算法：" + keyAlgName + " 密钥长度：" + keyLength);

        KeyPair signKeyPair;
        try {
            signKeyPair = KeyUtils.genKeyPair(keyAlgName, keyLength);
        } catch (Exception e) {
            logger.info("生成用户签名公私钥失败");
            result.setError(ErrorEnum.GEN_USER_CERT_SIGN_KEY_FAIL);
            return result;
        }

        Result issueResult = certLifeCycleManager.issueUserCert(applyNo, null, signKeyPair.getPublic().getEncoded(), raDN, caDN, transId, tempNo, tempParas, signAlg, certValidity, userCertDN, keyFormat);
        if (!issueResult.isSuccess()) {
            // 更新申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(issueApplyDTO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, issueApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作签发失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }

            // 添加申请记录
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_ISSUE_1, Constants.OPERATE_TYPE_ISSUE_5, applyNo, null, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, issueResult.getErrorBean().getErrMsg(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, isOnlineIssue);

            logger.error("调用CA，签发证书失败");
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo) issueResult.getInfo();

        // 用户证书入库
        Result certInsertResult = this.insertUserCertInfo(issueApplyDTO.getUserId(), issueApplyDTO.getApplyId(), issueApplyDTO.getTempId(), issueApplyDTO.getTempNo(), signAlg, issueApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            logger.info("将用户证书插入数据库失败");
            result.setError(certInsertResult.getError());
            return result;
        }

        // 用私钥解密用户加密私钥信封
        PrivateKey encPriKey = null;
        if (issueApplyDTO.getCertPatterm() != SdkConstants.CERT_TYPE_SINGLE_1) {
            try {
                logger.info("签名私钥：" + Base64.toBase64String(signKeyPair.getPrivate().getEncoded()) + " 私钥信封：" + userCertInfo.getEncPriKey());
                String encPriKeyStr = CertUtils.getDataFromSignedAndEnvelopedDataByBc(signKeyPair.getPrivate().getEncoded(), userCertInfo.getEncPriKey().getBytes(), CommonVariable.getKeyAlgName());
                logger.info("加密私钥：" + encPriKeyStr);
                byte[] decode = Base64.decode(encPriKeyStr);
                if (CommonVariable.getKeyAlgName().equalsIgnoreCase(Constants.KEY_ALG_NAME_SM2)) {
                    byte[] data = new byte[32];
                    System.arraycopy(decode, 32, data, 0, 32);
                    encPriKey = GMSSLX509Utils.convertSM2PrivateKey(data);
                } else if (CommonVariable.getKeyAlgName().equalsIgnoreCase(Constants.KEY_ALG_NAME_RSA)) {
                    KeyFactory keyFactory = KeyFactory.getInstance(RsaObjectIdentifiers.rsaAlg.getId(), new BouncyCastleProvider());
                    encPriKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decode));
                } else {
                    byte[] data = new byte[32];
                    System.arraycopy(decode, 32, data, 0, 32);
                    encPriKey = GMSSLX509Utils.convertPrivateKeyEncode(data);
                }

            } catch (Exception e) {
                logger.error("从P7b格式中获取加密私钥失败", e);
                result.setError(ErrorEnum.GET_ENC_PUBLIC_KEY_FROM_P7B_FAIL);
                return result;
            }
        }
        // 组装用户PFX或JKS证书
        // keystore中证书存放方式应该为倒序存入  现存服务器证书 然后上级CA证书 最后根证书
        Map<String, byte[]> keyStores = null;
        try {
            List<X509Certificate> trustCaCerts = CommonVariable.getTrustCaCerts();
            for (X509Certificate trustCaCert : trustCaCerts) {
                logger.info("trustCaCerts.size()==========" + trustCaCerts.size());
                logger.info("trustCaCert====issuer:" + CertUtils.getIssuerByX509Cert(trustCaCert) + " subjcet:" + CertUtils.getSubjectByX509Cert(trustCaCert));
            }
            int length = trustCaCerts.size();
            X509Certificate[] caCerts = new X509Certificate[length];
            trustCaCerts.toArray(caCerts);

            for (int i = 0; i < caCerts.length; i++) {
                logger.info("caCerts.length==========" + caCerts.length);
                X509Certificate caCert = caCerts[i];
                logger.info("caCert====issuer:" + CertUtils.getIssuerByX509Cert(caCert) + " subjcet:" + CertUtils.getSubjectByX509Cert(caCert));
            }

            X509Certificate[] signCert = new X509Certificate[caCerts.length + 1];
            signCert[0] = CertUtils.getCertFromStr(userCertInfo.getSignCert());
            for (int i = 1; i < signCert.length; i++) {
                signCert[i] = caCerts[i - 1];
            }

            for (int i = 0; i < signCert.length; i++) {
                logger.info("signCert.length==========" + signCert.length);
                X509Certificate x509Certificate = signCert[i];
                logger.info("signCert====issuer:" + CertUtils.getIssuerByX509Cert(x509Certificate) + " subjcet:" + CertUtils.getSubjectByX509Cert(x509Certificate));
            }

            X509Certificate[] encCert = null;
            if (issueApplyDTO.getCertPatterm() != SdkConstants.CERT_TYPE_SINGLE_1) {
                encCert = new X509Certificate[caCerts.length + 1];
                encCert[0] = CertUtils.getCertFromStr(userCertInfo.getEncCert());
                for (int i = 1; i < encCert.length; i++) {
                    encCert[i] = caCerts[i - 1];
                }
            }
            keyStores = KeyStoreUtils.generateDoubleCertByKeyStore(false, signCert, encCert, signKeyPair.getPrivate(), encPriKey, certFormatType, applyNo, PathConstants.USER_CERT_KEYSTORE_FILE_PATH);
        } catch (Exception e) {
            logger.error("生成用户keyStore类型证书失败", e);
            result.setError(ErrorEnum.GEN_USER_CERT_KEY_STORE_FILE_FAIL);
            return result;
        }
        result.setInfo(keyStores);
        return result;
    }

    /**
     * 为无密钥生成能力的用户更新证书
     *
     * @param applyNo
     * @param raDN
     * @param caDN
     * @param transId
     * @param isOnlineIssue
     * @return
     */
    private Result updateApplyHandlerByKeyStore(String applyNo, String raDN, String caDN, String transId, int certFormatType, boolean isOnlineIssue, Integer keyFormat) {
        Result result = new Result();
        // 从签发申请中获取相应内容
        UpdateApplyDTO updateApplyDTO = null;
        try {
            updateApplyDTO = updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
        } catch (EmptyResultDataAccessException e) {
            logger.info("getUpdateApplyInfo.applyNo:" + applyNo + " 查询更新证书申请实体为空");
        }
        if (updateApplyDTO == null) {
            logger.info("获取更新证书申请基本信息为空");
            result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
            return result;
        }

        int certValidity = updateApplyDTO.getCertValidity();
        String tempNo = updateApplyDTO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank(updateApplyDTO.getTempParas())) {
            tempParas = updateApplyDTO.getTempParas();
        }
        KeyPair signKeyPair;
        String keyAlgName;
        int keyLength;
        if (Constants.SIGN_ALG_NAME_SM3_WHIT_SM2.equalsIgnoreCase(updateApplyDTO.getSignAlg())) {
            keyAlgName = Constants.KEY_ALG_NAME_SM2;
            keyLength = 256;
        } else if (Constants.SIGN_ALG_NAME_SHA256_WHIT_ECDSA.equalsIgnoreCase(updateApplyDTO.getSignAlg())) {
            keyAlgName = Constants.KEY_ALG_NAME_NIST;
            keyLength = 256;
        } else {
            keyAlgName = Constants.KEY_ALG_NAME_RSA;
            keyLength = 2048;
        }
        try {
            signKeyPair = KeyUtils.genKeyPair(keyAlgName, keyLength);
        } catch (Exception e) {
            logger.error("生成用户签名公私钥失败", e);
            result.setError(ErrorEnum.GEN_USER_CERT_SIGN_KEY_FAIL);
            return result;
        }

        String userCertDN = updateApplyDTO.getCertDn();
        Result updateResult = certLifeCycleManager.updateUserCert(applyNo, null, signKeyPair.getPublic().getEncoded(), raDN, caDN, transId, tempNo, tempParas, updateApplyDTO.getSignAlg(), certValidity, userCertDN, updateApplyDTO.getSignSn(), updateApplyDTO.getUpdateKey(), keyFormat);
        if (!updateResult.isSuccess()) {
            // 更新申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(updateApplyDTO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, updateApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作签发失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }

            // 添加申请记录
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_UPDATE_2, Constants.OPERATE_TYPE_ISSUE_5, applyNo, null, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, updateApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, isOnlineIssue);

            logger.info("调用CA，更新证书失败");
            result.setErrorBean(updateResult.getErrorBean());
            return result;
        }

        UserCertInfo userCertInfo = (UserCertInfo) updateResult.getInfo();

        // 用户证书入库
        Result certInsertResult = this.insertUserCertInfo(updateApplyDTO.getUserId(), updateApplyDTO.getApplyId(), updateApplyDTO.getTempId(), updateApplyDTO.getTempNo(), updateApplyDTO.getSignAlg(), updateApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            logger.info("将用户证书插入数据库失败");
            throw new RuntimeException();
        }
        if (userCertInfo.getEncPriKey() == null) {
            logger.info("CA未返回加密私钥信封");
            throw new RuntimeException();
        }

        // 用私钥解密用户加密私钥信封
        PrivateKey encPriKey = null;
        if (updateApplyDTO.getCertPatterm() != SdkConstants.CERT_TYPE_SINGLE_1) {
            try {
                String encPriKeyStr = CertUtils.getDataFromSignedAndEnvelopedDataByBc(signKeyPair.getPrivate().getEncoded(), userCertInfo.getEncPriKey().getBytes(), CommonVariable.getKeyAlgName());

                byte[] decode = Base64.decode(encPriKeyStr);
                if (CommonVariable.getKeyAlgName().equalsIgnoreCase(Constants.KEY_ALG_NAME_SM2)) {
                    byte[] data = new byte[32];
                    System.arraycopy(decode, 32, data, 0, 32);
                    encPriKey = GMSSLX509Utils.convertSM2PrivateKey(data);
                } else if (CommonVariable.getKeyAlgName().equalsIgnoreCase(Constants.KEY_ALG_NAME_RSA)) {
                    KeyFactory keyFactory = KeyFactory.getInstance(RsaObjectIdentifiers.rsaAlg.getId(), new BouncyCastleProvider());
                    encPriKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decode));
                } else {
                    //DO NIST
                    byte[] data = new byte[32];
                    System.arraycopy(decode, 32, data, 0, 32);
                    encPriKey = GMSSLX509Utils.convertPrivateKeyEncode(data);
                }

            } catch (Exception e) {
                logger.error("从P7b格式中获取加密私钥失败", e);
                result.setError(ErrorEnum.GET_ENC_PUBLIC_KEY_FROM_P7B_FAIL);
                return result;
            }
        }
        // 组装用户PFX或JKS证书
        Map<String, byte[]> keyStores;
        try {
            List<X509Certificate> trustCaCerts = CommonVariable.getTrustCaCerts();
            int length = trustCaCerts.size();
            X509Certificate[] caCerts = new X509Certificate[length];
            trustCaCerts.toArray(caCerts);
            X509Certificate[] signCert = new X509Certificate[caCerts.length + 1];
            signCert[0] = CertUtils.getCertFromStr(userCertInfo.getSignCert());
            for (int i = 1; i < signCert.length; i++) {
                signCert[i] = caCerts[i - 1];
            }
            X509Certificate[] encCert = null;
            if (updateApplyDTO.getCertPatterm() != SdkConstants.CERT_TYPE_SINGLE_1) {
                encCert = new X509Certificate[caCerts.length + 1];
                encCert[0] = CertUtils.getCertFromStr(userCertInfo.getEncCert());
                for (int i = 1; i < encCert.length; i++) {
                    encCert[i] = caCerts[i - 1];
                }
            }
            keyStores = KeyStoreUtils.generateDoubleCertByKeyStore(false, signCert, encCert, signKeyPair.getPrivate(), encPriKey, certFormatType, applyNo, PathConstants.USER_CERT_KEYSTORE_FILE_PATH);
        } catch (Exception e) {
            logger.error("生成用户keyStore类型证书失败", e);
            result.setError(ErrorEnum.GEN_USER_CERT_KEY_STORE_FILE_FAIL);
            return result;
        }

        result.setInfo(keyStores);
        return result;
    }

    /**
     * 为无密钥生成能力的用户恢复证书
     *
     * @param applyNo
     * @param raDN
     * @param caDN
     * @param transId
     * @param isOnlineIssue
     * @return
     */
    private Result recoveryApplyHandlerByKeyStore(String applyNo, String raDN, String caDN, String transId, int certFormatType, boolean isOnlineIssue, Integer keyFormat) {
        Result result = new Result();
        // 从恢复申请中获取响应内容
        RecoveryApplyDTO recoveryApplyDTO = null;
        try {
            recoveryApplyDTO = recoveryApplyDao.getRecoveryApplyInfoByApplyNo(applyNo);
        } catch (Exception e) {
            logger.info("获取恢复证书申请基本信息为空");
            result.setError(ErrorEnum.GET_RECOVERY_APPLY_INFO_IS_EMPTY);
            return result;
        }
        if (recoveryApplyDTO == null) {
            logger.info("获取恢复证书申请基本信息为空");
            result.setError(ErrorEnum.GET_RECOVERY_APPLY_INFO_IS_EMPTY);
            return result;
        }
        String signAlg = recoveryApplyDTO.getSignAlg();
        String userCertDN = recoveryApplyDTO.getCertDn();

        KeyPair signKeyPair;
        String keyAlgName;
        int keyLength = 256;
        if (Constants.SIGN_ALG_NAME_SM3_WHIT_SM2.equalsIgnoreCase(signAlg)) {
            keyAlgName = Constants.KEY_ALG_NAME_SM2;
        } else if (Constants.SIGN_ALG_NAME_SHA256_WHIT_ECDSA.equalsIgnoreCase(signAlg)) {
            keyAlgName = Constants.KEY_ALG_NAME_NIST;
        } else {
            keyAlgName = Constants.KEY_ALG_NAME_RSA;
            keyLength = 2048;
        }
        try {
            signKeyPair = KeyUtils.genKeyPair(keyAlgName, keyLength);
        } catch (Exception e) {
            logger.error("生成用户签名公私钥失败", e);
            result.setError(ErrorEnum.GEN_USER_CERT_SIGN_KEY_FAIL);
            return result;
        }

        Result recoveryResult = certLifeCycleManager.recoveryUserCert(applyNo, raDN, caDN, signKeyPair.getPublic().getEncoded(), recoveryApplyDTO.getSignSn(), transId, signAlg, userCertDN, keyFormat);
        if (!recoveryResult.isSuccess()) {
            // 恢复申请状态
            Result issueCertApplyResult = certApplyService.updateCertApplyInfo(recoveryApplyDTO.getCertDn(), applyNo, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, recoveryApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                logger.info("操作恢复失败:" + JsonUtils.object2Json(issueCertApplyResult));
                throw new RuntimeException();
            }

            // 添加申请记录
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_RECOVERY_4, Constants.OPERATE_TYPE_ISSUE_5, applyNo, null, Constants.CERT_APPLY_STATUS_ISSUE_FAIL_4, recoveryResult.getErrorBean().getErrMsg(), Constants.CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7, false, isOnlineIssue);

            logger.error("调用CA，签发证书失败");
            result.setErrorBean(recoveryResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo) recoveryResult.getInfo();

        // 用户证书入库
        Result certInsertResult = this.insertUserCertInfoByRecovery(recoveryApplyDTO.getUserId(), recoveryApplyDTO.getApplyId(), recoveryApplyDTO.getTempId(), recoveryApplyDTO.getTempNo(), signAlg, recoveryApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            logger.info("将用户证书插入数据库失败");
            result.setError(certInsertResult.getError());
            return result;
        }

        if (userCertInfo.getEncPriKey() == null) {
            logger.info("CA未返回加密私钥信封");
            throw new RuntimeException();
        }

        // 用私钥解密用户加密私钥信封
        PrivateKey encPriKey = null;

        try {
            logger.info("签名私钥：" + Base64.toBase64String(signKeyPair.getPrivate().getEncoded()) + " 私钥信封：" + userCertInfo.getEncPriKey());
            String encPriKeyStr = CertUtils.getDataFromSignedAndEnvelopedDataByBc(signKeyPair.getPrivate().getEncoded(), userCertInfo.getEncPriKey().getBytes(), CommonVariable.getKeyAlgName());
            logger.info("加密私钥：" + encPriKeyStr);

            byte[] decode = Base64.decode(encPriKeyStr);
            if (CommonVariable.getKeyAlgName().equalsIgnoreCase(Constants.KEY_ALG_NAME_SM2)) {
                byte[] data = new byte[32];
                System.arraycopy(decode, 32, data, 0, 32);
                encPriKey = GMSSLX509Utils.convertSM2PrivateKey(data);
            } else if (CommonVariable.getKeyAlgName().equalsIgnoreCase(Constants.KEY_ALG_NAME_RSA)) {
                KeyFactory keyFactory = KeyFactory.getInstance(RsaObjectIdentifiers.rsaAlg.getId(), new BouncyCastleProvider());
                encPriKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decode));
            } else {
                //DO NIST
                byte[] data = new byte[32];
                System.arraycopy(decode, 32, data, 0, 32);
                encPriKey = GMSSLX509Utils.convertPrivateKeyEncode(data);
            }

        } catch (Exception e) {
            logger.error("从P7b格式中获取加密私钥失败", e);
            result.setError(ErrorEnum.GET_ENC_PUBLIC_KEY_FROM_P7B_FAIL);
            return result;
        }

        // 组装用户PFX或JKS证书
        Map<String, byte[]> keyStores;
        try {
            List<X509Certificate> trustCaCerts = CommonVariable.getTrustCaCerts();
            int length = trustCaCerts.size();
            X509Certificate[] caCerts = new X509Certificate[length];
            trustCaCerts.toArray(caCerts);
            X509Certificate[] signCert = new X509Certificate[caCerts.length + 1];
            signCert[0] = CertUtils.getCertFromStr(userCertInfo.getSignCert());
            for (int i = 1; i < signCert.length; i++) {
                signCert[i] = caCerts[i - 1];
            }
            X509Certificate[] encCert = new X509Certificate[caCerts.length + 1];
            encCert[0] = CertUtils.getCertFromStr(userCertInfo.getEncCert());
            for (int i = 1; i < encCert.length; i++) {
                encCert[i] = caCerts[i - 1];
            }
            keyStores = KeyStoreUtils.generateDoubleCertByKeyStore(false, signCert, encCert, signKeyPair.getPrivate(), encPriKey, certFormatType, applyNo, PathConstants.USER_CERT_KEYSTORE_FILE_PATH);
        } catch (Exception e) {
            logger.error("生成用户keyStore类型证书失败", e);
            result.setError(ErrorEnum.GEN_USER_CERT_KEY_STORE_FILE_FAIL);
            return result;
        }

        result.setInfo(keyStores);
        return result;
    }


    /**
     * 将CA返回的用户证书插入到数据表中
     *
     * @param userId
     * @param applyId
     * @param tempId
     * @param signAlg
     * @param privateKeyLength
     * @param userCertInfo
     * @return
     */
    private Result insertUserCertInfoByRecovery(long userId, long applyId, long tempId, String tempNo, String signAlg, int privateKeyLength, UserCertInfo userCertInfo) {
        Result result = new Result();
        String signCert = userCertInfo.getSignCert();
        if (StringUtils.isBlank(signCert)) {
            logger.info("CA返回的用户证书信息中，签名证书为空");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_INFO_IS_EMPTY);
            return result;
        }

        long pairCertIndex;
        synchronized (LOCK_RECOCERY_PAIR_CERT_INDEX){
            pairCertIndex = System.nanoTime() + (ThreadLocalRandom.current().nextLong(0,9999999) + 90000000);
        }

        UserCertDO signCertDO = new UserCertDO();
        signCertDO.setPairCertIndex(pairCertIndex);
        signCertDO.setCertType(Constants.CERT_TYPE_SIGN_2);
        signCertDO.setCertStatus(Constants.CERT_STATUS_NO_CONFIRM_0);

        signCertDO.setUserId(userId);
        signCertDO.setApplyId(applyId);
        signCertDO.setTempId(tempId);
        signCertDO.setTempNo(tempNo);
        signCertDO.setSignAlg(signAlg);
        signCertDO.setPrivateKeyLength(privateKeyLength);

        CaCertDO newCaCertInfo = caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            logger.info("获取CA证书信息为空");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        signCertDO.setCaCertId(newCaCertInfo.getId());

        X509Certificate signCertStr = CertUtils.getCertFromStr(signCert);
        if (signCertStr == null) {
            logger.info("CA返回的用户证书信息中，签名证书错误");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
            return result;
        }
        signCertDO.setCertSn(signCertStr.getSerialNumber().toString(16).toLowerCase());
        signCertDO.setCertDn(CertUtils.getSubjectByX509Cert(signCertStr));

        Date startDate = signCertStr.getNotBefore();
        Date endDate = signCertStr.getNotAfter();
        signCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        signCertDO.setFailureTime(new Timestamp(endDate.getTime()));

        // 用户证书有效期
        int certDays = (int) ((endDate.getTime() - startDate.getTime()) / (1000 * 3600 * 24));
        signCertDO.setCertValidity(certDays);

        // 用户证书中对应的加密公私钥的有效天数
        int priKeyDays = (int) ((newCaCertInfo.getFailureTime().getTime() - startDate.getTime()) / (1000 * 3600 * 24));
        signCertDO.setEncKeyValidity(priKeyDays);

        Date date = new Date();
        signCertDO.setGmtCreate(new Timestamp(date.getTime()));
        signCertDO.setGmtUpdate((new Timestamp(date.getTime())));
        userCertDao.insertUserCertInfo(signCertDO);

        return result;
    }

    /**
     * 获取系统RA服务器签名证书DN
     *
     * @return
     */
    private String getRAServiceDnName() {
        X509Certificate certFromStr = CommonVariable.getRaServiceCert();
        String raServiceDnName = CertUtils.getSubjectByX509Cert(certFromStr);
        return raServiceDnName;
    }

    /**
     * 获取系统CA服务器证书DN
     *
     * @return
     */
    private String getCAServiceDnName() {

        X509Certificate certFromStr = CommonVariable.getCaServiceCert();
        String caServiceDnName = CertUtils.getSubjectByX509Cert(certFromStr);
        return caServiceDnName;
    }

}
