package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.ca.constant.SdkConstants;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.core.util.time.DateUtils;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.FreezeApplyDao;
import com.xdja.pki.ra.manager.dao.model.*;
import com.xdja.pki.ra.manager.dto.FreezeApplyDTO;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.manager.sdk.cmp.bean.CertLifeInfo;
import com.xdja.pki.ra.security.bean.Operator;
import com.xdja.pki.ra.security.util.OperatorUtil;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.FreezeApplyVO;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import org.apache.shiro.dao.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

/**
 * 冻结证书申请服务层
 *
 * @author yangmenghao
 * @date 2020-03-24 16:13:05
 */
@Service
public class FreezeApplyServiceImpl implements FreezeApplyService {
    private final static Logger log = LoggerFactory.getLogger(FreezeApplyServiceImpl.class);
    private static final String LOCK_APPLY_NO="applyNo";
    @Autowired
    private CertApplyHelperService certApplyHelperService;
    @Autowired
    private CertApplyService certApplyService;
    @Autowired
    private UserCertService userCertService;
    @Autowired
    private BaseUserDao baseUserDao;
    @Autowired
    private CertTempDao certTempDao;
    @Autowired
    private CertLifeCycleManager certLifeCycleManager;
    @Autowired
    private CertApplyDao certApplyDao;
    @Autowired
    private FreezeApplyDao freezeApplyDao;

    @Override
    public Result getFreezeApplyInfo(String applyNo) {
        Result result = new Result();

        FreezeApplyVO freezeApplyVO = new FreezeApplyVO();
        FreezeApplyDTO freezeApplyDTO;
        try {
            freezeApplyDTO = freezeApplyDao.getFreezeApplyInfoByApplyNo(applyNo);
        } catch (EmptyResultDataAccessException e) {
            log.info("getFreezeApplyInfo.applyNo:" + applyNo + " 查询冻结解冻证书申请实体为空");
            log.info("获取冻结解冻证书申请详细信息为空");
            result.setError(ErrorEnum.GET_FREEZE_UNFREEZE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        BeanUtils.copyProperties(freezeApplyDTO, freezeApplyVO);
        String decryptLicenseNumber = null;
        try {
            decryptLicenseNumber = DecryptUserInfo.getDecryptString(freezeApplyVO.getLicenseNumber());
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        freezeApplyVO.setLicenseNumber(decryptLicenseNumber);
        Timestamp gmtCreate = freezeApplyDTO.getGmtCreate();
        freezeApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
        result.setInfo(freezeApplyVO);
        return result;
    }

    @Transactional
    @Override
    public Result insertUserCertFreezeApply(String systemFlag, FreezeApplyDTO freezeApplyDTO, boolean isOnline, boolean isNormal) {
        String signSn = freezeApplyDTO.getSignSn();
        Integer applyType = freezeApplyDTO.getApplyType();
        Result result = certApplyHelperService.checkBeforeSaveApplyRecord(signSn, applyType);
        if (!result.isSuccess()) {
            return result;
        }
        Map<String, String> dnNameMap = (Map<String, String>) result.getInfo();
        CertApplyDO certApplyDO = new CertApplyDO();
        certApplyDO.setApplyType(applyType);
        Result userCertInfoResult = userCertService.getUserCertBaseInfo(signSn);
        if (!userCertInfoResult.isSuccess()) {
            return userCertInfoResult;
        }
        UserCertDO userCertDO = (UserCertDO) userCertInfoResult.getInfo();
        if (isOnline && !isNormal) {
            //查deviceNo对应的userId
            String licenseNumber;
            try {
                licenseNumber = baseUserDao.getLicenseNumberById(userCertDO.getUserId());
            } catch (DataAccessException e) {
                log.info("查询证书对应的设备编号为空", e);
                result.setError(ErrorEnum.ONLINE_DEVICE_INFO_NOT_EXIST);
                return result;
            }
            //查询这个用户证书和设备是否对应66
            if (!licenseNumber.equals(freezeApplyDTO.getLicenseNumber())) {
                log.info("设备编号和sn对应证书不匹配");
                result.setError(ErrorEnum.ONLINE_DEVICE_NO_GET_CERT_ERROR);
                return result;
            }
            certApplyDO.setUserId(userCertDO.getUserId());
        }
        if (!isOnline) {
            // 获取当前登录管理员的信息
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有录入员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_INPUT_3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }

            long adminId = currentAdminInfo.getId();
            // 添加申请基本信息
            String adminCertDn = currentAdminInfo.getCertDn();
            certApplyDO.setAdminId(adminId);
            certApplyDO.setAdminCertDn(adminCertDn);
        }
        certApplyDO.setCertDn(userCertDO.getCertDn());
        if (certApplyDO.getUserId() == null) {
            certApplyDO.setUserId(userCertDO.getUserId());
        }
        // 判断当前的用户状态是否支持证书申请 -->Bug修复 yangmenghao 2020-04-17

        // 判断当前的用户状态是否支持证书申请  do 0418
        BaseUserDO baseUserDO;
        try {
            baseUserDO = baseUserDao.getBaseUserInfo(freezeApplyDTO.getUserId());
        } catch (Exception e) {
            log.info("获取用户表信息异常");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (baseUserDO == null) {
            log.info("获取用户表信息为空");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }
        if (freezeApplyDTO.getApplyType() == SdkConstants.CERT_APPLY_TYPE_UNFREEZE_6 && baseUserDO.getStatus() == Constants.USER_STATUS_STOP_1) {
            log.info("发起证书解冻申请的用户已停用");
            result.setError(ErrorEnum.APPLY_USER_STATUS_IS_STOP);
            return result;
        }

        //申请编号 modify by wangtf nanotime+随机数，解决高并发下申请编号重复问题
        String applyDO;
        synchronized (LOCK_APPLY_NO){
            applyDO =String.valueOf(System.nanoTime())+ (ThreadLocalRandom.current().nextLong(0,9999999) + 90000000);
        }
        certApplyDO.setApplyNo(applyDO);
//        certApplyDO.setApplyNo(DateUtils.getCurrDate(DateUtils.FORMAT_FIVE) + String.valueOf((int) (Math.random() * 900000) + 100000));

        result.setLogContent("，申请编号=" + certApplyDO.getApplyNo());
        Timestamp timestamp = new Timestamp(DateUtils.getCurrentTimeMillis());
        certApplyDO.setGmtCreate(timestamp);
        certApplyDO.setGmtUpdate(timestamp);

        CertTempDO certTempInfo = certTempDao.getCertTempInfoByTempNo(freezeApplyDTO.getTempNo());
        if (certTempInfo == null) {
            log.info("证书发起冻结/解冻时，获取证书模板信息为空");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        log.info("证书发起冻结/解冻时，对应模板编号为{},审核策略为【{}】", certTempInfo.getTempNo(), certTempInfo.getCheckStrategy() == 1 ? "自动" : "手动");

        // 1. 记录录入操作
        certApplyService.insertCertApplyRecord(applyType, Constants.OPERATE_TYPE_ENTRY_1, certApplyDO.getApplyNo(), systemFlag, Constants.CERT_APPLY_STATUS_NOT_CHECK_1, freezeApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_SUBMIT_SUCCESS_1, false, isOnline);


        // 如果审核策略是自动的，则申请状态直接为待签发，否则是待审核状态
        int applyStatus = Constants.CERT_APPLY_STATUS_NOT_CHECK_1;
        if (Constants.TEMP_CHECK_STRATEGY_AUTO_1 == certTempInfo.getCheckStrategy() || (isOnline && !isNormal)) {
            // 如果是自动审核  则直接调用SDK发起证书撤销申请

            // 2. 记录自动审核操作
            certApplyService.insertCertApplyRecord(applyType, Constants.OPERATE_TYPE_CHECK_3, certApplyDO.getApplyNo(), systemFlag, 0, "自动审核类模板-审核成功", Constants.CERT_APPLY_OPERATE_TYPE_CHECK_SUCCESS_4, true, isOnline);
            CertLifeInfo certLifeInfo = convertCertLifeInfo(freezeApplyDTO, dnNameMap, certApplyDO);
            Result freezeResult = certLifeCycleManager.freezeUserCert(certLifeInfo, applyType, freezeApplyDTO.getApplyReason());
            int operatorType;
            int operatorRepType;
            if (!freezeResult.isSuccess()) {
                log.info("发起证书冻结/解冻失败 errorCode:{}", freezeResult.getErrorBean().getErrCode());
                result.setErrorBean(freezeResult.getErrorBean());

                if (applyType == ApplyTypeEnum.FREEZE_APPLY.id) {
                    applyStatus = Constants.CERT_APPLY_STATUS_FREEZE_FAIL_8;
                    operatorType = Constants.OPERATE_TYPE_FREEZE_6;
                    operatorRepType = Constants.CERT_APPLY_OPERATE_TYPE_FREEZE_FAIL_9;
                } else {
                    applyStatus = Constants.CERT_APPLY_STATUS_UNFREEZE_FAIL_10;
                    operatorType = Constants.OPERATE_TYPE_UNFREEZE_7;
                    operatorRepType = Constants.CERT_APPLY_OPERATE_TYPE_UNFREEZE_FAIL_11;
                }

                // 3. 记录撤销操作结果
                certApplyService.insertCertApplyRecord(applyType, operatorType, certApplyDO.getApplyNo(), systemFlag, applyStatus, "证书冻结/解冻失败code:" + freezeResult.getErrorBean().getErrCode(), operatorRepType, false, isOnline);

            } else {
                int certStatus;
                if (applyType == ApplyTypeEnum.FREEZE_APPLY.id) {
                    applyStatus = Constants.CERT_APPLY_STATUS_FREEZE_9;
                    operatorType = Constants.OPERATE_TYPE_FREEZE_6;
                    operatorRepType = Constants.CERT_APPLY_OPERATE_TYPE_FREEZE_SUCCESS_10;
                    certStatus = Constants.CERT_STATUS_FREEZE_4;
                } else {
                    applyStatus = Constants.CERT_APPLY_STATUS_UNFREEZE_11;
                    operatorType = Constants.OPERATE_TYPE_UNFREEZE_7;
                    operatorRepType = Constants.CERT_APPLY_OPERATE_TYPE_UNFREEZE_SUCCESS_12;
                    certStatus = Constants.CERT_STATUS_NORMAL_1;
                }
                certApplyService.insertCertApplyRecord(applyType, operatorType, certApplyDO.getApplyNo(), systemFlag, applyStatus, freezeApplyDTO.getApplyReason(), operatorRepType, false, isOnline);

                Result updateStatusResult = userCertService.updateUserCertStatus(certStatus, freezeApplyDTO.getSignSn());
                if (!updateStatusResult.isSuccess()) {
                    log.info("更新证书状态错误:" + JsonUtils.object2Json(updateStatusResult));
                    result.setError(updateStatusResult.getError());
                    return result;
                }
            }
        }
        certApplyDO.setApplyStatus(applyStatus);
        certApplyDO.setTempId(certTempInfo.getId());

        CertApplyDO addCertApply = certApplyDao.insertCertApply(certApplyDO);
        // 添加撤销申请信息
        FreezeApplyDO freezeApplyDO = new FreezeApplyDO();
        freezeApplyDO.setApplyId(addCertApply.getId());
        freezeApplyDO.setSignSn(freezeApplyDTO.getSignSn());
        freezeApplyDO.setEncSn(freezeApplyDTO.getEncSn());
        freezeApplyDO.setApplyReason(freezeApplyDTO.getApplyReason());

        freezeApplyDO.setSignAlg(userCertDO.getSignAlg());
        freezeApplyDO.setPrivateKeyLength(userCertDO.getPrivateKeyLength());
        freezeApplyDO.setCertValidity(userCertDO.getCertValidity());
        freezeApplyDO.setTempNo(userCertDO.getTempNo());
        freezeApplyDO.setGmtUpdate(timestamp);
        freezeApplyDO.setGmtCreate(timestamp);
        freezeApplyDO.setApplyType(applyType);
        freezeApplyDao.insertFreezeApply(freezeApplyDO);
        result.setInfo(addCertApply.getApplyNo());
        return result;
    }

    private CertLifeInfo convertCertLifeInfo(FreezeApplyDTO freezeApplyDTO, Map<String, String> dnNameMap, CertApplyDO certApplyDO) {
        CertLifeInfo certLifeInfo = new CertLifeInfo();
        certLifeInfo.setApplyNo(certApplyDO.getApplyNo());
        certLifeInfo.setRaDN(dnNameMap.get("raServiceDnName"));
        certLifeInfo.setCaDN(dnNameMap.get("caServiceDnName"));
        certLifeInfo.setSignSn(freezeApplyDTO.getSignSn());
        certLifeInfo.setUserCertDN(freezeApplyDTO.getCertDn());
        return certLifeInfo;
    }

    @Override
    public Result updateUserCertFreezeApply(String applyNo, FreezeApplyDTO freezeApplyDTO, boolean isOnlineRevoke) {
        return null;
    }
}
