package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.core.util.time.DateUtils;
import com.xdja.pki.ra.manager.dao.ApplyRecordDao;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.RevokeApplyDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.*;
import com.xdja.pki.ra.manager.dto.RevokeApplyDTO;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.security.bean.Operator;
import com.xdja.pki.ra.security.util.OperatorUtil;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.RevokeApplyVO;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.ra.service.manager.system.CaService;
import com.xdja.pki.ra.service.manager.system.RaServer;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.dao.DataAccessException;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

/**
 * 撤销证书申请服务层-实现类
 *
 * @author syg
 */
@Service
public class RevokeApplyServiceImpl implements RevokeApplyService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LOCK_APPLY_NO="applyNo";

    @Autowired
    RaServer raServer;

    @Autowired
    CaService caService;

    @Autowired
    CertApplyDao certApplyDao;

    @Autowired
    RevokeApplyDao revokeApplyDao;

    @Autowired
    CertTempDao certTempDao;

    @Autowired
    ApplyRecordDao applyRecordDao;

    @Autowired
    CertApplyService certApplyService;

    @Autowired
    UserCertService userCertService;

    @Autowired
    CertLifeCycleManager certLifeCycleManager;

    @Autowired
    UserCertDao userCertDao;

    @Autowired
    CaCertDao caCertDao;

    @Autowired
    RaCertDao raCertDao;

    @Autowired
    BaseUserDao baseUserDao;

    @Override
    public Result getRevokeApplyInfo(String applyNo) {
        Result result = new Result();
        RevokeApplyVO revokeApplyVO = new RevokeApplyVO();
        RevokeApplyDTO revokeApplyInfoByApplyNo = null;
        try {
            revokeApplyInfoByApplyNo = revokeApplyDao.getRevokeApplyInfoByApplyNo(applyNo);
        } catch (EmptyResultDataAccessException e) {
            logger.info("getRevokeApplyInfo.applyNo:" + applyNo + " 查询撤销证书申请实体为空");
        }
        if (revokeApplyInfoByApplyNo == null) {
            logger.info("获取撤销证书申请详细信息为空");
            result.setError(ErrorEnum.GET_REVOKE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        BeanUtils.copyProperties(revokeApplyInfoByApplyNo, revokeApplyVO);
        String decryptLicenseNumber = null;
        try {
            decryptLicenseNumber = DecryptUserInfo.getDecryptString(revokeApplyVO.getLicenseNumber());
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        revokeApplyVO.setLicenseNumber(decryptLicenseNumber);
        Timestamp gmtCreate = revokeApplyInfoByApplyNo.getGmtCreate();
        revokeApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
        result.setInfo(revokeApplyVO);
        return result;
    }

    @Transactional
    @Override
    public Result insertUserCertRevokeApply(String systemFlag, RevokeApplyDTO revokeApplyDTO, boolean isOnlineRevoke,boolean isNormal) {
        Result result = new Result();

        // 获取当前RA服务器签名证书DN
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank(raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        // 获取目标CA证书DN
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank(caServiceDnName)){
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }

        // 判断当前用户证书状态  是否支持发起撤销申请
        UserCertDO userCertDO = userCertDao.getUserCertBaseInfo(revokeApplyDTO.getSignSn());
        if (userCertDO == null) {
            logger.info("获取用户证书信息为空");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }

        // 证书状态为正常/已冻结时，可以撤销证书    ---> 修复BUG  2020-04-16 yangmenghao@xdja.com   DO || -->  &&
        long time = userCertDO.getFailureTime().getTime() - System.currentTimeMillis();
        if ((Constants.CERT_STATUS_NORMAL_1 != userCertDO.getCertStatus() &&  Constants.CERT_STATUS_FREEZE_4 != userCertDO.getCertStatus()) || time < 0) {
            logger.info("用户证书不是可撤销状态");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }

        CertApplyDO certApplyDO = new CertApplyDO();
        if (isOnlineRevoke && !isNormal) {
            //查deviceNo对应的userId
            String licenseNumber;
            try {
                licenseNumber = baseUserDao.getLicenseNumberById(userCertDO.getUserId());
            } catch (DataAccessException e) {
                logger.info("查询证书对应的设备编号为空", e);
                result.setError(ErrorEnum.ONLINE_DEVICE_INFO_NOT_EXIST);
                return result;
            }
            //查询这个用户证书和设备是否对应
            if(!licenseNumber.equals(revokeApplyDTO.getLicenseNumber())){
                logger.info("设备编号和sn对应证书不匹配");
                result.setError(ErrorEnum.ONLINE_DEVICE_NO_GET_CERT_ERROR);
                return result;
            }
            certApplyDO.setUserId(userCertDO.getUserId());
        }

        if (!isOnlineRevoke) {
            // 获取当前登录管理员的信息
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有录入员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_INPUT_3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }

            long adminId = currentAdminInfo.getId();
            // 添加申请基本信息
            String adminCertDn = currentAdminInfo.getCertDn();
            certApplyDO.setAdminId(adminId);
            certApplyDO.setAdminCertDn(adminCertDn);

        }

        certApplyDO.setCertDn(userCertDO.getCertDn());
        if(certApplyDO.getUserId() == null){
            certApplyDO.setUserId(revokeApplyDTO.getUserId());
        }
        //申请编号 modify by wangtf nanotime+随机数，解决高并发下申请编号重复问题
        String applyDO;
        synchronized (LOCK_APPLY_NO){
            applyDO = String.valueOf(System.nanoTime())+ (ThreadLocalRandom.current().nextLong(0,9999999) + 90000000);
        }
        certApplyDO.setApplyNo(applyDO);
//        certApplyDO.setApplyNo(DateUtils.getCurrDate(DateUtils.FORMAT_FIVE) + String.valueOf((int) (Math.random() * 900000) + 100000));
        certApplyDO.setApplyType(Constants.CERT_APPLY_TYPE_REVOKE_3);

        result.setLogContent("，申请编号=" + certApplyDO.getApplyNo());


        certApplyDO.setGmtCreate(new Timestamp(new Date().getTime()));
        certApplyDO.setGmtUpdate(new Timestamp(new Date().getTime()));

        CertTempDO certTempInfo = certTempDao.getCertTempInfoByTempNo(revokeApplyDTO.getTempNo());
        if (certTempInfo == null) {
            logger.info("证书发起撤销时，获取证书模板信息为空");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }

        logger.info("证书发起撤销时，对应模板编号为{},审核策略为【{}】", certTempInfo.getTempNo(), certTempInfo.getCheckStrategy() == 1 ? "自动" : "手动");

        // 1. 记录录入操作
        certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_ENTRY_1, certApplyDO.getApplyNo(), systemFlag, Constants.CERT_APPLY_STATUS_NOT_CHECK_1, revokeApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_SUBMIT_SUCCESS_1, false, isOnlineRevoke);


        // 如果审核策略是自动的，则申请状态直接为待签发，否则是待审核状态
        int applyStatus = Constants.CERT_APPLY_STATUS_NOT_CHECK_1;
        if (Constants.TEMP_CHECK_STRATEGY_AUTO_1 == certTempInfo.getCheckStrategy() || (isOnlineRevoke&&!isNormal)) {
            // 如果是自动审核  则直接调用SDK发起证书撤销申请

            // 2. 记录自动审核操作
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_CHECK_3, certApplyDO.getApplyNo(), systemFlag,0, "自动审核类模板-审核成功", Constants.CERT_APPLY_OPERATE_TYPE_CHECK_SUCCESS_4, true, isOnlineRevoke);

            Result revokeResult = certLifeCycleManager.revokeUserCert( certApplyDO.getApplyNo(),raServiceDnName, caServiceDnName, revokeApplyDTO.getSignSn(), revokeApplyDTO.getCertDn(), revokeApplyDTO.getRevokeReason(), revokeApplyDTO.getApplyReason());
            if (!revokeResult.isSuccess()) {
                logger.info("发起证书撤销失败 errorCode:" + revokeResult.getErrorBean().getErrCode());
                result.setErrorBean(revokeResult.getErrorBean());
                applyStatus = Constants.CERT_APPLY_STATUS_REVOKE_FAIL_6;
                // 3. 记录撤销操作结果
                certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_REVOKE_4, certApplyDO.getApplyNo(),systemFlag, applyStatus, "证书撤销失败code:" + revokeResult.getErrorBean().getErrCode(), Constants.CERT_APPLY_OPERATE_TYPE_REVOKE_FAIL_5, false, isOnlineRevoke);

            } else {
                applyStatus = Constants.CERT_APPLY_STATUS_REVOKED_7;
                certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_REVOKE_4, certApplyDO.getApplyNo(),systemFlag, applyStatus, revokeApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_REVOKE_SUCCESS_6, false, isOnlineRevoke);

                Result updateStatusResult = userCertService.updateUserCertStatus(Constants.CERT_STATUS_REVOKED_3, revokeApplyDTO.getSignSn());
                if (!updateStatusResult.isSuccess()) {
                    logger.info("更新证书状态错误:" + JsonUtils.object2Json(updateStatusResult));
                    result.setError(updateStatusResult.getError());
                    return result;
                }
            }
        }
        certApplyDO.setApplyStatus(applyStatus);
        certApplyDO.setTempId(certTempInfo.getId());

        CertApplyDO addCertApply = certApplyDao.insertCertApply(certApplyDO);
        // 添加撤销申请信息
        RevokeApplyDO revokeApplyDO = new RevokeApplyDO();
        revokeApplyDO.setSignSn(revokeApplyDTO.getSignSn());
        revokeApplyDO.setEncSn(revokeApplyDTO.getEncSn());
        revokeApplyDO.setApplyId(addCertApply.getId());
        revokeApplyDO.setRevokeReason(revokeApplyDTO.getRevokeReason());
        revokeApplyDO.setApplyReason(revokeApplyDTO.getApplyReason());

        revokeApplyDO.setSignAlg(userCertDO.getSignAlg());
        revokeApplyDO.setPrivateKeyLength(userCertDO.getPrivateKeyLength());
        revokeApplyDO.setCertValidity(userCertDO.getCertValidity());

        Date date = new Date();
        revokeApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        revokeApplyDO.setGmtCreate(new Timestamp(date.getTime()));
        revokeApplyDao.insertRevokeApply(revokeApplyDO);
        result.setInfo(addCertApply.getApplyNo());
        return result;
    }

    @Transactional
    @Override
    public Result updateUserCertRevokeApply(String systemFlag,String applyNo, RevokeApplyDTO revokeApplyDTO, boolean isOnlineRevoke) {
        Result result = new Result();
        if (!isOnlineRevoke){
            // 获取当前登录管理员的信息
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有录入员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_INPUT_3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }

        // 判断当前证书申请状态  是否支持发起撤销申请修改
        CertApplyDO certApplyDO = certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyDO == null) {
            logger.info("获取证书申请基本信息为空");
            result.setError(ErrorEnum.GET_CERT_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int nowApplyStatus = certApplyDO.getApplyStatus();
        if (nowApplyStatus != Constants.CERT_APPLY_STATUS_CHECK_FAIL_2) {
            logger.info("当前申请状态，不可修改申请信息");
            result.setError(ErrorEnum.APPLY_STATUS_CANNOT_UPDATE_INFO);
            return result;
        }

        // 判断当前用户证书  是否支持发起撤销申请
        UserCertDO userCertBaseInfo = userCertDao.getUserCertBaseInfo(revokeApplyDTO.getSignSn());
        if (userCertBaseInfo == null) {
            logger.info("获取用户证书信息为空");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        long time = userCertBaseInfo.getFailureTime().getTime() - System.currentTimeMillis();
        if ((Constants.CERT_STATUS_NORMAL_1 != userCertBaseInfo.getCertStatus() &&  Constants.CERT_STATUS_FREEZE_4 != userCertBaseInfo.getCertStatus()) || time < 0 ) {
            logger.info("用户证书不是可撤销状态");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }

        long applyId = certApplyDO.getId();

        // 更新签发申请信息
        RevokeApplyDO revokeApplyDO = revokeApplyDao.getRevokeApplyInfoByApplyId(applyId);
        if (revokeApplyDO == null) {
            logger.info("获取撤销证书申请基本信息为空");
            result.setError(ErrorEnum.GET_REVOKE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        revokeApplyDO.setApplyReason(revokeApplyDTO.getApplyReason());
        revokeApplyDO.setRevokeReason(revokeApplyDTO.getRevokeReason());
        revokeApplyDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));

        int updateRevokeApplyResult = revokeApplyDao.updateRevokeApply(revokeApplyDO);
        if (updateRevokeApplyResult <= 0) {
            logger.info("更新撤销申请基本信息失败");
            result.setError(ErrorEnum.UPDATE_REVOKE_CERT_APPLY_INFO_FAIL);
            return result;
        }

        CertTempDO certTempInfo = certTempDao.getCertTempInfoByTempNo(revokeApplyDTO.getTempNo());
        if (certTempInfo == null) {
            logger.info("获取证书模板信息为空");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }

        // 记录撤销申请修改操作
        certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_UPDATE_2, applyNo, systemFlag, Constants.CERT_APPLY_STATUS_NOT_CHECK_1, revokeApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_UPDATE_SUCCESS_2, false, isOnlineRevoke);

        int applyStatus = Constants.CERT_APPLY_STATUS_NOT_CHECK_1;
        if (Constants.TEMP_CHECK_STRATEGY_AUTO_1 == certTempInfo.getCheckStrategy()) {
            // 记录自动审核操作
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_CHECK_3, certApplyDO.getApplyNo(),systemFlag, 0, "自动审核类模板-审核成功", Constants.CERT_APPLY_OPERATE_TYPE_CHECK_SUCCESS_4, true, isOnlineRevoke);
            // 如果是自动审核  则直接调用SDK发起证书撤销申请
            // 获取当前RA服务器签名证书DN
            String raServiceDnName = this.getRAServiceDnName();
            if (StringUtils.isBlank(raServiceDnName)) {
                result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
                return result;
            }

            // 获取目标CA证书DN
            String caServiceDnName = this.getCAServiceDnName();
            if (StringUtils.isBlank(caServiceDnName)) {
                result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
                return result;
            }
            Result revokeResult = certLifeCycleManager.revokeUserCert(applyNo,raServiceDnName, caServiceDnName,revokeApplyDTO.getSignSn(), revokeApplyDTO.getCertDn(), revokeApplyDTO.getRevokeReason(), revokeApplyDTO.getApplyReason());
            if (!revokeResult.isSuccess()) {
                logger.info("发起证书撤销失败 errorCode:" + revokeResult.getErrorBean().getErrCode());
                result.setErrorBean(revokeResult.getErrorBean());
                applyStatus = Constants.CERT_APPLY_STATUS_REVOKE_FAIL_6;
                certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_REVOKE_4, applyNo,systemFlag, applyStatus, "证书撤销失败code:" + revokeResult.getErrorBean().getErrCode(), Constants.CERT_APPLY_OPERATE_TYPE_REVOKE_FAIL_5, false, isOnlineRevoke);
            } else {
                applyStatus = Constants.CERT_APPLY_STATUS_REVOKED_7;
                certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_REVOKE_3, Constants.OPERATE_TYPE_REVOKE_4, applyNo, systemFlag, applyStatus, revokeApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_REVOKE_SUCCESS_6, false, isOnlineRevoke);
            }
        }

        Result updateCertApplyResult = certApplyService.updateCertApplyInfo(revokeApplyDTO.getCertDn(), applyNo, applyStatus, certTempInfo.getId());
        if (!updateCertApplyResult.isSuccess()) {
            logger.info("更新申请信息失败:" + JsonUtils.object2Json(updateCertApplyResult));
            throw new RuntimeException();
        }
        return result;
    }


    /**
     * 获取系统RA服务器签名证书DN
     *
     * @return
     */
    private String getRAServiceDnName() {
        RaCertDO newRaCertInfo = null;
        try {
            newRaCertInfo = raCertDao.getNewRaCertInfo();
        } catch (Exception e) {
            logger.error("获取RA服务器证书异常{}", e);
            return null;
        }

        if (newRaCertInfo == null) {
            return null;
        }
        String certInfo = newRaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr(certInfo);
        String raServiceDnName = CertUtils.getSubjectByX509Cert(certFromStr);
        return raServiceDnName;
    }

    /**
     * 获取系统CA服务器证书DN
     *
     * @return
     */
    private String getCAServiceDnName() {
        CaCertDO newCaCertInfo = null;
        try {
            newCaCertInfo = caCertDao.getNewCaCertInfo();
        } catch (Exception e) {
            logger.error("获取CA服务器证书异常{}", e);
            return null;
        }

        if (newCaCertInfo == null) {
            return null;
        }
        String certInfo = newCaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr(certInfo);
        String caServiceDnName = CertUtils.getSubjectByX509Cert(certFromStr);
        return caServiceDnName;
    }
}
