package com.xdja.pki.ra.service.manager.certapply;

import com.alibaba.fastjson.JSONObject;
import com.xdja.ca.utils.DnUtil;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.core.util.time.DateUtils;
import com.xdja.pki.ra.manager.dao.*;
import com.xdja.pki.ra.manager.dao.model.*;
import com.xdja.pki.ra.manager.dto.UpdateApplyDTO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.security.bean.Operator;
import com.xdja.pki.ra.security.util.OperatorUtil;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.UpdateApplyVO;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.naming.NamingException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

/**
 * 更新证书申请服务层-实现类
 *
 * @author syg
 */
@Service
public class UpdateApplyServiceImpl implements UpdateApplyService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LOCK_APPLY_NO="applyNo";

    @Autowired
    UpdateApplyDao updateApplyDao;

    @Autowired
    CertApplyDao certApplyDao;

    @Autowired
    CertTempDao certTempDao;

    @Autowired
    ApplyRecordDao applyRecordDao;

    @Autowired
    CertApplyService certApplyService;

    @Autowired
    BaseUserDao baseUserDao;

    @Autowired
    UserCertDao userCertDao;

    @Autowired
    CaBusinessManager caBusinessManager;

    @Override
    public Result getUpdateApplyInfo(String applyNo) {
        Result result = new Result();
        UpdateApplyVO updateApplyVO = new UpdateApplyVO();
        UpdateApplyDTO updateApplyInfoByApplyNo;
        try {
            updateApplyInfoByApplyNo = updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
        } catch (EmptyResultDataAccessException e) {
            logger.info("getUpdateApplyInfo.applyNo:" + applyNo + " 查询更新证书申请实体为空");
            throw new RuntimeException(e);
        }
        if (updateApplyInfoByApplyNo == null) {
            logger.info("获取更新证书申请详细信息为空");
            result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
            return result;
        }

        BeanUtils.copyProperties(updateApplyInfoByApplyNo, updateApplyVO);

        String decryptLicenseNumber = null;
        try {
            decryptLicenseNumber = DecryptUserInfo.getDecryptString(updateApplyVO.getLicenseNumber());
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        updateApplyVO.setLicenseNumber(decryptLicenseNumber);

        int leftDates = (int) ((updateApplyInfoByApplyNo.getFailureTime().getTime() - System.currentTimeMillis()) / (1000 * 3600 * 24));
        updateApplyVO.setLeftValidity(leftDates);
        updateApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(updateApplyInfoByApplyNo.getGmtCreate()));
        updateApplyVO.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(updateApplyInfoByApplyNo.getEffectiveTime()));
        updateApplyVO.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(updateApplyInfoByApplyNo.getFailureTime()));

        //获取更新前的证书主体和证书有效期
        String signSn = updateApplyInfoByApplyNo.getSignSn();
        Result certDetailResult = caBusinessManager.getCertDetailInfoBySingSn(signSn);
        if (!certDetailResult.isSuccess()) {
            return certDetailResult;
        }
        JSONObject json = JSONObject.parseObject(String.valueOf(certDetailResult.getInfo()));
        String oldSubject = json.getString("subject");
        if (!updateApplyVO.getCertDn().equals(oldSubject)) {
            updateApplyVO.setOldCertDn(oldSubject);
        }
        String notafter = json.getString("notafter");
        String notbefore = json.getString("notbefore");
        if (updateApplyInfoByApplyNo.getUpdateValidity()) {
            notbefore = notbefore.substring(0, 10).replace(".", "-");
            notafter = notafter.substring(0, 10).replace(".", "-");
            updateApplyVO.setOldNotBefore(notbefore);
            updateApplyVO.setOldNotAfter(notafter);
        } else {
            try {
                //不更新有效期 详情展示原来的有效期
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                int time = (int) ((sdf.parse(notafter).getTime() - sdf.parse(notbefore).getTime()) / (1000 * 3600 * 24));
                updateApplyVO.setCertValidity(time);
            } catch (ParseException e) {
                logger.info("getUpdateApplyInfo.applyNo:" + applyNo + " 计算原证书有效期异常");
                throw new RuntimeException(e);
            }
        }

        result.setInfo(updateApplyVO);
        return result;
    }

    @Override
    public Result insertCertUpdateApply(UpdateApplyDTO updateApplyDTO, UserCertDO userCertDO, CertTempDO certTempInfo, boolean isNormal) {

        Result result = new Result();
        // 添加申请基本信息
        CertApplyDO certApplyDO = new CertApplyDO();
        certApplyDO.setApplyNo(updateApplyDTO.getApplyNo());
        certApplyDO.setUserId(updateApplyDTO.getUserId());
        certApplyDO.setApplyType(Constants.CERT_APPLY_TYPE_UPDATE_2);
        certApplyDO.setCertDn(updateApplyDTO.getCertDn());
        certApplyDO.setGmtCreate(new Timestamp(new Date().getTime()));
        certApplyDO.setGmtUpdate(new Timestamp(new Date().getTime()));
        if (Constants.TEMP_CHECK_STRATEGY_AUTO_1 == certTempInfo.getCheckStrategy() || !isNormal) {
            certApplyDO.setApplyStatus(Constants.CERT_APPLY_STATUS_NOT_ISSUE_3);
        }else {
            certApplyDO.setApplyStatus(Constants.CERT_APPLY_STATUS_NOT_CHECK_1);
        }
        certApplyDO.setTempId(certTempInfo.getId());

        CertApplyDO addCertApply = certApplyDao.insertCertApply(certApplyDO);
        if (addCertApply == null) {
            logger.info("添加证书申请基本信息失败");
            result.setError(ErrorEnum.INSERT_CERT_APPLY_INFO_FAIL);
            return result;
        }

        // 添加更新申请信息
        UpdateApplyDO updateApplyDO = new UpdateApplyDO();
        updateApplyDO.setApplyId(addCertApply.getId());
        updateApplyDO.setSignSn(updateApplyDTO.getSignSn());
        updateApplyDO.setEncSn(updateApplyDTO.getEncSn());
        updateApplyDO.setSignAlg(updateApplyDTO.getSignAlg());
        updateApplyDO.setPrivateKeyLength(updateApplyDTO.getPrivateKeyLength());
        updateApplyDO.setApplyReason(updateApplyDTO.getApplyReason());
        updateApplyDO.setTempParas(updateApplyDTO.getTempParas());
        updateApplyDO.setIsUpdateKey(updateApplyDTO.getUpdateKey() ? 1 : 0);

        //是否更新有效期 时间信息
        updateApplyDO.setIsUpdateValidity(updateApplyDTO.getUpdateValidity() ? 1 : 0);
        Date date = new Date();
        if (updateApplyDTO.getUpdateValidity() && updateApplyDTO.getCertValidity() != null) {
            updateApplyDO.setEffectiveTime(new Timestamp(date.getTime()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(Calendar.DATE, updateApplyDTO.getCertValidity());
            updateApplyDO.setFailureTime(new Timestamp(calendar.getTime().getTime()));
            updateApplyDO.setCertValidity(updateApplyDTO.getCertValidity());
        } else {
            updateApplyDO.setEffectiveTime(userCertDO.getEffectiveTime());
            updateApplyDO.setFailureTime(userCertDO.getFailureTime());
            updateApplyDO.setCertValidity(userCertDO.getCertValidity());
        }
        updateApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        updateApplyDO.setGmtCreate(new Timestamp(date.getTime()));
        UpdateApplyDO addUpdateApply = updateApplyDao.insertUpdateApply(updateApplyDO);
        if (addUpdateApply == null) {
            logger.info("添加更新申请基本信息失败");
            result.setError(ErrorEnum.INSERT_UPDATE_CERT_APPLY_INFO_FAIL);
            throw new RuntimeException();
        }
        result.setInfo(addCertApply.getId());
        return result;
    }

    public static void main(String[] args) throws Exception{
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String notbefore = "2023-03-27 15:56:43";
        notbefore = notbefore.substring(0, 10).replace(".", "-");
        long time = sdf.parse(notbefore).getTime();
        System.out.println(time);

    }

    @Transactional
    @Override
    public Result insertUserCertUpdateApply(String systemFlag, UpdateApplyDTO updateApplyDTO, boolean isOnlineUpdate, boolean isNormal) {
        Result result = new Result();
        CurrentAdminInfo currentAdminInfo = null;

        if (!isOnlineUpdate) {
            // 获取当前登录管理员的信息
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有录入员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_INPUT_3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }

        // 判断用户状态 是否支持发起更新申请
        BaseUserDO baseUserDO;
        try {
            baseUserDO = baseUserDao.getBaseUserInfo(updateApplyDTO.getUserId());
        } catch (Exception e) {
            logger.info("获取用户表信息异常");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (baseUserDO == null) {
            logger.info("获取用户表信息为空");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }

        if (baseUserDO.getStatus() == Constants.USER_STATUS_STOP_1) {
            logger.info("发起证书更新申请的用户已停用");
            result.setError(ErrorEnum.UPDATE_APPLY_USER_STATUS_IS_STOP);
            return result;
        }

        //审计日志
        result.setLogContent("，用户ID=" + baseUserDO.getId());

        // 判断用户证书状态  是否支持发起更新申请
        UserCertDO userCertBaseInfo = userCertDao.getUserCertBaseInfo(updateApplyDTO.getSignSn());
        if (userCertBaseInfo == null) {
            logger.info("获取用户证书信息为空");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        long time = userCertBaseInfo.getFailureTime().getTime() - System.currentTimeMillis();
        if (Constants.CERT_STATUS_NORMAL_1 != userCertBaseInfo.getCertStatus() || time < 0) {
            logger.info("用户证书不是正常状态");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }


        // 添加申请基本信息
        CertApplyDO certApplyDO = new CertApplyDO();
        //申请编号
        //申请编号 modify by wangtf nanotime+随机数，解决高并发下申请编号重复问题
        String applyDO;
        synchronized (LOCK_APPLY_NO) {
            applyDO = String.valueOf(System.nanoTime()) + (ThreadLocalRandom.current().nextLong(0, 9999999) + 90000000);
        }
        certApplyDO.setApplyNo(applyDO);
//        certApplyDO.setApplyNo(DateUtils.getCurrDate(DateUtils.FORMAT_FIVE) + String.valueOf((int) (Math.random() * 900000) + 100000));
        certApplyDO.setUserId(updateApplyDTO.getUserId());
        certApplyDO.setApplyType(Constants.CERT_APPLY_TYPE_UPDATE_2);
        String dnName;
        try {
            dnName = DnUtil.getRFC4519X500Name(updateApplyDTO.getCertDn()).toString();
        }catch (NamingException e){
            logger.info("certDn不正确{}",e.getMessage());
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        certApplyDO.setCertDn(dnName);

        //审计日志
        result.setLogContent(result.getLogContent() + "，申请编号=" + certApplyDO.getApplyNo());
        if (!isOnlineUpdate) {
            long adminId = currentAdminInfo.getId();
            String adminCertDn = currentAdminInfo.getCertDn();
            certApplyDO.setAdminId(adminId);
            certApplyDO.setAdminCertDn(adminCertDn);
        }
        certApplyDO.setGmtCreate(new Timestamp(new Date().getTime()));
        certApplyDO.setGmtUpdate(new Timestamp(new Date().getTime()));

        CertTempDO certTempInfo = certTempDao.getCertTempInfoByTempNo(updateApplyDTO.getTempNo());
        if (certTempInfo == null) {
            logger.info("获取证书模板信息为空");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }

        if (certTempInfo.getTempStatus() != Constants.TEMP_STATUS_RUN_2 || certTempInfo.getTempBound() != Constants.TEMP_BOUND_STATUS_1) {
            logger.info("获取证书模板状态不可用" + JsonUtils.object2Json(certTempInfo));
            result.setError(ErrorEnum.CERT_TEMP_STATUS_IS_NOT_NORMAL);
            return result;
        }

        // 如果审核策略是自动的，则申请状态直接为待签发，否则是待审核状态
        int applyStatus = Constants.CERT_APPLY_STATUS_NOT_CHECK_1;
        if (Constants.TEMP_CHECK_STRATEGY_AUTO_1 == certTempInfo.getCheckStrategy() || (isOnlineUpdate && !isNormal)) {
            applyStatus = Constants.CERT_APPLY_STATUS_NOT_ISSUE_3;
        }
        certApplyDO.setApplyStatus(applyStatus);
        certApplyDO.setTempId(certTempInfo.getId());

        CertApplyDO addCertApply = certApplyDao.insertCertApply(certApplyDO);
        result.setInfo(addCertApply.getApplyNo());
        if (addCertApply == null) {
            logger.info("添加证书申请基本信息失败");
            result.setError(ErrorEnum.INSERT_CERT_APPLY_INFO_FAIL);
            return result;
        }

        // 添加更新申请信息
        UpdateApplyDO updateApplyDO = new UpdateApplyDO();
        updateApplyDO.setApplyId(addCertApply.getId());

        updateApplyDO.setSignSn(updateApplyDTO.getSignSn());
        updateApplyDO.setEncSn(updateApplyDTO.getEncSn());

        updateApplyDO.setSignAlg(updateApplyDTO.getSignAlg());
        updateApplyDO.setPrivateKeyLength(updateApplyDTO.getPrivateKeyLength());
        updateApplyDO.setApplyReason(updateApplyDTO.getApplyReason());
        updateApplyDO.setTempParas(updateApplyDTO.getTempParas());
        updateApplyDO.setIsUpdateKey(updateApplyDTO.getUpdateKey() ? 1 : 0);

        // 时间信息
        //是否更新有效期
        updateApplyDO.setIsUpdateValidity(updateApplyDTO.getUpdateValidity() ? 1 : 0);
        Date date = new Date();
        if (updateApplyDTO.getUpdateValidity() && updateApplyDTO.getCertValidity()!=null){
            updateApplyDO.setEffectiveTime(new Timestamp(date.getTime()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(Calendar.DATE, updateApplyDTO.getCertValidity());
            updateApplyDO.setFailureTime(new Timestamp(calendar.getTime().getTime()));
            updateApplyDO.setCertValidity(updateApplyDTO.getCertValidity());
        }else {
            updateApplyDO.setEffectiveTime(userCertBaseInfo.getEffectiveTime());
            updateApplyDO.setFailureTime(userCertBaseInfo.getFailureTime());
            updateApplyDO.setCertValidity(userCertBaseInfo.getCertValidity());
        }
        updateApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        updateApplyDO.setGmtCreate(new Timestamp(date.getTime()));
        UpdateApplyDO addUpdateApply = updateApplyDao.insertUpdateApply(updateApplyDO);
        if (addUpdateApply == null) {
            logger.info("添加更新申请基本信息失败");
            result.setError(ErrorEnum.INSERT_UPDATE_CERT_APPLY_INFO_FAIL);
            throw new RuntimeException();
        }

        // 添加申请记录信息
        certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_UPDATE_2, Constants.OPERATE_TYPE_ENTRY_1, addCertApply.getApplyNo(), systemFlag, Constants.CERT_APPLY_STATUS_NOT_CHECK_1, updateApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_SUBMIT_SUCCESS_1, false, isOnlineUpdate);

        // 如果为自动审核的模板，则添加自动审核记录
        if (Constants.TEMP_CHECK_STRATEGY_AUTO_1 == certTempInfo.getCheckStrategy()) {
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_UPDATE_2, Constants.OPERATE_TYPE_CHECK_3, addCertApply.getApplyNo(), systemFlag, Constants.CERT_APPLY_STATUS_NOT_ISSUE_3, "自动审核类模板-审核成功", Constants.CERT_APPLY_OPERATE_TYPE_CHECK_SUCCESS_4, true, isOnlineUpdate);
        }

        return result;
    }

    @Transactional
    @Override
    public Result updateUserCertUpdateApply(String systemFlag, String applyNo, UpdateApplyDTO updateApplyDTO, boolean isOnlineUpdate) {
        Result result = new Result();

        if (!isOnlineUpdate){
            // 获取当前登录管理员的信息
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = operator.getCurrUser();
            List<Integer> roleList = currentAdminInfo.getRoleList();
            // 判断当前登录的管理员是不是拥有录入员角色
            if (!roleList.contains(Constants.ADMIN_ROLE_OPERATOR_INPUT_3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }

        // 判断当前申请状态  是否支持发起更新申请修改
        CertApplyDO certApplyDO = certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyDO == null) {
            logger.info("获取证书申请基本信息为空");
            result.setError(ErrorEnum.GET_CERT_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int nowApplyStatus = certApplyDO.getApplyStatus();
        if (nowApplyStatus != Constants.CERT_APPLY_STATUS_CHECK_FAIL_2) {
            logger.info("当前申请状态，不可修改申请信息");
            result.setError(ErrorEnum.APPLY_STATUS_CANNOT_UPDATE_INFO);
            return result;
        }

        // 判断当前的用户状态
        BaseUserDO baseUserDO = null;
        try {
            baseUserDO = baseUserDao.getBaseUserInfo(updateApplyDTO.getUserId());
        } catch (Exception e) {
            logger.info("获取用户表信息异常");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (baseUserDO == null) {
            logger.info("获取用户表信息为空");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }

        if (baseUserDO.getStatus() == Constants.USER_STATUS_STOP_1) {
            logger.info("修改证书更新申请的用户已停用");
            result.setError(ErrorEnum.UPDATE_UPDATE_APPLY_USER_STATUS_IS_STOP);
            return result;
        }

        //审计日志
        result.setLogContent("，用户ID=" + baseUserDO.getId());

        // 判断证书状态 是否支持发起更新申请
        UserCertDO userCertBaseInfo = userCertDao.getUserCertBaseInfo(updateApplyDTO.getSignSn());
        if (userCertBaseInfo == null) {
            logger.info("获取用户证书信息为空");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        long time = userCertBaseInfo.getFailureTime().getTime() - System.currentTimeMillis();
        if (Constants.CERT_STATUS_NORMAL_1 != userCertBaseInfo.getCertStatus() || time < 0 ) {
            logger.info("用户证书不是正常状态");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }

        long applyId = certApplyDO.getId();

        // 更新签发申请信息
        UpdateApplyDO updateApplyDO = updateApplyDao.getUpdateApplyInfoByApplyId(applyId);
        if (updateApplyDO == null) {
            logger.info("获取更新证书申请基本信息为空");
            result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
            return result;
        }
//        issueApplyDO.setSignAlg(issueApplyDTO.getSignAlg());
//        issueApplyDO.setPrivateKeyLength(issueApplyDTO.getPrivateKeyLength());

        updateApplyDO.setSignSn(updateApplyDTO.getSignSn());
        updateApplyDO.setEncSn(updateApplyDTO.getEncSn());


        updateApplyDO.setCertValidity(updateApplyDTO.getCertValidity());
        updateApplyDO.setApplyReason(updateApplyDTO.getApplyReason());
        updateApplyDO.setTempParas(updateApplyDTO.getTempParas());
        updateApplyDO.setIsUpdateKey(updateApplyDTO.getUpdateKey() == true ? 1 : 0);
        // 更新失效时间
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, updateApplyDTO.getCertValidity());
        updateApplyDO.setFailureTime(new Timestamp(calendar.getTime().getTime()));
        updateApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        int updateApplyResult = updateApplyDao.updateUpdateApply(updateApplyDO);
        if (updateApplyResult <= 0) {
            logger.info("更新签发申请基本信息失败");
            result.setError(ErrorEnum.UPDATE_UPDATE_CERT_APPLY_INFO_FAIL);
            return result;
        }


        // 更新申请信息和记录更新记录
        CertTempDO certTempInfo = certTempDao.getCertTempInfoByTempNo(updateApplyDTO.getTempNo());
        if (certTempInfo == null) {
            logger.info("获取证书模板信息为空");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }

        if (certTempInfo.getTempStatus() != Constants.TEMP_STATUS_RUN_2 || certTempInfo.getTempBound() != Constants.TEMP_BOUND_STATUS_1) {
            logger.info("获取证书模板状态不可用" + JsonUtils.object2Json(certTempInfo));
            result.setError(ErrorEnum.CERT_TEMP_STATUS_IS_NOT_NORMAL);
            return result;
        }

        // 如果审核策略是自动的，则申请状态直接为待签发，否则是待审核状态
        int applyStatus = Constants.CERT_APPLY_STATUS_NOT_CHECK_1;
        if (Constants.TEMP_CHECK_STRATEGY_AUTO_1 == certTempInfo.getCheckStrategy()) {
            applyStatus = Constants.CERT_APPLY_STATUS_NOT_ISSUE_3;
        }
        String dnName;
        try {
            dnName = DnUtil.getRFC4519X500Name(updateApplyDTO.getCertDn()).toString();
        } catch (NamingException e) {
            logger.info("certDn不正确{}", e.getMessage());
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        // 修改更新申请状态
        Result updateCertApplyResult = certApplyService.updateCertApplyInfo(dnName, applyNo, applyStatus, certTempInfo.getId());
        if (!updateCertApplyResult.isSuccess()) {
            logger.info("更新申请信息失败:" + JsonUtils.object2Json(updateCertApplyResult));
            throw new RuntimeException();
        }

        // 添加申请记录
        certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_UPDATE_2, Constants.OPERATE_TYPE_UPDATE_2, applyNo, systemFlag, Constants.CERT_APPLY_STATUS_NOT_CHECK_1, updateApplyDTO.getApplyReason(), Constants.CERT_APPLY_OPERATE_TYPE_UPDATE_SUCCESS_2, false, isOnlineUpdate);


        // 如果为自动审核的模板，则添加自动审核记录
        if (Constants.TEMP_CHECK_STRATEGY_AUTO_1 == certTempInfo.getCheckStrategy()) {
            certApplyService.insertCertApplyRecord(Constants.CERT_APPLY_TYPE_UPDATE_2, Constants.OPERATE_TYPE_CHECK_3, applyNo, systemFlag, Constants.CERT_APPLY_STATUS_NOT_ISSUE_3, "自动审核类模板-审核成功", Constants.CERT_APPLY_OPERATE_TYPE_CHECK_SUCCESS_4, true, isOnlineUpdate);
        }

        return result;
    }
}
