package com.xdja.pki.ra.service.manager.dic;

import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.manager.dao.DicDao;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class DicServiceImpl implements DicService {

    @Resource
    private DicDao dicDao;

    @Override
    public List<Map<String, String>> getDicsByParentCode(String parentCode) {
        try {
            List<Map<String, String>> result = new ArrayList<>();
            Map<String, String> dic = null;

            Map<String, String> dics = dicDao.getDicsByParentCode(parentCode);

            for (Map.Entry<String, String> item : dics.entrySet()) {
                dic = new HashMap<>();
                dic.put("code", item.getKey());
                dic.put("name", item.getValue());

                result.add(dic);
            }

            return result;
        } catch (Exception e) {
            throw new ServiceException("根据父字典代码获取字典列表失败", e);
        }
    }

}
