package com.xdja.pki.ra.service.manager.init;

import com.xdja.pki.apache.client.utils.ApacheClientHttpUtils;
import com.xdja.pki.core.exception.ServiceException;
import com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLKeKUtils;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.security.service.SecurityService;
import com.xdja.pki.ra.service.manager.system.SystemService;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.manager.dao.InitDao;
import org.springframework.beans.factory.annotation.Autowired;

import javax.naming.NamingException;


/**
 * @author wly
 */
@Service
public class InitServiceImpl implements InitService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    InitDao initDao;

    @Autowired
    SecurityService securityService;

    @Autowired
    CaBusinessManager caBusinessManager;

    @Autowired
    AdminCertDao adminCertDao;

    @Autowired
    SystemService systemService;

    private String tomcatPath = System.getProperty("catalina.home");

    @Value("${ra.system.https.port}")
    private String httpsPort;

    @Value("${ra.system.http.port}")
    private String httpPort;


    @Override
    public Result isInitialized() {
        Result result = new Result();
        int isInit;
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            }
            isInit = config.getIsInit();
        } catch (Exception e) {
            logger.error("获取是否初始化读取配置文件异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        result.setInfo(isInit);
        return result;
    }

    @Override
    public Result updateDeviceInitStatus(Integer status) {
        Result result = new Result();

        try {
            Config config = Config.getConfig(PathConstants.GLOBAL_CONF_FILE_PATH);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            }
            config.setIsInit(status);
            Config.saveConfig(config, PathConstants.GLOBAL_CONF_FILE_PATH);
        } catch (Exception e) {
            logger.error("修改初始化状态操作异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        return result;
    }

    @Override
    public Result updateInitStep(int step) {
        Result result = new Result();
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            }
            config.setInitStep(step);

            systemService.updateConfigFile(config);
        } catch (Exception e) {
            logger.error("记录步骤数异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        return result;
    }

    @Override
    public Result getOperateStep() {
        Result result = new Result();
        int initStepId;
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            }
            initStepId = config.getInitStep();
        } catch (Exception e) {
            logger.error("获取步骤数异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        result.setInfo(initStepId);
        return result;
    }

    @Override
    public Result initDeviceRecover() {
        Result result = new Result();

        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            }
            int init = config.getIsInit();
            if (Constants.ISINIT_STATUS_TRUE == init) {
                logger.info("系统已经初始化");
                result.setError(ErrorEnum.SYSTEM_IS_INIT_TRUE);
                return result;
            }
            config.setIsInit(Constants.ISINIT_STATUS_FALSE);
            config.setInitStep(Constants.WELCOME_PAGE);
            config.setIsReboot(Constants.IISREBOOT_FALSE);
            systemService.updateConfigFile(config);
        } catch (Exception e) {
            logger.error("重新开始初始化重置配置文件异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        try {
            initDao.deleteRaCert();
        } catch (Exception e) {
            logger.error("重新开始初始化清空ra_cert表异常", e);
            result.setError(ErrorEnum.RECOVER_INIT_DB_OPERATION_ERROR);
            return result;
        }
        try {
            initDao.deleteCACert();
        } catch (Exception e) {
            logger.error("重新开始初始化清空ca_cert表异常", e);
            result.setError(ErrorEnum.RECOVER_INIT_DB_OPERATION_ERROR);
            return result;
        }
        try {
            initDao.deleteAdminCert();
        } catch (Exception e) {
            logger.error("重新开始初始化清空admin_cert表异常", e);
            result.setError(ErrorEnum.RECOVER_INIT_DB_OPERATION_ERROR);
            return result;
        }
        try {
            initDao.deleteAdminRole();
        } catch (Exception e) {
            logger.error("重新开始初始化清空admin_role表异常", e);
            result.setError(ErrorEnum.RECOVER_INIT_DB_OPERATION_ERROR);
            return result;
        }
        //DO config.son 存库处理
        try {
            systemService.updateConfigFile(Config.getConfigInit());
        } catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        //清理缓存
        CommonVariable.clear();
        ApacheClientHttpUtils.client = null;   //在pki-apache-client模块中client如果非空则不再构造client ,所以当系统重新初始化时，需要将client至null，则可以构造不同需求的client  add by syg 20200715
        //清空个别文件夹内容  软算法文件夹 caCerts文件夹
        FileUtils.deleteFile(new File(PathConstants.SOFT_ALG_FOLDER_PATH));
        FileUtils.deleteFile(new File(PathConstants.SUPER_CA_CERTS_FILE_PATH));

        return result;
    }


    @Override
    public Result authorizeAdmin(String signSn, String cardNo, int adminType) {
        Result result = new Result();
        AdminCertDO adminCertInfo = null;
        //判断操作步骤是否正确
        Result stepResult = getOperateStep();
        logger.info("当前初始化步骤为========" + stepResult.getInfo());

        if (Constants.ADMIN_TYPE_BUSINESS_1 == adminType && !stepResult.getInfo().equals(Constants.DATA_ENCRYPTION)) {
            logger.info("初始化步骤数错误");
            result.setError(ErrorEnum.INIT_STEP_ERROR);
            return result;
        }
        if (Constants.ADMIN_TYPE_AUDIT_2 == adminType && !stepResult.getInfo().equals(Constants.BUSINESS_ADMIN_PAGE)) {
            logger.info("初始化步骤数错误");
            result.setError(ErrorEnum.INIT_STEP_ERROR);
            return result;
        }

        try {
            adminCertInfo = adminCertDao.getAdminCertInfo(signSn, Constants.CERT_TYPE_SIGN_2);
        } catch (Exception e) {
            logger.info("该sn【{}】未进行过授权，将进行授权操作！", signSn);
        }
        if (adminCertInfo != null) {
            result.setError(ErrorEnum.THIS_ADMIN_SIGN_SN_HAD_AUTHORIZE);
            return result;
        }

        Result authenResult = caBusinessManager.raAdminLoginAuthen(signSn);
        if (!authenResult.isSuccess()) {
            return authenResult;
        }
        Map<String, Object> caAuthenMap = (Map<String, Object>) authenResult.getInfo();
        logger.info("CA返回的认证信息 ============ " + JsonUtils.object2Json(caAuthenMap));
        if (CollectionUtils.isEmpty(caAuthenMap)) {
            result.setError(ErrorEnum.CA_RETURN_ADMIN_AUTHEN_INFO_IS_EMPTY);
            return result;
        }

        // 判断管理员角色
        int caAdminType = (int) caAuthenMap.get("adminType");
        if (caAdminType != adminType) {
            result.setError(ErrorEnum.AUTHEN_ADMIN_ROLE_IS_ERROR);
            return result;
        }

        // 判断管理员状态
        int signCertStatus = (int) caAuthenMap.get("signCertStatus");
        if (Constants.CERT_STATUS_NORMAL_1 != signCertStatus) {
            result.setError(ErrorEnum.ADMIN_CERT_STATUS_IS_NOT_NORMAL);
            return result;
        }

        // 进行管理员授权操作
        String signCertData = (String) caAuthenMap.get("signCertData");
        String encCertData = (String) caAuthenMap.get("encCertData");
        Result authorResult = null;
        try {
            authorResult = securityService.authorizationAdminInfo(cardNo, signCertData, encCertData, adminType, signCertStatus);
        } catch (NamingException e) {
            e.printStackTrace();
        }
        if (!authorResult.isSuccess()) {
            result.setError(authorResult.getError());
            return result;
        }

        //记录步骤数
        if (Constants.ADMIN_TYPE_BUSINESS_1 == adminType) {
            result = updateInitStep(Constants.BUSINESS_ADMIN_PAGE);
        } else {
            result = updateInitStep(Constants.AUDITOR_ADMIN_PAGE);
        }

        return result;
    }

    @Override
    public Result initRaSystem() {
        Result result = new Result();

        //记录步骤数
        //记录重启标识
        //修改初始化状态
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            }
            config.setIsReboot(Constants.ISREBOOT_TRUE);
            config.setIsInit(Constants.ISINIT_STATUS_TRUE);
            config.setInitStep(Constants.SYSTEM_RESTART);
            systemService.updateConfigFile(config);
        } catch (Exception e) {
            logger.error("系统重启修改配置文件异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        //DO 20200507 初始化结束不再关掉http通道
        /*try {
            logger.info("系统配置Tomcat路径:  " + tomcatPath);
            //关闭HTTP
            GMSSLTomcatUtils.closeTomcatPort(tomcatPath, Integer.parseInt(httpPort));
            logger.info("HTTP端口：" + httpPort + " 已关闭");
        } catch (Exception e) {
            logger.error("关闭http异常", e);
            result.setError(ErrorEnum.STOP_TOMCAT_HTTP);
            return result;
        }*/
        //返回https端口号
        logger.info("HTTPs端口：" + httpsPort + " 请跳转");
        result.setInfo(httpsPort);

        return result;
    }

    @Override
    public Result restartTomcat() {

        Result result = new Result();
        //tomcat 路径
        logger.info("================tomcatPath " + tomcatPath);

        // 调用密码机
       // boolean restartTomcat = GMSSLTomcatUtils.restartTomcat(tomcatPath);
        try {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        Thread.sleep(900);
                        Runtime.getRuntime().exec(tomcatPath + "/bin/restart.sh");
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        } catch (Exception e) {
            logger.error("重启tomcat失败");
            result.setError(ErrorEnum.RESTART_TOMCAT_ERROR);
            return result;
        }

        return Result.success();
    }

    @Override
    public Result getSystemKeyAlgName() {
        String keyAlgName = CommonVariable.getKeyAlgName();
        if (StringUtils.isBlank(keyAlgName)) {
            logger.error("获取系统算法失败");
            return Result.failure(ErrorEnum.GET_CERT_ALG_NAME_LENGTH_EXCEPTION);
        }
        int keyAlg;
        if (Constants.KEY_ALG_NAME_SM2.equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
            keyAlg = 1;
        } else if (Constants.KEY_ALG_NAME_RSA.equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
            keyAlg = 2;
        } else {
            keyAlg = 3;
        }
        return Result.success(keyAlg);
    }


    @Override
    public Result genLocalEncryptKey() {
        try{
            //生成随机数
            byte[] random = GMSSLRandomUtils.generateRandom(16);
//            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
//            if (null == config) {
//                return Result.failure(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
//            }
//            config.setEncryptKey(Base64.toBase64String(random));
//            systemService.updateConfigFile(config);
            return Result.success();
        }catch (Exception e) {
            logger.error("生成加密对称密钥失败",e);
            throw new ServiceException("生成加密对称密钥失败", e);
        }
    }

    @Override
    public Result genEncryptKey(Integer keyIndex) {
        Result result;
        try{
            /**
             * 步骤数验证
             */
            result = getOperateStep();
            if (!result.getInfo().equals(Constants.RA_SERVER_PAGE)) {
                logger.info("初始化步骤数错误");
                result.setError(ErrorEnum.INIT_STEP_ERROR);
                return result;
            }
            /**
             * 读取配置文件
             */
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            }
            CommonVariable.setIsEncrypt(Constants.DATA_IS_ENCRYPTION_1);
            /**
             * 步骤数
             */
            config.setInitStep(Constants.DATA_ENCRYPTION);

            byte[] key;
            if(Constants.HSM_SERVER_XDJA_1 == CommonVariable.getIsHsm()){
                //已配置XDJA密码机
                config.setEncryptKeyIndex(keyIndex);
                CommonVariable.setEncryptKeyIndex(keyIndex);
                //对称秘钥
                key = GMSSLKeKUtils.generateKeyWithKeKBySM4ECB(keyIndex);
            }else{
                // 未配置XDJA密码机
                key = GMSSLRandomUtils.generateRandom(16);

            }
            //放入缓存 是明文的
            CommonVariable.setEncryptKey(Base64.toBase64String(key));
            //存库 DO key加密存储
            String encrypt = HsmUtils.getEncryptKey(Base64.toBase64String(key));
            config.setEncryptKey(encrypt);
            config = HsmUtils.cryptConfigRaPwd(true, config);
            systemService.updateConfigFile(config);

        }catch (Exception e){
            logger.error("生成加密对称密钥失败",e);
            throw new ServiceException("生成加密对称密钥失败", e);
        }
        return Result.success();
    }

}
