package com.xdja.pki.ra.service.manager.login;

import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRandomUtils;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.AdminRoleDao;
import com.xdja.pki.ra.manager.dao.FunctionDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.dao.model.FunctionDO;
import com.xdja.pki.ra.manager.dao.model.RoleDO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.security.bean.Menu;
import com.xdja.pki.ra.security.bean.Operator;
import com.xdja.pki.ra.security.service.AdminCertCardNoToken;
import com.xdja.pki.ra.security.service.SecurityService;
import com.xdja.pki.ra.security.util.OperatorUtil;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 管理员登录服务层
 *
 * @author syg
 */
@Service
public class AdminLoginServiceImpl implements AdminLoginService {

    protected transient final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    AdminCertDao adminCertDao;

    @Autowired
    FunctionDao functionDao;

    @Autowired
    AdminRoleDao adminRoleDao;

    @Autowired
    SecurityService securityService;

    @Autowired
    CaBusinessManager caBusinessManager;

    @Autowired
    AuditLogService auditLogService;

    @Override
    public Result managerLogin(String cardNo, String signSn, String signData, String clientIpAddress, AuditSignBean bean) {
        Result result = new Result();
        try {
            AdminCertCardNoToken token = new AdminCertCardNoToken(signSn,"111111");
            token.setCardNo(cardNo);
            token.setSignSn(signSn);
            token.setSignData(signData);
            SecurityUtils.getSubject().login(token);
        }catch (AuthenticationException e){
            String errorInfo = e.getMessage();
            switch (errorInfo) {
                case "20001":
                    result.setError(ErrorEnum.ADMIN_LOGIN_AUTHEN_EXCEPTION);
                    break;
                case "20002":
                    result.setError(ErrorEnum.ADMIN_CERT_NOT_EXIST);
                    break;
                case "20003":
                    result.setError(ErrorEnum.ADMIN_CERT_STATUS_IS_NOT_NORMAL);
                    break;
                case "20004":
                    result.setError(ErrorEnum.ADMIN_ROLE_TYPE_IS_ERROR);
                    break;
                case "20006":
                    result.setError(ErrorEnum.CA_OPEN_API_SERVICE_EXCEPTION);
                    break;
                case "20007":
                    result.setError(ErrorEnum.CHALLENGE_CODE_IS_EMPTY);
                    break;
                case "20008":
                    result.setError(ErrorEnum.CHALLENGE_CODE_VERIFY_IS_ERROR);
                    break;
                case "20317":
                    result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
                    break;
                case "20505":
                    Result.failure(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
                    break;
                case "20506":
                    result.setError(ErrorEnum.CA_RESPONSE_USER_ENC_CERT_ERROR);
                    break;
                case "20510":
                    result.setError(ErrorEnum.CA_SERVICE_RETURN_LOGIN_AUTHEN_ERROR);
                    break;
                case "20713":
                    result.setError(ErrorEnum.CA_RETURN_ADMIN_AUTHEN_INFO_IS_EMPTY);
                    break;
                default:
                    logger.info("========== authentication_exception_errorInfo ========= "+ errorInfo);
                    result.setError(ErrorEnum.AUTHENTICATION_EXCEPTION);
                    break;
            }
            return result;
        }

        // 获取当前登录用户信息
        AdminCertDO adminCertInfo = adminCertDao.getAdminCertInfo(signSn, Constants.CERT_TYPE_SIGN_2);
        // 没有查找到用户信息
        if (null == adminCertInfo) {
            result.setError(ErrorEnum.ADMIN_CERT_NOT_EXIST);
            return result;
        }

        // 管理员角色集合
        List<Integer> roleList = new ArrayList<>();
        boolean isAuditor = false;
        List<RoleDO> roleDOS = adminRoleDao.getRoleListByAdminCertId(adminCertInfo.getId());
        for(RoleDO roleDO : roleDOS){
            roleList.add(roleDO.getType());
            if(Constants.ADMIN_ROLE_AUDIT_2 == roleDO.getType().intValue()){
                isAuditor = true;
            }
        }

        //审计日志超出最大存储条数时，不允许非审计员角色登录
        boolean allowLogin = auditLogService.isAllowLogin();
        if(!allowLogin && !isAuditor) {
            result.setError(ErrorEnum.MAX_AUDIT_LOG_STORAGE);
            return result;
        }

        /*List<AdminRoleDO> adminRoleDOList = adminRoleDao.queryAdminRoleList(adminCertInfo.getId());
        if(org.springframework.util.CollectionUtils.isEmpty(adminRoleDOList)) {
            CoreResult.failure(ErrorEnum.QUERY_ADMIN_ROLE_IS_EMPTY);
            return result;
        }
        for (AdminRoleDO adminRoleDO : adminRoleDOList) {
            roleList.add(adminRoleDO.getRoleId().intValue());
        }*/

       /* String certInfo = adminCertInfo.getCertInfo();
        X509Certificate signCert = CertUtils.getCertFromStr(certInfo);
        String adminCertDn = CertUtils.getSubjectByX509Cert(signCert);
        logger.info("当前管理员的证书主体为:"+adminCertDn);
        String adminDnName = StringUtils.substringBetween(adminCertDn,"=", ",");*/

        //DO bug -20200606 管理员登录管理员名字显示角色
        String adminDnName;
        if (Constants.ADMIN_TYPE_OPERATOR_3 == adminCertInfo.getAdminType()) {
            adminDnName = "业务操作员";
        } else {
            adminDnName = adminCertInfo.getRoleInfo();
        }
        // 判断系统是否使用密码机 不使用 查库的时候去掉密码机配置菜单。
        Integer isHsm = CommonVariable.getIsHsm();

        // 获取该用户拥有的权限菜单
        Map<String, Menu> menuMap = this.queryFunctions(signSn, isHsm);
        logger.info("【{}】管理员拥有的【权限】菜单 : "+ JsonUtils.object2Json(menuMap), adminDnName);

        //do  判断系统是否使用密码机 不使用 不展示密码机配置菜单。

        // 过滤掉不需要展示的功能菜单
        menuMap = this.removeUserManagerMenu(menuMap);
        List<Menu> menus = this.sortMenuList(menuMap.values());
        logger.info("【{}】管理员拥有的【访问】菜单 :"+ JsonUtils.object2Json(menus),adminDnName);


        // 设置session属性中添加signSn值，用于后续判断该管理员是否登录
        // 将权限菜单信息存入session
        CurrentAdminInfo currentAdminInfo = new CurrentAdminInfo();
        BeanUtils.copyProperties(adminCertInfo,currentAdminInfo);
        currentAdminInfo.setRoleList(roleList);
        currentAdminInfo.setClientIpAddress(clientIpAddress);
        OperatorUtil.setOperator(new Operator(signSn, menuMap, currentAdminInfo));
        Session session = SecurityUtils.getSubject().getSession();
        session.setAttribute("sessionId", session.getId().toString());


        Map<String,Object> userInfoMap = new HashMap<>();
        userInfoMap.put("name",adminDnName);
        userInfoMap.put("role",roleList);
        userInfoMap.put("sn",signSn);

        Map<String,Object> map = new HashMap<>();
        map.put("menus",menus);
        map.put("userInfo",userInfoMap);
        result.setInfo(map);

        logger.info("AdminLoginServiceImpl.managerLogin>>>>>>result:"+ JsonUtils.object2Json(result));
        return result;
    }

    @Override
    public Result generateChallenge(String signSn) {
        Result result = new Result();
        // 调用密码机获取随机数
        String challengeCode;
     //   if (CommonVariable.isUseHsm()){
        if(Constants.HSM_SERVER_0 != CommonVariable.getIsHsm()){
            try {
                challengeCode = GMSSLRandomUtils.generateRandomByYunhsm(20);
            } catch (Exception e) {
                e.printStackTrace();
                logger.error("密码机国密算法工具类-获取随机数-异常,{}",e);
                result.setError(ErrorEnum.GMSSL_HSM_UTILS_IS_EXCEPTION);
                return result;
            }
        }else {
            challengeCode = UUID.randomUUID().toString().replace("-", "");
        }
        logger.info("LoginManagerImpl.generateChallenge>>>>>>signSn:"+ signSn +" challengeCode:"+ challengeCode);
        result.setInfo(challengeCode);
        return result;
    }

    /**
     * 查询功能菜单
     * @param signSn
     * @return
     */
    public Map<String, Menu> queryFunctions(String signSn, Integer isHsm) {
        List<FunctionDO> functions = new ArrayList<>();
        if (signSn==null) {
            functions = functionDao.queryAllFunctions();
        } else {
            functions = functionDao.queryFunctionsByAdminCertSn(signSn ,isHsm);
        }
        return queryMapFunctions(functions);
    }

    /**
     * 将功能列表转化为map集合
     * @param functionList
     * @return
     */
    private Map<String, Menu> queryMapFunctions(List<FunctionDO> functionList) {
        Map<String, Menu> functions = new LinkedHashMap<String, Menu>();
        Map<Long, Menu> tempFunctions = new LinkedHashMap<Long, Menu>();
        Menu menu = null;
        for (FunctionDO function : functionList) {
            menu = function2Menu(function);
            if (function.getParentId() == 0L) {
                tempFunctions.put(function.getId(), menu);
                functions.put(String.valueOf(function.getId()), menu);
            } else {
                Menu parentFunc = tempFunctions.get(function.getParentId());
                if (parentFunc != null) {
                    parentFunc.addChild(menu);
                }
                tempFunctions.put(function.getId(), menu);
            }
        }

        return functions;
    }


    /**
     * 将功能列表转化为展示菜单
     * @param function
     * @return
     */
    private Menu function2Menu(FunctionDO function) {
        Menu menu = new Menu();
        menu.setId(String.valueOf(function.getId()));
        menu.setName(function.getName());
        menu.setPermissionKey(function.getPermissionKey());
        menu.setPermission(function.getPermission());
        menu.setIcon(function.getIcon());
        menu.setLink(function.getLink());
        menu.setObjName(function.getObjName());
        menu.setOrder(function.getOrderNum());
        menu.setShow(function.getIsShow()==1?true:false);
        return menu;
    }

    /**
     * 对menu菜单按照orderNum属性进行从小到大排序
     * @param menuCollection
     * @return
     */
    private List<Menu> sortMenuList( Collection<Menu> menuCollection){
        List<Menu> menuList = new ArrayList<>();
        menuList.addAll(menuCollection);
        Collections.sort(menuList, new MenuComparator());
        return menuList;
    }
    //比较器类
    private class MenuComparator implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            int orderNum1 = (int) ((Menu) o1).getOrder();
            int orderNum2 = (int) ((Menu) o2).getOrder();
            if (orderNum1 > orderNum2) {
                return 1;
            } else if (orderNum1 < orderNum2) {
                return -1;
            } else {
                return 0;
            }
        }
    }

    /**
     * 过滤掉非导航栏的菜单
     * 目前菜单维持 三级  如果后续有级数增加 可修改成递归方法
     * @param menuMap
     * @return
     */
    private Map<String, Menu> removeUserManagerMenu(Map<String, Menu> menuMap) {
        Iterator<Map.Entry<String, Menu>> iterator = menuMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Menu> next = iterator.next();
            Collection<Menu> children = next.getValue().getChildren();
            if (CollectionUtils.isNotEmpty(children)) {
                Iterator<Menu> childIterator = children.iterator();
                while (childIterator.hasNext()) {
                    Menu childNext = childIterator.next();
                    Collection<Menu> children1 = childNext.getChildren();
                    if (CollectionUtils.isNotEmpty(children1)){
                        Iterator<Menu> iterator1 = children1.iterator();
                        while (iterator1.hasNext()){
                            Menu next1 = iterator1.next();
                            if (!next1.isShow()){
                                iterator1.remove();
                            }
                        }

                    }
                    if (!childNext.isShow()) {
                        childIterator.remove();
                    }
                }
            }
            if (!next.getValue().isShow()){
                iterator.remove();
            }
        }
        return menuMap;
    }
}
