package com.xdja.pki.ra.service.manager.statistics;

import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.StatisticsDao;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dto.StatisticsCertDTO;
import com.xdja.pki.ra.manager.dto.StatisticsCustomerDTO;
import com.xdja.pki.ra.manager.dto.StatisticsUserDTO;
import com.xdja.pki.ra.service.manager.statistics.bean.CertTemplateVO;
import com.xdja.pki.ra.service.manager.statistics.bean.StatisticsCertVO;
import com.xdja.pki.ra.service.manager.statistics.bean.StatisticsCustomerVO;
import com.xdja.pki.ra.service.manager.statistics.bean.StatisticsUserVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


@Service
public class StatisticsServiceImpl implements StatisticsService {

    @Autowired
    StatisticsDao certCountDao;
    @Autowired
    CertTempDao certTempDao;

    @Override
    public List<StatisticsCustomerVO> getCustomerCertStatistics(String customerSysName, String startTime, String endTime) {

        List<StatisticsCustomerDTO> customerCertCountList = certCountDao.getCustomerCertCount(customerSysName,startTime,endTime);
        List<StatisticsCustomerVO> voList = new ArrayList<>();

        if(customerCertCountList.isEmpty()){
            StatisticsCustomerVO vo = new StatisticsCustomerVO();
            vo.setCustomerSysName(null);
            vo.setCustomerSysNumber("合计");
            vo.setNormal(0);
            vo.setExpire(0);
            vo.setRevoke(0);
            vo.setFreeze(0);
            vo.setTotal(0);
            voList.add(vo);
            return voList;
        }
        for (StatisticsCustomerDTO statisticsCustomerDTO : customerCertCountList) {
            StatisticsCustomerVO vo = new StatisticsCustomerVO();
            vo.setCustomerSysName(statisticsCustomerDTO.getCustomerSysName());
            vo.setCustomerSysNumber(statisticsCustomerDTO.getCustomerSysNumber());
            vo.setNormal(statisticsCustomerDTO.getNormal());
            vo.setExpire(statisticsCustomerDTO.getOutdate());
            vo.setRevoke(statisticsCustomerDTO.getRevoked());
            vo.setFreeze(statisticsCustomerDTO.getFreeze());
            vo.setTotal(statisticsCustomerDTO.getTotal());
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public List<StatisticsCertVO> getCertStatistics(String certTemplateName, String startTime, String endTime) {
        List<StatisticsCertDTO> dtoList = certCountDao.getCertCount(certTemplateName, startTime, endTime);
        List<StatisticsCertVO> voList = new ArrayList<>();
        for (StatisticsCertDTO statisticsCertDTO : dtoList) {
            StatisticsCertVO vo = new StatisticsCertVO();
            vo.setCertTemplateName(statisticsCertDTO.getTempName());
            vo.setNormal(statisticsCertDTO.getNormal());
            vo.setExpire(statisticsCertDTO.getOutdate());
            vo.setFreeze(statisticsCertDTO.getFreeze());
            vo.setRevoke(statisticsCertDTO.getRevoked());
            vo.setTotal(statisticsCertDTO.getTotal());
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public List<StatisticsUserVO> getUserStatistics(String startTime, String endTime) {
        List<StatisticsUserDTO> dtoList = certCountDao.getUserCount(startTime, endTime);
        List<StatisticsUserVO> voList = new ArrayList<>();
        int normalCount = 0;
        int disabledCount = 0;
        int totalCount = 0;
        for (int i = 0; i < dtoList.size(); i++) {
            StatisticsUserVO userVO = new StatisticsUserVO();
            userVO.setType(dtoList.get(i).getTypeString());
            userVO.setNormal(dtoList.get(i).getNormal());
            userVO.setDisabled(dtoList.get(i).getDisabled());
            userVO.setTotal(dtoList.get(i).getTotal());
            normalCount += dtoList.get(i).getNormal();
            disabledCount += dtoList.get(i).getDisabled();
            totalCount += dtoList.get(i).getTotal();
            voList.add(userVO);
        }
        StatisticsUserVO userVO = new StatisticsUserVO();
        userVO.setType("合计");
        userVO.setNormal(normalCount);
        userVO.setDisabled(disabledCount);
        userVO.setTotal(totalCount);
        voList.add(userVO);
        return voList;
    }

    @Override
    public List<CertTemplateVO> getCertTemplate() {
        List<CertTempDO> templateList = certCountDao.getTemplate();
        List<CertTemplateVO> list = new ArrayList<>();
        for (CertTempDO templateDO : templateList) {
            CertTemplateVO vo = new CertTemplateVO();
            vo.setTempNo(templateDO.getTempNo());
            vo.setTemplateName(templateDO.getTempName());
            list.add(vo);
        }
        return list;
    }

}
