package com.xdja.pki.ra.service.manager.system;

import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLYunHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.SancHsmInfoEntry;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmInfoEntry;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.service.manager.init.InitService;
import com.xdja.pki.ra.service.manager.system.bean.HsmInfoVO;
import com.xdja.pki.ra.service.manager.system.bean.SancHsmInfoEntryVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.FileInputStream;

/**
 * @author cl
 */
@Service
public class HsmServerImpl implements HsmServer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    InitService initService;

    @Autowired
    SystemService systemService;

    @Override
    public Result initHsmServer(String hsmServerIp, int hsmServerPort, String signCertPwd, String encCertPwd, MultipartFile sign, MultipartFile enc, MultipartFile certChain) {
        // 调用密码机保存
        Result result = new Result();
        FileInputStream inputSign = null;
        FileInputStream inputEnc = null;
        FileInputStream inputCertChain = null;
        try {
            if (sign!=null)
            {
                inputSign = (FileInputStream) sign.getInputStream();
            }
            if (enc!=null){
                inputEnc = (FileInputStream) enc.getInputStream();
            }
            if (certChain!=null){
                inputCertChain = (FileInputStream) certChain.getInputStream();
            }
        } catch (Exception e) {
            logger.info("文件流异常", e);
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
            return result;
        }
        try {//调用密码机保存IP，证书等
            YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect(hsmServerIp, hsmServerPort, signCertPwd, encCertPwd, inputSign, inputEnc, inputCertChain);
            if(YunHsmExceptionEnum.NORMAL.id != yunHsmExceptionEnum.id) {
                //密码机返回的错误码
                switch (yunHsmExceptionEnum) {
                    case TELNET_PORT_FAILURE:
                        result.setError(ErrorEnum.TELNET_IP_FAILURE);
                        break;

                    case OPEN_DEVICE_IS_FAILURE:
                        result.setError(ErrorEnum.TELNET_IP_FAILURE);
                        break;
                    case SIGN_PASSWORD_IS_ERROR:
                        result.setError(ErrorEnum.SIGN_PASSWORD_IS_ERROR);
                        break;
                    case ENC_PASSWORD_IS_ERROR:
                        result.setError(ErrorEnum.ENC_PASSWORD_IS_ERROR);
                        break;
                    case SIGN_CERT_VERIFY_IS_ERROR:
                        result.setError(ErrorEnum.SIGN_CERT_VERIFY_IS_ERROR);
                        break;
                    case ENC_CERT_VERIFY_IS_ERROR:
                        result.setError(ErrorEnum.ENC_CERT_VERIFY_IS_ERROR);
                        break;
                    case OPEN_TRAIN_CERT_P7b_IS_ERROR:
                        result.setError(ErrorEnum.OPEN_TRAIN_CERT_P7b_IS_ERROR);
                        break;
                    case SIGN_CERT_KEY_USAGE_IS_ERROR:
                        result.setError(ErrorEnum.SIGN_CERT_KEY_USAGE_IS_ERROR);
                        break;
                    case ENC_CERT_KEY_USAGE_IS_ERROR:
                        result.setError(ErrorEnum.ENC_CERT_KEY_USAGE_IS_ERROR);
                        break;
                    default:
                        result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
                        break;
                }
            }
        } catch (Exception e) {
            logger.info("密码机异常", e);
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
            return result;
        }
        //修改初始化配置文件  DO不在保存密码机配置信息配置
        /*result = configHsmServer(hsmServerIp, hsmServerPort, signCertPwd, encCertPwd, sign ,enc, certChain);
        if (!result.isSuccess()) {
            logger.info("密码机初始化:修改初始化配置文件失败");
            return result;
        }*/
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            config.setIsHsm(Constants.HSM_SERVER_XDJA_1);
            config.setInitStep(Constants.HSM_SERVER_PAGE);
            systemService.updateConfigFile(config);
        }catch (Exception e){
            logger.info("修改配置文件异常",e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        CommonVariable.setIsHsm(Constants.HSM_SERVER_XDJA_1);
        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();

        return result;
    }

    @Override
    public Result testHsmConnect(String hsmServerIp, int hsmServerPort, String signCertPwd, String encCertPwd, MultipartFile sign, MultipartFile enc, MultipartFile certChain) {
        Result result = new Result();
        FileInputStream inputSign = null;
        FileInputStream inputEnc = null;
        FileInputStream inputCertChain = null;
        try {
            if (sign!=null)
            {
                inputSign = (FileInputStream) sign.getInputStream();
            }
            if (enc!=null){
                inputEnc = (FileInputStream) enc.getInputStream();
            }
            if (certChain!=null){
                inputCertChain = (FileInputStream) certChain.getInputStream();
            }
        } catch (Exception e) {
            logger.info("文件流异常", e);
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
            return result;
        }
        try {//调用密码机保存IP，证书等
            YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.testConnect(hsmServerIp, hsmServerPort, signCertPwd, encCertPwd, inputSign, inputEnc, inputCertChain);
            if(YunHsmExceptionEnum.NORMAL.id != yunHsmExceptionEnum.id) {
                logger.info("测试XDJA密码机连通性异常，原因：" + yunHsmExceptionEnum.value);
                //密码机返回的错误码
                switch (yunHsmExceptionEnum) {

                    case TELNET_PORT_FAILURE:
                        result.setError(ErrorEnum.TELNET_IP_FAILURE);
                        break;
                    case OPEN_DEVICE_IS_FAILURE:
                        result.setError(ErrorEnum.TELNET_IP_FAILURE);
                        break;
                    case SIGN_PASSWORD_IS_ERROR:
                        result.setError(ErrorEnum.SIGN_PASSWORD_IS_ERROR);
                        break;
                    case ENC_PASSWORD_IS_ERROR:
                        result.setError(ErrorEnum.ENC_PASSWORD_IS_ERROR);
                        break;
                    case SIGN_CERT_VERIFY_IS_ERROR:
                        result.setError(ErrorEnum.SIGN_CERT_VERIFY_IS_ERROR);
                        break;
                    case ENC_CERT_VERIFY_IS_ERROR:
                        result.setError(ErrorEnum.ENC_CERT_VERIFY_IS_ERROR);
                        break;
                    case OPEN_TRAIN_CERT_P7b_IS_ERROR:
                        result.setError(ErrorEnum.OPEN_TRAIN_CERT_P7b_IS_ERROR);
                        break;
                    case SIGN_CERT_KEY_USAGE_IS_ERROR:
                        result.setError(ErrorEnum.SIGN_CERT_KEY_USAGE_IS_ERROR);
                        break;
                    case ENC_CERT_KEY_USAGE_IS_ERROR:
                        result.setError(ErrorEnum.ENC_CERT_KEY_USAGE_IS_ERROR);
                        break;
                    default:
                        result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
                        break;
                }
            }
        } catch (Exception e) {
            logger.info("密码机异常", e);
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
        }

        return result;
    }


    @Override
    public Result testHsmConnect() {
        Result result = Result.success();
        boolean status = GMSSLYunHsmUtils.testConnect();
        if (!status){
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
        }
        return result;
    }

    @Override
    public Result isHsm() {
        Result result = new Result();
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            //配置不使用密码机
            config.setIsHsm(Constants.HSM_SERVER_0);
            CommonVariable.setIsHsm(Constants.HSM_SERVER_0);
            //记录步骤数
            config.setInitStep(Constants.HSM_SERVER_PAGE);
            systemService.updateConfigFile(config);
        } catch (Exception e) {
            logger.info("修改配置文件异常",e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        return null;
    }

    @Override
    public Result saveSwxaHsm(String hsmServerIp, int hsmServerPort, String accessPassword, boolean isInit) {
        Result result = new Result();
        //DO 调用
        YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.initConfigAndTestConnect(hsmServerIp,hsmServerPort,accessPassword, isInit);
        if(YunHsmExceptionEnum.NORMAL.id != yunHsmExceptionEnum.id){
            logger.info("测试SWXA密码机连通性异常，原因：" + yunHsmExceptionEnum.value );
            switch (yunHsmExceptionEnum) {
                case TELNET_PORT_FAILURE:
                    result.setError(ErrorEnum.TELNET_IP_FAILURE);
                    break;
                case OPEN_DEVICE_IS_FAILURE:
                    result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
                    break;
                default:result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
                    break;
            }
            return result;
        }

        //DO 保存配置文件密码机类型为2  缓存密码机类型为2
        try {
            Config config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            //配置使用密码机swxa
            config.setIsHsm(Constants.HSM_SERVER_SWXA_2);
            //记录步骤数
            config.setInitStep(Constants.HSM_SERVER_PAGE);
            systemService.updateConfigFile(config);
        } catch (Exception e) {
            logger.info("修改配置文件异常",e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        CommonVariable.setIsHsm(Constants.HSM_SERVER_SWXA_2);
        try {
            GMSSLPkiCryptoInit.getSancHsmInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Result testSwxaHsmConnect(String hsmServerIp, int hsmServerPort, String accessPassword, boolean isInit) {
        Result result = new Result();
        //DO 调用
        YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect(hsmServerIp,hsmServerPort,accessPassword,isInit);
        if(YunHsmExceptionEnum.NORMAL.id != yunHsmExceptionEnum.id){
            logger.info("测试SWXA密码机连通性异常，原因：" + yunHsmExceptionEnum.value );
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
            return result;
        }
        return result;
    }

    @Override
    public Result getHsmInfo() {
        Result result = new Result();
        HsmInfoVO hsmInfoVO = new HsmInfoVO();
        try {
            if (Constants.HSM_SERVER_XDJA_1 == CommonVariable.getIsHsm()) {
                // XDJA
                YunHsmInfoEntry hsmInfo = GMSSLYunHsmUtils.getYunHsmInfo();
                hsmInfoVO.setYunHsmInfoEntry(hsmInfo);
            } else if (Constants.HSM_SERVER_SWXA_2 == CommonVariable.getIsHsm()) {
                // SWXA
                SancHsmInfoEntry sancHsmInfoEntry = GMSSLSancHsmUtils.getSancDeviceInfo();
                SancHsmInfoEntryVO sancHsmInfoEntryVO = new SancHsmInfoEntryVO();
                BeanUtils.copyProperties(sancHsmInfoEntry, sancHsmInfoEntryVO);
                sancHsmInfoEntryVO.setSancHsmType("三未信安服务器密码机");
                hsmInfoVO.setSancHsmInfoEntry(sancHsmInfoEntryVO);
            }
        } catch (Exception e) {
            logger.info("读取密码配置文件异常", e);
            result.setError(ErrorEnum.HSM_GET_DETAILS_ERROR);
        }
        result.setInfo(hsmInfoVO);
        return result;
    }

}
