package com.xdja.pki.ra.service.manager.system;

import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLYunHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.SancHsmInfoEntry;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.CaServerConf;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.system.bean.ServerStatusResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author wly
 */
@Service
public class ServerStatusImpl implements ServerStatus {

    @Autowired
    CaService caService;

    @Autowired
    HsmServer hsmServer;

    @Autowired
    CaBusinessManager caBusinessManager;

    @Autowired
    SystemService systemService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Result testServerConnect() {
        Result result = new Result();
        Config config = null;
        try {
            config = systemService.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
        } catch (Exception e) {
            logger.error("获取配置文件异常", e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }

        //获取CA ip和端口
        CaServerConf caServerConf = config.getCaServerConf();
        String ip = caServerConf.getCaServerIp();
        int port = caServerConf.getCaServerPort();

        //构造前端返回值
        ServerStatusResp serverStatusResp = new ServerStatusResp();
        //CA连通性  file读取服务器中的证书链
        Result testCaResult = caBusinessManager.testCaServerConnect(null,ip, port);
        if (testCaResult.isSuccess()) {
            serverStatusResp.setCaServer(true);
        }
        Integer isHsm = CommonVariable.getIsHsm();
        //密码机连通性
        if(Constants.HSM_SERVER_XDJA_1 == isHsm){
            serverStatusResp.setHsmServer(GMSSLYunHsmUtils.testConnect());
        }else if(Constants.HSM_SERVER_SWXA_2 == isHsm){
            // DO SWXA 测试连接
            YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect();
            if(YunHsmExceptionEnum.NORMAL.id == yunHsmExceptionEnum.id){
                serverStatusResp.setHsmServer(true);
            }else {
                logger.info("测试SWXA密码机连通性异常，原因：" + yunHsmExceptionEnum.value );
            }
        }

        result.setInfo(serverStatusResp);
        return result;
    }
}
