package com.xdja.pki.ra.service.manager.system;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.SystemDao;
import com.xdja.pki.ra.manager.dao.model.ConfigFileDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.sql.Timestamp;


/**
 * @author wly
 */
@Service
public class SystemImpl implements SystemService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SystemDao systemDao;

    @Override
    public Config getConfigFile(String fileName) {
        ConfigFileDO configFileDO = systemDao.getConfigFile(fileName);
        if (null == configFileDO) {
            return null;
        }
        String content = configFileDO.getFileValue();
        Config config = JsonUtils.json2Object(content, Config.class);
        if("null".equalsIgnoreCase(config.getEncryptKey())){
            config.setEncryptKey("");
        }
        return config;
    }

    @Override
    public Result updateConfigFile(Config config) {
        ConfigFileDO configFileDO = systemDao.getConfigFile(Constants.CONFIG_JSON_FILE_NAME);
        String fileValue = JsonUtils.object2Json(config);
        configFileDO.setFileValue(fileValue);
        configFileDO.setGmtModified(new Timestamp(System.currentTimeMillis()));
        systemDao.updateConfigFile(configFileDO);
        return Result.success();
    }

    @Override
    public void saveConfigFile(Config config) {
        ConfigFileDO configFileDO = new ConfigFileDO();
        configFileDO.setFileName(Constants.CONFIG_JSON_FILE_NAME);
        String fileValue = JsonUtils.object2Json(config);
        configFileDO.setFileValue(fileValue);
        configFileDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        configFileDO.setGmtModified(new Timestamp(System.currentTimeMillis()));
        systemDao.saveConfigFile(configFileDO);
    }

}
