package com.xdja.pki.ra.service.manager.template;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.*;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.manager.sdk.business.SynTempInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 证书模板服务层-实现类
 *
 * @author syg
 */
@Service
public class CertTempServiceImpl implements CertTempService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    CertTempDao certTempDao;

    @Autowired
    RaCertDao raCertDao;

    @Autowired
    CaCertDao caCertDao;

    @Autowired
    CaBusinessManager caBusinessManager;

    @Autowired
    UserCertDao userCertDao;

    @Autowired
    AdminCertDao adminCertDao;

    /**
     * 按查询条件，分页查询证书模板信息列表
     *
     * @param tempName
     * @param tempStatus
     * @param pageNo
     * @param pageSize
     * @return
     */
    @Override
    public Result listCertTemplate(String tempName, int tempStatus, int pageNo, int pageSize) {
        CertTempResp certTempResp = new CertTempResp();
        Result result = new Result();
        PageInfo<CertTempDO> certTempDOPageInfo = certTempDao.listPageAppUserCert(tempName, tempStatus, pageNo, pageSize);
        if (certTempDOPageInfo == null) {
            result.setError(ErrorEnum.QUERY_TEMP_LIST_ERROR);
            return result;
        }
        List<CertTempVO> certTempVOList = new ArrayList<>();

        List<CertTempDO> certTempDOList = certTempDOPageInfo.getList();
        if (CollectionUtils.isEmpty(certTempDOList)) {
            certTempResp.setRecordCount(0);
            certTempResp.setPageCount(0);
            certTempResp.setDatas(certTempVOList);
            result.setInfo(certTempResp);
            return result;
        }
        for (CertTempDO certTempDO : certTempDOList) {
            CertTempVO certTempVO = new CertTempVO();
            BeanUtils.copyProperties(certTempDO, certTempVO);
            certTempVOList.add(certTempVO);
        }

        certTempResp.setDatas(certTempVOList);
        certTempResp.setPageCount(certTempDOPageInfo.getPageCount());
        certTempResp.setRecordCount(certTempDOPageInfo.getRecordCount());
        result.setInfo(certTempResp);
        return result;
    }

    /**
     * 证书模板-同步
     *
     * @param pageNo
     * @param pageSize
     * @return
     */
    @Transactional
    @Override
    public Result synCertTemplateList(int pageNo, int pageSize) {
        Result result = new Result();
        // 调用CA-SDK中的同步接口，全量获取CA分配给RA的所有模板信息
        Result synResult = caBusinessManager.synCertTemplateList();
        if (!synResult.isSuccess()){
            return synResult;
        }
        List<SynTempInfo> synTempInfoList  = (List<SynTempInfo>) synResult.getInfo();
        logger.info("RA调用CA证书模板通过接口返回的模板信息："+ JsonUtils.object2Json(synTempInfoList));
        if (CollectionUtils.isEmpty(synTempInfoList)){
            // 更新最新的全量模板数据到数据库
            certTempDao.updateCertTempNewStatus();
        }else {
            List<CertTempDO> localTempDoList = certTempDao.getAllNewCertTemplateList();
            if (!CollectionUtils.isEmpty(localTempDoList)) {
                Map<String, String> tempStrategy = new HashMap<>();
                for (CertTempDO certTempDO : localTempDoList) {
                    tempStrategy.put(certTempDO.getTempNo(), String.valueOf(certTempDO.getCheckStrategy()));
                }

                // 更新最新的全量模板数据到数据库
                certTempDao.updateCertTempNewStatus();

                for (SynTempInfo synTempInfo : synTempInfoList) {
                    CertTempDO certTempDO = new CertTempDO();
                    if (tempStrategy.containsKey(synTempInfo.getCode())) {
                        certTempDO.setCheckStrategy(Integer.valueOf(tempStrategy.get(synTempInfo.getCode())));
                    } else {
                        certTempDO.setCheckStrategy(Constants.TEMP_CHECK_STRATEGY_MANUAL_2);
                    }
                    CaCertDO newestCaInfo = caCertDao.getNewCaCertInfo();
                    if (newestCaInfo == null) {
                        logger.info("获取最新的CA信息为空");
                        result.setError(ErrorEnum.GET_NEWEST_TEMP_INFO_IS_EMPTY);
                        result.setError(ErrorEnum.GET_NEWEST_TEMP_INFO_IS_EMPTY);
                        return result;
                    }
                    certTempDO.setCaId(newestCaInfo.getId());
                    certTempDO.setTempNo(synTempInfo.getCode());
                    certTempDO.setTempName(synTempInfo.getName());
                    certTempDO.setTempBound(synTempInfo.getBound());
                    certTempDO.setMaxValidity(synTempInfo.getMaxValidity());
                    certTempDO.setSignAlg(synTempInfo.getSignAlg());
                    certTempDO.setPrivateKeyLength(synTempInfo.getKeySize());
                    certTempDO.setPublicKeyAlg(synTempInfo.getKeyAlg());
                    certTempDO.setTempType(synTempInfo.getType());
                    certTempDO.setTempParas(synTempInfo.getTemParas());
                    certTempDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
                    certTempDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
                    certTempDO.setTempStatus(synTempInfo.getStatus());
                    certTempDO.setIsNewestTemp(1);
                    certTempDO.setCertPatterm(synTempInfo.getCertPatterm());
                    certTempDO.setBaseDn(synTempInfo.getBaseDn());
                    certTempDao.insertCertTemp(certTempDO);
                }
            }else {
                for (SynTempInfo synTempInfo : synTempInfoList) {
                    CertTempDO certTempDO = new CertTempDO();
                    CaCertDO newestCaInfo = caCertDao.getNewCaCertInfo();
                    if (newestCaInfo == null) {
                        logger.info("获取最新的CA信息为空");
                        result.setError(ErrorEnum.GET_NEWEST_TEMP_INFO_IS_EMPTY);
                        result.setError(ErrorEnum.GET_NEWEST_TEMP_INFO_IS_EMPTY);
                        return result;
                    }
                    certTempDO.setCaId(newestCaInfo.getId());
                    certTempDO.setTempNo(synTempInfo.getCode());
                    certTempDO.setTempName(synTempInfo.getName());
                    certTempDO.setTempBound(synTempInfo.getBound());
                    certTempDO.setMaxValidity(synTempInfo.getMaxValidity());
                    certTempDO.setSignAlg(synTempInfo.getSignAlg());
                    certTempDO.setPrivateKeyLength(synTempInfo.getKeySize());
                    certTempDO.setPublicKeyAlg(synTempInfo.getKeyAlg());
                    certTempDO.setTempType(synTempInfo.getType());
                    certTempDO.setTempParas(synTempInfo.getTemParas());
                    certTempDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
                    certTempDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
                    certTempDO.setTempStatus(synTempInfo.getStatus());
                    certTempDO.setIsNewestTemp(1);
                    certTempDO.setCheckStrategy(Constants.TEMP_CHECK_STRATEGY_MANUAL_2);
                    certTempDO.setCertPatterm(synTempInfo.getCertPatterm());
                    certTempDO.setBaseDn(synTempInfo.getBaseDn());
                    certTempDao.insertCertTemp(certTempDO);

                }
            }
        }

        // 分页查询出最新的模板数据
        Result listCertTemplateResult = this.listCertTemplate(null, 0, pageNo, pageSize);
        if (!listCertTemplateResult.isSuccess()){
            logger.info("按查询条件，分页查询证书模板信息列表失败");
            result.setError(synResult.getError());
            return result;
        }
        result.setInfo(listCertTemplateResult.getInfo());
        return result;
    }


    @Override
    public Result updateCertTempCheckStrategy(String tempNo, int checkStrategy) {
        Result result = new Result();
        int isOk = certTempDao.updateCertTempCheckStrategy(tempNo, checkStrategy);
        if (isOk != 1) {
            logger.info("更新模板审核策略失败");
            result.setError(ErrorEnum.UPDATE_CHECK_STRATEGY_FAIL);
            return result;
        }
        return result;
    }

    @Override
    public Result listCertTemplateDropDownList() {
        Result result = new Result();
        List<CertTempDO> certTempDOList = null;
        try {
            certTempDOList = certTempDao.listCertTemplateDropDownList();
        } catch (EmptyResultDataAccessException e) {
            logger.info("listCertTemplateDropDownList 查询所有的下拉列表内容为空");
        }
        if (CollectionUtils.isEmpty(certTempDOList)) {
            result.setInfo(null);
            return result;
        }
        List<CertTempVO> list = new ArrayList<>();
        for (CertTempDO certTempDO : certTempDOList) {
            CertTempVO certTempVO = new CertTempVO();
            BeanUtils.copyProperties(certTempDO, certTempVO);
            list.add(certTempVO);
        }
        result.setInfo(list);
        return result;

    }

    @Override
    public Result getCertApplyMaxValidity(String tempNo,int updateKey,String signSn) {
        Result result = new Result();
        CertTempDO certTempInfoByTempNo = certTempDao.getCertTempInfoByTempNo(tempNo);
        if (certTempInfoByTempNo == null){
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        int tempMaxValidity = certTempInfoByTempNo.getMaxValidity();

        //todo 优化调用 可以不读库
        CaCertDO newCaCertInfo = caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null){
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        Timestamp failureTime = newCaCertInfo.getFailureTime();
        long failTime = failureTime.getTime();
        long nowTime = System.currentTimeMillis();
        int caValidity = (int) ((failTime - nowTime) / (1000 * 3600 * 24));

        // 如果不更新密钥  则需要将用户证书的加密公私钥的有效期计算在内
        if (updateKey == Constants.CANNOT_UPDATE_CERT_KEY_0) {
            UserCertDO userCertBaseInfo = userCertDao.getUserCertBaseInfo(signSn);
            if (userCertBaseInfo == null){
                logger.info("获取用户证书信息为空");
                result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
                return result;
            }
            int priKeyValidity = userCertBaseInfo.getEncKeyValidity();

            logger.debug("用户模板:"+tempNo+" CA最大有效期:"+caValidity+" 模板最大有效期:"+tempMaxValidity+" 加密密钥最大有效期:"+priKeyValidity);
            // 取CA证书有效期、模板有效期、加密密钥有效期的最小值
            int min = tempMaxValidity;
            min = (caValidity < min) ? caValidity : min;
            min = (priKeyValidity < min) ? priKeyValidity : min;
            result.setInfo(min);
        } else {
            logger.debug("用户模板:"+tempNo+" CA最大有效期:"+caValidity+" 模板最大有效期:"+tempMaxValidity);
            int min = (tempMaxValidity < caValidity ? tempMaxValidity : caValidity);
            result.setInfo(min);
        }
        return result;
    }



}
