package com.xdja.pki.ra.service.manager.usercert;


import com.xdja.ca.constant.SdkConstants;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.CustomerDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.UserCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 用户证书服务层-实现类
 *
 * @author syg
 */
@Service
public class UserCertServiceImpl implements UserCertService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    UserCertDao userCertDao;

    @Autowired
    CustomerDao customerDao;

    @Autowired
    CertTempDao certTempDao;

    @Autowired
    CaBusinessManager caBusinessManager;

    @Override
    public Result listUserCert(String certDn, String userName, int userType, int pageNo, int pageSize, int leftDate, Boolean effectiveTimeAsc, Boolean failureTimeAsc) {
        UserCertResp userCertResp = new UserCertResp();
        Result result = new Result();
        PageInfo<UserCertDTO> userCertDTOPageInfo = userCertDao.listPageUserCert(certDn,userType,userName, pageNo, pageSize,effectiveTimeAsc,failureTimeAsc,leftDate);
        if (userCertDTOPageInfo == null) {
            result.setError(ErrorEnum.QUERY_USER_CERT_LIST_ERROR);
            return result;
        }

        List<UserCertVO> userCertVOList = new ArrayList<>();

        List<UserCertDTO> userCertDTOList = userCertDTOPageInfo.getList();
        if (CollectionUtils.isEmpty(userCertDTOList)) {
            userCertResp.setRecordCount(0);
            userCertResp.setPageCount(0);
            userCertResp.setDatas(userCertVOList);
            result.setInfo(userCertResp);
            return result;
        }

        for (UserCertDTO userCertDTO : userCertDTOList) {
            UserCertVO userCertVO = new UserCertVO();
            BeanUtils.copyProperties(userCertDTO, userCertVO);
            Timestamp effectiveTime = userCertDTO.getEffectiveTime();
            userCertVO.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(effectiveTime));

            Timestamp failureTime = userCertDTO.getFailureTime();
            userCertVO.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(failureTime));

            if (new Date().getTime()>failureTime.getTime()){
                userCertVO.setCertStatus(Constants.CERT_STATUS_EXPIRED_2);
            }
            // 剩余证书有效期
            int leftDates = (int) ((failureTime.getTime() - new Date().getTime()) / (1000 * 3600 * 24));
            userCertVO.setLeftValidity(leftDates);
            userCertVOList.add(userCertVO);
        }

        userCertResp.setDatas(userCertVOList);
        userCertResp.setPageCount(userCertDTOPageInfo.getPageCount());
        userCertResp.setRecordCount(userCertDTOPageInfo.getRecordCount());
        result.setInfo(userCertResp);
        return result;
    }


    @Override
    public Result listUserCertNew(String certDn, String userName, int userType, int pageNo, int pageSize, int leftDate, Boolean effectiveTimeAsc, Boolean failureTimeAsc) {
        /**
         * DO 20200808 证书列表优化
         * 1.先通过筛选条件查询用户表和证书表信息
         * 2.再循环查询模板表和系统表信息
         */
        UserCertResp userCertResp = new UserCertResp();
        Result result = new Result();
        PageInfo<UserCertDTO> userCertDTOPageInfo = userCertDao.listPageUserCertNew(certDn,userType,userName, pageNo, pageSize,effectiveTimeAsc,failureTimeAsc,leftDate);
        if (userCertDTOPageInfo == null) {
            result.setError(ErrorEnum.QUERY_USER_CERT_LIST_ERROR);
            return result;
        }

        List<UserCertVO> userCertVOList = new ArrayList<>();

        List<UserCertDTO> userCertDTOList = userCertDTOPageInfo.getList();
        if (CollectionUtils.isEmpty(userCertDTOList)) {
            userCertResp.setRecordCount(0);
            userCertResp.setPageCount(0);
            userCertResp.setDatas(userCertVOList);
            result.setInfo(userCertResp);
            return result;
        }
        for (UserCertDTO userCertDTO : userCertDTOList) {
            UserCertVO userCertVO = new UserCertVO();
            BeanUtils.copyProperties(userCertDTO, userCertVO);
            /**
             * 查询对应系统名称
             */
//            String systemName = customerDao.getSystemNameByFlag(userCertDTO.getSystemFlag());
//            userCertVO.setSystemName(systemName);
            /**
             * 查询模板信息
             */
//            CertTempDO certTempInfoByTempId = certTempDao.getCertTempInfoByTempId(userCertDTO.getTempId());
//            userCertVO.setCertPatterm(certTempInfoByTempId.getCertPatterm());
//            userCertVO.setCheckStrategy(String.valueOf(certTempInfoByTempId.getCheckStrategy()));
//            userCertVO.setTempName(certTempInfoByTempId.getTempName());
//            userCertVO.setTempNo(certTempInfoByTempId.getTempNo());
            /**
             * 同时查询模板信息和系统名称
             */
            UserCertDTO certListInfo = userCertDao.getCertListInfo(userCertDTO.getSystemFlag(), userCertDTO.getTempId());

            userCertVO.setSystemName(certListInfo.getSystemName());
            userCertVO.setCertPatterm(certListInfo.getCertPatterm());
            userCertVO.setCheckStrategy(String.valueOf(certListInfo.getCheckStrategy()));
            userCertVO.setTempName(certListInfo.getTempName());
            userCertVO.setTempNo(certListInfo.getTempNo());

            Timestamp effectiveTime = userCertDTO.getEffectiveTime();
            userCertVO.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(effectiveTime));

            Timestamp failureTime = userCertDTO.getFailureTime();
            userCertVO.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(failureTime));

            if (new Date().getTime()>failureTime.getTime()){
                userCertVO.setCertStatus(Constants.CERT_STATUS_EXPIRED_2);
            }
            // 剩余证书有效期
            int leftDates = (int) ((failureTime.getTime() - new Date().getTime()) / (1000 * 3600 * 24));
            userCertVO.setLeftValidity(leftDates);
            userCertVOList.add(userCertVO);
        }

        userCertResp.setDatas(userCertVOList);
        userCertResp.setPageCount(userCertDTOPageInfo.getPageCount());
        userCertResp.setRecordCount(userCertDTOPageInfo.getRecordCount());
        result.setInfo(userCertResp);
        return result;
    }



    @Override
    public Result getUserCertStatus(String certSn){
        Result result = new Result();
        Result certStatusResult = caBusinessManager.getCertStatus(certSn);
        if(!certStatusResult.isSuccess()){
            return certStatusResult;
        }
        int status = (int) certStatusResult.getInfo();

        if (status != Constants.CERT_STATUS_NO_CONFIRM_0){
            try {
                userCertDao.updateDoubleUserCertStatus(status,certSn);
            }catch (Exception e){
                logger.error("更新用户证书状态异常{}",e);
                result.setError(ErrorEnum.UPDATE_USER_CERT_STATUS_EXCEPTION);
                return result;
            }
        }
        return certStatusResult;
    }

    @Override
    public Result exportUserDoubleCerts(String certSn){
        Result result = new Result();
        Result certDataInfoResult = caBusinessManager.downloadCertDataInfo(certSn,false);
        if (!certDataInfoResult.isSuccess()){
            return certDataInfoResult;
        }

        Map<String,String> map = (Map<String, String>) certDataInfoResult.getInfo();
        List<Map<String, Object>> list = new ArrayList<>();

        Map<String, Object> caCertMap = new HashMap<>();
        caCertMap.put("name", "CACert");
        caCertMap.put("suffix", "p7b");
        caCertMap.put("buffer", FileUtils.readByBinary(PathConstants.CA_TRUST_SERVICE_CERT_FILE_PATH));
        list.add(caCertMap);

        Map<String, Object> signMap = new HashMap<>();
        signMap.put("name", "UserCert");
        if(null != map.get("encCert")) {
            Map<String, Object> encMap = new HashMap<>();
            encMap.put("name", "EncCert");
            encMap.put("suffix", "p7b");
            byte[] encByte = map.get("encCert").getBytes();
            encMap.put("buffer", encByte);
            list.add(encMap);

            signMap.put("name", "SignCert");
        }
        signMap.put("suffix", "p7b");
        byte[] signByte = map.get("signCert").getBytes();
        signMap.put("buffer", signByte);
        list.add(signMap);

        result.setInfo(list);
        return result;
    }

    @Override
    public Result getUserCertBaseInfo(String certSn) {
        Result result = new Result();
        UserCertDO userCertBaseInfo = userCertDao.getUserCertBaseInfo(certSn);
        if (userCertBaseInfo == null){
            logger.info("获取用户证书信息为空");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        result.setInfo(userCertBaseInfo);
        return result;
    }

    @Override
    public Result updateUserCertStatus(int certStatus, String certSn) {
        Result result = new Result();
        try {
            userCertDao.updateDoubleUserCertStatus(certStatus,certSn);
        }catch (Exception e){
            logger.error("更新用户证书状态异常{}",e);
            result.setError(ErrorEnum.UPDATE_USER_CERT_STATUS_EXCEPTION);
            return result;
        }
        return result;
    }
}
