package com.xdja.pki.ra.service.manager.usercertmanager;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.core.util.file.ZipUtils;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.UserCertDTO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import com.xdja.pki.ra.service.manager.usercert.UserCertStr;
import com.xdja.pki.ra.service.manager.usercertmanager.bean.CertBaseInfo;
import com.xdja.pki.ra.service.manager.usercertmanager.bean.UserCertInfo;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author: ggp
 * @Date: 2019/10/30 17:04
 * @Description:
 */
@Service
public class UserCertManagerImpl implements UserCertManagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private BaseUserDao baseUserDao;

    @Autowired
    private UserCertDao userCertDao;

    @Autowired
    private CaBusinessManager caBusinessManager;

    @Autowired
    private CertTempDao certTempDao;

    @Autowired
    private UserCertService userCertService;

    @Autowired
    BaseUserService baseUserService;

    /**
     * 查询用户证书
     *
     * @param userType
     * @param identType
     * @param identNumber
     * @return
     */
    @Override
    public Result getUserCertInfoList(Integer userType, Integer identType, String identNumber, String systemFlag) {
        try {
            Result result = new Result();
            Long userId = baseUserService.queryUserId(userType, systemFlag, identType, identNumber);
//            int count = baseUserService.queryUserExist(identType, identNumber, userType, systemFlag); 多余
            if (null == userId) {
                logger.error("查询用户不存在：userType:[{}],identType:[{}],licenseNumber:[{}],systemFlag:[{}]",userType,identType,identNumber,systemFlag);
                return Result.failure(ErrorEnum.GET_PERSON_USER_INFO_IS_EMPTY);
            }
            List<UserCertDTO> userCertDOS = userCertDao.getUserCertList(userId);
            logger.debug("查询用户userId:" + userId);
            if (userCertDOS.isEmpty()) {
                result.setInfo(null);
                return result;
            }
            List<UserCertInfo> userCertInfos = new ArrayList<>();
            for (UserCertDTO userCertDO : userCertDOS) {
                UserCertInfo userCertInfo = new UserCertInfo();
                BeanUtils.copyProperties(userCertDO, userCertInfo);
                if(Constants.CERT_RECOVERY_1 == userCertDO.getIsRecovery() || Constants.CERT_TYPE_SINGLE_1  == userCertDO.getCertType()){
                    userCertInfo.setEncSn(null);
                }
                Integer leftTime = 0;
                leftTime = (int) ((userCertDO.getFailureTime().getTime() - System.currentTimeMillis()) / (1000 * 60 * 60 * 24));
                userCertInfo.setLeftValidity(leftTime);
                userCertInfo.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(userCertDO.getEffectiveTime()));
                userCertInfo.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(userCertDO.getFailureTime()));
                userCertInfos.add(userCertInfo);
            }
            result.setInfo(userCertInfos);
            return result;
        } catch (BeansException e) {
            throw new ServiceException("查询用户证书失败", e);
        }
    }

    /**
     * 查询证书详情
     *
     * @param certSn
     * @return
     */
    @Override
    public Result getUserCertBaseInfo(String certSn,String systemFLag) {
        CertBaseInfo certBaseInfo = new CertBaseInfo();
        UserCertDO userCertDO = userCertDao.getUserDetail(certSn);
        if(null == userCertDO){
            return Result.failure(ErrorEnum.THE_SN_IS_INVALID);
        }
        boolean flag = baseUserDao.isAuthorize(systemFLag,userCertDO.getUserId().intValue());
        if(!flag){
            return Result.failure(ErrorEnum.THE_CERT_IS_NOT_BELONG_TO_THE_SYSTEM);
        }
        BeanUtils.copyProperties(userCertDO, certBaseInfo);
        certBaseInfo.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(userCertDO.getFailureTime()));
        certBaseInfo.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(userCertDO.getEffectiveTime()));
        CertTempDO certTempDO = certTempDao.getCertTempInfoByTempNo(userCertDO.getTempNo());
        certBaseInfo.setTempName(certTempDO.getTempName());
        Result result = caBusinessManager.getCertDetailInfoBySingSn(certSn);
        if (!result.isSuccess()) {
            return result;
        }
        /**
         * 部分数据从CA获取
         */
        JSONObject detail = JSONObject.parseObject(result.getInfo().toString());
        certBaseInfo.setVersion((String) detail.get("version"));
        certBaseInfo.setIssuerDn((String) detail.get("issuer"));
        certBaseInfo.setSubjectDn((String) detail.get("subject"));
        certBaseInfo.setSubjectPublicKeyInfo((String) detail.get("subjectPublicKeyInfo"));


        result.setInfo(certBaseInfo);
        return result;
    }

    /**
     * 用户双证书下载
     *
     * @param signSn
     * @return
     */
    @Override
    public Result downLoadUserCertFile(String signSn,String systemFlag) {
        Result x = checkSystem(signSn, systemFlag);
        if (x != null) {
            return x;
        }

        Result result = userCertService.exportUserDoubleCerts(signSn);
        List<Map<String, Object>> list = (List<Map<String, Object>>) result.getInfo();
        byte[] data = new byte[0];
        try {
            data = ZipUtils.generateZipByte(list);
        } catch (Exception e) {
            logger.error("导出zip压缩包失败，原因：{}", e.getMessage());
            return Result.failure(ErrorEnum.MAKE_ZIP_FILE_EXCEPTION);
        }
        result.setInfo(data);
        return result;
    }

    /**
     * 根据签名证书sn获取base64格式证书
     *
     * @param signSn
     * @param systemFlag
     * @return
     */
    @Override
    public Result getUserCert(String signSn, String systemFlag) {
        Result x = checkSystem(signSn, systemFlag);
        if (x != null) {
            return x;
        }
        Result result = new Result();
        Result certDataInfoResult = caBusinessManager.downloadCertDataInfo(signSn,true);
        if (!certDataInfoResult.isSuccess()){
            return certDataInfoResult;
        }
        Map<String,String> map = (Map<String, String>) certDataInfoResult.getInfo();
        UserCertStr userCertStr = new UserCertStr();
        userCertStr.setSignCert(map.get("signCert"));
        String encCert = map.get("encCert");
        if(null != encCert){
            userCertStr.setEncCert(encCert);
        }
        result.setInfo(userCertStr);
        return result;
    }

    /**
     * 校验请求内容是否是该系统的
     * @param signSn
     * @param systemFlag
     * @return
     */
    private Result checkSystem(String signSn, String systemFlag) {
        UserCertDO userCertDO = userCertDao.getUserCertBaseInfoBySignSn(signSn);
        if(null == userCertDO){
            return Result.failure(ErrorEnum.THE_SN_IS_INVALID);
        }
        boolean flag = baseUserDao.isAuthorize(systemFlag,userCertDO.getUserId().intValue());
        if(!flag){
            return Result.failure(ErrorEnum.THE_CERT_IS_NOT_BELONG_TO_THE_SYSTEM);
        }
        return null;
    }
}
