package com.xdja.pki.ra.service.manager.utils;

import com.xdja.pki.ra.core.util.cert.SM2Extensions;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;

import java.util.HashMap;
import java.util.Map;

public class CertExtendNameFinder {

	private final static Map extendNames = new HashMap();
	 
	 static {
		 extendNames.put(Extension.auditIdentity, "AuditIdentity");
		 extendNames.put(Extension.authorityInfoAccess, "authorityInfoAccess");
		 extendNames.put(Extension.authorityKeyIdentifier, "authorityKeyIdentifier");
		 extendNames.put(Extension.basicConstraints, "basicConstraints");
		 extendNames.put(Extension.biometricInfo, "biometricInfo");
		 extendNames.put(Extension.certificateIssuer, "certificateIssuer");
		 extendNames.put(Extension.certificatePolicies, "certificatePolicies");
		 extendNames.put(Extension.cRLDistributionPoints, "cRLDistributionPoints");
		 extendNames.put(Extension.cRLNumber, "cRLNumber");
		 extendNames.put(Extension.deltaCRLIndicator, "deltaCRLIndicator");
		 extendNames.put(Extension.extendedKeyUsage, "extendedKeyUsage");
		 extendNames.put(Extension.freshestCRL, "freshestCRL");
		 extendNames.put(Extension.inhibitAnyPolicy, "inhibitAnyPolicy");
		 extendNames.put(Extension.instructionCode, "instructionCode");
		 extendNames.put(Extension.invalidityDate, "invalidityDate");
		 extendNames.put(Extension.issuerAlternativeName, "issuerAlternativeName");
		 extendNames.put(Extension.issuingDistributionPoint, "issuingDistributionPoint");
		 extendNames.put(Extension.keyUsage, "keyUsage");
		 extendNames.put(Extension.logoType, "logoType");
		 extendNames.put(Extension.nameConstraints, "nameConstraints");
		 extendNames.put(Extension.noRevAvail, "noRevAvail");
		 extendNames.put(Extension.policyConstraints, "policyConstraints");
		 extendNames.put(Extension.privateKeyUsagePeriod, "privateKeyUsagePeriod");
		 extendNames.put(Extension.qCStatements, "qCStatements");
		 extendNames.put(Extension.reasonCode, "reasonCode");
		 extendNames.put(Extension.subjectAlternativeName, "subjectAlternativeName");
		 extendNames.put(Extension.subjectDirectoryAttributes, "subjectDirectoryAttributes");
		 extendNames.put(Extension.subjectInfoAccess, "subjectInfoAccess");
		 extendNames.put(Extension.subjectKeyIdentifier, "subjectKeyIdentifier");
		 extendNames.put(Extension.targetInformation, "targetInformation");
		 extendNames.put(Extension.policyMappings, "policyMappings");
		 extendNames.put(SM2Extensions.identifyCode, "identifyCode");
		 extendNames.put(SM2Extensions.insuranceNumber, "insuranceNumber");
		 extendNames.put(SM2Extensions.iCRegistrationNumber, "iCRegistrationNumber");
		 extendNames.put(SM2Extensions.organizationCode, "organizationCode");
		 extendNames.put(SM2Extensions.taxationNumber, "taxationNumber");
		 
	 }
	 
	 public static String getExtendName(ASN1ObjectIdentifier objectIdentifier)
    {
        String name = (String)extendNames.get(objectIdentifier);

        return (name != null) ? name : objectIdentifier.getId();
    }
	 
}
