package com.xdja.pki.ra.service.manager.utils;

import org.bouncycastle.asn1.x509.GeneralName;

import java.util.HashMap;
import java.util.Map;

public class GeneralNameFinder {

	private final static Map<Integer, String> GeneralNames = new HashMap<Integer, String>();
	
	static {
		GeneralNames.put(GeneralName.otherName, "otherName");
		GeneralNames.put(GeneralName.rfc822Name, "rfc822Name");
		GeneralNames.put(GeneralName.dNSName, "dNSName");
		GeneralNames.put(GeneralName.x400Address, "x400Address");
		GeneralNames.put(GeneralName.directoryName, "directoryName");
		GeneralNames.put(GeneralName.ediPartyName, "ediPartyName");
		GeneralNames.put(GeneralName.uniformResourceIdentifier, "URL");
		GeneralNames.put(GeneralName.iPAddress, "iPAddress");
		GeneralNames.put(GeneralName.registeredID, "registeredID");
	}
	
	public static String getGeneralName(int tag) {
		String name = (String) GeneralNames.get(tag);
		return  (name != null) ? name : String.valueOf(tag);
	}
}
