package com.xdja.pki.ra.service.manager.utils;

/**
 * 个人身份标识枚举
 * 
 * @author zjr
 * @date  
 *
 */
public enum IdentifyCodeEnum {
	
	/**
	 * 身份证号码
	 */
	RESIDENTERCARDNUMBER(0, "身份证号码"),
	/**
	 * 军官证号码
	 */
	MILITARYOFFICERCARDNUMBER(1, "军官证号码"),
	/**
	 * 护照号码
	 */
	PASSPORTNUMBER(2, "护照号码");
	
	/**
	 * 枚举值
	 */
	public int value;
	/**
	 * 枚举描述
	 */
	public String desc;

	private IdentifyCodeEnum(int value, String desc) {
		this.value = value;
		this.desc = desc;
	}
	
	/**
	 * 枚举类型转换
	 * @param value 待转换枚举值
	 * @return 对应枚举
	 */
	public static final IdentifyCodeEnum convert(int value) {
		for (IdentifyCodeEnum item : IdentifyCodeEnum.values()) {
			if (item.value == value) {
				return item;
			}
		}
		
		throw new IllegalArgumentException(String.format("个人身份标识枚举转换异常[value=%s]", value));
	}
	
}
