package com.xdja.pki.ra.service.manager.utils;

import java.util.regex.Pattern;

/**
 * 参数校验工具
 * @author zjr
 *
 */
public class ParmsCommonVerifyUtil {
	/**
	 * 根据正则表达式，对值进行验证
	 * @param reg 表达式
	 * @param value 待验证的值
	 * @return true-成功；false-失败
	 */
	public static boolean check(String reg, String value) {
		if (null == reg || null == value) {
			return false;
		}

		return Pattern.matches(reg, value);
	}


	/**
	 * IP地址校验
	 * @param ipAddress
	 * @return boolean
	 */
	public static boolean isIpv4(String ipAddress) {  
		  
        String ip = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\."  
                +"(00?\\d|1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\."  
                +"(00?\\d|1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\."  
                +"(00?\\d|1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";  
       
        return check(ip, ipAddress);
  
    }
	
	/**
	 *  邮箱校验
	 * @param email
	 * @return boolean
	 */
	public static boolean isEmail(String email) {  
		 /**
		  * @之前必须有内容且只能是字母（大小写）、数字、下划线(_)、减号（-）、点（.）
		  * @和最后一个.之间必须有内容且只能是字母（大小写）、数字、点（.）、减号（-），且两个点不能挨着
		  * 最后一个.之后必须有内容且内容只能是字母（大小写）、数字且长度为大于等于2个字节，小于等于6个字节` 
		  */
        String reg = "^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z0-9]{2,6}$";  
        return check(reg, email);
  
    }
	
	/**
	 * 手机号校验
	 * @param mobile
	 * @return boolean
	 */
	public static boolean isMobile(String mobile) {  
		/**
		 *  reg 表示以1开头，第二位可能是3/4/5/6/7/8/9等的任意一个，在加上后面的\d表示数字[0-9]的9位，总共加起来11位结束
		 */
        String reg = "^1(3|4|5|6|7|8|9)\\d{9}$";  
        return check(reg, mobile);
  
    }
}
