/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.AkService;

import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.core.util.cert.Asn1Util;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.P10Utils;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.DoubleCodeDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import com.xdja.pki.ra.manager.dto.PersonUserDTO;
import com.xdja.pki.ra.manager.dto.RecoveryApplyDTO;
import com.xdja.pki.ra.manager.dto.RevokeApplyDTO;
import com.xdja.pki.ra.manager.dto.UpdateApplyDTO;
import com.xdja.pki.ra.service.manager.CommonService;
import com.xdja.pki.ra.service.manager.ak.AkService;
import com.xdja.pki.ra.service.manager.ak.xml.common.Request;
import com.xdja.pki.ra.service.manager.ak.xml.common.RequestHead;
import com.xdja.pki.ra.service.manager.ak.xml.common.Response;
import com.xdja.pki.ra.service.manager.ak.xml.common.ResponseBody;
import com.xdja.pki.ra.service.manager.ak.xml.common.ResponseDatagram;
import com.xdja.pki.ra.service.manager.ak.xml.common.ResponseHead;
import com.xdja.pki.ra.service.manager.ak.xml.request.CertApplyReq;
import com.xdja.pki.ra.service.manager.ak.xml.request.CertDownReq;
import com.xdja.pki.ra.service.manager.ak.xml.request.CertRevokeReq;
import com.xdja.pki.ra.service.manager.ak.xml.request.CertUpdateReq;
import com.xdja.pki.ra.service.manager.ak.xml.request.KeyRestoreReq;
import com.xdja.pki.ra.service.manager.ak.xml.request.UserRegisterReq;
import com.xdja.pki.ra.service.manager.ak.xml.request.vo.CertApplyReqVO;
import com.xdja.pki.ra.service.manager.ak.xml.request.vo.CertDownReqVO;
import com.xdja.pki.ra.service.manager.ak.xml.request.vo.CertRevokeReqVO;
import com.xdja.pki.ra.service.manager.ak.xml.request.vo.CertUpdateReqVO;
import com.xdja.pki.ra.service.manager.ak.xml.request.vo.KeyRestoreReqVO;
import com.xdja.pki.ra.service.manager.ak.xml.request.vo.UserRegisterReqVO;
import com.xdja.pki.ra.service.manager.ak.xml.response.vo.CertApplyRespVO;
import com.xdja.pki.ra.service.manager.ak.xml.response.vo.CertDownRespVO;
import com.xdja.pki.ra.service.manager.ak.xml.response.vo.CertRevokeRespVO;
import com.xdja.pki.ra.service.manager.ak.xml.response.vo.Certificate;
import com.xdja.pki.ra.service.manager.ak.xml.response.vo.KeyRestoreRespVO;
import com.xdja.pki.ra.service.manager.ak.xml.response.vo.Restore;
import com.xdja.pki.ra.service.manager.ak.xml.response.vo.UserRegisterRespVO;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.IssueApplyService;
import com.xdja.pki.ra.service.manager.certapply.RecoveryApplyService;
import com.xdja.pki.ra.service.manager.certapply.RevokeApplyService;
import com.xdja.pki.ra.service.manager.certapply.UpdateApplyService;
import com.xdja.pki.ra.service.manager.certapply.bean.DoubleCode;
import com.xdja.pki.ra.service.manager.personuser.PersonUserService;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AkServiceImpl
implements AkService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SUCCESS_CODE = "0X00000000";
    @Autowired
    private PersonUserService personUserService;
    @Autowired
    private CertTempCache certTempCache;
    @Autowired
    private IssueApplyService issueApplyService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private DoubleCodeDao doubleCodeDao;
    @Autowired
    private CertApplyService certApplyService;
    @Autowired
    private UpdateApplyService updateApplyService;
    @Autowired
    private RevokeApplyService revokeApplyService;
    @Autowired
    private RecoveryApplyService recoveryApplyService;
    @Autowired
    private UserCertDao userCertDao;
    @Autowired
    private CertApplyDao certApplyDao;
    @Autowired
    private BaseUserDao baseUserDao;

    public Result userRegister(UserRegisterReq userRegisterReq) {
        UserRegisterReqVO reqVO = (UserRegisterReqVO)userRegisterReq.getDatagram().getBody().getConfiguration();
        PersonUserDTO personUserDTO = new PersonUserDTO();
        String userID = String.valueOf(System.nanoTime());
        personUserDTO.setSystemFlag("V2X");
        personUserDTO.setPersonName(reqVO.getUsername());
        personUserDTO.setAddress(reqVO.getAddress());
        personUserDTO.setEmail(reqVO.getEmail());
        personUserDTO.setRemark(reqVO.getRemark());
        personUserDTO.setLicenseType(4);
        personUserDTO.setLicenseNumber(userID);
        Result result = this.personUserService.savePersonUser(personUserDTO);
        if (!result.isSuccess()) {
            this.logger.error(result.getErrorBean().toString());
            return result;
        }
        UserRegisterRespVO respVO = new UserRegisterRespVO();
        respVO.setUserID(userID);
        ResponseHead responseHead = this.buildHead((Request)userRegisterReq, "User register succeed", true);
        Response resp = new Response(new ResponseDatagram(responseHead, new ResponseBody((Object)respVO)), userRegisterReq.getSignature());
        return Result.success((Object)resp);
    }

    public Result certApply(CertApplyReq certApplyReq) {
        CertApplyReqVO reqVO = (CertApplyReqVO)certApplyReq.getDatagram().getBody().getConfiguration();
        IssueApplyDTO issueApplyDTO = new IssueApplyDTO();
        issueApplyDTO.setUserId(this.baseUserDao.getUserId(1, "V2X", Integer.valueOf(4), reqVO.getUserID()));
        issueApplyDTO.setUserType(Integer.valueOf(UserTypeEnum.PERSON_USER.id));
        issueApplyDTO.setLicenseType(Integer.valueOf(4));
        issueApplyDTO.setLicenseNumber(reqVO.getUserID());
        issueApplyDTO.setTempNo(reqVO.getTemplateName());
        issueApplyDTO.setCertDn(reqVO.getCertDN());
        issueApplyDTO.setCertValidity(Integer.valueOf(reqVO.getCertValidLength().intValue()));
        CertTempDO certTempDO = this.certTempCache.getCertTempInfoByTempNo(issueApplyDTO.getTempNo());
        issueApplyDTO.setSignAlg(certTempDO.getSignAlg());
        issueApplyDTO.setPrivateKeyLength(certTempDO.getPrivateKeyLength());
        Result result = this.issueApplyService.insertUserCertIssueApply("V2X", issueApplyDTO, true, true);
        if (!result.isSuccess()) {
            this.logger.error(result.getErrorBean().toString());
            return result;
        }
        DoubleCode doubleCode = this.commonService.createDoubleCode(result.getInfo().toString());
        CertApplyRespVO respVO = new CertApplyRespVO();
        respVO.setRefNO(doubleCode.getRefCode());
        respVO.setAuthCode(doubleCode.getAuthCode());
        ResponseHead responseHead = this.buildHead((Request)certApplyReq, "Cert request succeed", true);
        Response resp = new Response(new ResponseDatagram(responseHead, new ResponseBody((Object)respVO)), certApplyReq.getSignature());
        return Result.success((Object)resp);
    }

    public Result certDown(CertDownReq certDownReq) {
        CertDownReqVO certDownReqVO = (CertDownReqVO)certDownReq.getDatagram().getBody().getConfiguration();
        PublicKey publicKey = P10Utils.p10ToPublicKey((String)certDownReqVO.getP10Cert());
        String applyNo = certDownReqVO.getAuthCode();
        CertApplyDO certApplyDO = this.certApplyDao.getCertApplyInfo(applyNo);
        Result result = this.certApplyService.issueUserCert(null, null, Integer.valueOf(4), certApplyDO.getApplyType().intValue(), applyNo, "V2X", null, publicKey.getEncoded(), 2, true, false, null, null);
        if (!result.isSuccess()) {
            this.logger.error(result.getErrorBean().toString());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)result.getInfo();
        Certificate certificate = new Certificate();
        certificate.setCertType("env");
        try {
            String signCert = userCertInfo.getSignCert();
            String encCert = userCertInfo.getEncCert();
            certificate.setSignCert(CertUtils.writeObject((Object)CertUtils.getCertFromStr((String)signCert)));
            certificate.setEncCert(CertUtils.writeObject((Object)CertUtils.getCertFromStr((String)encCert)));
            certificate.setEnvelope(Asn1Util.convertSignDataEnvelop2Sm2Envelop((String)userCertInfo.getEncPriKey(), (PublicKey)CertUtils.getCertFromStr((String)encCert).getPublicKey()));
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8f6c\u6362\u5f02\u5e38 ", (Throwable)e);
        }
        this.certApplyService.issueUserCertResp(applyNo, "V2X", true);
        this.doubleCodeDao.updateStatus(certDownReqVO.getAuthCode());
        CertDownRespVO certDownRespVO = new CertDownRespVO(certificate);
        ResponseHead responseHead = this.buildHead((Request)certDownReq, "Certificate download succeed", true);
        Response resp = new Response(new ResponseDatagram(responseHead, new ResponseBody((Object)certDownRespVO)), certDownReq.getSignature());
        return Result.success((Object)resp);
    }

    public Result certUpdate(CertUpdateReq certUpdateReq) {
        CertUpdateReqVO certUpdateReqVO = (CertUpdateReqVO)certUpdateReq.getDatagram().getBody().getConfiguration();
        UpdateApplyDTO updateApplyDTO = new UpdateApplyDTO();
        updateApplyDTO.setUpdateKey(Boolean.valueOf(true));
        updateApplyDTO.setUpdateValidity(Boolean.valueOf(true));
        updateApplyDTO.setSignSn(certUpdateReqVO.getCertSN());
        UserCertDO userCert = this.userCertDao.getUserCertBaseInfo(certUpdateReqVO.getCertSN());
        updateApplyDTO.setUserId(userCert.getUserId());
        updateApplyDTO.setTempNo(userCert.getTempNo());
        updateApplyDTO.setCertDn(userCert.getCertDn());
        updateApplyDTO.setCertValidity(Integer.valueOf(certUpdateReqVO.getCertValidLength()));
        CertTempDO certTempDO = this.certTempCache.getCertTempInfoByTempNo(updateApplyDTO.getTempNo());
        updateApplyDTO.setPrivateKeyLength(certTempDO.getPrivateKeyLength());
        updateApplyDTO.setSignAlg(certTempDO.getSignAlg());
        updateApplyDTO.setEncSn(this.userCertDao.getEncSnBySignSn(certUpdateReqVO.getCertSN()));
        Result result = this.updateApplyService.insertUserCertUpdateApply("V2X", updateApplyDTO, true, true);
        if (!result.isSuccess()) {
            this.logger.error(result.getErrorBean().toString());
            return result;
        }
        CertApplyRespVO respVO = new CertApplyRespVO();
        DoubleCode doubleCode = this.commonService.createDoubleCode(result.getInfo().toString());
        respVO.setRefNO(doubleCode.getRefCode());
        respVO.setAuthCode(doubleCode.getAuthCode());
        ResponseHead responseHead = this.buildHead((Request)certUpdateReq, "Cert update succeed", true);
        Response resp = new Response(new ResponseDatagram(responseHead, new ResponseBody((Object)respVO)), certUpdateReq.getSignature());
        return Result.success((Object)resp);
    }

    public Result certRevoke(CertRevokeReq certRevokeReq) {
        CertRevokeReqVO certRevokeReqVO = (CertRevokeReqVO)certRevokeReq.getDatagram().getBody().getConfiguration();
        String signSn = certRevokeReqVO.getCertSN();
        RevokeApplyDTO revokeApplyDTO = new RevokeApplyDTO();
        revokeApplyDTO.setSignSn(certRevokeReqVO.getCertSN());
        revokeApplyDTO.setRevokeReason(Integer.valueOf(certRevokeReqVO.getRevokeReason().substring(2), 16));
        UserCertDO userCertDO = this.userCertDao.getUserCertBaseInfo(signSn);
        revokeApplyDTO.setUserId(userCertDO.getUserId());
        revokeApplyDTO.setTempNo(userCertDO.getTempNo());
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(revokeApplyDTO.getTempNo());
        revokeApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength());
        revokeApplyDTO.setSignAlg(certTempInfo.getSignAlg());
        String encSn = this.userCertDao.getEncSnBySignSn(signSn);
        revokeApplyDTO.setEncSn(encSn == null ? "" : encSn);
        Result result = this.revokeApplyService.insertUserCertRevokeApply("V2X", revokeApplyDTO, true, true);
        if (!result.isSuccess()) {
            this.logger.error(result.getErrorBean().toString());
            return result;
        }
        ResponseHead responseHead = this.buildHead((Request)certRevokeReq, "Cert Revoke succeed", true);
        Response resp = new Response(new ResponseDatagram(responseHead, new ResponseBody((Object)new CertRevokeRespVO())), certRevokeReq.getSignature());
        return Result.success((Object)resp);
    }

    public Result keyRestore(KeyRestoreReq keyRestoreReq) {
        KeyRestoreReqVO keyRestoreReqVO = (KeyRestoreReqVO)keyRestoreReq.getDatagram().getBody().getConfiguration();
        RecoveryApplyDTO recoveryApplyDTO = new RecoveryApplyDTO();
        String signSn = keyRestoreReqVO.getCertSN();
        recoveryApplyDTO.setSignSn(signSn);
        UserCertDO userCertDO = this.userCertDao.getUserCertBaseInfo(signSn);
        recoveryApplyDTO.setUserId(userCertDO.getUserId().longValue());
        recoveryApplyDTO.setTempNo(userCertDO.getTempNo());
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(recoveryApplyDTO.getTempNo());
        recoveryApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength().intValue());
        recoveryApplyDTO.setSignAlg(certTempInfo.getSignAlg());
        String encSn = this.userCertDao.getEncSnBySignSn(signSn);
        recoveryApplyDTO.setEncSn(encSn == null ? "" : encSn);
        Result result = this.recoveryApplyService.insertUserCertRecoveryApply("V2X", recoveryApplyDTO, true);
        if (!result.isSuccess()) {
            this.logger.error(result.getErrorBean().toString());
            return result;
        }
        PublicKey publicKey = P10Utils.p10ToPublicKey((String)keyRestoreReqVO.getP10Cert());
        String applyNo = result.getInfo().toString();
        result = this.certApplyService.issueUserCert(null, null, Integer.valueOf(4), ApplyTypeEnum.RECOVERY_APPLY.id, applyNo, "V2X", null, publicKey.getEncoded(), 2, true, false, null, null);
        if (!result.isSuccess()) {
            this.logger.error(result.getErrorBean().toString());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)result.getInfo();
        Restore certificate = new Restore();
        certificate.setCertType("env");
        try {
            String encCert = userCertInfo.getEncCert();
            certificate.setEncCert(CertUtils.writeObject((Object)CertUtils.getCertFromStr((String)encCert)));
            certificate.setEnvelope(Asn1Util.convertSignDataEnvelop2Sm2Envelop((String)userCertInfo.getEncPriKey(), (PublicKey)CertUtils.getCertFromStr((String)encCert).getPublicKey()));
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8f6c\u6362\u5f02\u5e38 ", (Throwable)e);
        }
        this.certApplyService.issueUserCertResp(applyNo, "V2X", true);
        KeyRestoreRespVO keyRestoreRespVO = new KeyRestoreRespVO(certificate);
        ResponseHead responseHead = this.buildHead((Request)keyRestoreReq, "Key restore succeed", true);
        Response resp = new Response(new ResponseDatagram(responseHead, new ResponseBody((Object)keyRestoreRespVO)), keyRestoreReq.getSignature());
        return Result.success((Object)resp);
    }

    private ResponseHead buildHead(Request request, String message, boolean isSuccess) {
        RequestHead requestHead = request.getDatagram().getHead();
        ResponseHead responseHead = new ResponseHead();
        responseHead.setVersion(requestHead.getVersion());
        responseHead.setMethod(requestHead.getMethod());
        responseHead.setTransactionCode(requestHead.getTransactionCode());
        if (isSuccess) {
            responseHead.setErrorCode(SUCCESS_CODE);
            responseHead.setErrorMessage(message);
        }
        return responseHead;
    }
}

