/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager;

import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.service.manager.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigFileData {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemService systemService;

    @Bean
    public Config configFile() {
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                config = Config.getConfig((String)PathConstants.GLOBAL_CONF_FILE_PATH);
                String content = FileUtils.read((String)PathConstants.DEFAULT_CONTAINER_PATH);
                config.setDefaultContainer(content.substring(21, content.length() - 2));
                config.setRaBaseDn("");
                this.systemService.saveConfigFile(config);
            }
            this.logger.info("\u7cfb\u7edf\u542f\u52a8\u52a0\u8f7dconfig.json\u914d\u7f6e\u6587\u4ef6\uff1a{}", (Object)config);
            CommonVariable.setConfig((Config)config);
            return config;
        }
        catch (Exception e) {
            this.logger.error("\u52a0\u8f7dconfig.json\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

