/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.auditlog;

import com.xdja.pki.cache.RedisClient;
import com.xdja.pki.core.constants.RedisKey;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.ArchiveConfigBean;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.util.time.DateUtils;
import com.xdja.pki.ra.service.manager.auditlog.ArchiveConfigService;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.ra.service.manager.system.bean.ArchiveConfigVO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArchiveConfigServiceImpl
implements ArchiveConfigService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedisClient redisClient;
    @Autowired
    SystemService systemService;

    public Result getArchiveConfig() {
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            ArchiveConfigBean archiveConfigBean = config.getArchiveConfigBean();
            if (null == archiveConfigBean) {
                ArchiveConfigBean archiveConfig = new ArchiveConfigBean();
                config.setArchiveConfigBean(archiveConfig);
                this.systemService.updateConfigFile(config);
            }
            result.setInfo((Object)archiveConfigBean);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6 \u5ba1\u8ba1\u53c2\u6570 \u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
    }

    public Result saveArchiveConfig(ArchiveConfigVO archiveConfigVO) {
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            ArchiveConfigBean archiveConfigBean = config.getArchiveConfigBean();
            Integer oldPeriod = 0;
            if (null != archiveConfigBean) {
                oldPeriod = archiveConfigBean.getAuditLogPeriod();
            }
            Integer newPeriod = archiveConfigVO.getAuditLogPeriod();
            BeanUtils.copyProperties((Object)archiveConfigVO, (Object)archiveConfigBean);
            config.setArchiveConfigBean(archiveConfigBean);
            this.systemService.updateConfigFile(config);
            Date date = new Date();
            if (null != newPeriod) {
                String nextAuditTime;
                String oldNextTime = this.redisClient.get(RedisKey.TIME_AUDIT_PERIOD);
                if (null == oldNextTime) {
                    Date intervalDate = DateUtils.getIntervalDate((Date)date, (int)10, (int)newPeriod);
                    nextAuditTime = String.valueOf(intervalDate.getTime());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u8bbe\u7f6e\u4e0b\u6b21\u5468\u671f\u5ba1\u8ba1\u65f6\u95f4\u4e3a\uff1a{}", (Object)DateUtils.longToStr((long)intervalDate.getTime()));
                    }
                } else if (oldPeriod < newPeriod) {
                    long l = (long)(newPeriod - oldPeriod) * 3600000L;
                    long newNextTime = Long.parseLong(oldNextTime) + l;
                    nextAuditTime = String.valueOf(newNextTime);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u4fee\u6539\u5468\u671f\u6027\u5ba1\u8ba1\u65b0\u5468\u671f\u5927\u4e8e\u539f\u6765\u5468\u671f\uff0c\u4e0b\u6b21\u5ba1\u8ba1\u65f6\u95f4\u4e3a\uff1a{}", (Object)DateUtils.longToStr((long)newNextTime));
                    }
                } else {
                    long nowTime;
                    long l = (long)oldPeriod.intValue() * 3600000L;
                    long lastTime = Long.parseLong(oldNextTime) - l;
                    long newPeriodLastTime = lastTime + (long)newPeriod.intValue() * 3600000L;
                    if (newPeriodLastTime < (nowTime = date.getTime())) {
                        nextAuditTime = String.valueOf(nowTime);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("\u4fee\u6539\u5468\u671f\u6027\u5ba1\u8ba1\u65b0\u5468\u671f\u5c0f\u4e8e\u539f\u6765\u5468\u671f\uff0c\u9700\u8981\u7acb\u5373\u6267\u884c\uff0c\u4e0b\u6b21\u5ba1\u8ba1\u65f6\u95f4\u4e3a\uff1a{}", (Object)DateUtils.longToStr((long)nowTime));
                        }
                    } else {
                        nextAuditTime = String.valueOf(newPeriodLastTime);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("\u4fee\u6539\u5468\u671f\u6027\u5ba1\u8ba1\u65b0\u5468\u671f\u5c0f\u4e8e\u539f\u6765\u5468\u671f\uff0c\u4e0b\u6b21\u5ba1\u8ba1\u65f6\u95f4\u4e3a\uff1a{}", (Object)DateUtils.longToStr((long)newPeriodLastTime));
                        }
                    }
                }
                this.redisClient.set(RedisKey.TIME_AUDIT_PERIOD, nextAuditTime);
            } else {
                this.redisClient.del(new String[]{RedisKey.TIME_AUDIT_PERIOD});
            }
            CommonVariable.setArchiveConfig((ArchiveConfigBean)archiveConfigBean);
            this.redisClient.publish(RedisKey.CHANNEL_SYSTEM_NOTICE, "notice:audit.config.changed");
            this.redisClient.publish(RedisKey.CHANNEL_SYSTEM_NOTICE, "notice:period.config.changed");
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58 \u5ba1\u8ba1\u53c2\u6570 \u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
    }
}

