/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.auditlog;

import com.xdja.pki.auditlog.dao.ArchiveLogDao;
import com.xdja.pki.auditlog.dao.model.ArchiveLogDO;
import com.xdja.pki.auditlog.service.ArchiveLogService;
import com.xdja.pki.auditlog.service.bean.ArchiveLogListVO;
import com.xdja.pki.auditlog.service.bean.ArchiveLogVO;
import com.xdja.pki.auditlog.service.bean.AuditLogIsAuditEnum;
import com.xdja.pki.auditlog.service.bean.AuditLogIsVerifyEnum;
import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.core.bean.ErrorBean;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArchiveLogServiceImpl
implements ArchiveLogService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ArchiveLogDao archiveLogDao;
    @Autowired
    public AdminCertDao adminCertDao;
    @Autowired
    public RaCertDao raCertDao;
    @Autowired
    private AuditLogService auditLogService;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Object listArchiveLogs(Integer pageNo, Integer pageSize, Integer operatorType, String startTime, String endTime, boolean isExport) {
        if (isExport) {
            List archiveLogs = (List)this.archiveLogDao.listArchiveLog(pageNo, pageSize, operatorType, startTime, endTime, isExport);
            return this.generateListVO(archiveLogs);
        }
        PageInfo pageInfo = (PageInfo)this.archiveLogDao.listArchiveLog(pageNo, pageSize, operatorType, startTime, endTime, isExport);
        pageInfo.setDatas(this.generateListVO((List)pageInfo.getDatas()));
        return pageInfo;
    }

    private List<ArchiveLogListVO> generateListVO(List<ArchiveLogDO> archiveLogs) {
        ArrayList<ArchiveLogListVO> archiveLogList = new ArrayList<ArchiveLogListVO>();
        for (ArchiveLogDO archiveLogDO : archiveLogs) {
            ArchiveLogListVO archiveLogListVO = new ArchiveLogListVO();
            archiveLogListVO.setId(archiveLogDO.getId());
            archiveLogListVO.setOperatorSubject(archiveLogDO.getOperatorSubject());
            archiveLogListVO.setOperatorType(archiveLogDO.getOperatorType());
            archiveLogListVO.setOperatorTypeString(AuditLogOperatorTypeEnum.getDescFromType((String)archiveLogDO.getOperatorType()));
            archiveLogListVO.setOperateClientIp(archiveLogDO.getOperateClientIp());
            archiveLogListVO.setOperateTime(this.sdf.format(archiveLogDO.getOperateTime()));
            archiveLogListVO.setOperateResult(archiveLogDO.getOperateResult());
            archiveLogListVO.setOperateResultString(AuditLogResultEnum.getValueFromId((int)archiveLogDO.getOperateResult()));
            archiveLogListVO.setIsAudit(archiveLogDO.getIsAudit());
            archiveLogListVO.setIsAuditString(AuditLogIsAuditEnum.getValueFromId((int)archiveLogDO.getIsAudit()));
            archiveLogListVO.setArchiveTime(this.sdf.format(archiveLogDO.getArchiveTime()));
            archiveLogList.add(archiveLogListVO);
        }
        return archiveLogList;
    }

    public Object getArchiveLogbyId(int id, Integer verify) {
        ArchiveLogDO archiveLogDO;
        try {
            archiveLogDO = this.archiveLogDao.get(id);
            if (null == archiveLogDO) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u5b9e\u4f8b\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
        }
        ArchiveLogVO archiveLogVO = new ArchiveLogVO();
        archiveLogVO.setId(archiveLogDO.getId());
        archiveLogVO.setOperatorSubject(archiveLogDO.getOperatorSubject());
        archiveLogVO.setOperatorSn(archiveLogDO.getOperatorSn());
        archiveLogVO.setOperatorType(archiveLogDO.getOperatorType());
        archiveLogVO.setOperatorTypeString(AuditLogOperatorTypeEnum.getDescFromType((String)archiveLogDO.getOperatorType()));
        archiveLogVO.setOperateClientIp(archiveLogDO.getOperateClientIp());
        archiveLogVO.setOperateContent(archiveLogDO.getOperateContent());
        archiveLogVO.setOperateResult(archiveLogDO.getOperateResult());
        archiveLogVO.setOperateTime(this.sdf.format(archiveLogDO.getOperateTime()));
        archiveLogVO.setOperateResultString(AuditLogResultEnum.getValueFromId((int)archiveLogDO.getOperateResult()));
        archiveLogVO.setOperateModifyDetail(archiveLogDO.getOperateModifyDetail());
        archiveLogVO.setOperateSign(archiveLogDO.getOperateSign());
        archiveLogVO.setIsAudit(archiveLogDO.getIsAudit());
        archiveLogVO.setIsAuditString(AuditLogIsAuditEnum.getValueFromId((int)archiveLogDO.getIsAudit()));
        if (archiveLogDO.getIsVerify() != null) {
            archiveLogVO.setIsVerify(archiveLogDO.getIsVerify());
            archiveLogVO.setIsVerifyString(AuditLogIsVerifyEnum.getValueFromId((int)archiveLogDO.getIsVerify()));
        }
        if (archiveLogDO.getIsAudit() == 2) {
            archiveLogVO.setAuditSubject(archiveLogDO.getAuditSubject());
            archiveLogVO.setAuditSn(archiveLogDO.getAuditSn());
            archiveLogVO.setAuditNote(archiveLogDO.getAuditNote());
            archiveLogVO.setAuditTime(this.sdf.format(archiveLogDO.getAuditTime()));
            archiveLogVO.setAuditClientIp(archiveLogDO.getAuditClientIp());
        }
        if (null != verify && verify == 1) {
            this.logger.info("get archive log info with verify!");
            Result v = archiveLogDO.getIsAudit() == 1 ? this.verifyOperateSign(archiveLogDO) : this.verifyAuditOperateSign(archiveLogDO);
            AuditLogIsVerifyEnum isVerifyEnum = AuditLogIsVerifyEnum.getInstance((boolean)v.isSuccess());
            archiveLogVO.setIsVerifyString(isVerifyEnum.value);
        }
        archiveLogVO.setArchiveTime(this.sdf.format(archiveLogDO.getArchiveTime()));
        return CoreResult.success((Object)archiveLogVO);
    }

    public CoreResult verifyArchiveLog(int id) {
        ArchiveLogDO archiveLogDO;
        try {
            archiveLogDO = this.archiveLogDao.get(id);
            if (null == archiveLogDO) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u5b9e\u4f8b\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
        }
        Result result = archiveLogDO.getIsAudit() == 1 ? this.verifyOperateSign(archiveLogDO) : this.verifyAuditOperateSign(archiveLogDO);
        ErrorEnum errorEnum = result.getError();
        ErrorBean errorBean = new ErrorBean();
        if (null != errorEnum) {
            errorBean = new ErrorBean(errorEnum.code, errorEnum.desc);
        }
        return new CoreResult(result.getCode(), result.getInfo(), errorBean);
    }

    private Result verifyOperateSign(ArchiveLogDO archiveLogDO) {
        boolean verify;
        this.logger.info("verify:{}", (Object)archiveLogDO);
        String operatorSn = archiveLogDO.getOperatorSn();
        AdminCertDO adminCertDO = this.adminCertDao.getAdminCertInfo(operatorSn, 2);
        if (adminCertDO == null) {
            return Result.failure((ErrorEnum)ErrorEnum.GET_OPERATOR_CERT_EMPTY);
        }
        this.logger.info("\u8bc1\u4e66\uff1a{}", (Object)adminCertDO.getCertInfo());
        X509Certificate operateCert = CertUtils.getCertFromStr((String)adminCertDO.getCertInfo());
        if (operateCert == null) {
            return Result.failure((ErrorEnum)ErrorEnum.GET_OPERATOR_CERT_EMPTY);
        }
        boolean verifySignedData = false;
        try {
            verifySignedData = SignedDataUtils.verifySignedData((String)archiveLogDO.getOperateSign(), (PublicKey)operateCert.getPublicKey());
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u7ba1\u7406\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL);
        }
        if (!verifySignedData) {
            this.logger.error("\u9a8c\u8bc1\u7ba1\u7406\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25");
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL);
        }
        try {
            RaCertDO raCertDO = this.raCertDao.queryRaCertDataById(archiveLogDO.getServerCertId());
            X509Certificate raServerCert = CertUtils.getCertFromStr((String)raCertDO.getCertInfo());
            verify = 0 != CommonVariable.getIsHsm() ? HsmUtils.verifyCertByYunHsm((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (String)archiveLogDO.operatorBase64Encode(), (String)archiveLogDO.getServerSign()) : HsmUtils.verifyCertByBC((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (byte[])Base64.decode((String)archiveLogDO.getServerSign()), (byte[])Base64.decode((String)archiveLogDO.operatorBase64Encode()));
        }
        catch (Exception e) {
            this.logger.error("verify audit error", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
        }
        if (verify) {
            return Result.success();
        }
        return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
    }

    private Result verifyAuditOperateSign(ArchiveLogDO archiveLogDO) {
        this.logger.info("verify:{}", (Object)archiveLogDO);
        String auditSn = archiveLogDO.getAuditSn();
        AdminCertDO adminCertDO = this.adminCertDao.getAdminCertInfo(auditSn, 2);
        if (adminCertDO == null) {
            return Result.failure((ErrorEnum)ErrorEnum.GET_AUDITOR_CERT_EMPTY);
        }
        this.logger.info("\u8bc1\u4e66\uff1a{}", (Object)adminCertDO.getCertInfo());
        X509Certificate operateCert = CertUtils.getCertFromStr((String)adminCertDO.getCertInfo());
        if (operateCert == null) {
            return Result.failure((ErrorEnum)ErrorEnum.GET_AUDITOR_CERT_EMPTY);
        }
        boolean verifySignedData = false;
        try {
            verifySignedData = SignedDataUtils.verifySignedData((String)archiveLogDO.getOperateSign(), (PublicKey)operateCert.getPublicKey());
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u5ba1\u8ba1\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL);
        }
        if (!verifySignedData) {
            this.logger.error("\u9a8c\u8bc1\u5ba1\u8ba1\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25");
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL);
        }
        boolean verify = false;
        try {
            RaCertDO raCertDO = this.raCertDao.queryRaCertDataById(archiveLogDO.getServerCertId());
            X509Certificate raServerCert = CertUtils.getCertFromStr((String)raCertDO.getCertInfo());
            verify = 0 != CommonVariable.getIsHsm() ? HsmUtils.verifyCertByYunHsm((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (String)archiveLogDO.operatorWithAuditInfoBase64Encode(), (String)archiveLogDO.getServerSign()) : HsmUtils.verifyCertByBC((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (byte[])Base64.decode((String)archiveLogDO.getServerSign()), (byte[])Base64.decode((String)archiveLogDO.operatorWithAuditInfoBase64Encode()));
        }
        catch (Exception e) {
            this.logger.error("verify audit error", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
        }
        if (verify) {
            return Result.success();
        }
        return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
    }
}

