/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.auditlog;

import com.xdja.pki.auditlog.dao.ArchiveLogDao;
import com.xdja.pki.auditlog.dao.AuditLogDao;
import com.xdja.pki.auditlog.dao.PeriodAuditLogRelationDao;
import com.xdja.pki.auditlog.dao.model.ArchiveLogDO;
import com.xdja.pki.auditlog.dao.model.AuditLogDO;
import com.xdja.pki.auditlog.dao.model.AuditLogListDO;
import com.xdja.pki.auditlog.service.bean.AuditLogIsAuditEnum;
import com.xdja.pki.auditlog.service.bean.AuditLogIsVerifyEnum;
import com.xdja.pki.auditlog.service.bean.AuditLogListVO;
import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.AuditLogVO;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditLogAuditReq;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.cache.RedisClient;
import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.core.bean.ErrorBean;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.core.constants.RedisKey;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.ArchiveConfigBean;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.core.util.time.DateUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.AdminRoleDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import com.xdja.pki.ra.manager.dao.model.RoleDO;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.util.OperatorUtil;
import java.net.InetAddress;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditLogServiceImpl
implements AuditLogService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    public AuditLogDao auditLogDao;
    @Autowired
    public AdminCertDao adminCertDao;
    @Autowired
    public RaCertDao raCertDao;
    @Autowired
    private ArchiveLogDao archiveLogDao;
    @Autowired
    private AdminRoleDao adminRoleDao;
    @Autowired
    public PeriodAuditLogRelationDao periodAuditLogRelationDao;
    @Autowired
    RedisClient redisClient;
    private static double ARCHIVE_PERCENT = 0.8;
    private static long MS_PER_DAY = 86400000L;

    public CoreResult save(int operatorType, String operatorContext, int operatorResult, String operatorSign) {
        AuditLogDO auditLogDO = new AuditLogDO();
        Operator operator = OperatorUtil.getOperator();
        if (operator == null || operator.getCurrUser() == null) {
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN.code, ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN.desc));
        }
        CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
        auditLogDO.setOperatorSubject(currentAdminInfo.getCertDn());
        auditLogDO.setOperatorSn(currentAdminInfo.getCertSn());
        auditLogDO.setOperatorCertId(currentAdminInfo.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        String format = sdf.format(new Date());
        try {
            Date date = sdf.parse(format);
            auditLogDO.setOperateTime(date);
        }
        catch (ParseException e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.TIME_CONVERSION_EXCEPTION.code, ErrorEnum.TIME_CONVERSION_EXCEPTION.desc));
        }
        auditLogDO.setOperatorType(String.valueOf(operatorType));
        auditLogDO.setOperateClientIp(currentAdminInfo.getClientIpAddress());
        auditLogDO.setOperateContent(operatorContext);
        auditLogDO.setOperateResult(Integer.valueOf(operatorResult));
        auditLogDO.setOperateSign(operatorSign);
        auditLogDO.setIsAudit(Integer.valueOf(AuditLogIsAuditEnum.FALSE.id));
        try {
            RaCertDO raServerCert = this.raCertDao.getNewRaCertInfo();
            if (raServerCert == null) {
                this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4e3a\u7a7a!");
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.GET_RA_SERVER_CERT_EMPTY.code, ErrorEnum.GET_RA_SERVER_CERT_EMPTY.desc));
            }
            auditLogDO.setServerCertId(raServerCert.getId());
            String content = auditLogDO.operatorBase64Encode();
            String sign = null;
            sign = 1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? HsmUtils.signByYunHsm((String)raServerCert.getSignAlg(), (int)CommonVariable.getKeyIndex(), (String)CommonVariable.getKeyPwd(), (String)content) : HsmUtils.signByBC((String)raServerCert.getSignAlg(), (byte[])CommonVariable.getRaSignPriKey(), (String)content);
            if (StringUtils.isBlank((CharSequence)sign)) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.SIGN_BY_HSM_IS_ERROR.code, ErrorEnum.SIGN_BY_HSM_IS_ERROR.desc));
            }
            auditLogDO.setServerSign(sign);
            this.auditLogDao.saveLog(auditLogDO);
        }
        catch (SdfSDKException | CryptoException e) {
            this.logger.error("RA\u670d\u52a1\u5668\u8bc1\u4e66\u7b7e\u540d\u5f02\u5e38!", e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.RA_SERVER_CERT_SIGN_EXCEPTION.code, ErrorEnum.RA_SERVER_CERT_SIGN_EXCEPTION.desc));
        }
        catch (Exception e) {
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.RA_SERVER_CERT_SIGN_EXCEPTION.code, ErrorEnum.RA_SERVER_CERT_SIGN_EXCEPTION.desc));
        }
        return new CoreResult(0, null);
    }

    public boolean saveAuditLog(int operatorType, String operatorContext, int operatorResult, String operatorSign) {
        AuditLogDO auditLogDO = new AuditLogDO();
        Operator operator = OperatorUtil.getOperator();
        if (operator == null || operator.getCurrUser() == null) {
            return false;
        }
        CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
        auditLogDO.setOperatorSubject(currentAdminInfo.getCertDn());
        auditLogDO.setOperatorSn(currentAdminInfo.getCertSn());
        auditLogDO.setOperatorCertId(currentAdminInfo.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        String format = sdf.format(new Date());
        try {
            Date date = sdf.parse(format);
            auditLogDO.setOperateTime(date);
        }
        catch (ParseException e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return false;
        }
        auditLogDO.setOperatorType(String.valueOf(operatorType));
        auditLogDO.setOperateClientIp(currentAdminInfo.getClientIpAddress());
        auditLogDO.setOperateContent(operatorContext);
        auditLogDO.setOperateResult(Integer.valueOf(operatorResult));
        auditLogDO.setOperateSign(operatorSign);
        auditLogDO.setIsAudit(Integer.valueOf(AuditLogIsAuditEnum.FALSE.id));
        try {
            RaCertDO raServerCert = this.raCertDao.getNewRaCertInfo();
            if (raServerCert == null) {
                this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4e3a\u7a7a!");
                return false;
            }
            auditLogDO.setServerCertId(raServerCert.getId());
            String content = auditLogDO.operatorBase64Encode();
            String sign = null;
            sign = 1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? HsmUtils.signByYunHsm((String)raServerCert.getSignAlg(), (int)CommonVariable.getKeyIndex(), (String)CommonVariable.getKeyPwd(), (String)content) : HsmUtils.signByBC((String)raServerCert.getSignAlg(), (byte[])CommonVariable.getRaSignPriKey(), (String)content);
            if (StringUtils.isBlank((CharSequence)sign)) {
                return false;
            }
            auditLogDO.setServerSign(sign);
            this.auditLogDao.saveLog(auditLogDO);
        }
        catch (SdfSDKException | CryptoException e) {
            this.logger.error("RA\u670d\u52a1\u5668\u8bc1\u4e66\u7b7e\u540d\u5f02\u5e38!", e);
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean saveAuditLog(int operatorType, String operatorContext, int operatorResult, String operatorSign, String operateModifyDetail) {
        AuditLogDO auditLogDO = new AuditLogDO();
        Operator operator = OperatorUtil.getOperator();
        if (operator == null || operator.getCurrUser() == null) {
            return false;
        }
        CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
        auditLogDO.setOperatorSubject(currentAdminInfo.getCertDn());
        auditLogDO.setOperatorSn(currentAdminInfo.getCertSn());
        auditLogDO.setOperatorCertId(currentAdminInfo.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        String format = sdf.format(new Date());
        try {
            Date date = sdf.parse(format);
            auditLogDO.setOperateTime(date);
        }
        catch (ParseException e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return false;
        }
        auditLogDO.setOperatorType(String.valueOf(operatorType));
        auditLogDO.setOperateClientIp(currentAdminInfo.getClientIpAddress());
        auditLogDO.setOperateContent(operatorContext);
        auditLogDO.setOperateResult(Integer.valueOf(operatorResult));
        auditLogDO.setOperateSign(operatorSign);
        auditLogDO.setOperateModifyDetail(operateModifyDetail);
        auditLogDO.setIsAudit(Integer.valueOf(AuditLogIsAuditEnum.FALSE.id));
        try {
            RaCertDO raServerCert = this.raCertDao.getNewRaCertInfo();
            if (raServerCert == null) {
                this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4e3a\u7a7a!");
                return false;
            }
            auditLogDO.setServerCertId(raServerCert.getId());
            String content = auditLogDO.operatorBase64Encode();
            String sign = null;
            sign = 1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? HsmUtils.signByYunHsm((String)raServerCert.getSignAlg(), (int)CommonVariable.getKeyIndex(), (String)CommonVariable.getKeyPwd(), (String)content) : HsmUtils.signByBC((String)raServerCert.getSignAlg(), (byte[])CommonVariable.getRaSignPriKey(), (String)content);
            if (StringUtils.isBlank((CharSequence)sign)) {
                return false;
            }
            auditLogDO.setServerSign(sign);
            this.auditLogDao.saveLog(auditLogDO);
        }
        catch (SdfSDKException | CryptoException e) {
            this.logger.error("RA\u670d\u52a1\u5668\u8bc1\u4e66\u7b7e\u540d\u5f02\u5e38!", e);
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public CoreResult getAuditLogList(Integer pageNo, Integer pageSize, String operatorSubject, Integer operatorType, Integer isAudit, String startTime, String endTime) {
        if (pageNo == 0 && pageSize == 0) {
            List doList = (List)this.auditLogDao.getLogList(pageNo, pageSize, operatorSubject, operatorType, isAudit, startTime, endTime);
            return new CoreResult(0, this.setDataList(doList));
        }
        PageInfo list = (PageInfo)this.auditLogDao.getLogList(pageNo, pageSize, operatorSubject, operatorType, isAudit, startTime, endTime);
        list.setDatas(this.setDataList((List)list.getDatas()));
        return new CoreResult(0, (Object)list);
    }

    private List<AuditLogListVO> setDataList(List<AuditLogListDO> list) {
        ArrayList<AuditLogListVO> infos = new ArrayList<AuditLogListVO>();
        Iterator<AuditLogListDO> iterator = list.iterator();
        while (iterator.hasNext()) {
            AuditLogListDO obj;
            AuditLogListDO logDo = obj = iterator.next();
            AuditLogListVO logVo = new AuditLogListVO();
            logVo.setId(logDo.getId());
            logVo.setOperatorSubject(logDo.getOperatorSubject());
            logVo.setOperatorType(logDo.getOperatorType());
            logVo.setOperatorTypeString(AuditLogOperatorTypeEnum.getDescFromType((String)logDo.getOperatorType()));
            logVo.setOperateClientIp(logDo.getOperateClientIp());
            logVo.setOperateResult(logDo.getOperateResult());
            logVo.setOperateResultString(AuditLogResultEnum.getValueFromId((int)logDo.getOperateResult()));
            logVo.setIsAudit(logDo.getIsAudit());
            logVo.setIsAuditString(AuditLogIsAuditEnum.getValueFromId((int)logDo.getIsAudit()));
            logVo.setOperateTime(logDo.getOperateTime());
            infos.add(logVo);
        }
        return infos;
    }

    public CoreResult doAuditLog(AuditLogAuditReq auditReq, AuditSignBean bean) {
        AuditLogDO auditLogDO;
        try {
            auditLogDO = this.auditLogDao.getLogById(auditReq.getId());
            if (null == auditLogDO) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u5b9e\u4f8b\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
        }
        if (auditLogDO.getIsAudit() == AuditLogIsAuditEnum.TRUE.id) {
            this.logger.error("\u8be5\u65e5\u5fd7\u5df2\u7ecf\u88ab\u5ba1\u6838\u8fc7!");
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_IS_ALREADY_AUDIT.code, ErrorEnum.LOG_IS_ALREADY_AUDIT.desc));
        }
        Result auditVerifyResult = this.verifyOperateSign(auditLogDO);
        if (!auditVerifyResult.isSuccess()) {
            return new CoreResult(auditVerifyResult.getCode(), auditVerifyResult.getInfo());
        }
        Operator operator = OperatorUtil.getOperator();
        if (operator == null || operator.getCurrUser() == null) {
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN.code, ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN.desc));
        }
        CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
        auditLogDO.setAuditClientIp(currentAdminInfo.getClientIpAddress());
        auditLogDO.setAuditCertId(currentAdminInfo.getId());
        auditLogDO.setAuditSn(currentAdminInfo.getCertSn());
        auditLogDO.setAuditSubject(currentAdminInfo.getCertDn());
        auditLogDO.setAuditSign(bean.getSign());
        auditLogDO.setAuditTime(new Date());
        auditLogDO.setIsAudit(Integer.valueOf(AuditLogIsAuditEnum.TRUE.id));
        auditLogDO.setAuditNote(auditReq.getAuditNote());
        auditLogDO.setIsVerify(Integer.valueOf(auditReq.getIsVerify()));
        String content = auditLogDO.operatorWithAuditInfoBase64Encode();
        try {
            RaCertDO raServerCert = this.raCertDao.getNewRaCertInfo();
            if (raServerCert == null) {
                this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4e3a\u7a7a!");
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.GET_RA_SERVER_CERT_EMPTY.code, ErrorEnum.GET_RA_SERVER_CERT_EMPTY.desc));
            }
            String sign = 1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? HsmUtils.signByYunHsm((String)raServerCert.getSignAlg(), (int)CommonVariable.getKeyIndex(), (String)CommonVariable.getKeyPwd(), (String)content) : HsmUtils.signByBC((String)raServerCert.getSignAlg(), (byte[])CommonVariable.getRaSignPriKey(), (String)content);
            if (StringUtils.isBlank((CharSequence)sign)) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.SIGN_BY_HSM_IS_ERROR.code, ErrorEnum.SIGN_BY_HSM_IS_ERROR.desc));
            }
            auditLogDO.setServerSign(sign);
            auditLogDO.setServerCertId(raServerCert.getId());
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL.code, ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL.desc));
        }
        int success = this.auditLogDao.updateLog(auditLogDO);
        if (success == 1) {
            return new CoreResult(0, null);
        }
        this.logger.error("\u66f4\u65b0\u5ba1\u6838\u65e5\u5fd7\u5931\u8d25!");
        return new CoreResult(-1, null, new ErrorBean(ErrorEnum.UPDATE_AUDIT_IS_FAILURE.code, ErrorEnum.UPDATE_AUDIT_IS_FAILURE.desc));
    }

    public Object getOperateLogById(int id) {
        AuditLogDO auditLogDO;
        try {
            auditLogDO = this.auditLogDao.getLogById(id);
            if (null == auditLogDO) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u5b9e\u4f8b\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
        }
        return CoreResult.success((Object)auditLogDO);
    }

    public CoreResult get(int id, Integer verify) {
        AuditLogDO logDO;
        try {
            logDO = this.auditLogDao.getLogById(id);
            if (null == logDO) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u5b9e\u4f8b\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
        }
        AuditLogVO logVO = new AuditLogVO();
        logVO.setId(logDO.getId());
        logVO.setOperatorSubject(logDO.getOperatorSubject());
        logVO.setOperatorSn(logDO.getOperatorSn());
        logVO.setOperatorType(logDO.getOperatorType());
        logVO.setOperatorTypeString(AuditLogOperatorTypeEnum.getDescFromType((String)logDO.getOperatorType()));
        logVO.setOperateClientIp(logDO.getOperateClientIp());
        logVO.setOperateContent(logDO.getOperateContent());
        logVO.setOperateResult(logDO.getOperateResult());
        logVO.setOperateResultString(AuditLogResultEnum.getValueFromId((int)logDO.getOperateResult()));
        logVO.setOperateModifyDetail(logDO.getOperateModifyDetail());
        logVO.setOperateSign(logDO.getOperateSign());
        logVO.setIsAudit(logDO.getIsAudit());
        logVO.setIsAuditString(AuditLogIsAuditEnum.getValueFromId((int)logDO.getIsAudit()));
        logVO.setOperateTime(logDO.getOperateTime());
        if (logDO.getIsVerify() != null) {
            logVO.setIsVerify(logDO.getIsVerify());
            logVO.setIsVerifyString(AuditLogIsVerifyEnum.getValueFromId((int)logDO.getIsVerify()));
        }
        if (logDO.getIsAudit() == 2) {
            logVO.setAuditSubject(logDO.getAuditSubject());
            logVO.setAuditSn(logDO.getAuditSn());
            logVO.setAuditNote(logDO.getAuditNote());
            logVO.setAuditTime(logDO.getAuditTime());
            logVO.setAuditClientIp(logDO.getAuditClientIp());
        }
        if (verify != null && verify == 1) {
            this.logger.info("get audit log info with verify!");
            Result v = logDO.getIsAudit() == 1 ? this.verifyOperateSign(logDO) : this.verifyAuditOperateSign(logDO);
            AuditLogIsVerifyEnum isVerifyEnum = AuditLogIsVerifyEnum.getInstance((boolean)v.isSuccess());
            logVO.setIsVerify(Integer.valueOf(isVerifyEnum.id));
            logVO.setIsVerifyString(isVerifyEnum.value);
        }
        return new CoreResult(0, (Object)logVO);
    }

    public CoreResult verify(int id) {
        AuditLogDO auditLogDO;
        try {
            auditLogDO = this.auditLogDao.getLogById(id);
            if (null == auditLogDO) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u5b9e\u4f8b\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
        }
        Result result = this.verifyAuditOperateSign(auditLogDO);
        ErrorEnum errorEnum = result.getError();
        ErrorBean errorBean = new ErrorBean();
        if (null != errorEnum) {
            errorBean = new ErrorBean(errorEnum.code, errorEnum.desc);
        }
        return new CoreResult(result.getCode(), result.getInfo(), errorBean);
    }

    private Result verifyOperateSign(AuditLogDO auditLogDO) {
        String operatorSn = auditLogDO.getOperatorSn();
        AdminCertDO adminCertDO = this.adminCertDao.getAdminCertInfo(operatorSn, 2);
        if (adminCertDO == null) {
            this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u5458\u8bc1\u4e66\u4e3a\u7a7a");
            return Result.failure((ErrorEnum)ErrorEnum.GET_OPERATOR_CERT_EMPTY);
        }
        String data = adminCertDO.getCertInfo();
        try {
            boolean verify;
            boolean verifySignedData;
            X509Certificate operatorCert = CertUtils.getCertFromStr((String)data);
            try {
                verifySignedData = SignedDataUtils.verifySignedData((String)auditLogDO.getOperateSign(), (PublicKey)operatorCert.getPublicKey());
            }
            catch (Exception e) {
                this.logger.error("\u9a8c\u8bc1\u7ba1\u7406\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL);
            }
            if (!verifySignedData) {
                this.logger.error("\u9a8c\u8bc1\u7ba1\u7406\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25");
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL);
            }
            try {
                RaCertDO raCertDO = this.raCertDao.queryRaCertDataById(auditLogDO.getServerCertId());
                X509Certificate raServerCert = CertUtils.getCertFromStr((String)raCertDO.getCertInfo());
                verify = 0 != CommonVariable.getIsHsm() ? HsmUtils.verifyCertByYunHsm((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (String)auditLogDO.operatorBase64Encode(), (String)auditLogDO.getServerSign()) : HsmUtils.verifyCertByBC((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (byte[])Base64.decode((String)auditLogDO.getServerSign()), (byte[])Base64.decode((String)auditLogDO.operatorBase64Encode()));
            }
            catch (Exception e) {
                this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
            }
            if (verify) {
                return Result.success();
            }
            this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25");
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.GENERATE_CERT_IS_ERROR);
        }
    }

    private Result verifyAuditOperateSign(AuditLogDO auditLogDO) {
        String auditSn = auditLogDO.getAuditSn();
        AdminCertDO adminCertDO = this.adminCertDao.getAdminCertInfo(auditSn, 2);
        if (adminCertDO == null) {
            this.logger.error("\u83b7\u53d6\u5ba1\u8ba1\u5458\u8bc1\u4e66\u4e3a\u7a7a");
            return Result.failure((ErrorEnum)ErrorEnum.GET_AUDITOR_CERT_EMPTY);
        }
        String data = adminCertDO.getCertInfo();
        try {
            boolean verify;
            boolean verifySignedData;
            X509Certificate operatorCert = CertUtils.getCertFromStr((String)data);
            try {
                verifySignedData = SignedDataUtils.verifySignedData((String)auditLogDO.getAuditSign(), (PublicKey)operatorCert.getPublicKey());
            }
            catch (Exception e) {
                this.logger.error("\u9a8c\u8bc1\u5ba1\u8ba1\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_AUDITOR_SIGN_FAIL);
            }
            if (!verifySignedData) {
                this.logger.error("\u9a8c\u8bc1\u5ba1\u8ba1\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25");
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_AUDITOR_SIGN_FAIL);
            }
            try {
                RaCertDO raCertDO = this.raCertDao.queryRaCertDataById(auditLogDO.getServerCertId());
                X509Certificate raServerCert = CertUtils.getCertFromStr((String)raCertDO.getCertInfo());
                verify = 0 != CommonVariable.getIsHsm() ? HsmUtils.verifyCertByYunHsm((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (String)auditLogDO.operatorWithAuditInfoBase64Encode(), (String)auditLogDO.getServerSign()) : HsmUtils.verifyCertByBC((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (byte[])Base64.decode((String)auditLogDO.getServerSign()), (byte[])Base64.decode((String)auditLogDO.operatorWithAuditInfoBase64Encode()));
            }
            catch (Exception e) {
                this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
            }
            if (verify) {
                return Result.success();
            }
            this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25");
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.GENERATE_CERT_IS_ERROR);
        }
    }

    public CoreResult doArchiveOperateLog(String operatorSubject, Integer operatorType, Integer isAudit, String startTime, String endTime) {
        HashMap<String, Object> archiveMap = new HashMap<String, Object>();
        try {
            List auditLogDOS = (List)this.auditLogDao.archiveList(operatorSubject, operatorType, isAudit, startTime, endTime);
            if (null == auditLogDOS || auditLogDOS.isEmpty()) {
                this.logger.info("\u624b\u52a8\u5f52\u6863\u64cd\u4f5c\u65e5\u5fd7 \u6ca1\u6709\u53ef\u5f52\u6863\u7684\u65e5\u5fd7");
                archiveMap.put("archiveResult", AuditLogResultEnum.SUCCESS.value);
                archiveMap.put("archiveNum", 0);
                return new CoreResult(0, archiveMap);
            }
            List<ArchiveLogDO> archiveLogDOList = this.generateArchiveLogFromAuditLog(auditLogDOS);
            int archiveResult = this.archiveLogDao.saveArchiveLogList(archiveLogDOList);
            int deleteResult = this.auditLogDao.deleteAuditLogList(auditLogDOS);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u624b\u52a8\u5f52\u6863 \u5220\u9664\u4eceAUDIT_LOG\u8868 \u5f52\u6863\u5230ARCHIVE_LOG\u8868 {} \u6570\u636e", (Object)deleteResult);
            }
            ArrayList<Long> auditLogIds = new ArrayList<Long>();
            for (AuditLogDO auditLogDO : auditLogDOS) {
                auditLogIds.add(auditLogDO.getId());
            }
            int deletePeriodResult = this.periodAuditLogRelationDao.deletePeriodAuditLogRelationByAuditLogId(auditLogIds);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u624b\u52a8\u5f52\u6863 \u5220\u9664PERIOD_AUDIT_LOG_RELATION\u8868 \u5f52\u6863\u5230ARCHIVE_LOG\u8868 {} \u6570\u636e", (Object)deletePeriodResult);
            }
            if (archiveResult != 0) {
                archiveMap.put("archiveResult", AuditLogResultEnum.SUCCESS.value);
                archiveMap.put("archiveNum", archiveResult);
                return new CoreResult(0, archiveMap);
            }
            archiveMap.put("archiveResult", AuditLogResultEnum.FAIL.value);
            archiveMap.put("archiveNum", auditLogDOS.size());
            return new CoreResult(-1, archiveMap);
        }
        catch (Exception e) {
            this.logger.error("\u624b\u52a8\u5f52\u6863\u64cd\u4f5c\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, (Object)"\u624b\u52a8\u5f52\u6863\u64cd\u4f5c\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38");
        }
    }

    private List<ArchiveLogDO> generateArchiveLogFromAuditLog(List<AuditLogDO> auditLogDOS) {
        ArrayList<ArchiveLogDO> archiveLogDOList = new ArrayList<ArchiveLogDO>();
        for (AuditLogDO auditLogDO : auditLogDOS) {
            ArchiveLogDO archiveLogDO = new ArchiveLogDO();
            BeanUtils.copyProperties((Object)auditLogDO, (Object)archiveLogDO, (String[])new String[]{"id"});
            archiveLogDO.setArchiveTime(new Date());
            archiveLogDOList.add(archiveLogDO);
        }
        return archiveLogDOList;
    }

    public Boolean isAllowLogin() {
        try {
            int currentRecordNum;
            ArchiveConfigBean archiveConfigBean = CommonVariable.getArchiveConfig();
            if (null == archiveConfigBean || archiveConfigBean.getMaxAuditLogLimit() == null) {
                return true;
            }
            int maxLogLimit = archiveConfigBean.getMaxAuditLogLimit();
            if (maxLogLimit > (currentRecordNum = this.auditLogDao.getTotalRecords())) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u767b\u5f55\u8bb8\u53ef\u6216\u65e5\u5fd7\u5199\u5165\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public CoreResult getAuditMsgInfo() {
        try {
            long auditLogPeriod;
            long logPeriod;
            ArchiveConfigBean archiveConfigBean = CommonVariable.getArchiveConfig();
            if (null == archiveConfigBean || archiveConfigBean.getAuditLogPeriod() == null) {
                return new CoreResult(0, null);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            long currentTime = DateUtils.getStartTime((String)sdf.format(new Date()));
            String compareTime = sdf.format(currentTime - (logPeriod = (auditLogPeriod = (long)archiveConfigBean.getAuditLogPeriod().intValue()) * MS_PER_DAY));
            long overAudit = this.auditLogDao.getOverAuditRecordNum(compareTime);
            if (overAudit != 0L) {
                return new CoreResult(0, (Object)("\u6709" + overAudit + "\u6761\u65e5\u5fd7\u5df2\u8d85\u5ba1\u6838\u5468\u671f\uff0c\u8bf7\u53ca\u65f6\u8fdb\u884c\u5ba1\u6838"));
            }
            return new CoreResult(0, null);
        }
        catch (Exception e) {
            return new CoreResult(-1, (Object)"\u83b7\u53d6\u5ba1\u6838\u63d0\u9192\u6d88\u606f\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public CoreResult getArchiveMsgInfo() {
        try {
            ArchiveConfigBean archiveConfigBean = CommonVariable.getArchiveConfig();
            if (null == archiveConfigBean || archiveConfigBean.getMaxAuditLogLimit() == null) {
                return new CoreResult(0, null);
            }
            long maxLogLimit = archiveConfigBean.getMaxAuditLogLimit().intValue();
            long currentRecordNum = this.auditLogDao.getTotalRecords();
            if ((double)currentRecordNum >= (double)maxLogLimit * ARCHIVE_PERCENT) {
                return new CoreResult(0, (Object)"\u65e5\u5fd7\u5373\u5c06\u8fbe\u5230\u5b58\u50a8\u64cd\u4f5c\u65e5\u5fd7\u7684\u6700\u5927\u89c4\u6a21\uff0c\u8bf7\u53ca\u65f6\u8fdb\u884c\u5f52\u6863");
            }
            return new CoreResult(0, null);
        }
        catch (Exception e) {
            return new CoreResult(-1, (Object)"\u83b7\u53d6\u5f52\u6863\u63d0\u9192\u6d88\u606f\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public CoreResult doAutoArchiveOperateLog() {
        try {
            this.logger.debug("\u81ea\u52a8\u5f52\u6863\u5f00\u59cb\u300b\u300b\u300b\u300b\u300b\u300b");
            HashMap<String, Object> archiveMap = new HashMap<String, Object>();
            ArchiveConfigBean archiveConfigBean = CommonVariable.getArchiveConfig();
            if (null == archiveConfigBean || archiveConfigBean.getAutoArchiveFlag() != 1) {
                return new CoreResult(-1, (Object)"\u81ea\u52a8\u5f52\u6863\u672a\u5f00\u542f");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            long autoArchiveAgo = archiveConfigBean.getAutoArchiveAgo().intValue();
            long logArchiveAgo = autoArchiveAgo * MS_PER_DAY;
            long currentTime = DateUtils.getCurrentTimeMillis();
            String compareTime = sdf.format(currentTime - logArchiveAgo);
            List auditLogDOS = (List)this.auditLogDao.autoArchiveList(compareTime);
            if (null == auditLogDOS || auditLogDOS.isEmpty()) {
                this.logger.info("\u81ea\u52a8\u5f52\u6863\u64cd\u4f5c\u65e5\u5fd7 \u6ca1\u6709\u53ef\u5f52\u6863\u7684\u65e5\u5fd7");
                archiveMap.put("archiveResult", AuditLogResultEnum.SUCCESS.value);
                archiveMap.put("archiveNum", 0);
                return new CoreResult(0, archiveMap);
            }
            List<ArchiveLogDO> archiveLogDOList = this.generateArchiveLogFromAuditLog(auditLogDOS);
            int archiveResult = this.archiveLogDao.saveArchiveLogList(archiveLogDOList);
            if (archiveResult != 0) {
                int deleteResult = this.auditLogDao.deleteAuditLogList(auditLogDOS);
                if (deleteResult != archiveResult) {
                    return new CoreResult(-1, (Object)"\u5220\u9664\u64cd\u4f5c\u65e5\u5fd7\u8868\u6570\u636e\u5f02\u5e38");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u81ea\u52a8\u5f52\u6863 \u5220\u9664\u4eceAUDIT_LOG\u8868 \u5f52\u6863\u5230ARCHIVE_LOG\u8868 {} \u6570\u636e", (Object)deleteResult);
                }
                ArrayList<Long> auditLogIds = new ArrayList<Long>();
                for (AuditLogDO auditLogDO : auditLogDOS) {
                    auditLogIds.add(auditLogDO.getId());
                }
                int deletePeriodResult = this.periodAuditLogRelationDao.deletePeriodAuditLogRelationByAuditLogId(auditLogIds);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u81ea\u52a8\u5f52\u6863 \u5220\u9664PERIOD_AUDIT_LOG_RELATION\u8868 \u5f52\u6863\u5230ARCHIVE_LOG\u8868 {} \u6570\u636e", (Object)deletePeriodResult);
                }
                archiveMap.put("archiveResult", AuditLogResultEnum.SUCCESS.value);
                archiveMap.put("archiveNum", archiveResult);
                this.logger.debug("\u81ea\u52a8\u5f52\u6863\u7ed3\u675f\u300b\u300b\u300b\u300b\u300b\u300b");
                return new CoreResult(0, archiveMap);
            }
            archiveMap.put("archiveResult", AuditLogResultEnum.FAIL.value);
            archiveMap.put("archiveNum", auditLogDOS.size());
            this.logger.debug("\u81ea\u52a8\u5f52\u6863\u7ed3\u675f\u300b\u300b\u300b\u300b\u300b\u300b");
            return new CoreResult(-1, archiveMap);
        }
        catch (Exception e) {
            this.logger.error("\u81ea\u52a8\u5f52\u6863\u64cd\u4f5c\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, (Object)"\u81ea\u52a8\u5f52\u6863\u64cd\u4f5c\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public void doAutoArchiveOperateLogLock() {
        String lockIp = this.redisClient.get(RedisKey.LOCK_AUDIT_ARCHIVE);
        String addressIp = this.getAddressIp();
        if (StringUtils.isBlank((CharSequence)lockIp)) {
            this.redisClient.setex(RedisKey.LOCK_AUDIT_ARCHIVE, 60, addressIp);
            this.doAutoArchiveOperateLog();
        } else {
            this.logger.info("scheduler lock audit archive ip : {}", (Object)lockIp);
        }
    }

    private String getAddressIp() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u670d\u52a1\u5668IP\u5730\u5740\u5f02\u5e38");
            return null;
        }
    }

    public CoreResult getRemindMsg() {
        try {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN.code, ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN.desc));
            }
            CurrentAdminInfo currUser = (CurrentAdminInfo)operator.getCurrUser();
            List roleDOS = this.adminRoleDao.getRoleListByAdminCertId(currUser.getId().longValue());
            HashMap resultInfo = new HashMap();
            boolean isAuditor = false;
            for (RoleDO roleDO : roleDOS) {
                if (2 != roleDO.getType()) continue;
                isAuditor = true;
            }
            HashMap<String, Object> msgInfo = new HashMap<String, Object>();
            if (isAuditor) {
                CoreResult archiveMsgResult;
                CoreResult auditMsgResult = this.getAuditMsgInfo();
                if (auditMsgResult.isSuccess()) {
                    msgInfo.put("auditMsg", null);
                }
                if ((archiveMsgResult = this.getArchiveMsgInfo()).isSuccess()) {
                    msgInfo.put("archiveMsg", archiveMsgResult.getInfo());
                }
            }
            if (!msgInfo.isEmpty()) {
                resultInfo.put("msg", msgInfo);
            }
            return new CoreResult(0, resultInfo);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u63d0\u9192\u6d88\u606f\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, (Object)"\u83b7\u53d6\u63d0\u9192\u6d88\u606f\u5f02\u5e38");
        }
    }

    public CoreResult existOrNot(int id) {
        try {
            AuditLogDO auditLogDO = this.auditLogDao.get(id);
            if (null == auditLogDO) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
            }
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u64cd\u4f5c\u65e5\u5fd7\u5b9e\u4f8b\u5b58\u5728\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
        }
        return CoreResult.success();
    }
}

