/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.auditlog;

import com.xdja.pki.auditlog.dao.AuditorOperateLogDao;
import com.xdja.pki.auditlog.dao.model.AuditorOperateLogDO;
import com.xdja.pki.auditlog.service.AuditorOperateLogService;
import com.xdja.pki.auditlog.service.bean.AuditorOperateLogListVO;
import com.xdja.pki.auditlog.service.bean.AuditorOperateLogResultEnum;
import com.xdja.pki.auditlog.service.bean.AuditorOperateLogVO;
import com.xdja.pki.auditlog.service.bean.AuditorOperateTypeEnum;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.util.OperatorUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuditorOperateLogServiceImpl
implements AuditorOperateLogService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource
    private AuditorOperateLogDao auditorOperateLogDao;

    public boolean saveAuditorOperateLog(int auditType, String auditContext, int auditResult) {
        AuditorOperateLogDO auditorOperateLogDO = new AuditorOperateLogDO();
        Operator operator = OperatorUtil.getOperator();
        CurrentAdminInfo currUser = (CurrentAdminInfo)operator.getCurrUser();
        auditorOperateLogDO.setAuditSubject(currUser.getCertDn());
        auditorOperateLogDO.setAuditSn(currUser.getCertSn());
        auditorOperateLogDO.setAuditCertId(currUser.getId());
        this.logger.info("\u5b58\u5e93\u65f6\u5ba1\u8ba1\u64cd\u4f5c\u8005\u8bc1\u4e66ID{}", (Object)currUser.getCertSn());
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        String format = sdf.format(new Date());
        try {
            Date date = sdf.parse(format);
            auditorOperateLogDO.setAuditTime(date);
        }
        catch (ParseException e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return false;
        }
        auditorOperateLogDO.setAuditType(String.valueOf(auditType));
        auditorOperateLogDO.setAuditClientIp(currUser.getClientIpAddress());
        auditorOperateLogDO.setAuditContent(auditContext);
        auditorOperateLogDO.setAuditResult(Integer.valueOf(auditResult));
        AuditorOperateLogDO backAuditorOperateLogDO = this.auditorOperateLogDao.save(auditorOperateLogDO);
        return backAuditorOperateLogDO != null;
    }

    public Object listAuditorOperateLog(Integer pageNo, Integer pageSize, String auditSubject, Integer auditType, String startTime, String endTime, boolean isExport) {
        if (isExport) {
            List auditorOperateLogDOS = (List)this.auditorOperateLogDao.listAuditorOperateLog(pageNo, pageSize, auditSubject, auditType, startTime, endTime, isExport);
            return this.generateListVO(auditorOperateLogDOS);
        }
        PageInfo pageInfo = (PageInfo)this.auditorOperateLogDao.listAuditorOperateLog(pageNo, pageSize, auditSubject, auditType, startTime, endTime, isExport);
        pageInfo.setDatas(this.generateListVO((List)pageInfo.getDatas()));
        return pageInfo;
    }

    private List<AuditorOperateLogListVO> generateListVO(List<AuditorOperateLogDO> auditorOperateLogDOS) {
        ArrayList<AuditorOperateLogListVO> auditorOperateLogList = new ArrayList<AuditorOperateLogListVO>();
        for (AuditorOperateLogDO auditorOperateLogDO : auditorOperateLogDOS) {
            AuditorOperateLogListVO auditorOperateLogVO = new AuditorOperateLogListVO();
            auditorOperateLogVO.setId(auditorOperateLogDO.getId());
            auditorOperateLogVO.setAuditSubject(auditorOperateLogDO.getAuditSubject());
            auditorOperateLogVO.setAuditType(auditorOperateLogDO.getAuditType());
            auditorOperateLogVO.setAuditTypeString(AuditorOperateTypeEnum.getDescFromType((String)auditorOperateLogDO.getAuditType()));
            auditorOperateLogVO.setAuditClientIp(auditorOperateLogDO.getAuditClientIp());
            auditorOperateLogVO.setAuditTime(this.sdf.format(auditorOperateLogDO.getAuditTime()));
            auditorOperateLogVO.setAuditResult(auditorOperateLogDO.getAuditResult());
            auditorOperateLogVO.setAuditResultString(AuditorOperateLogResultEnum.getValueFromId((int)auditorOperateLogDO.getAuditResult()));
            auditorOperateLogList.add(auditorOperateLogVO);
        }
        return auditorOperateLogList;
    }

    public Object getAuditorOperateLogById(int id) {
        AuditorOperateLogDO auditorOperateLogDO = this.auditorOperateLogDao.get(id);
        AuditorOperateLogVO auditorOperateLogVO = new AuditorOperateLogVO();
        auditorOperateLogVO.setId(auditorOperateLogDO.getId());
        auditorOperateLogVO.setAuditSubject(auditorOperateLogDO.getAuditSubject());
        auditorOperateLogVO.setAuditSn(auditorOperateLogDO.getAuditSn());
        auditorOperateLogVO.setAuditCertId(auditorOperateLogDO.getAuditCertId());
        auditorOperateLogVO.setAuditType(auditorOperateLogDO.getAuditType());
        auditorOperateLogVO.setAuditTypeString(AuditorOperateTypeEnum.getDescFromType((String)auditorOperateLogDO.getAuditType()));
        auditorOperateLogVO.setAuditClientIp(auditorOperateLogDO.getAuditClientIp());
        auditorOperateLogVO.setAuditContent(auditorOperateLogDO.getAuditContent());
        auditorOperateLogVO.setAuditResult(auditorOperateLogDO.getAuditResult());
        auditorOperateLogVO.setAuditResultString(AuditorOperateLogResultEnum.getValueFromId((int)auditorOperateLogDO.getAuditResult()));
        auditorOperateLogVO.setAuditTime(this.sdf.format(auditorOperateLogDO.getAuditTime()));
        return auditorOperateLogVO;
    }
}

