/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.auditlog;

import com.xdja.pki.auditlog.dao.AuditLogDao;
import com.xdja.pki.auditlog.dao.PeriodAuditLogDao;
import com.xdja.pki.auditlog.dao.PeriodAuditLogRelationDao;
import com.xdja.pki.auditlog.dao.model.AuditLogDO;
import com.xdja.pki.auditlog.dao.model.PeriodAuditLogDO;
import com.xdja.pki.auditlog.dao.model.PeriodAuditLogRelationDO;
import com.xdja.pki.auditlog.service.PeriodAuditLogService;
import com.xdja.pki.auditlog.service.bean.AuditLogIsAuditEnum;
import com.xdja.pki.auditlog.service.bean.AuditLogIsVerifyEnum;
import com.xdja.pki.auditlog.service.bean.AuditLogListVO;
import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.PeriodAuditLogListVO;
import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.cache.RedisClient;
import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.core.bean.DatabaseTypeEnum;
import com.xdja.pki.core.bean.ErrorBean;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.core.constants.RedisKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.core.util.time.DateUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import java.net.InetAddress;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PeriodAuditLogServiceImpl
implements PeriodAuditLogService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    public AuditLogDao auditLogDao;
    @Autowired
    public PeriodAuditLogDao periodAuditLogDao;
    @Autowired
    public PeriodAuditLogRelationDao periodAuditLogRelationDao;
    @Autowired
    public AdminCertDao adminCertDao;
    @Autowired
    public RaCertDao raCertDao;
    @Autowired
    RedisClient redisClient;
    private static final String EMPTYSTR = "";
    private static final int PID = 1;

    public CoreResult saveAndSignAuditLog(Integer period) {
        List auditLogDOS;
        String startTime;
        String endTime;
        this.logger.info("\u5468\u671f\u6027\u5ba1\u8ba1\u65e5\u5fd7\u5f00\u59cb\u300b\u300b\u300b\u300b\u300b");
        String lastTime = this.periodAuditLogRelationDao.getLastPeriodAuditTime();
        this.logger.debug("\u4e0a\u6b21\u5468\u671f\u6027\u5ba1\u8ba1\u64cd\u4f5c\u65f6\u95f4\uff1a{}", (Object)lastTime);
        PeriodAuditLogDO periodAuditLogDO = new PeriodAuditLogDO();
        if (DatabaseTypeEnum.MYSQL.type == Constants.SYSTEM_DATABASE_TYPE) {
            endTime = DateUtils.getCurrDate();
            startTime = null != lastTime ? lastTime : DateUtils.longToStr((long)(DateUtils.dateTimeStrToLong((String)endTime) - 3600000L * (long)period.intValue()));
            periodAuditLogDO.setSignPeriodStart(DateUtils.strToDate((String)startTime));
            periodAuditLogDO.setSignPeriodEnd(DateUtils.strToDate((String)endTime));
            periodAuditLogDO.setOperateTime(DateUtils.strToDate((String)endTime));
            auditLogDOS = this.auditLogDao.getAuditLogListbyPeriod(startTime, endTime);
        } else if (DatabaseTypeEnum.SQLITE.type == Constants.SYSTEM_DATABASE_TYPE) {
            endTime = String.valueOf(new Date().getTime());
            startTime = null != lastTime ? lastTime : String.valueOf(Long.parseLong(endTime) - 3600000L * (long)period.intValue());
            periodAuditLogDO.setSignPeriodStart(DateUtils.longToDate((long)Long.parseLong(startTime)));
            periodAuditLogDO.setSignPeriodEnd(DateUtils.longToDate((long)Long.parseLong(endTime)));
            periodAuditLogDO.setOperateTime(DateUtils.longToDate((long)Long.parseLong(endTime)));
            auditLogDOS = this.auditLogDao.getAuditLogListbyPeriod(DateUtils.longToStr((long)Long.parseLong(startTime)), DateUtils.longToStr((long)Long.parseLong(endTime)));
        } else {
            this.logger.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
            throw new ServiceException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
        }
        try {
            RaCertDO raServerCert = this.raCertDao.getNewRaCertInfo();
            if (null == raServerCert) {
                this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4e3a\u7a7a!");
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.GET_RA_SERVER_CERT_EMPTY.code, ErrorEnum.GET_RA_SERVER_CERT_EMPTY.desc));
            }
            periodAuditLogDO.setServerCertId(raServerCert.getId());
            periodAuditLogDO.setServerSubject(raServerCert.getCertDn());
            PeriodAuditLogDO maxIdPeriodAuditLogDO = this.periodAuditLogDao.getMaxIdPeriodAuditLog();
            String periodAuditLogSign = null == maxIdPeriodAuditLogDO ? EMPTYSTR : maxIdPeriodAuditLogDO.getAuditLogSign();
            String signAlg = raServerCert.getSignAlg();
            String contentAudit = this.getDistAuditLogList(auditLogDOS, signAlg, periodAuditLogSign);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">>>>>>>>>>>>>>>> \u5ba1\u8ba1\u7b7e\u540d \u539f\u6587\uff1a{}", (Object)contentAudit);
            }
            String signAduit = null;
            signAduit = 1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? HsmUtils.signByYunHsm((String)raServerCert.getSignAlg(), (int)CommonVariable.getKeyIndex(), (String)CommonVariable.getKeyPwd(), (String)contentAudit) : HsmUtils.signByBC((String)raServerCert.getSignAlg(), (byte[])CommonVariable.getRaSignPriKey(), (String)contentAudit);
            if (StringUtils.isBlank((CharSequence)signAduit)) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.SIGN_BY_HSM_IS_ERROR.code, ErrorEnum.SIGN_BY_HSM_IS_ERROR.desc));
            }
            periodAuditLogDO.setOperateResult(Integer.valueOf(AuditLogResultEnum.SUCCESS.id));
            periodAuditLogDO.setAuditLogSign(signAduit);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">>>>>>>>>>>>>>>> \u5ba1\u8ba1\u7b7e\u540d \u7b7e\u540d\uff1a{ }", (Object)signAduit);
            }
            String contentOperate = periodAuditLogDO.operatorBase64Encode();
            String signOperate = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">>>>>>>>>>>>>>>> \u670d\u52a1\u5668\u64cd\u4f5c \u539f\u6587\uff1a{ }", (Object)contentOperate);
            }
            if (StringUtils.isBlank((CharSequence)(signOperate = 1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? HsmUtils.signByYunHsm((String)raServerCert.getSignAlg(), (int)CommonVariable.getKeyIndex(), (String)CommonVariable.getKeyPwd(), (String)contentOperate) : HsmUtils.signByBC((String)raServerCert.getSignAlg(), (byte[])CommonVariable.getRaSignPriKey(), (String)contentOperate)))) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.SIGN_BY_HSM_IS_ERROR.code, ErrorEnum.SIGN_BY_HSM_IS_ERROR.desc));
            }
            periodAuditLogDO.setServerOperatorSign(signOperate);
            periodAuditLogDO = this.periodAuditLogDao.savePeriodAuditLog(periodAuditLogDO);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">>>>>>>>>>>>>>>> \u670d\u52a1\u5668\u64cd\u4f5c \u7b7e\u540d\uff1a{ }", (Object)signOperate);
            }
            ArrayList<PeriodAuditLogRelationDO> periodAuditLogRelationDOS = new ArrayList<PeriodAuditLogRelationDO>();
            PeriodAuditLogRelationDO periodAuditLogRelationDO = null;
            for (AuditLogDO auditLogDO : auditLogDOS) {
                periodAuditLogRelationDO = new PeriodAuditLogRelationDO();
                periodAuditLogRelationDO.setPeriodLogId(periodAuditLogDO.getId());
                periodAuditLogRelationDO.setAuditLogId(auditLogDO.getId());
                periodAuditLogRelationDO.setCreateTime(new Date());
                periodAuditLogRelationDOS.add(periodAuditLogRelationDO);
            }
            this.periodAuditLogRelationDao.insertList(periodAuditLogRelationDOS);
        }
        catch (SdfSDKException | CryptoException e) {
            this.logger.error("RA\u670d\u52a1\u5668\u8bc1\u4e66\u7b7e\u540d\u5f02\u5e38!", e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.RA_SERVER_CERT_SIGN_EXCEPTION.code, ErrorEnum.RA_SERVER_CERT_SIGN_EXCEPTION.desc));
        }
        catch (Exception e) {
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.RA_SERVER_CERT_SIGN_EXCEPTION.code, ErrorEnum.RA_SERVER_CERT_SIGN_EXCEPTION.desc));
        }
        this.logger.info("\u5468\u671f\u6027\u5ba1\u8ba1\u65e5\u5fd7\u7ed3\u675f\u300b\u300b\u300b\u300b\u300b");
        return new CoreResult(0, null);
    }

    public void saveAndSignAuditLogLock(Integer period) {
        String lockIp = this.redisClient.get(RedisKey.LOCK_AUDIT_PERIOD);
        String addressIp = this.getAddressIp();
        if (StringUtils.isBlank((CharSequence)lockIp)) {
            this.redisClient.setex(RedisKey.LOCK_AUDIT_PERIOD, 60, addressIp);
            this.saveAndSignAuditLog(period);
            String nextAuditTime = this.redisClient.get(RedisKey.TIME_AUDIT_PERIOD);
            String nextTime = String.valueOf(Long.parseLong(nextAuditTime) + 3600000L * (long)period.intValue());
            this.redisClient.set(RedisKey.TIME_AUDIT_PERIOD, nextTime);
        } else {
            this.logger.info("scheduler lock audit period ip : {}", (Object)lockIp);
        }
    }

    private String getAddressIp() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u670d\u52a1\u5668IP\u5730\u5740\u5f02\u5e38");
            return null;
        }
    }

    private String getDistAuditLogList(List<AuditLogDO> auditLogDOS, String signAlgName, String periodAuditLogSign) throws Exception {
        String digestName = null;
        digestName = signAlgName.equalsIgnoreCase("SHA256withRSA") || signAlgName.equalsIgnoreCase("SHA256withECDSA") ? "SHA256" : (signAlgName.equalsIgnoreCase("SM3withSM2") ? "SM2" : "SHA1");
        StringBuffer sbDigest = new StringBuffer();
        String auditLogStr = null;
        for (AuditLogDO auditLogDO : auditLogDOS) {
            auditLogStr = 1 == CommonVariable.getIsHsm() ? (digestName.equalsIgnoreCase("SHA256") ? GMSSLSHA256DigestUtils.digestByYunHsm((String)auditLogDO.operatorBase64Encode()) : (digestName.equalsIgnoreCase("SM2") ? GMSSLSM3DigestUtils.digestByYunhsm((String)auditLogDO.operatorBase64Encode()) : GMSSLSHA1DigestUtils.digestByYunHsm((String)auditLogDO.operatorBase64Encode()))) : (digestName.equalsIgnoreCase("SHA256") ? GMSSLSHA256DigestUtils.digestByBC((String)auditLogDO.operatorBase64Encode()) : (digestName.equalsIgnoreCase("SM2") ? GMSSLSM3DigestUtils.digestByBC((String)auditLogDO.operatorBase64Encode()) : GMSSLSHA1DigestUtils.digestByBC((String)auditLogDO.operatorBase64Encode())));
            sbDigest.append(auditLogStr);
        }
        sbDigest.append(GMSSLByteArrayUtils.base64Encode((byte[])periodAuditLogSign.getBytes()));
        if (1 == CommonVariable.getIsHsm()) {
            if (digestName.equalsIgnoreCase("SHA256")) {
                return GMSSLSHA256DigestUtils.digestByYunHsm((String)GMSSLByteArrayUtils.base64Encode((byte[])sbDigest.toString().getBytes()));
            }
            if (digestName.equalsIgnoreCase("SM2")) {
                return GMSSLSM3DigestUtils.digestByYunhsm((String)GMSSLByteArrayUtils.base64Encode((byte[])sbDigest.toString().getBytes()));
            }
            return GMSSLSHA1DigestUtils.digestByYunHsm((String)GMSSLByteArrayUtils.base64Encode((byte[])sbDigest.toString().getBytes()));
        }
        if (digestName.equalsIgnoreCase("SHA256")) {
            return GMSSLSHA256DigestUtils.digestByBC((String)GMSSLByteArrayUtils.base64Encode((byte[])sbDigest.toString().getBytes()));
        }
        if (digestName.equalsIgnoreCase("SM2")) {
            return GMSSLSM3DigestUtils.digestByBC((String)GMSSLByteArrayUtils.base64Encode((byte[])sbDigest.toString().getBytes()));
        }
        return GMSSLSHA1DigestUtils.digestByBC((String)GMSSLByteArrayUtils.base64Encode((byte[])sbDigest.toString().getBytes()));
    }

    public CoreResult getPeriodAuditLogList(Integer pageNo, Integer pageSize, String startTime, String endTime) {
        if (pageNo == 0 && pageSize == 0) {
            List doList = (List)this.periodAuditLogDao.getPeriodAuditLogList(pageNo, pageSize, startTime, endTime);
            return new CoreResult(0, this.setDataList(doList));
        }
        PageInfo list = (PageInfo)this.periodAuditLogDao.getPeriodAuditLogList(pageNo, pageSize, startTime, endTime);
        list.setDatas(this.setDataList((List)list.getDatas()));
        return new CoreResult(0, (Object)list);
    }

    private List<PeriodAuditLogListVO> setDataList(List<PeriodAuditLogDO> periodAuditLogList) {
        ArrayList<PeriodAuditLogListVO> infos = new ArrayList<PeriodAuditLogListVO>();
        Iterator<PeriodAuditLogDO> iterator = periodAuditLogList.iterator();
        while (iterator.hasNext()) {
            PeriodAuditLogDO obj;
            PeriodAuditLogDO logDo = obj = iterator.next();
            PeriodAuditLogListVO logVo = new PeriodAuditLogListVO();
            logVo.setId(logDo.getId());
            logVo.setOperateResult(logDo.getOperateResult());
            logVo.setOperateResultString(AuditLogResultEnum.getValueFromId((int)logDo.getOperateResult()));
            logVo.setOperateTime(logDo.getOperateTime());
            logVo.setServerSubject(logDo.getServerSubject());
            logVo.setSignPeriodStart(logDo.getSignPeriodStart());
            logVo.setSignPeriodEnd(logDo.getSignPeriodEnd());
            infos.add(logVo);
        }
        return infos;
    }

    public CoreResult getAuditLogList(long periodLogId, Integer pageNo, Integer pageSize) {
        PageInfo relationPageInfo = this.periodAuditLogRelationDao.getPageInfoByPeriodId(periodLogId, pageNo, pageSize);
        ArrayList<Long> auditLogIds = new ArrayList<Long>();
        List periodAuditLogRelationDOS = (List)relationPageInfo.getDatas();
        for (PeriodAuditLogRelationDO periodAuditLogRelationDO : periodAuditLogRelationDOS) {
            auditLogIds.add(periodAuditLogRelationDO.getAuditLogId());
        }
        if (auditLogIds.isEmpty()) {
            return new CoreResult(0, null);
        }
        List auditLogDOS = this.periodAuditLogDao.getAuditLogByPeriodId(auditLogIds);
        PageInfo pageInfo = new PageInfo(pageNo.intValue(), pageSize.intValue());
        pageInfo.setDatas(this.setAuditDataList(auditLogDOS));
        pageInfo.setRecordCount(relationPageInfo.getRecordCount());
        return new CoreResult(0, (Object)pageInfo);
    }

    private List<AuditLogListVO> setAuditDataList(List<AuditLogDO> list) {
        ArrayList<AuditLogListVO> infos = new ArrayList<AuditLogListVO>();
        Iterator<AuditLogDO> iterator = list.iterator();
        while (iterator.hasNext()) {
            AuditLogDO obj;
            AuditLogDO logDo = obj = iterator.next();
            AuditLogListVO logVo = new AuditLogListVO();
            logVo.setId(logDo.getId());
            logVo.setOperatorSubject(logDo.getOperatorSubject());
            logVo.setOperatorType(logDo.getOperatorType());
            logVo.setOperatorTypeString(AuditLogOperatorTypeEnum.getDescFromType((String)logDo.getOperatorType()));
            logVo.setOperateClientIp(logDo.getOperateClientIp());
            logVo.setOperateResult(logDo.getOperateResult());
            logVo.setOperateResultString(AuditLogResultEnum.getValueFromId((int)logDo.getOperateResult()));
            logVo.setIsAudit(logDo.getIsAudit());
            logVo.setIsAuditString(AuditLogIsAuditEnum.getValueFromId((int)logDo.getIsAudit()));
            Result result = logDo.getIsAudit() == 1 ? this.verifyOperateSign(logDo) : this.verifyAuditOperateSign(logDo);
            if (result.isSuccess()) {
                logVo.setIsVerify(Integer.valueOf(AuditLogIsVerifyEnum.TRUE.id));
                logVo.setIsVerifyString(AuditLogIsVerifyEnum.getValueFromId((int)AuditLogIsVerifyEnum.TRUE.id));
            } else {
                logVo.setIsVerify(Integer.valueOf(AuditLogIsVerifyEnum.FALSE.id));
                logVo.setIsVerifyString(AuditLogIsVerifyEnum.getValueFromId((int)AuditLogIsVerifyEnum.FALSE.id));
            }
            logVo.setOperateTime(logDo.getOperateTime());
            infos.add(logVo);
        }
        return infos;
    }

    private Result verifyOperateSign(AuditLogDO auditLogDO) {
        String operatorSn = auditLogDO.getOperatorSn();
        AdminCertDO adminCertDO = this.adminCertDao.getAdminCertInfo(operatorSn, 2);
        if (null == adminCertDO) {
            this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u5458\u8bc1\u4e66\u4e3a\u7a7a");
            return Result.failure((ErrorEnum)ErrorEnum.GET_OPERATOR_CERT_EMPTY);
        }
        String data = adminCertDO.getCertInfo();
        try {
            boolean verify;
            boolean verifySignedData;
            X509Certificate operatorCert = CertUtils.getCertFromStr((String)data);
            try {
                verifySignedData = SignedDataUtils.verifySignedData((String)auditLogDO.getOperateSign(), (PublicKey)operatorCert.getPublicKey());
            }
            catch (Exception e) {
                this.logger.error("\u9a8c\u8bc1\u7ba1\u7406\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL);
            }
            if (!verifySignedData) {
                this.logger.error("\u9a8c\u8bc1\u7ba1\u7406\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25");
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL);
            }
            try {
                RaCertDO raCertDO = this.raCertDao.queryRaCertDataById(auditLogDO.getServerCertId());
                X509Certificate raServerCert = CertUtils.getCertFromStr((String)raCertDO.getCertInfo());
                verify = 0 != CommonVariable.getIsHsm() ? HsmUtils.verifyCertByYunHsm((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (String)auditLogDO.operatorBase64Encode(), (String)auditLogDO.getServerSign()) : HsmUtils.verifyCertByBC((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (byte[])Base64.decode((String)auditLogDO.getServerSign()), (byte[])Base64.decode((String)auditLogDO.operatorBase64Encode()));
            }
            catch (Exception e) {
                this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
            }
            if (verify) {
                return Result.success();
            }
            this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25");
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.GENERATE_CERT_IS_ERROR);
        }
    }

    private Result verifyAuditOperateSign(AuditLogDO auditLogDO) {
        String auditSn = auditLogDO.getAuditSn();
        AdminCertDO adminCertDO = this.adminCertDao.getAdminCertInfo(auditSn, 2);
        if (null == adminCertDO) {
            this.logger.error("\u83b7\u53d6\u5ba1\u8ba1\u5458\u8bc1\u4e66\u4e3a\u7a7a");
            return Result.failure((ErrorEnum)ErrorEnum.GET_AUDITOR_CERT_EMPTY);
        }
        String data = adminCertDO.getCertInfo();
        try {
            boolean verify;
            boolean verifySignedData;
            X509Certificate operatorCert = CertUtils.getCertFromStr((String)data);
            try {
                verifySignedData = SignedDataUtils.verifySignedData((String)auditLogDO.getAuditSign(), (PublicKey)operatorCert.getPublicKey());
            }
            catch (Exception e) {
                this.logger.error("\u9a8c\u8bc1\u5ba1\u8ba1\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_AUDITOR_SIGN_FAIL);
            }
            if (!verifySignedData) {
                this.logger.error("\u9a8c\u8bc1\u5ba1\u8ba1\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25");
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_AUDITOR_SIGN_FAIL);
            }
            try {
                RaCertDO raCertDO = this.raCertDao.queryRaCertDataById(auditLogDO.getServerCertId());
                X509Certificate raServerCert = CertUtils.getCertFromStr((String)raCertDO.getCertInfo());
                verify = 0 != CommonVariable.getIsHsm() ? HsmUtils.verifyCertByYunHsm((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (String)auditLogDO.operatorWithAuditInfoBase64Encode(), (String)auditLogDO.getServerSign()) : HsmUtils.verifyCertByBC((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (byte[])Base64.decode((String)auditLogDO.getServerSign()), (byte[])Base64.decode((String)auditLogDO.operatorWithAuditInfoBase64Encode()));
            }
            catch (Exception e) {
                this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
            }
            if (verify) {
                return Result.success();
            }
            this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25");
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.GENERATE_CERT_IS_ERROR);
        }
    }

    public CoreResult verify(int id) {
        PeriodAuditLogDO periodAuditLogDO;
        try {
            periodAuditLogDO = this.periodAuditLogDao.getPeriodAuditLogById((long)id);
            if (null == periodAuditLogDO) {
                return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u5b9e\u4f8b\u5f02\u5e38", (Throwable)e);
            return new CoreResult(-1, null, new ErrorBean(ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.code, ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED.desc));
        }
        Result result = this.verifyPeriodAuditLogSign(periodAuditLogDO);
        ErrorEnum errorEnum = result.getError();
        ErrorBean errorBean = new ErrorBean();
        if (null != errorEnum) {
            errorBean = new ErrorBean(errorEnum.code, errorEnum.desc);
        }
        return new CoreResult(result.getCode(), result.getInfo(), errorBean);
    }

    private Result verifyPeriodAuditLogSign(PeriodAuditLogDO periodAuditLogDO) {
        List auditLogIds = this.periodAuditLogRelationDao.getAuditLogIdByPeriodId(periodAuditLogDO.getId().longValue());
        if (null == auditLogIds) {
            return Result.failure((ErrorEnum)ErrorEnum.LOG_NOT_EXIST_OR_ARCHIVED);
        }
        List auditLogDOS = this.periodAuditLogDao.getAuditLogByPeriodId(auditLogIds);
        try {
            boolean verifyOperate;
            boolean verifyAudit;
            try {
                RaCertDO raCertDO = this.raCertDao.queryRaCertDataById(periodAuditLogDO.getServerCertId());
                X509Certificate raServerCert = CertUtils.getCertFromStr((String)raCertDO.getCertInfo());
                Long periodId = periodAuditLogDO.getId();
                PeriodAuditLogDO lastPeriodAuditLogDO = this.periodAuditLogDao.getPeriodAuditLogById(periodId - 1L);
                String auditLogSign = 1L == periodId ? EMPTYSTR : lastPeriodAuditLogDO.getAuditLogSign();
                String signAlgName = raServerCert.getSigAlgName();
                String sourceStr = this.getDistAuditLogList(auditLogDOS, signAlgName, auditLogSign);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(">>>>>>>>>>>>>>>>>>>> \u5ba1\u8ba1\u9a8c\u7b7e \u539f\u6587\uff1a{ }", (Object)sourceStr);
                    this.logger.debug(">>>>>>>>>>>>>>>>>>>> \u5ba1\u8ba1\u9a8c\u7b7e \u7b7e\u540d\uff1a{ }", (Object)periodAuditLogDO.getAuditLogSign());
                }
                if (!(verifyAudit = 0 != CommonVariable.getIsHsm() ? HsmUtils.verifyCertByYunHsm((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (String)sourceStr, (String)periodAuditLogDO.getAuditLogSign()) : HsmUtils.verifyCertByBC((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (byte[])Base64.decode((String)periodAuditLogDO.getAuditLogSign()), (byte[])Base64.decode((String)sourceStr)))) {
                    this.logger.error("\u5b58\u5728\u65e5\u5fd7\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u4e00\u81f4");
                    return Result.failure((ErrorEnum)ErrorEnum.AUDIT_LOG_EXIST_VERIFY_FAILURE);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(">>>>>>>>>>>>>>>>>>>> \u670d\u52a1\u5668\u64cd\u4f5c\u9a8c\u7b7e \u539f\u6587\uff1a{ }", (Object)periodAuditLogDO.operatorBase64Encode());
                    this.logger.debug(">>>>>>>>>>>>>>>>>>>> \u670d\u52a1\u5668\u64cd\u4f5c\u9a8c\u7b7e \u7b7e\u540d\uff1a{ }", (Object)periodAuditLogDO.getServerOperatorSign());
                }
                if (!(verifyOperate = 0 != CommonVariable.getIsHsm() ? HsmUtils.verifyCertByYunHsm((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (String)periodAuditLogDO.operatorBase64Encode(), (String)periodAuditLogDO.getServerOperatorSign()) : HsmUtils.verifyCertByBC((String)raServerCert.getSigAlgName(), (PublicKey)raServerCert.getPublicKey(), (byte[])Base64.decode((String)periodAuditLogDO.getServerOperatorSign()), (byte[])Base64.decode((String)periodAuditLogDO.operatorBase64Encode())))) {
                    this.logger.error("\u672c\u6761\u5ba1\u8ba1\u8bb0\u5f55\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u4e00\u81f4");
                    return Result.failure((ErrorEnum)ErrorEnum.CURRENT_PERIOD_AUDIT_LOG_VERIFY_FAILURE);
                }
            }
            catch (Exception e) {
                this.logger.error("\u670d\u52a1\u5668\u7b7e\u540d\u503c\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
            }
            if (verifyAudit && verifyOperate) {
                return Result.success();
            }
            this.logger.error("\u65e5\u5fd7\u548c\u5ba1\u8ba1\u8bb0\u5f55\u7b7e\u540d\u9a8c\u8bc1\u90fd\u4e0d\u4e00\u81f4");
            return Result.failure((ErrorEnum)ErrorEnum.VERIFY_SERVER_CERT_SIGN_FAIL);
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.GENERATE_CERT_IS_ERROR);
        }
    }
}

