/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.auth;

import com.xdja.pki.auth.service.AuditSignService;
import com.xdja.pki.auth.service.bean.CertInfoDTO;
import com.xdja.pki.ra.core.asn1.DigestObjectIdentifiers;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.commonenum.KeyAlgEnum;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuditSignServiceImpl
implements AuditSignService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${client.offset.time}")
    private int offsetTime;
    @Autowired
    AdminCertDao adminCertDao;
    @Autowired
    CaBusinessManager caBusinessManager;

    public int getOffsetTime() {
        return this.offsetTime;
    }

    public boolean verifySign(int keyAlg, int digestAlg, PublicKey publicKey, byte[] sourceData, byte[] signData) {
        boolean verifyResult = false;
        this.logger.info("keyAlg:" + keyAlg + " digestAlg:" + digestAlg);
        try {
            verifyResult = 0 != CommonVariable.getIsHsm() ? HsmUtils.verifyByYunHsmWithAlgId((int)digestAlg, (int)keyAlg, (PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : HsmUtils.verifyByBCWithAlgId((int)digestAlg, (int)keyAlg, (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        }
        catch (Exception e) {
            this.logger.error(" =================== \u52a0\u5bc6\u673a\u9a8c\u7b7e\u5f02\u5e38{}", (Throwable)e);
        }
        if (!verifyResult) {
            this.logger.info(" =================== \u52a0\u5bc6\u673a\u9a8c\u7b7e\u5931\u8d25");
        }
        this.logger.info("=========================== " + verifyResult);
        return verifyResult;
    }

    public int getSystemKeyAlg() {
        String keyAlgName = CommonVariable.getKeyAlgName();
        if (keyAlgName.equalsIgnoreCase(KeyAlgEnum.RSA.desc)) {
            return KeyAlgEnum.RSA.value;
        }
        if (keyAlgName.equalsIgnoreCase(KeyAlgEnum.SM2.desc)) {
            return KeyAlgEnum.SM2.value;
        }
        if (keyAlgName.equalsIgnoreCase(KeyAlgEnum.NISTP256.desc)) {
            return KeyAlgEnum.NISTP256.value;
        }
        return 0;
    }

    public CertInfoDTO getCertBySn(String s, int i) {
        this.logger.info("\u5f53\u524d\u64cd\u4f5c\u7684\u7ba1\u7406\u5458sn\u4e3a:" + s);
        AdminCertDO adminCertInfo = this.adminCertDao.getAdminCertInfo(s, 2);
        if (adminCertInfo == null) {
            Result result;
            this.logger.info("\u672c\u5730\u65e0\u8be5sn\uff1a{}\u5bf9\u5e94\u7684\u8bc1\u4e66\u4fe1\u606f\uff0c\u5148\u8bf7\u6c42CA\u8fdb\u884c\u9a8c\u8bc1\uff01", (Object)s);
            try {
                result = this.caBusinessManager.raAdminLoginAuthen(s);
            }
            catch (Exception e) {
                this.logger.error("\u5f85CA\u8ba4\u8bc1\u7ba1\u7406\u5458\u63a5\u53e3\u5f02\u5e38{}", (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
            Map caAuthenMap = (Map)result.getInfo();
            if (CollectionUtils.isEmpty((Map)caAuthenMap)) {
                return null;
            }
            String signCertData = (String)caAuthenMap.get("signCertData");
            X509Certificate signCert = CertUtils.getCertFromStr((String)signCertData);
            int signCertStatus = (Integer)caAuthenMap.get("signCertStatus");
            CertInfoDTO certInfo = new CertInfoDTO();
            certInfo.setSn(signCert.getSerialNumber().toString(16));
            certInfo.setKeyAlg("RSA".equalsIgnoreCase(signCert.getPublicKey().getAlgorithm()) ? 1 : 2);
            certInfo.setSubject(CertUtils.getSubjectByX509Cert((X509Certificate)signCert));
            certInfo.setStatus(signCertStatus);
            certInfo.setData(signCertData);
            certInfo.setPublicKey(signCert.getPublicKey());
            return certInfo;
        }
        CertInfoDTO certInfo = new CertInfoDTO();
        certInfo.setSn(adminCertInfo.getCertSn());
        certInfo.setKeyAlg("RSA".equalsIgnoreCase(adminCertInfo.getPublicKeyAlg()) ? 1 : 2);
        certInfo.setSubject(adminCertInfo.getCertDn());
        certInfo.setStatus(adminCertInfo.getCertStatus().intValue());
        certInfo.setData(adminCertInfo.getCertInfo());
        X509Certificate signCert = CertUtils.getCertFromStr((String)adminCertInfo.getCertInfo());
        certInfo.setPublicKey(signCert.getPublicKey());
        return certInfo;
    }

    public byte[] getDigest(byte[] bytes) {
        byte[] digest = null;
        try {
            digest = 0 != CommonVariable.getIsHsm() ? ("SHA256withECDSA".equalsIgnoreCase(CommonVariable.getSigAlgName()) || "SHA256withRSA".equalsIgnoreCase(CommonVariable.getSigAlgName()) ? HsmUtils.digestByYunHsmWithOid((String)DigestObjectIdentifiers.id_sha256.getId(), (byte[])bytes) : ("SM3withSM2".equalsIgnoreCase(CommonVariable.getSigAlgName()) ? HsmUtils.digestByYunHsmWithOid((String)DigestObjectIdentifiers.sm3.getId(), (byte[])bytes) : HsmUtils.digestByYunHsmWithOid((String)DigestObjectIdentifiers.id_sha1.getId(), (byte[])bytes))) : ("SHA256withECDSA".equalsIgnoreCase(CommonVariable.getSigAlgName()) || "SHA256withRSA".equalsIgnoreCase(CommonVariable.getSigAlgName()) ? HsmUtils.digestByBCWithOid((String)DigestObjectIdentifiers.id_sha256.getId(), (byte[])bytes) : ("SM3withSM2".equalsIgnoreCase(CommonVariable.getSigAlgName()) ? HsmUtils.digestByBCWithOid((String)DigestObjectIdentifiers.sm3.getId(), (byte[])bytes) : HsmUtils.digestByBCWithOid((String)DigestObjectIdentifiers.id_sha1.getId(), (byte[])bytes)));
        }
        catch (Exception e) {
            this.logger.error(" =================== \u52a0\u5bc6\u673a\u83b7\u53d6\u6458\u8981\u5f02\u5e38{}", (Throwable)e);
        }
        return digest;
    }

    public Object getIllegalParamError(HttpServletResponse httpServletResponse) {
        return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(httpServletResponse);
    }

    public Object getVerifyTimeError(HttpServletResponse httpServletResponse) {
        return ErrorEnum.CLIENT_TIME_AND_SERVER_DISACCORD.resp(httpServletResponse);
    }

    public Object getContentDisaccordError(HttpServletResponse httpServletResponse) {
        return ErrorEnum.REQUEST_BODY_AND_SIGN_BODY_DISACCORD.resp(httpServletResponse);
    }

    public Object getIllegalSignAlgError(HttpServletResponse httpServletResponse) {
        return ErrorEnum.NOT_SUPPORTED_SIGN_ALG.resp(httpServletResponse);
    }

    public Object getCertNotExistError(HttpServletResponse httpServletResponse) {
        return ErrorEnum.ADMIN_CERT_NOT_EXIST.resp(httpServletResponse);
    }

    public Object getCertStatusError(int i, HttpServletResponse httpServletResponse) {
        return ErrorEnum.ADMIN_CERT_STATUS_IS_NOT_NORMAL.resp(httpServletResponse);
    }

    public Object getVerifySignFailError(HttpServletResponse httpServletResponse) {
        return ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL.resp(httpServletResponse);
    }

    public Object getServerInternalError(HttpServletResponse httpServletResponse) {
        return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(httpServletResponse);
    }
}

