/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.baseuser;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.DeviceUserDao;
import com.xdja.pki.ra.manager.dao.OrganUserDao;
import com.xdja.pki.ra.manager.dao.PersonUserDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dto.DeviceUserDetailsDTO;
import com.xdja.pki.ra.manager.dto.OrganUserInfoDTO;
import com.xdja.pki.ra.manager.dto.PersonUserDTO;
import com.xdja.pki.ra.manager.dto.SystemInfo;
import com.xdja.pki.ra.manager.dto.UserInfoDTO;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.baseuser.bean.DeviceUser;
import com.xdja.pki.ra.service.manager.baseuser.bean.EncryptUserInfo;
import com.xdja.pki.ra.service.manager.baseuser.bean.OrganUser;
import com.xdja.pki.ra.service.manager.baseuser.bean.PersonUser;
import com.xdja.pki.ra.service.manager.baseuser.bean.UserInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.deviceuser.DeviceUserService;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserInfo;
import com.xdja.pki.ra.service.manager.organuser.OrganUserService;
import com.xdja.pki.ra.service.manager.personuser.PersonUserService;
import com.xdja.pki.ra.service.manager.personuser.bean.PersonUserInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BaseUserServiceImpl
implements BaseUserService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    CertApplyDao certApplyDao;
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    PersonUserService personUserService;
    @Autowired
    OrganUserService organUserService;
    @Autowired
    DeviceUserService deviceUserService;
    @Autowired
    DeviceUserDao deviceUserDao;
    @Autowired
    OrganUserDao organUserDao;
    @Autowired
    PersonUserDao personUserDao;
    @Autowired
    UserCertDao userCertDao;

    public Result getAllSystemName() {
        ArrayList<SystemInfo> systemNames;
        Result result = new Result();
        try {
            systemNames = this.baseUserDao.getAllSystemName();
        }
        catch (DataAccessException e) {
            systemNames = new ArrayList<SystemInfo>();
        }
        SystemInfo systemInfo = new SystemInfo("V2X", "V2X");
        systemNames.add(systemInfo);
        result.setInfo(systemNames);
        return result;
    }

    public Result getBaseUser(Long baseId) {
        BaseUserDO baseUserDO;
        Result result = new Result();
        try {
            baseUserDO = this.baseUserDao.getBaseUserInfo(baseId.longValue());
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u5f02\u5e38");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (null == baseUserDO) {
            this.logger.error("\u83b7\u53d6base_user\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }
        result.setInfo((Object)baseUserDO);
        return result;
    }

    @Transactional
    public Result updateUserStatus(Integer userId, int status, boolean isOnline, String systemFlag) {
        try {
            Result result = new Result();
            this.baseUserDao.updateUserStatus(userId, status);
            List unEndCertApplyList = this.certApplyDao.getUnEndCertApplyByUserId((long)userId.intValue());
            if (!CollectionUtils.isEmpty((Collection)unEndCertApplyList)) {
                for (CertApplyDO certApplyDO : unEndCertApplyList) {
                    this.certApplyService.insertCertApplyRecord(certApplyDO.getApplyType().intValue(), 5, certApplyDO.getApplyNo(), systemFlag, 4, "\u7528\u6237\u88ab\u505c\u7528", 7, false, isOnline);
                }
            }
            this.certApplyDao.updateCertStatusByUserId((long)userId.intValue(), 4);
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0\u7528\u6237\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    public Result updateUserStatus(Integer userType, Integer identType, String licenseNumber, Integer status, String systemFlag) {
        int count = this.queryUserExist(identType, licenseNumber, userType, systemFlag);
        if (count == 0) {
            this.logger.error("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff1auserType:[{}],identType:[{}],licenseNumber:[{}],systemFlag:[{}]", new Object[]{userType, identType, licenseNumber, systemFlag});
            return Result.failure((ErrorEnum)ErrorEnum.GET_PERSON_USER_INFO_IS_EMPTY);
        }
        long userId = this.queryUserId(userType, systemFlag, identType, licenseNumber);
        Result result = this.updateUserStatus((int)userId, status, true, systemFlag);
        return result;
    }

    public int queryUserExist(Integer licenseType, String licenseNumber, Integer userType, String systemFlag) {
        try {
            licenseNumber = EncryptUserInfo.getEncryptString((String)licenseNumber);
            return this.baseUserDao.queryUser(licenseType, licenseNumber, userType, systemFlag);
        }
        catch (Exception e) {
            throw new ServiceException("\u7528\u6237\u5df2\u5b58\u5728\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result userRegister(Integer userType, UserInfo userInfo, String systemFlag) {
        try {
            Result result;
            if (userType == UserTypeEnum.PERSON_USER.id) {
                PersonUserDTO personUserDTO = new PersonUserDTO();
                BeanUtils.copyProperties((Object)userInfo.getPersonUser(), (Object)personUserDTO);
                personUserDTO.setSystemFlag(systemFlag);
                result = this.personUserService.savePersonUser(personUserDTO);
            } else if (userType == UserTypeEnum.ORGAN_USER.id) {
                OrganUserInfoDTO organUserDTO = new OrganUserInfoDTO();
                OrganUser organUser = userInfo.getOrganUser();
                PersonUser personInfo = organUser.getUserInfo();
                UserInfoDTO userInfoDTO = new UserInfoDTO();
                BeanUtils.copyProperties((Object)organUser, (Object)organUserDTO);
                if (null != personInfo) {
                    BeanUtils.copyProperties((Object)personInfo, (Object)userInfoDTO);
                }
                organUserDTO.setSystemFlag(systemFlag);
                result = this.organUserService.saveOrganUser(userInfoDTO, organUserDTO);
            } else {
                com.xdja.pki.ra.service.manager.deviceuser.bean.UserInfo userInfoDTO = new com.xdja.pki.ra.service.manager.deviceuser.bean.UserInfo();
                DeviceUserInfo deviceUserInfo = new DeviceUserInfo();
                DeviceUser deviceUser = userInfo.getDeviceUser();
                PersonUser personInfo = deviceUser.getUserInfo();
                BeanUtils.copyProperties((Object)deviceUser, (Object)deviceUserInfo);
                if (null != personInfo) {
                    BeanUtils.copyProperties((Object)personInfo, (Object)userInfoDTO);
                }
                deviceUserInfo.setSystemFlag(systemFlag);
                result = this.deviceUserService.registerDeviceUser(deviceUserInfo, userInfoDTO, false);
            }
            return result;
        }
        catch (BeansException e) {
            throw new ServiceException("open-handler \u7528\u6237\u6ce8\u518c\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result userQuery(Integer userType, Integer identType, String licenseNumber, String systemFlag) {
        try {
            Result result;
            UserInfo userInfo = new UserInfo();
            if (userType == UserTypeEnum.PERSON_USER.id) {
                result = this.personUserService.getPersonUserDetailsByLicenseTypeAndLicenseNumber(identType, licenseNumber, systemFlag);
                if (!result.isSuccess()) {
                    return result;
                }
                PersonUserDTO personUserDTO = (PersonUserDTO)result.getInfo();
                PersonUser personUser = new PersonUser();
                BeanUtils.copyProperties((Object)personUserDTO, (Object)personUser);
                personUser = DecryptUserInfo.getDecryptPersonUser((PersonUser)personUser);
                userInfo.setPersonUser(personUser);
            } else if (userType == UserTypeEnum.ORGAN_USER.id) {
                result = this.organUserService.getOrganUser(identType, licenseNumber, systemFlag);
                if (!result.isSuccess()) {
                    return result;
                }
                Map map = (Map)result.getInfo();
                PersonUser personInfo = new PersonUser();
                OrganUser organUser = new OrganUser();
                BeanUtils.copyProperties(map.get("userInfo"), (Object)personInfo);
                BeanUtils.copyProperties(map.get("organUserInfo"), (Object)organUser);
                if (null == personInfo.getLicenseType()) {
                    personInfo = null;
                }
                personInfo = DecryptUserInfo.getDecryptPersonUser((PersonUser)personInfo);
                organUser = DecryptUserInfo.getDecryptOrganUser((OrganUser)organUser);
                organUser.setUserInfo(personInfo);
                userInfo.setOrganUser(organUser);
            } else {
                result = this.deviceUserService.getDevice(identType, licenseNumber, systemFlag);
                if (!result.isSuccess()) {
                    return result;
                }
                PersonUser personInfo = new PersonUser();
                Map map = (Map)result.getInfo();
                DeviceUser deviceUser = new DeviceUser();
                DeviceUserDetailsDTO deviceUserDetailsDTO = (DeviceUserDetailsDTO)map.get("deviceUser");
                BeanUtils.copyProperties((Object)deviceUserDetailsDTO, (Object)deviceUser);
                deviceUser.setUserName(deviceUserDetailsDTO.getDeviceName());
                deviceUser.setLicenseNumber(deviceUserDetailsDTO.getLicenseNumber());
                BeanUtils.copyProperties(map.get("userInfo"), (Object)personInfo);
                if (personInfo.getLicenseType() == 0) {
                    personInfo = null;
                }
                personInfo = DecryptUserInfo.getDecryptPersonUser((PersonUser)personInfo);
                deviceUser = DecryptUserInfo.getDecryptDeviceUser((DeviceUser)deviceUser);
                deviceUser.setUserInfo(personInfo);
                userInfo.setDeviceUser(deviceUser);
            }
            result.setInfo((Object)userInfo);
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("open-handler \u7528\u6237\u67e5\u8be2", (Throwable)e);
        }
    }

    public Result userQuery(String sn, String systemFlag) {
        Result result = new Result();
        BaseUserDO baseUserDO = null;
        Long id = this.userCertDao.getUserId(sn);
        if (null != id) {
            baseUserDO = this.baseUserDao.getBaseUserInfo(id.longValue(), systemFlag);
        }
        if (null == baseUserDO || null == id) {
            this.logger.error("\u6839\u636e\u7b7e\u540d\u8bc1\u4e66sn\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u7528\u6237\u4e0d\u5b58\u5728");
            result.setError(ErrorEnum.THE_USER_IS_NOT_EXIT);
            return result;
        }
        String licenseNumberDecrypt = null;
        try {
            licenseNumberDecrypt = DecryptUserInfo.getDecryptString((String)baseUserDO.getLicenseNumber());
        }
        catch (Exception e) {
            throw new ServiceException("open-handler \u7528\u6237\u67e5\u8be2", (Throwable)e);
        }
        return this.userQuery(baseUserDO.getUserType(), baseUserDO.getLicenseType(), licenseNumberDecrypt, systemFlag);
    }

    public Long queryUserId(int userType, String systemFlag, Integer licenseType, String licenseNumber) {
        try {
            licenseNumber = EncryptUserInfo.getEncryptString((String)licenseNumber);
            return this.baseUserDao.getUserId(userType, systemFlag, licenseType, licenseNumber);
        }
        catch (Exception e) {
            throw new ServiceException("\u67e5\u8be2\u7528\u6237ID\u5931\u8d25", (Throwable)e);
        }
    }

    public Result userUpdate(Integer userType, Integer identType, String licenseNumber, UserInfo userInfo, String systemFlag) {
        try {
            Result result;
            if (userType == UserTypeEnum.PERSON_USER.id) {
                Long userId = this.queryUserId(UserTypeEnum.PERSON_USER.id, systemFlag, identType, licenseNumber);
                if (null == userId) {
                    return Result.failure((ErrorEnum)ErrorEnum.THE_USER_IS_NOT_EXIT);
                }
                PersonUserInfo personUserInfo = new PersonUserInfo();
                PersonUser personUser = userInfo.getPersonUser();
                BeanUtils.copyProperties((Object)personUser, (Object)personUserInfo);
                personUserInfo.setSystemFlag(systemFlag);
                if (null == personUserInfo.getLicenseType()) {
                    personUserInfo.setLicenseType(identType);
                }
                if (null == personUserInfo.getLicenseNumber()) {
                    personUserInfo.setLicenseNumber(licenseNumber);
                }
                result = this.personUserService.updatePersonUser(userId.intValue(), personUserInfo);
            } else if (userType == UserTypeEnum.ORGAN_USER.id) {
                Long userId = this.queryUserId(UserTypeEnum.ORGAN_USER.id, systemFlag, identType, licenseNumber);
                if (null == userId) {
                    return Result.failure((ErrorEnum)ErrorEnum.THE_USER_IS_NOT_EXIT);
                }
                OrganUserInfoDTO organUserInfoDTO = new OrganUserInfoDTO();
                UserInfoDTO userInfoDTO = new UserInfoDTO();
                OrganUser organUser = userInfo.getOrganUser();
                PersonUser personInfo = organUser.getUserInfo();
                BeanUtils.copyProperties((Object)organUser, (Object)organUserInfoDTO);
                if (null != personInfo) {
                    BeanUtils.copyProperties((Object)personInfo, (Object)userInfoDTO);
                }
                organUserInfoDTO.setSystemFlag(systemFlag);
                if (null == organUserInfoDTO.getLicenseType()) {
                    organUserInfoDTO.setLicenseType(identType);
                }
                if (null == organUserInfoDTO.getLicenseNumber()) {
                    organUserInfoDTO.setLicenseNumber(licenseNumber);
                }
                result = this.organUserService.updateOrganUserInfo(userId, organUserInfoDTO, userInfoDTO);
            } else {
                DeviceUserInfo deviceUserInfo = new DeviceUserInfo();
                com.xdja.pki.ra.service.manager.deviceuser.bean.UserInfo userInfoDTO = new com.xdja.pki.ra.service.manager.deviceuser.bean.UserInfo();
                DeviceUser deviceUser = userInfo.getDeviceUser();
                PersonUser personInfo = deviceUser.getUserInfo();
                Long userId = this.queryUserId(UserTypeEnum.DEVICE_USER.id, systemFlag, identType, licenseNumber);
                if (null == userId) {
                    return Result.failure((ErrorEnum)ErrorEnum.THE_USER_IS_NOT_EXIT);
                }
                BeanUtils.copyProperties((Object)deviceUser, (Object)deviceUserInfo);
                if (null != personInfo) {
                    BeanUtils.copyProperties((Object)personInfo, (Object)userInfoDTO);
                }
                deviceUserInfo.setSystemFlag(systemFlag);
                if (null == deviceUserInfo.getLicenseType()) {
                    deviceUserInfo.setLicenseType(identType);
                }
                if (null == deviceUserInfo.getLicenseNumber()) {
                    deviceUserInfo.setLicenseNumber(licenseNumber);
                }
                result = this.deviceUserService.updateDeviceUser(userId.longValue(), deviceUserInfo, userInfoDTO);
            }
            return result;
        }
        catch (BeansException e) {
            throw new ServiceException("open-handler \u7528\u6237\u67e5\u8be2", (Throwable)e);
        }
    }
}

