/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.baseuser;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.commonenum.UserStatusEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.util.file.ErrorExcel;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.ContactUserDao;
import com.xdja.pki.ra.manager.dao.CustomerDao;
import com.xdja.pki.ra.manager.dao.DeviceUserDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.ContactUserDO;
import com.xdja.pki.ra.manager.dao.model.DeviceUserDO;
import com.xdja.pki.ra.manager.dto.DeviceUserDTO;
import com.xdja.pki.ra.manager.dto.DeviceUserDetailsDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.baseuser.bean.EncryptUserInfo;
import com.xdja.pki.ra.service.manager.customer.CustomerSysService;
import com.xdja.pki.ra.service.manager.deviceuser.DeviceUserService;
import com.xdja.pki.ra.service.manager.deviceuser.bean.BatchResp;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceInfo;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserInfo;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserResp;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserVO;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUtils;
import com.xdja.pki.ra.service.manager.deviceuser.bean.UserInfo;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DeviceUserServiceImpl
implements DeviceUserService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DeviceUserDao deviceUserDao;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    ContactUserDao contactUserDao;
    @Autowired
    CustomerDao customerDao;
    @Autowired
    CustomerSysService customerSysService;
    @Autowired
    BaseUserService baseUserService;

    @Transactional(propagation=Propagation.REQUIRED)
    public Result registerDeviceUser(DeviceUserInfo deviceUserInfo, UserInfo userInfo, boolean isV2X) {
        Result result = new Result();
        try {
            ContactUserDO contactUser;
            if (!isV2X) {
                result = this.customerSysService.verifyUserSystemFlag(deviceUserInfo.getSystemFlag());
                if (!result.isSuccess()) {
                    return result;
                }
                int count = this.baseUserService.queryUserExist(deviceUserInfo.getLicenseType(), deviceUserInfo.getLicenseNumber(), Integer.valueOf(UserTypeEnum.DEVICE_USER.id), deviceUserInfo.getSystemFlag());
                if (count > 0) {
                    result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                    return result;
                }
            }
            Date date = new Date(System.currentTimeMillis());
            Timestamp time = new Timestamp(date.getTime());
            BaseUserDO baseUserDO = new BaseUserDO();
            BeanUtils.copyProperties((Object)deviceUserInfo, (Object)baseUserDO);
            baseUserDO.setGmtCreate(time);
            baseUserDO.setGmtUpdate(time);
            baseUserDO.setSystemFlag(deviceUserInfo.getSystemFlag());
            baseUserDO = EncryptUserInfo.getEncryptBaseUserDO((BaseUserDO)baseUserDO);
            BaseUserDO baseUser = this.baseUserDao.addApplyRecord(baseUserDO);
            if (baseUser == null) {
                this.logger.info("\u63d2\u5165BaseUser\u5931\u8d25");
                throw new RuntimeException();
            }
            ContactUserDO contactUserDO = new ContactUserDO();
            if (null != userInfo) {
                BeanUtils.copyProperties((Object)userInfo, (Object)contactUserDO);
            }
            contactUserDO.setUserId(baseUser.getId());
            contactUserDO.setGmtCreate(time);
            contactUserDO.setGmtUpdate(time);
            if (null == contactUserDO.getSex()) {
                contactUserDO.setSex(Integer.valueOf(0));
            }
            if ((contactUser = this.contactUserDao.addPersonUserInfo(contactUserDO = EncryptUserInfo.getEncryptContactUserDO((ContactUserDO)contactUserDO))) == null) {
                this.logger.info("\u63d2\u5165\u8bbe\u5907\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25");
                throw new RuntimeException();
            }
            DeviceUserDO deviceUserDO = new DeviceUserDO();
            BeanUtils.copyProperties((Object)deviceUserInfo, (Object)deviceUserDO);
            deviceUserDO.setDeviceName(deviceUserInfo.getUserName());
            deviceUserDO.setDeviceNo(deviceUserInfo.getUserNo());
            deviceUserDO.setRemark(userInfo.getRemark());
            deviceUserDO.setUserId(baseUser.getId());
            deviceUserDO.setPersonId(contactUser.getId());
            deviceUserDO.setGmtCreate(time);
            deviceUserDO.setGmtUpdate(time);
            deviceUserDO.setLicenseNumber(baseUserDO.getLicenseNumber());
            DeviceUserDO deviceUser = this.deviceUserDao.addDeviceUser(deviceUserDO);
            if (deviceUser == null) {
                this.logger.info("\u63d2\u5165\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
                throw new RuntimeException();
            }
            result.setLogContent(", \u7528\u6237ID=" + deviceUser.getId());
        }
        catch (Exception e) {
            this.logger.error("\u6ce8\u518c\u7528\u6237\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    public Result registerBatchDeviceUser(DeviceUserInfo deviceUserInfo, UserInfo userInfo) {
        Result result = new Result();
        try {
            ContactUserDO contactUser;
            int count = this.baseUserService.queryUserExist(deviceUserInfo.getLicenseType(), deviceUserInfo.getLicenseNumber(), Integer.valueOf(UserTypeEnum.DEVICE_USER.id), deviceUserInfo.getSystemFlag());
            if (count > 0) {
                result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                return result;
            }
            Date date = new Date(System.currentTimeMillis());
            Timestamp time = new Timestamp(date.getTime());
            BaseUserDO baseUserDO = new BaseUserDO();
            BeanUtils.copyProperties((Object)userInfo, (Object)baseUserDO);
            BeanUtils.copyProperties((Object)deviceUserInfo, (Object)baseUserDO);
            baseUserDO.setGmtCreate(time);
            baseUserDO.setGmtUpdate(time);
            baseUserDO = EncryptUserInfo.getEncryptBaseUserDO((BaseUserDO)baseUserDO);
            BaseUserDO baseUser = this.baseUserDao.addApplyRecord(baseUserDO);
            if (baseUser == null) {
                this.logger.info("\u63d2\u5165BaseUser\u5931\u8d25");
                throw new RuntimeException();
            }
            ContactUserDO contactUserDO = new ContactUserDO();
            BeanUtils.copyProperties((Object)deviceUserInfo, (Object)contactUserDO);
            BeanUtils.copyProperties((Object)userInfo, (Object)contactUserDO);
            contactUserDO.setUserId(baseUser.getId());
            contactUserDO.setGmtCreate(time);
            contactUserDO.setGmtUpdate(time);
            if (null == contactUserDO.getSex()) {
                contactUserDO.setSex(Integer.valueOf(0));
            }
            if ((contactUser = this.contactUserDao.addPersonUserInfo(contactUserDO = EncryptUserInfo.getEncryptContactUserDO((ContactUserDO)contactUserDO))) == null) {
                this.logger.info("\u63d2\u5165\u8bbe\u5907\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25");
                throw new RuntimeException();
            }
            DeviceUserDO deviceUserDO = new DeviceUserDO();
            BeanUtils.copyProperties((Object)deviceUserInfo, (Object)deviceUserDO);
            deviceUserDO.setDeviceName(deviceUserInfo.getUserName());
            deviceUserDO.setDeviceNo(deviceUserInfo.getUserNo());
            deviceUserDO.setRemark(userInfo.getRemark());
            deviceUserDO.setUserId(baseUser.getId());
            deviceUserDO.setPersonId(contactUser.getId());
            deviceUserDO.setGmtCreate(time);
            deviceUserDO.setGmtUpdate(time);
            deviceUserDO = EncryptUserInfo.getEncryptDeviceUserDO((DeviceUserDO)deviceUserDO);
            DeviceUserDO deviceUser = this.deviceUserDao.addDeviceUser(deviceUserDO);
            if (deviceUser == null) {
                this.logger.info("\u63d2\u5165\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return null;
    }

    @Transactional
    public Result batchSaveDeviceUserByTemplateFile(ArrayList<ArrayList<String>> lists) {
        Result result = new Result();
        ArrayList<ArrayList> trueList = new ArrayList<ArrayList>();
        ArrayList<ArrayList<String>> falseList = new ArrayList<ArrayList<String>>();
        for (int i = 0; i < lists.size(); ++i) {
            result = new DeviceUtils().checkFormat(lists.get(i));
            if (result.getCode() == 0) {
                trueList.add((ArrayList)result.getInfo());
                continue;
            }
            falseList.add((ArrayList)result.getInfo());
        }
        ArrayList trueInfoList = new ArrayList();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < trueList.size(); ++i) {
            ArrayList listFornt = (ArrayList)trueList.get(i);
            String s = (String)listFornt.get(1) + (String)listFornt.get(2);
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)listFornt.get(13))) && !"RA".equals(listFornt.get(13))) {
                s = s + (String)listFornt.get(13);
            }
            if (!hashSet.contains(s)) {
                hashSet.add(s);
                trueInfoList.add(trueList.get(i));
                continue;
            }
            ArrayList list = (ArrayList)trueList.get(i);
            list.add("\u672c\u5730\u4e0a\u4f20\u8bbe\u5907\u7528\u6237\u91cd\u590d");
            falseList.add(list);
        }
        ArrayList<DeviceInfo> infoList = new ArrayList<DeviceInfo>();
        Iterator it = trueInfoList.iterator();
        while (it.hasNext()) {
            ArrayList next = (ArrayList)it.next();
            DeviceInfo info = DeviceUtils.format((List)next);
            String systemName = info.getDeviceUserInfo().getSystemName();
            int systemFlagSize = 1;
            String systemFlag = null;
            if (StringUtils.isBlank((CharSequence)systemName) || "RA".equals(systemName)) {
                systemFlag = "RA";
            } else if ("V2X".equals(systemName)) {
                systemFlag = "V2X";
            } else {
                systemFlagSize = this.baseUserDao.querySystemName(systemName);
                if (systemFlagSize != 0) {
                    systemFlag = this.baseUserDao.getSystemFlagByName(systemName);
                }
            }
            info.getDeviceUserInfo().setSystemFlag(systemFlag);
            int count = 0;
            if (null != systemFlag) {
                count = this.baseUserService.queryUserExist(info.getDeviceUserInfo().getLicenseType(), info.getDeviceUserInfo().getLicenseNumber(), Integer.valueOf(UserTypeEnum.ORGAN_USER.id), systemFlag);
            }
            if (count == 0 && systemFlagSize == 1) {
                infoList.add(info);
                continue;
            }
            falseList.add(next);
            it.remove();
            if (count > 0 && systemFlagSize != 1) {
                next.add("\u552f\u4e00\u6807\u8bc6\u7b26\u5df2\u5b58\u5728\uff0c\u6240\u5c5e\u7cfb\u7edf\u4e0d\u5b58\u5728");
                continue;
            }
            if (count > 0) {
                next.add("\u552f\u4e00\u6807\u8bc6\u7b26\u5df2\u5b58\u5728");
                continue;
            }
            next.add("\u6240\u5c5e\u7cfb\u7edf\u4e0d\u5b58\u5728");
        }
        this.DeviceRegisterBatch(infoList);
        result = this.generateExcel("device_user_batch_register_error_template", infoList, falseList);
        result.setLogContent("\uff0c\u6210\u529f\u6761\u6570=" + infoList.size() + "\uff0c\u5931\u8d25\u6761\u6570=" + falseList.size());
        return result;
    }

    public Result generateExcel(String templateName, ArrayList<DeviceInfo> infoList, ArrayList<ArrayList<String>> falseList) {
        Result result = new Result();
        try {
            BatchResp batchResp = null;
            if (falseList.size() > 0) {
                Result res = ErrorExcel.generateExcel((String)PathConstants.BATCH_REGISTER_FILE_PATH, (String)templateName, falseList);
                batchResp = new BatchResp(String.valueOf(infoList.size()), String.valueOf(falseList.size()), (String)res.getInfo());
            } else {
                batchResp = new BatchResp(String.valueOf(infoList.size()), String.valueOf(falseList.size()), null);
            }
            result.setCode(0);
            result.setInfo((Object)batchResp);
            return result;
        }
        catch (Exception e) {
            result.setError(ErrorEnum.UPDATE_ERROR_EXCEL_IS_ERROR);
            this.logger.info("\u751f\u6210\u9519\u8bef\u4fe1\u606f\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            return result;
        }
    }

    public void DeviceRegisterBatch(ArrayList<DeviceInfo> infoList) {
        for (int i = 0; i < infoList.size(); ++i) {
            this.registerBatchDeviceUser(infoList.get(i).getDeviceUserInfo(), infoList.get(i).getUserInfo());
        }
    }

    @Transactional
    public Result updateDeviceUser(long deviceId, DeviceUserInfo deviceUserInfo, UserInfo userInfo) {
        Result result = new Result();
        try {
            Date date = new Date(System.currentTimeMillis());
            result = this.customerSysService.verifyUserSystemFlag(deviceUserInfo.getSystemFlag());
            if (!result.isSuccess()) {
                return result;
            }
            Timestamp time = new Timestamp(date.getTime());
            String encryptLicenseNumber = EncryptUserInfo.getEncryptString((String)deviceUserInfo.getLicenseNumber());
            DeviceUserDO deviceUserDO = this.deviceUserDao.getDeviceUser(deviceUserInfo.getLicenseType(), encryptLicenseNumber, deviceUserInfo.getSystemFlag());
            if (null != deviceUserDO && (long)deviceUserDO.getUserId().intValue() != deviceId) {
                this.logger.info("\u67e5\u8be2\u8bbe\u5907\u7528\u6237\u5df2\u7ecf\u6ce8\u518c");
                result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                return result;
            }
            DeviceUserDO deviceInfo = this.deviceUserDao.getDeviceInfoById(deviceId);
            if (null == deviceInfo) {
                this.logger.error("\u66f4\u65b0\u7528\u6237\u4e0d\u5b58\u5728");
                result.setError(ErrorEnum.GET_DEVICE_INFO_EMPTY);
                return result;
            }
            Timestamp timestamp = deviceInfo.getGmtCreate();
            BeanUtils.copyProperties((Object)deviceUserInfo, (Object)deviceInfo);
            deviceInfo.setDeviceName(deviceUserInfo.getUserName());
            deviceInfo.setGmtCreate(timestamp);
            deviceInfo.setGmtUpdate(time);
            deviceInfo = EncryptUserInfo.getEncryptDeviceUserDO((DeviceUserDO)deviceInfo);
            int state = this.deviceUserDao.updateDeviceUser(deviceInfo);
            if (state != 1) {
                this.logger.info("\u66f4\u65b0\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
                result.setError(ErrorEnum.UPDATE_DEVICE_USER_INFO_ERROR);
                return result;
            }
            BaseUserDO baseUser = this.baseUserDao.getBaseUserInfo(deviceInfo.getUserId().longValue());
            if (null == baseUser) {
                this.logger.info("\u67e5\u8be2\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
                result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
                return result;
            }
            if (baseUser.getStatus() == UserStatusEnum.DISABLED.id) {
                result.setError(ErrorEnum.USER_STATUS_TYPE_IS_NOT_SUPPORT);
                return result;
            }
            Long id = baseUser.getId();
            result.setLogContent("\uff0c\u7528\u6237ID=" + baseUser.getId());
            BeanUtils.copyProperties((Object)deviceUserInfo, (Object)baseUser);
            baseUser.setGmtCreate(timestamp);
            baseUser.setGmtUpdate(time);
            baseUser.setId(id);
            baseUser = EncryptUserInfo.getEncryptBaseUserDO((BaseUserDO)baseUser);
            state = this.baseUserDao.updateBaseUser(baseUser);
            if (state != 1) {
                this.logger.info("\u66f4\u65b0\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
                result.setError(ErrorEnum.UPDATE_DEVICE_USER_INFO_ERROR);
                return result;
            }
            ContactUserDO contactInfo = this.deviceUserDao.getDeviceContactById(baseUser.getId().longValue());
            if (null != userInfo) {
                BeanUtils.copyProperties((Object)userInfo, (Object)contactInfo);
            }
            contactInfo.setGmtUpdate(time);
            contactInfo.setGmtCreate(timestamp);
            if (null == contactInfo.getSex()) {
                contactInfo.setSex(Integer.valueOf(0));
            }
            if ((state = this.deviceUserDao.updateContactUser(contactInfo = EncryptUserInfo.getEncryptContactUserDO((ContactUserDO)contactInfo))) != 1) {
                this.logger.info("\u66f4\u65b0\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
                result.setError(ErrorEnum.UPDATE_DEVICE_USER_INFO_ERROR);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u7528\u6237\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    public int getIdByUserNo(String userNo) {
        return this.deviceUserDao.getIdByUserNo(userNo);
    }

    public Result queryDeviceDetails(long deviceId) {
        DeviceUserDetailsDTO detailsDTO;
        Result result = new Result();
        try {
            detailsDTO = this.deviceUserDao.queryDeviceDetails(deviceId);
        }
        catch (EmptyResultDataAccessException e) {
            result.setError(ErrorEnum.GET_DEVICE_INFO_EMPTY);
            return result;
        }
        String systemName = this.customerDao.getSystemNameByFlag(detailsDTO.getSystemFlag());
        DeviceUserVO deviceUserVO = new DeviceUserVO();
        BeanUtils.copyProperties((Object)detailsDTO, (Object)deviceUserVO);
        deviceUserVO.setSystemName(systemName);
        Timestamp gmtCreate = detailsDTO.getGmtCreate();
        deviceUserVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
        try {
            deviceUserVO = DecryptUserInfo.getDecryptOrganUserVO((DeviceUserVO)deviceUserVO);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        result.setInfo((Object)deviceUserVO);
        return result;
    }

    public Result getDevice(Integer identType, String licenseNumber, String systemFlag) {
        String licenseNumberEncrypt;
        Result result = new Result();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            licenseNumberEncrypt = EncryptUserInfo.getEncryptString((String)licenseNumber);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        DeviceUserDetailsDTO deviceUserDTO = this.deviceUserDao.queryDeviceDetails(identType, licenseNumberEncrypt, systemFlag);
        if (null == deviceUserDTO) {
            this.logger.info("\u83b7\u53d6\u8bbe\u5907\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            return Result.failure((ErrorEnum)ErrorEnum.GET_DEVICE_INFO_EMPTY);
        }
        ContactUserDO contactUserDO = this.contactUserDao.getContactUser((long)deviceUserDTO.getPersonId());
        map.put("deviceUser", deviceUserDTO);
        map.put("userInfo", contactUserDO);
        result.setInfo(map);
        return result;
    }

    public Result listDeviceUser(String deviceName, String deviceNumber, int status, int pageIndex, int pageSize) {
        DeviceUserResp deviceUserResp = new DeviceUserResp();
        Result result = new Result();
        try {
            String licenseNumberEncrypt = EncryptUserInfo.getEncryptString((String)deviceNumber);
            PageInfo deviceUserDTOPageInfo = this.deviceUserDao.listPageDeviceUser(deviceName, licenseNumberEncrypt, status, pageIndex, pageSize);
            if (deviceUserDTOPageInfo == null) {
                result.setError(ErrorEnum.QUERY_DEVICE_USER_LIST_ERROR);
                return result;
            }
            ArrayList<DeviceUserVO> deviceUserVOList = new ArrayList<DeviceUserVO>();
            List deviceUserDTOList = deviceUserDTOPageInfo.getList();
            if (CollectionUtils.isEmpty((Collection)deviceUserDTOList)) {
                deviceUserResp.setRecordCount(0);
                deviceUserResp.setPageCount(0);
                deviceUserResp.setDatas(deviceUserVOList);
                result.setInfo((Object)deviceUserResp);
                return result;
            }
            for (DeviceUserDTO deviceUserDTO : deviceUserDTOList) {
                DeviceUserVO deviceUserVO = new DeviceUserVO();
                BeanUtils.copyProperties((Object)deviceUserDTO, (Object)deviceUserVO);
                Timestamp gmtCreate = deviceUserDTO.getGmtCreate();
                deviceUserVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
                deviceUserVO = DecryptUserInfo.getDecryptOrganUserVO((DeviceUserVO)deviceUserVO);
                deviceUserVOList.add(deviceUserVO);
            }
            deviceUserResp.setDatas(deviceUserVOList);
            deviceUserResp.setPageCount(deviceUserDTOPageInfo.getPageCount());
            deviceUserResp.setRecordCount(deviceUserDTOPageInfo.getRecordCount());
            result.setInfo((Object)deviceUserResp);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }
}

