/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.baseuser;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.commonenum.UserStatusEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.util.file.ErrorExcel;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.ContactUserDao;
import com.xdja.pki.ra.manager.dao.CustomerDao;
import com.xdja.pki.ra.manager.dao.OrganUserDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.ContactUserDO;
import com.xdja.pki.ra.manager.dao.model.OrganUserDO;
import com.xdja.pki.ra.manager.dto.OrganUserDTO;
import com.xdja.pki.ra.manager.dto.OrganUserInfoDTO;
import com.xdja.pki.ra.manager.dto.UserInfoDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.baseuser.bean.EncryptUserInfo;
import com.xdja.pki.ra.service.manager.customer.CustomerSysService;
import com.xdja.pki.ra.service.manager.organuser.OrganUserService;
import com.xdja.pki.ra.service.manager.organuser.bean.BatchResp;
import com.xdja.pki.ra.service.manager.organuser.bean.OrganParamsCheck;
import com.xdja.pki.ra.service.manager.organuser.bean.OrganUserResp;
import com.xdja.pki.ra.service.manager.organuser.bean.OrganUserVO;
import com.xdja.pki.ra.service.manager.organuser.bean.SaveOrganUserVO;
import com.xdja.pki.ra.service.manager.organuser.bean.ToOrganUserVO;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrganUserServiceImpl
implements OrganUserService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    OrganUserDao organUserDao;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    ContactUserDao contactUserDao;
    @Autowired
    CustomerDao customerDao;
    @Autowired
    CustomerSysService customerSysService;
    @Autowired
    BaseUserService baseUserService;

    public Result listOrganUser(String organName, String licenseNumber, Integer status, Integer pageNo, Integer pageSize) {
        OrganUserResp organUserResp = new OrganUserResp();
        Result result = new Result();
        try {
            String licenseNumberEncrypt = EncryptUserInfo.getEncryptString((String)licenseNumber);
            PageInfo organUserDOPageInfo = this.organUserDao.listPageOrganUser(organName, licenseNumberEncrypt, status.intValue(), pageNo.intValue(), pageSize.intValue());
            if (organUserDOPageInfo == null) {
                result.setError(ErrorEnum.QUERY_ORGAN_USER_LIST_ERROR);
                return result;
            }
            ArrayList<OrganUserVO> organUserVOList = new ArrayList<OrganUserVO>();
            List organUserDOList = organUserDOPageInfo.getList();
            if (CollectionUtils.isEmpty((Collection)organUserDOList)) {
                organUserResp.setRecordCount(0);
                organUserResp.setPageCount(0);
                organUserResp.setDatas(organUserVOList);
                result.setInfo((Object)organUserResp);
                return result;
            }
            for (OrganUserDTO organUserDTO : organUserDOList) {
                OrganUserVO organUserVO = new OrganUserVO();
                BeanUtils.copyProperties((Object)organUserDTO, (Object)organUserVO);
                Timestamp gmtCreate = organUserDTO.getGmtCreate();
                organUserVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
                organUserVO = DecryptUserInfo.getDecryptOrganUserVO((OrganUserVO)organUserVO);
                organUserVOList.add(organUserVO);
            }
            organUserResp.setDatas(organUserVOList);
            organUserResp.setPageCount(organUserDOPageInfo.getPageCount());
            organUserResp.setRecordCount(organUserDOPageInfo.getRecordCount());
            result.setInfo((Object)organUserResp);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    @Transactional
    public Result saveOrganUser(UserInfoDTO userInfoDTO, OrganUserInfoDTO organUserInfoDTO) {
        Result result = new Result();
        try {
            result = this.customerSysService.verifyUserSystemFlag(organUserInfoDTO.getSystemFlag());
            if (!result.isSuccess()) {
                return result;
            }
            BaseUserDO baseUser = new BaseUserDO();
            Date date = new Date(System.currentTimeMillis());
            Timestamp time = new Timestamp(date.getTime());
            baseUser.setUserType(Integer.valueOf(2));
            baseUser.setUserName(organUserInfoDTO.getOrganName());
            int queryOrganUser = this.baseUserService.queryUserExist(organUserInfoDTO.getLicenseType(), organUserInfoDTO.getLicenseNumber(), Integer.valueOf(UserTypeEnum.ORGAN_USER.id), organUserInfoDTO.getSystemFlag());
            if (queryOrganUser > 0) {
                this.logger.info("\u673a\u6784\u7528\u6237\u4fe1\u606f\u5df2\u6ce8\u518c");
                result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                return result;
            }
            baseUser.setLicenseNumber(organUserInfoDTO.getLicenseNumber());
            baseUser.setLicenseType(organUserInfoDTO.getLicenseType());
            baseUser.setGmtUpdate(time);
            baseUser.setGmtCreate(time);
            baseUser.setStatus(Integer.valueOf(0));
            baseUser.setSystemFlag(organUserInfoDTO.getSystemFlag());
            baseUser = EncryptUserInfo.getEncryptBaseUserDO((BaseUserDO)baseUser);
            this.baseUserDao.saveBaseUserInfo(baseUser);
            ContactUserDO contactUser = new ContactUserDO();
            BeanUtils.copyProperties((Object)userInfoDTO, (Object)contactUser);
            contactUser.setUserId(baseUser.getId());
            contactUser.setGmtUpdate(time);
            contactUser.setGmtCreate(time);
            if (null == contactUser.getSex()) {
                contactUser.setSex(Integer.valueOf(0));
            }
            contactUser = EncryptUserInfo.getEncryptContactUserDO((ContactUserDO)contactUser);
            this.contactUserDao.saveContactUserInfo(contactUser);
            OrganUserDO organUser = new OrganUserDO();
            BeanUtils.copyProperties((Object)organUserInfoDTO, (Object)organUser);
            organUser.setPersonId(contactUser.getId());
            organUser.setUserId(baseUser.getId());
            organUser.setGmtCreate(time);
            organUser.setGmtUpdate(time);
            organUser = EncryptUserInfo.getEncryptOrganUserDO((OrganUserDO)organUser);
            OrganUserDO addOrganUserDO = this.organUserDao.saveOrganUserInfo(organUser);
            result.setLogContent(", \u7528\u6237ID=" + addOrganUserDO.getId());
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    public Result batchSaveOrganUser(UserInfoDTO userInfoDTO, OrganUserInfoDTO organUserInfoDTO) {
        Result result = new Result();
        try {
            Date date = new Date();
            Timestamp s = new Timestamp(date.getTime());
            BaseUserDO baseUser = new BaseUserDO();
            baseUser.setUserType(Integer.valueOf(2));
            baseUser.setUserName(organUserInfoDTO.getOrganName());
            baseUser.setGmtCreate(s);
            baseUser.setGmtUpdate(s);
            baseUser.setStatus(Integer.valueOf(0));
            baseUser.setLicenseNumber(organUserInfoDTO.getLicenseNumber());
            baseUser.setLicenseType(organUserInfoDTO.getLicenseType());
            baseUser.setSystemFlag(organUserInfoDTO.getSystemFlag());
            baseUser = EncryptUserInfo.getEncryptBaseUserDO((BaseUserDO)baseUser);
            this.baseUserDao.saveBaseUserInfo(baseUser);
            ContactUserDO contactUser = new ContactUserDO();
            contactUser.setUserId(baseUser.getId());
            contactUser.setPersonName(userInfoDTO.getPersonName());
            contactUser.setSex(userInfoDTO.getSex());
            contactUser.setLicenseType(userInfoDTO.getLicenseType());
            contactUser.setLicenseNumber(userInfoDTO.getLicenseNumber());
            contactUser.setTelNumber(userInfoDTO.getTelNumber());
            contactUser.setAddress(userInfoDTO.getAddress());
            contactUser.setEmail(userInfoDTO.getEmail());
            contactUser.setPostalCode(userInfoDTO.getPostalCode());
            contactUser.setRemark(userInfoDTO.getRemark());
            contactUser.setGmtCreate(s);
            contactUser.setGmtUpdate(s);
            if (null == contactUser.getSex()) {
                contactUser.setSex(Integer.valueOf(0));
            }
            contactUser = EncryptUserInfo.getEncryptContactUserDO((ContactUserDO)contactUser);
            this.contactUserDao.saveContactUserInfo(contactUser);
            OrganUserDO organUser = new OrganUserDO();
            organUser.setPersonId(contactUser.getId());
            organUser.setUserId(baseUser.getId());
            organUser.setOrganName(organUserInfoDTO.getOrganName());
            organUser.setLegalPerson(organUserInfoDTO.getLegalPerson());
            organUser.setLicenseType(organUserInfoDTO.getLicenseType());
            organUser.setLicenseNumber(organUserInfoDTO.getLicenseNumber());
            organUser.setAddress(organUserInfoDTO.getAddress());
            organUser.setEmail(organUserInfoDTO.getEmail());
            organUser.setPostalCode(organUserInfoDTO.getPostalCode());
            organUser.setGmtCreate(s);
            organUser.setGmtUpdate(s);
            organUser = EncryptUserInfo.getEncryptOrganUserDO((OrganUserDO)organUser);
            this.organUserDao.saveOrganUserInfo(organUser);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    public Result getOrganUserInfo(Long organId) {
        OrganUserDTO organUserDTO;
        Result result = new Result();
        OrganUserVO organUserVO = new OrganUserVO();
        try {
            organUserDTO = this.organUserDao.getOrganUserInfo(organId.longValue());
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u673a\u6784\u7528\u6237\u8be6\u60c5\u4fe1\u606f\u5f02\u5e38");
            result.setError(ErrorEnum.GET_ORGAN_USER_INFO_EXCEPTION);
            return result;
        }
        if (null == organUserDTO) {
            this.logger.info("\u83b7\u53d6\u673a\u6784\u7528\u6237\u8be6\u60c5\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ORGAN_USER_IS_EMPTY);
            return result;
        }
        String systemName = this.customerDao.getSystemNameByFlag(organUserDTO.getSystemFlag());
        BeanUtils.copyProperties((Object)organUserDTO, (Object)organUserVO);
        organUserVO.setSystemName(systemName);
        Timestamp gmtCreate = organUserDTO.getGmtCreate();
        organUserVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
        try {
            organUserVO = DecryptUserInfo.getDecryptOrganUserVO((OrganUserVO)organUserVO);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        result.setInfo((Object)organUserVO);
        return result;
    }

    public Result getOrganUser(Integer identType, String licenseNumber, String systemFlag) {
        Result result = new Result();
        HashMap<String, Object> map = new HashMap<String, Object>();
        OrganUserDTO organUserDTO = null;
        try {
            organUserDTO = this.organUserDao.getOrganUserInfo(identType, EncryptUserInfo.getEncryptString((String)licenseNumber), systemFlag);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        if (null == organUserDTO) {
            this.logger.info("\u83b7\u53d6\u673a\u6784\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
            return Result.failure((ErrorEnum)ErrorEnum.GET_ORGAN_USER_TABLE_IS_EMPTY);
        }
        String systemName = this.customerDao.getSystemNameByFlag(systemFlag);
        organUserDTO.setSystemName(systemName);
        ContactUserDO contactUserDO = this.contactUserDao.getContactUser(organUserDTO.getPersonId().longValue());
        map.put("organUserInfo", organUserDTO);
        map.put("userInfo", contactUserDO);
        result.setInfo(map);
        return result;
    }

    @Transactional
    public Result updateOrganUserInfo(Long organId, OrganUserInfoDTO updateOrganUserInfoDTO, UserInfoDTO updateUserInfoDTO) {
        Result result = new Result();
        try {
            int updatePersonUserDO;
            OrganUserDO organUserInfo = this.organUserDao.getOrganUser(organId);
            if (organUserInfo == null) {
                this.logger.info("\u67e5\u8be2\u673a\u6784\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
                result.setError(ErrorEnum.GET_ORGAN_USER_TABLE_IS_EMPTY);
                return result;
            }
            result = this.customerSysService.verifyUserSystemFlag(updateOrganUserInfoDTO.getSystemFlag());
            if (!result.isSuccess()) {
                return result;
            }
            String licenseNumberEncrypt = EncryptUserInfo.getEncryptString((String)updateOrganUserInfoDTO.getLicenseNumber());
            OrganUserDO organUserDO = this.organUserDao.getOrganUser(updateOrganUserInfoDTO.getLicenseType(), licenseNumberEncrypt, updateOrganUserInfoDTO.getSystemFlag());
            if (null != organUserDO && organUserDO.getUserId().intValue() != organId.intValue()) {
                this.logger.info("\u673a\u6784\u7528\u6237\u4fe1\u606f\u5df2\u6ce8\u518c");
                result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                return result;
            }
            organUserInfo.setOrganName(updateOrganUserInfoDTO.getOrganName());
            organUserInfo.setLegalPerson(updateOrganUserInfoDTO.getLegalPerson());
            organUserInfo.setLicenseType(updateOrganUserInfoDTO.getLicenseType());
            organUserInfo.setLicenseNumber(updateOrganUserInfoDTO.getLicenseNumber());
            organUserInfo.setAddress(updateOrganUserInfoDTO.getAddress());
            organUserInfo.setEmail(updateOrganUserInfoDTO.getEmail());
            organUserInfo.setPostalCode(updateOrganUserInfoDTO.getPostalCode());
            Date date = new Date();
            Timestamp s = new Timestamp(date.getTime());
            organUserInfo.setGmtUpdate(s);
            organUserInfo = EncryptUserInfo.getEncryptOrganUserDO((OrganUserDO)organUserInfo);
            int updateOrganUserDO = this.organUserDao.updateOrganUserInfo(organUserInfo);
            if (updateOrganUserDO != 1) {
                this.logger.info("\u66f4\u65b0\u673a\u6784\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                result.setError(ErrorEnum.UPDATE_ORGAN_USER_INFO_ERROR);
                return result;
            }
            ContactUserDO contactUserInfo = this.contactUserDao.getContactUser(organUserInfo.getPersonId().longValue());
            if (contactUserInfo == null) {
                this.logger.info("\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f\u4e3a\u7a7a");
                result.setError(ErrorEnum.GET_CONTACT_USER_INFO_IS_EMPTY);
                return result;
            }
            contactUserInfo.setPersonName(updateUserInfoDTO.getPersonName());
            contactUserInfo.setSex(updateUserInfoDTO.getSex());
            contactUserInfo.setLicenseType(updateUserInfoDTO.getLicenseType());
            contactUserInfo.setTelNumber(updateUserInfoDTO.getTelNumber());
            contactUserInfo.setLicenseNumber(updateUserInfoDTO.getLicenseNumber());
            contactUserInfo.setAddress(updateUserInfoDTO.getAddress());
            contactUserInfo.setEmail(updateUserInfoDTO.getEmail());
            contactUserInfo.setPostalCode(updateUserInfoDTO.getPostalCode());
            contactUserInfo.setRemark(updateUserInfoDTO.getRemark());
            contactUserInfo.setGmtUpdate(s);
            if (null == contactUserInfo.getSex()) {
                contactUserInfo.setSex(Integer.valueOf(0));
            }
            if ((updatePersonUserDO = this.contactUserDao.updateContactUserInfo(contactUserInfo = EncryptUserInfo.getEncryptContactUserDO((ContactUserDO)contactUserInfo))) != 1) {
                this.logger.info("\u66f4\u65b0\u673a\u6784\u7528\u6237\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25");
                result.setError(ErrorEnum.UPDATE_ORGAN_USER_INFO_ERROR);
                return result;
            }
            BaseUserDO baseUser = this.baseUserDao.getBaseUserInfo(organUserInfo.getUserId().longValue());
            if (baseUser == null) {
                this.logger.info("\u67e5\u8be2\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
                result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
                return result;
            }
            if (baseUser.getStatus() == UserStatusEnum.DISABLED.id) {
                result.setError(ErrorEnum.USER_STATUS_TYPE_IS_NOT_SUPPORT);
                return result;
            }
            baseUser.setUserName(organUserInfo.getOrganName());
            baseUser.setLicenseType(organUserInfo.getLicenseType());
            baseUser.setLicenseNumber(organUserInfo.getLicenseNumber());
            baseUser.setGmtUpdate(s);
            int updateBaseUserDO = this.baseUserDao.updateBaseUser(baseUser);
            if (updateBaseUserDO != 1) {
                this.logger.info("\u66f4\u65b0\u673a\u6784\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                result.setError(ErrorEnum.UPDATE_ORGAN_USER_INFO_ERROR);
                return result;
            }
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    @Transactional
    public Result batchSaveOrganUserByTemplateFile(ArrayList<ArrayList<String>> fileList) {
        String filename;
        int i;
        Result result = new Result();
        int excelSize = fileList.size();
        ArrayList<ArrayList> trueList = new ArrayList<ArrayList>();
        ArrayList<ArrayList> falseList = new ArrayList<ArrayList>();
        for (int i2 = 0; i2 < fileList.size(); ++i2) {
            Result organResult = new OrganParamsCheck().checkOrganParams(fileList.get(i2));
            if (organResult.getCode() == 0) {
                trueList.add((ArrayList)organResult.getInfo());
                continue;
            }
            falseList.add((ArrayList)organResult.getInfo());
        }
        ArrayList<SaveOrganUserVO> infoList = new ArrayList<SaveOrganUserVO>();
        HashSet<String> hashSet = new HashSet<String>();
        for (i = 0; i < trueList.size(); ++i) {
            ArrayList list;
            SaveOrganUserVO info = ToOrganUserVO.format((List)((List)trueList.get(i)));
            OrganUserInfoDTO organUser = info.getOrganUserInfoDTO();
            String licenseNumber = organUser.getLicenseNumber();
            Integer licenseType = organUser.getLicenseType();
            String s = licenseNumber + licenseType.toString();
            String systemName = organUser.getSystemName();
            int systemFlagSize = 1;
            String systemFlag = null;
            if (StringUtils.isBlank((CharSequence)systemName) || "RA".equals(systemName)) {
                systemFlag = "RA";
            } else {
                if ("V2X".equals(systemName)) {
                    systemFlag = "V2X";
                } else {
                    systemFlagSize = this.baseUserDao.querySystemName(systemName);
                    if (systemFlagSize != 0) {
                        systemFlag = this.baseUserDao.getSystemFlagByName(systemName);
                    }
                }
                s = s + systemFlag;
            }
            organUser.setSystemFlag(systemFlag);
            int queryOrganUser = 0;
            if (null != systemFlag) {
                try {
                    queryOrganUser = this.baseUserService.queryUserExist(licenseType, licenseNumber, Integer.valueOf(UserTypeEnum.ORGAN_USER.id), systemFlag);
                }
                catch (Exception e) {
                    this.logger.info("\u67e5\u8be2\u5df2\u6ce8\u518c\u673a\u6784\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
                    result.setError(ErrorEnum.GET_ORGAN_USER_INFO_EXCEPTION);
                    return result;
                }
            }
            if (!hashSet.contains(s)) {
                hashSet.add(s);
                if (queryOrganUser == 0 && systemFlagSize == 1) {
                    infoList.add(info);
                    continue;
                }
                list = (ArrayList)trueList.get(i);
                falseList.add(list);
                if (queryOrganUser > 0 && systemFlagSize != 1) {
                    list.add("\u673a\u6784\u7528\u6237\u8bc1\u4ef6\u53f7\u7801\u5df2\u5b58\u5728\uff0c\u6240\u5c5e\u7cfb\u7edf\u4e0d\u5b58\u5728");
                    continue;
                }
                if (queryOrganUser > 0) {
                    list.add("\u673a\u6784\u7528\u6237\u8bc1\u4ef6\u53f7\u7801\u5df2\u5b58\u5728");
                    continue;
                }
                list.add("\u6240\u5c5e\u7cfb\u7edf\u4e0d\u5b58\u5728");
                continue;
            }
            list = (ArrayList)trueList.get(i);
            list.add("\u672c\u5730\u4e0a\u4f20\u673a\u6784\u7528\u6237\u91cd\u590d");
            falseList.add(list);
        }
        for (i = 0; i < infoList.size(); ++i) {
            this.batchSaveOrganUser(((SaveOrganUserVO)infoList.get(i)).getUserInfoDTO(), ((SaveOrganUserVO)infoList.get(i)).getOrganUserInfoDTO());
        }
        if (excelSize != infoList.size()) {
            Result name = null;
            try {
                name = ErrorExcel.generateExcel((String)PathConstants.BATCH_REGISTER_FILE_PATH, (String)"organ_user_batch_register_error_template", falseList);
            }
            catch (IOException e) {
                result.setError(ErrorEnum.UPDATE_ERROR_EXCEL_IS_ERROR);
                this.logger.info("\u751f\u6210\u9519\u8bef\u4fe1\u606f\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                return result;
            }
            filename = (String)name.getInfo();
        } else {
            filename = null;
        }
        BatchResp batchResp = new BatchResp(Integer.valueOf(infoList.size()), Integer.valueOf(falseList.size()), filename);
        result.setLogContent("\uff0c\u6210\u529f\u6761\u6570=" + infoList.size() + "\uff0c\u5931\u8d25\u6761\u6570=" + falseList.size());
        result.setInfo((Object)batchResp);
        return result;
    }
}

