/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.baseuser;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.commonenum.UserStatusEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.core.util.file.ErrorExcel;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CustomerDao;
import com.xdja.pki.ra.manager.dao.PersonUserDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.PersonUserDO;
import com.xdja.pki.ra.manager.dto.PersonUserDTO;
import com.xdja.pki.ra.manager.dto.PersonUserDetailsDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.baseuser.bean.EncryptUserInfo;
import com.xdja.pki.ra.service.manager.customer.CustomerSysService;
import com.xdja.pki.ra.service.manager.organuser.bean.BatchResp;
import com.xdja.pki.ra.service.manager.personuser.PersonUserService;
import com.xdja.pki.ra.service.manager.personuser.bean.PersonParamsCheck;
import com.xdja.pki.ra.service.manager.personuser.bean.PersonUserInfo;
import com.xdja.pki.ra.service.manager.personuser.bean.PersonUserResp;
import com.xdja.pki.ra.service.manager.personuser.bean.PersonUserVO;
import com.xdja.pki.ra.service.manager.personuser.bean.SavePersonUserVO;
import com.xdja.pki.ra.service.manager.personuser.bean.ToPersonUserVO;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;

@Service
public class PersonUserServiceImpl
implements PersonUserService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    PersonUserDao personUserDao;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    CustomerDao customerDao;
    @Autowired
    CustomerSysService customerSysService;
    @Autowired
    BaseUserService baseUserService;

    public Result listPersonUser(String personName, String licenseNumber, int status, int pageIndex, int pageSize) {
        Result result = new Result();
        try {
            PersonUserResp personUserResp = new PersonUserResp();
            String licenseNumberEncrypt = EncryptUserInfo.getEncryptString((String)licenseNumber);
            PageInfo personUserDTOPageInfo = this.personUserDao.listPagePersonUser(personName, licenseNumberEncrypt, status, pageIndex, pageSize);
            if (personUserDTOPageInfo == null) {
                result.setError(ErrorEnum.QUERY_PERSON_USER_LIST_EMPTY);
                return result;
            }
            ArrayList<PersonUserVO> personUserVOList = new ArrayList<PersonUserVO>();
            List personUserDTOList = personUserDTOPageInfo.getList();
            if (CollectionUtils.isEmpty((Collection)personUserDTOList)) {
                personUserResp.setRecordCount(0);
                personUserResp.setPageCount(0);
                personUserResp.setDatas(personUserVOList);
                result.setInfo((Object)personUserResp);
                return result;
            }
            for (PersonUserDTO personUserDTO : personUserDTOList) {
                PersonUserVO personUserVO = new PersonUserVO();
                BeanUtils.copyProperties((Object)personUserDTO, (Object)personUserVO);
                Timestamp gmtCreate = personUserDTO.getGmtCreate();
                personUserVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
                personUserVO = DecryptUserInfo.getDecryptPersonUserVO((PersonUserVO)personUserVO);
                personUserVOList.add(personUserVO);
            }
            personUserResp.setDatas(personUserVOList);
            personUserResp.setPageCount(personUserDTOPageInfo.getPageCount());
            personUserResp.setRecordCount(personUserDTOPageInfo.getRecordCount());
            result.setInfo((Object)personUserResp);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    public Result getPersonUserDetails(long personId) {
        Result result = new Result();
        try {
            PersonUserDetailsDTO personUserDetailsDTO = null;
            try {
                personUserDetailsDTO = this.personUserDao.getPersonDetailsInfoById(personId);
            }
            catch (EmptyResultDataAccessException e) {
                result.setError(ErrorEnum.GET_PERSON_USER_INFO_IS_EMPTY);
                return result;
            }
            String systemName = this.customerDao.getSystemNameByFlag(personUserDetailsDTO.getSystemFlag());
            PersonUserVO personUserVO = new PersonUserVO();
            BeanUtils.copyProperties((Object)personUserDetailsDTO, (Object)personUserVO);
            personUserVO.setSystemName(systemName);
            Timestamp gmtCreate = personUserDetailsDTO.getGmtCreate();
            personUserVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
            personUserVO = DecryptUserInfo.getDecryptPersonUserVO((PersonUserVO)personUserVO);
            result.setInfo((Object)personUserVO);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    public Result getPersonUserDetailsByLicenseTypeAndLicenseNumber(Integer identType, String licenseNumber, String systemFlag) {
        try {
            Result result = new Result();
            String licenseNumberEncrypt = EncryptUserInfo.getEncryptString((String)licenseNumber);
            PersonUserDTO personUserDTO = this.personUserDao.getPersonInfoByLicenseTypeAndLicenseNumber(identType, licenseNumberEncrypt, systemFlag);
            if (null == personUserDTO) {
                return Result.failure((ErrorEnum)ErrorEnum.GET_PERSON_USER_INFO_IS_EMPTY);
            }
            result.setInfo((Object)personUserDTO);
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("\u901a\u8fc7\u8bc1\u4ef6\u7c7b\u578b\u548c\u8bc1\u4ef6\u53f7\u7801\u67e5\u8be2\u4e2a\u4eba\u7528\u6237\u8be6\u60c5", (Throwable)e);
        }
    }

    @Transactional
    public Result updatePersonUser(int personId, PersonUserInfo personUserInfo) {
        Result result = new Result();
        try {
            Date date = new Date();
            Timestamp s = new Timestamp(date.getTime());
            PersonUserDO personInfo = this.personUserDao.getPersonInfoById((long)personId);
            if (null == personInfo) {
                this.logger.info("\u66f4\u65b0\u7528\u6237\u4e0d\u5b58\u5728");
                result.setError(ErrorEnum.GET_PERSON_USER_INFO_IS_EXCEPTION);
                return result;
            }
            result = this.customerSysService.verifyUserSystemFlag(personUserInfo.getSystemFlag());
            if (!result.isSuccess()) {
                return result;
            }
            String licenseNumberEncrypt = EncryptUserInfo.getEncryptString((String)personUserInfo.getLicenseNumber());
            PersonUserDTO personUserDTO = this.personUserDao.getPersonInfoByLicenseTypeAndLicenseNumber(personUserInfo.getLicenseType(), licenseNumberEncrypt, personUserInfo.getSystemFlag());
            if (null != personUserDTO && (long)personId != personUserDTO.getUserId()) {
                this.logger.info("\u7528\u6237\u4fe1\u606f\u5df2\u7ecf\u6ce8\u518c");
                result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                return result;
            }
            if (null == personUserInfo.getSex()) {
                personUserInfo.setSex(Integer.valueOf(0));
            }
            BeanUtils.copyProperties((Object)personUserInfo, (Object)personInfo);
            personInfo.setPersonUserType(Integer.valueOf(0));
            personInfo.setGmtUpdate(s);
            personInfo = EncryptUserInfo.getEncryptPersonUserDO((PersonUserDO)personInfo);
            int i = this.personUserDao.updatePersonUser(personInfo);
            if (i != 1) {
                result.setError(ErrorEnum.UPDATE_PERSON_INFO_FAIL);
                return result;
            }
            long userId = personInfo.getUserId();
            BaseUserDO baseUser = this.baseUserDao.getBaseUserInfo(userId);
            if (baseUser == null) {
                result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
                return result;
            }
            if (baseUser.getStatus() == UserStatusEnum.DISABLED.id) {
                result.setError(ErrorEnum.USER_STATUS_TYPE_IS_NOT_SUPPORT);
                return result;
            }
            baseUser.setLicenseNumber(personUserInfo.getLicenseNumber());
            baseUser.setLicenseType(personUserInfo.getUserType());
            baseUser.setUserName(personUserInfo.getPersonName());
            baseUser.setGmtUpdate(s);
            baseUser = EncryptUserInfo.getEncryptBaseUserDO((BaseUserDO)baseUser);
            try {
                this.baseUserDao.updateBaseUser(baseUser);
            }
            catch (Exception e) {
                this.logger.error("\u66f4\u65b0\u7528\u6237\u57fa\u672c\u4fe1\u606f\u8868\u5f02\u5e38{}", (Throwable)e);
                result.setError(ErrorEnum.UPDATE_BASE_USER_INFO_ERROR);
                return result;
            }
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    @Transactional
    public Result savePersonUser(PersonUserDTO personUserInfo) {
        Result result = new Result();
        try {
            BaseUserDO baseUserDO = new BaseUserDO();
            result = this.customerSysService.verifyUserSystemFlag(personUserInfo.getSystemFlag());
            if (!result.isSuccess()) {
                return result;
            }
            int queryUser = this.baseUserService.queryUserExist(Integer.valueOf(personUserInfo.getLicenseType()), personUserInfo.getLicenseNumber(), Integer.valueOf(UserTypeEnum.PERSON_USER.id), personUserInfo.getSystemFlag());
            if (queryUser > 0) {
                this.logger.info("\u4e2a\u4eba\u7528\u6237\u8bc1\u4ef6\u53f7\u7801\u5df2\u6ce8\u518c");
                result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                return result;
            }
            baseUserDO.setUserType(Integer.valueOf(1));
            baseUserDO.setUserName(personUserInfo.getPersonName());
            baseUserDO.setLicenseNumber(personUserInfo.getLicenseNumber());
            baseUserDO.setLicenseType(Integer.valueOf(personUserInfo.getLicenseType()));
            baseUserDO.setStatus(Integer.valueOf(0));
            Date date = new Date();
            Timestamp s = new Timestamp(date.getTime());
            baseUserDO.setGmtCreate(s);
            baseUserDO.setGmtUpdate(s);
            baseUserDO.setSystemFlag(personUserInfo.getSystemFlag());
            baseUserDO = EncryptUserInfo.getEncryptBaseUserDO((BaseUserDO)baseUserDO);
            this.baseUserDao.saveBaseUserInfo(baseUserDO);
            PersonUserDO personUserDO = new PersonUserDO();
            BeanUtils.copyProperties((Object)personUserInfo, (Object)personUserDO);
            personUserDO.setUserId(baseUserDO.getId());
            personUserDO.setGmtUpdate(s);
            personUserDO.setGmtCreate(s);
            personUserDO.setPersonUserType(Integer.valueOf(0));
            if (null == personUserDO.getSex()) {
                personUserDO.setSex(Integer.valueOf(0));
            }
            personUserDO = EncryptUserInfo.getEncryptPersonUserDO((PersonUserDO)personUserDO);
            PersonUserDO personUser = this.personUserDao.savePersonUserInfo(personUserDO);
            result.setLogContent(", \u7528\u6237ID=" + personUser.getId());
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    public Result saveBatchPersonUser(PersonUserDTO personUserInfo) {
        Result result = new Result();
        try {
            Date date = new Date();
            Timestamp s = new Timestamp(date.getTime());
            BaseUserDO baseUserDO = new BaseUserDO();
            baseUserDO.setUserType(Integer.valueOf(1));
            baseUserDO.setUserName(personUserInfo.getPersonName());
            int queryUser = this.baseUserService.queryUserExist(Integer.valueOf(personUserInfo.getLicenseType()), personUserInfo.getLicenseNumber(), Integer.valueOf(UserTypeEnum.PERSON_USER.id), personUserInfo.getSystemFlag());
            if (queryUser > 0) {
                this.logger.info("\u4e2a\u4eba\u7528\u6237\u4fe1\u606f\u5df2\u6ce8\u518c");
                result.setError(ErrorEnum.QUERY_BASE_USER_IS_EXISTENCE);
                return result;
            }
            baseUserDO.setLicenseNumber(personUserInfo.getLicenseNumber());
            baseUserDO.setLicenseType(Integer.valueOf(personUserInfo.getLicenseType()));
            baseUserDO.setSystemFlag(personUserInfo.getSystemFlag());
            baseUserDO.setStatus(Integer.valueOf(0));
            baseUserDO.setGmtCreate(s);
            baseUserDO.setGmtUpdate(s);
            baseUserDO = EncryptUserInfo.getEncryptBaseUserDO((BaseUserDO)baseUserDO);
            this.baseUserDao.saveBaseUserInfo(baseUserDO);
            PersonUserDO personUserDO = new PersonUserDO();
            BeanUtils.copyProperties((Object)personUserInfo, (Object)personUserDO);
            personUserDO.setUserId(baseUserDO.getId());
            personUserDO.setGmtUpdate(s);
            personUserDO.setGmtCreate(s);
            personUserDO.setPersonUserType(Integer.valueOf(0));
            if (null == personUserDO.getSex()) {
                personUserDO.setSex(Integer.valueOf(0));
            }
            personUserDO = EncryptUserInfo.getEncryptPersonUserDO((PersonUserDO)personUserDO);
            this.personUserDao.savePersonUserInfo(personUserDO);
            result.setInfo((Object)true);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        return result;
    }

    @Transactional
    public Result batchSavePersonUserByTemplateFile(ArrayList<ArrayList<String>> fileList) {
        String filename;
        Result result = new Result();
        int excelSize = fileList.size();
        ArrayList<ArrayList> trueList = new ArrayList<ArrayList>();
        ArrayList<ArrayList> falseList = new ArrayList<ArrayList>();
        for (int i = 0; i < fileList.size(); ++i) {
            Result personResult = new PersonParamsCheck().checkPersonParams(fileList.get(i));
            if (personResult.getCode() == 0) {
                trueList.add((ArrayList)personResult.getInfo());
                continue;
            }
            falseList.add((ArrayList)personResult.getInfo());
        }
        ArrayList<SavePersonUserVO> infoList = new ArrayList<SavePersonUserVO>();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < trueList.size(); ++i) {
            ArrayList list;
            SavePersonUserVO personUser = ToPersonUserVO.format((List)((List)trueList.get(i)));
            String licenseNumber = personUser.getLicenseNumber();
            Integer licenseType = personUser.getLicenseType();
            String s = licenseNumber + licenseType.toString();
            int queryUser = 0;
            String systemName = personUser.getSystemName();
            int systemFlagSize = 1;
            String systemFlag = null;
            if (StringUtils.isBlank((CharSequence)systemName) || "RA".equals(systemName)) {
                systemFlag = "RA";
            } else {
                if ("V2X".equals(systemName)) {
                    systemFlag = "V2X";
                } else {
                    systemFlagSize = this.baseUserDao.querySystemName(systemName);
                    if (systemFlagSize != 0) {
                        systemFlag = this.baseUserDao.getSystemFlagByName(systemName);
                    }
                }
                s = s + systemFlag;
            }
            personUser.setSystemFlag(systemFlag);
            if (null != systemFlag) {
                try {
                    queryUser = this.baseUserService.queryUserExist(licenseType, licenseNumber, Integer.valueOf(UserTypeEnum.PERSON_USER.id), systemFlag);
                }
                catch (Exception e) {
                    this.logger.info("\u67e5\u8be2\u5df2\u6ce8\u518c\u4e2a\u4eba\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
                    result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return result;
                }
            }
            if (!hashSet.contains(s)) {
                hashSet.add(s);
                if (queryUser == 0 && systemFlagSize == 1) {
                    infoList.add(personUser);
                    continue;
                }
                list = (ArrayList)trueList.get(i);
                falseList.add(list);
                if (queryUser > 0 && systemFlagSize != 1) {
                    list.add("\u4e2a\u4eba\u7528\u6237\u8bc1\u4ef6\u53f7\u7801\u5df2\u5b58\u5728\uff0c\u6240\u5c5e\u7cfb\u7edf\u4e0d\u5b58\u5728");
                    continue;
                }
                if (queryUser > 0) {
                    list.add("\u4e2a\u4eba\u7528\u6237\u8bc1\u4ef6\u53f7\u7801\u5df2\u5b58\u5728");
                    continue;
                }
                list.add("\u6240\u5c5e\u7cfb\u7edf\u4e0d\u5b58\u5728");
                continue;
            }
            list = (ArrayList)trueList.get(i);
            list.add("\u672c\u5730\u4e0a\u4f20\u4e2a\u4eba\u7528\u6237\u91cd\u590d");
            falseList.add(list);
        }
        this.addBatchSuccessInfo(infoList);
        if (excelSize != infoList.size()) {
            Result name = null;
            try {
                name = ErrorExcel.generateExcel((String)PathConstants.BATCH_REGISTER_FILE_PATH, (String)"person_user_batch_register_error_template", falseList);
            }
            catch (IOException e) {
                result.setError(ErrorEnum.UPDATE_ERROR_EXCEL_IS_ERROR);
                this.logger.info("\u751f\u6210\u9519\u8bef\u4fe1\u606f\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                return result;
            }
            filename = (String)name.getInfo();
        } else {
            filename = null;
        }
        BatchResp batchResp = new BatchResp(Integer.valueOf(infoList.size()), Integer.valueOf(falseList.size()), filename);
        result.setLogContent("\uff0c\u6210\u529f\u6761\u6570=" + infoList.size() + "\uff0c\u5931\u8d25\u6761\u6570=" + falseList.size());
        result.setInfo((Object)batchResp);
        return result;
    }

    public Result addBatchSuccessInfo(ArrayList<SavePersonUserVO> list) {
        Result result = new Result();
        for (int i = 0; i < list.size(); ++i) {
            SavePersonUserVO savePersonUserVO = list.get(i);
            PersonUserDTO personUserDTO = new PersonUserDTO();
            BeanUtils.copyProperties((Object)savePersonUserVO, (Object)personUserDTO);
            result = this.saveBatchPersonUser(personUserDTO);
        }
        result.setInfo((Object)true);
        return result;
    }
}

