/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.service.manager.certapply.CertApplyHelperService;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CertApplyHelperServiceImpl
implements CertApplyHelperService {
    private Logger logger = LoggerFactory.getLogger(CertApplyHelperServiceImpl.class);
    @Autowired
    private RaCertDao raCertDao;
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    private UserCertDao userCertDao;

    public Result checkBeforeSaveApplyRecord(String signSn, Integer applyType) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        UserCertDO userCertBaseInfo = this.userCertDao.getUserCertBaseInfo(signSn);
        if (userCertBaseInfo == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        long time = userCertBaseInfo.getFailureTime().getTime() - System.currentTimeMillis();
        if (0 == userCertBaseInfo.getCertStatus() || 2 == userCertBaseInfo.getCertStatus() || 3 == userCertBaseInfo.getCertStatus() || time < 0L) {
            this.logger.info("\u7528\u6237\u8bc1\u4e66\u4e0d\u662f\u6b63\u5e38\u72b6\u6001");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }
        if (applyType.equals(ApplyTypeEnum.UNFREEZE_APPLY.id)) {
            if (4 != userCertBaseInfo.getCertStatus()) {
                this.logger.info("\u7528\u6237\u8bc1\u4e66\u4e0d\u662f\u51bb\u7ed3\u72b6\u6001");
                result.setError(ErrorEnum.USER_CERT_IS_NOT_FREEZE_STATUS);
                return result;
            }
        } else if (1 != userCertBaseInfo.getCertStatus()) {
            this.logger.info("\u7528\u6237\u8bc1\u4e66\u4e0d\u662f\u6b63\u5e38\u72b6\u6001");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }
        HashMap<String, String> dnNameMap = new HashMap<String, String>(4);
        dnNameMap.put("raServiceDnName", raServiceDnName);
        dnNameMap.put("caServiceDnName", caServiceDnName);
        result.setInfo(dnNameMap);
        return result;
    }

    public String getRAServiceDnName() {
        RaCertDO newRaCertInfo = null;
        try {
            newRaCertInfo = this.raCertDao.getNewRaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return null;
        }
        if (newRaCertInfo == null) {
            return null;
        }
        String certInfo = newRaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        return CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
    }

    public String getCAServiceDnName() {
        CaCertDO newCaCertInfo = null;
        try {
            newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return null;
        }
        if (newCaCertInfo == null) {
            return null;
        }
        String certInfo = newCaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        return CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
    }
}

