/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.ca.pkcs7.Pkcs7Utils;
import com.xdja.ca.utils.DnUtil;
import com.xdja.ca.utils.SdkP10Utils;
import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.core.bean.DatabaseTypeEnum;
import com.xdja.pki.core.exception.ServiceException;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.asn1.NISTObjectIdentifiers;
import com.xdja.pki.ra.core.asn1.RsaObjectIdentifiers;
import com.xdja.pki.ra.core.asn1.SM2ObjectIdentifiers;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.DoubleCodeUseEnum;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.CertDnVerifyUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.core.util.cert.KeyStoreUtils;
import com.xdja.pki.ra.core.util.cert.KeyUtils;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.core.util.file.ZipUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.ApplyRecordDao;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.DoubleCodeDao;
import com.xdja.pki.ra.manager.dao.FreezeApplyDao;
import com.xdja.pki.ra.manager.dao.IssueApplyDao;
import com.xdja.pki.ra.manager.dao.RecoveryApplyDao;
import com.xdja.pki.ra.manager.dao.RevokeApplyDao;
import com.xdja.pki.ra.manager.dao.UpdateApplyDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.ApplyRecordDO;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.BksIndexDO;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.DoubleCodeDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.CertApplyDTO;
import com.xdja.pki.ra.manager.dto.FreezeApplyDTO;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import com.xdja.pki.ra.manager.dto.RecoveryApplyDTO;
import com.xdja.pki.ra.manager.dto.RevokeApplyDTO;
import com.xdja.pki.ra.manager.dto.UpdateApplyDTO;
import com.xdja.pki.ra.manager.dto.UserCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.manager.sdk.business.BaseDn;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.manager.sdk.cmp.bean.CertLifeInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.bean.ApplyRecordVO;
import com.xdja.pki.ra.service.manager.certapply.bean.CertApplyResp;
import com.xdja.pki.ra.service.manager.certapply.bean.CertApplyVO;
import com.xdja.pki.ra.service.manager.certapply.thread.CertApplyThread;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.util.OperatorUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.naming.NamingException;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CertApplyServiceImpl
implements CertApplyService {
    private Logger logger = LoggerFactory.getLogger(CertApplyServiceImpl.class);
    @Autowired
    CertApplyDao certApplyDao;
    @Autowired
    ApplyRecordDao applyRecordDao;
    @Autowired
    CertLifeCycleManager certLifeCycleManager;
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    IssueApplyDao issueApplyDao;
    @Autowired
    UpdateApplyDao updateApplyDao;
    @Autowired
    RevokeApplyDao revokeApplyDao;
    @Autowired
    RecoveryApplyDao recoveryApplyDao;
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    UserCertService userCertService;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    DoubleCodeDao doubleCodeDao;
    @Autowired
    FreezeApplyDao freezeApplyDao;
    @Autowired
    SystemService systemService;
    @Autowired
    RaSdkCache raSdkCache;
    @Autowired
    CertTempDao certTempDao;
    @Autowired
    CertTempCache certTempCache;

    public Result updateCertApplyInfo(String certDn, String applyNo, int applyStatus, Long tempId) {
        int updateCertApplyStatusResult;
        Result result = new Result();
        CertApplyDO certApplyInfo = this.certApplyDao.getCertApplyInfo(applyNo);
        if (null == certApplyInfo) {
            this.logger.info("========================\u5f85\u66f4\u65b0\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.UPDATE_CERT_APPLY_INFO_FAIL);
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)certDn)) {
            certApplyInfo.setCertDn(certDn == null ? certApplyInfo.getCertDn() : certDn);
        }
        certApplyInfo.setApplyStatus(Integer.valueOf(applyStatus));
        certApplyInfo.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        if (tempId != null) {
            certApplyInfo.setTempId(tempId);
        }
        if ((updateCertApplyStatusResult = this.certApplyDao.updateCertApply(certApplyInfo)) <= 0) {
            this.logger.info("\u66f4\u65b0\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.UPDATE_CERT_APPLY_INFO_FAIL);
            return result;
        }
        return result;
    }

    public Result insertCertApplyRecordScep(int applyType, int operateType, String applyNo, String adminCertDn, int applyStatus, String desc, int operateResultType, boolean isAuto, boolean isOnlineIssue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u8bb0\u5f55\u7533\u8bf7\u64cd\u4f5c\u548c\u7ed3\u679c\u5230apply_record\u8868\u4e2d applyNo:[{}]", (Object)applyNo);
        }
        Result result = new Result();
        ApplyRecordDO applyRecordDO = new ApplyRecordDO();
        applyRecordDO.setAdminId(Long.valueOf(0L));
        applyRecordDO.setAdminCertDn(adminCertDn);
        if (isAuto) {
            applyRecordDO.setAdminId(Long.valueOf(0L));
            applyRecordDO.setAdminCertDn("\u81ea\u52a8\u5ba1\u6838");
        }
        applyRecordDO.setApplyNo(applyNo);
        applyRecordDO.setOperateType(Integer.valueOf(operateType));
        applyRecordDO.setApplyType(Integer.valueOf(applyType));
        applyRecordDO.setApplyStatus(Integer.valueOf(applyStatus));
        applyRecordDO.setOperateResult(Integer.valueOf(operateResultType));
        applyRecordDO.setRemark(desc == null ? "" : desc);
        applyRecordDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        applyRecordDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        try {
            this.applyRecordDao.addApplyRecord(applyRecordDO);
        }
        catch (Exception e) {
            this.logger.error("applyNo{}\uff0c\u8bb0\u5f55\u7533\u8bf7\u64cd\u4f5c\u5f02\u5e38{}", (Object)applyNo, (Object)e.getMessage());
        }
        return result;
    }

    public Result insertCertApplyRecord(int applyType, int operateType, String applyNo, String systemFlag, int applyStatus, String desc, int operateResultType, boolean isAuto, boolean isOnlineIssue) {
        Result result = new Result();
        ApplyRecordDO applyRecordDO = new ApplyRecordDO();
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            long adminId = currentAdminInfo.getId();
            String adminCertDn = currentAdminInfo.getCertDn();
            applyRecordDO.setAdminId(Long.valueOf(adminId));
            applyRecordDO.setAdminCertDn(adminCertDn);
        } else {
            applyRecordDO.setAdminId(Long.valueOf(0L));
            String dn = null;
            if ("V2X" == systemFlag || StringUtils.isBlank((CharSequence)systemFlag)) {
                dn = "V2X";
            } else {
                try {
                    dn = this.certApplyDao.getSystemCertDn(systemFlag);
                }
                catch (DataAccessException e) {
                    this.logger.info("\u901a\u8fc7\u5728\u7ebf\u7b7e\u53d1\u7cfb\u7edf\u6807\u8bc6\u672a\u83b7\u53d6\u5230\u7cfb\u7edf\u8bc1\u4e66\u4e3b\u4f53\u8ba4\u5b9a\u4e3aV2X");
                    dn = "V2X";
                }
                if (StringUtils.isBlank((CharSequence)dn)) {
                    dn = "V2X";
                }
            }
            applyRecordDO.setAdminCertDn(dn);
        }
        if (isAuto) {
            applyRecordDO.setAdminId(Long.valueOf(0L));
            applyRecordDO.setAdminCertDn("\u81ea\u52a8\u5ba1\u6838");
        }
        applyRecordDO.setApplyNo(applyNo);
        applyRecordDO.setOperateType(Integer.valueOf(operateType));
        applyRecordDO.setApplyType(Integer.valueOf(applyType));
        applyRecordDO.setApplyStatus(Integer.valueOf(applyStatus));
        applyRecordDO.setOperateResult(Integer.valueOf(operateResultType));
        applyRecordDO.setRemark(desc == null ? "" : desc);
        applyRecordDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        applyRecordDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        try {
            this.applyRecordDao.addApplyRecord(applyRecordDO);
        }
        catch (Exception e) {
            this.logger.error("applyNo{}\uff0c\u8bb0\u5f55\u7533\u8bf7\u64cd\u4f5c\u5f02\u5e38{}", (Object)applyNo, (Object)e.getMessage());
        }
        return result;
    }

    @Deprecated
    public Result updateCertApplyStatus(int applyType, int operateType, String applyNo, int applyStatus, String desc, int operateResultType) {
        Result result = new Result();
        Operator operator = OperatorUtil.getOperator();
        if (operator == null || operator.getCurrUser() == null) {
            result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
            return result;
        }
        CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
        long adminId = currentAdminInfo.getId();
        String adminCertDn = currentAdminInfo.getCertDn();
        ApplyRecordDO applyRecordDO = new ApplyRecordDO();
        applyRecordDO.setApplyNo(applyNo);
        applyRecordDO.setOperateType(Integer.valueOf(operateType));
        applyRecordDO.setApplyType(Integer.valueOf(applyType));
        applyRecordDO.setApplyStatus(Integer.valueOf(applyStatus));
        applyRecordDO.setAdminId(Long.valueOf(adminId));
        applyRecordDO.setAdminCertDn(adminCertDn);
        applyRecordDO.setOperateResult(Integer.valueOf(operateResultType));
        applyRecordDO.setRemark(desc);
        applyRecordDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        applyRecordDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        ApplyRecordDO applyRecordResult = this.applyRecordDao.addApplyRecord(applyRecordDO);
        if (applyRecordResult == null) {
            this.logger.info("\u6dfb\u52a0\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_APPLY_RECORD_FAIL);
            throw new RuntimeException();
        }
        return result;
    }

    public Result listUserApply(String userCA, String userName, int userType, int applyStatus, int pageNo, int pageSize, String startTime, String endTime) {
        CertApplyResp certApplyResp = new CertApplyResp();
        Result result = new Result();
        PageInfo certApplyDTOPageInfo = this.certApplyDao.listPageUserCert(userCA, userName, userType, applyStatus, pageNo, pageSize, startTime, endTime);
        if (certApplyDTOPageInfo == null) {
            result.setError(ErrorEnum.QUERY_CERT_APPLY_LIST_ERROR);
            return result;
        }
        ArrayList<CertApplyVO> certApplyVOList = new ArrayList<CertApplyVO>();
        List certApplyDTOList = certApplyDTOPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)certApplyDTOList)) {
            certApplyResp.setRecordCount(0);
            certApplyResp.setPageCount(0);
            certApplyResp.setDatas(certApplyVOList);
            result.setInfo((Object)certApplyResp);
            return result;
        }
        for (CertApplyDTO certApplyDTO : certApplyDTOList) {
            CertApplyVO certApplyVO = new CertApplyVO();
            BeanUtils.copyProperties((Object)certApplyDTO, (Object)certApplyVO);
            UserCertDTO certListInfo = this.userCertDao.getCertListInfo(certApplyDTO.getSystemFlag(), certApplyDTO.getTempId());
            certApplyVO.setSystemName(certListInfo.getSystemName());
            certApplyVO.setCertPatterm(certListInfo.getCertPatterm());
            certApplyVO.setTempNo(certListInfo.getTempNo());
            certApplyVO.setUserCA(certListInfo.getUserCA());
            Timestamp gmtCreate = certApplyDTO.getGmtCreate();
            certApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
            certApplyVOList.add(certApplyVO);
        }
        certApplyResp.setDatas(certApplyVOList);
        certApplyResp.setPageCount(certApplyDTOPageInfo.getPageCount());
        certApplyResp.setRecordCount(certApplyDTOPageInfo.getRecordCount());
        result.setInfo((Object)certApplyResp);
        return result;
    }

    public Result verifyUserCertApplyDn(String certDn) {
        Result result = new Result();
        X500Name x500Name = null;
        try {
            Result checkResult;
            x500Name = DnUtil.getRFC4519X500Name((String)certDn);
            String certDnFormat = x500Name.toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u683c\u5f0f\u5316\u4e4b\u540e\u7684\u7533\u8bf7DN:{}", (Object)certDnFormat);
            }
            if (!(checkResult = CertDnVerifyUtils.checkDn((X500Name)x500Name)).isSuccess()) {
                result.setError(checkResult.getError());
                return result;
            }
            checkResult = CertDnVerifyUtils.checkCertDnSort((X500Name)x500Name);
            if (!checkResult.isSuccess()) {
                this.logger.error("\u8bc1\u4e66\u7684DN\u7684\u7c7b\u578b\u5148\u540e\u987a\u5e8f\u6709\u8bef:{}", (Object)JsonUtils.object2Json((Object)checkResult.getError()));
                result.setError(checkResult.getError());
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("certDn\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        return result;
    }

    public Result verifyUserCertApplyDn(String certDn, long userId, String applyNo) {
        Result result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u8bc1\u4e66DN\u7684\u6821\u9a8c\u89c4\u5219,certDn:[{}] userId:[{}] applyNo:[{}]", new Object[]{certDn, userId, applyNo});
        }
        if (!(result = this.verifyUserCertApplyDn(certDn)).isSuccess()) {
            return result;
        }
        int userCertByUserIdAndCertDN = this.userCertDao.getUserCertByUserIdAndCertDN(certDn, userId);
        if (userCertByUserIdAndCertDN >= 1) {
            this.logger.error("\u6709\u591a\u4e2a\u7684\u8bc1\u4e66\u7684DN\u4fe1\u606f\u540c[{}]\u4e00\u81f4", (Object)certDn);
            result.setError(ErrorEnum.USER_CERT_DN_HAVE_SAME_APPLY_CERT_DN);
            return result;
        }
        int count = this.certApplyDao.getCertApplyCountByCertDn(certDn, userId);
        if (count >= 1) {
            String applyCertDn;
            if (StringUtils.isNotBlank((CharSequence)applyNo) && certDn.equalsIgnoreCase(applyCertDn = this.certApplyDao.getCertDnByApplyNo(applyNo))) {
                return result;
            }
            this.logger.error("\u5df2\u5b58\u5728\u76f8\u540c\u8bc1\u4e66\u4e3b\u4f53\u7684\u7528\u6237\u7533\u8bf7:{}", (Object)certDn);
            result.setError(ErrorEnum.CERT_APPLY_CERT_DN_IS_EXIST);
            return result;
        }
        return result;
    }

    public Result verifyUserCertApply(String signSn, int applyType) {
        int unClosedFreezeApplyNum;
        Result result = new Result();
        if (applyType == 2) {
            int unClosedApplyNum = this.updateApplyDao.getUnClosedUpdateApplyNum(signSn);
            if (unClosedApplyNum > 0) {
                result.setError(ErrorEnum.SIGN_SN_HAS_UPDATE_APPLY_NOT_CLOSED);
                return result;
            }
        } else if (applyType == 3) {
            int unClosedRevokeApplyNum = this.revokeApplyDao.getUnClosedRevokeApplyNum(signSn);
            if (unClosedRevokeApplyNum > 0) {
                result.setError(ErrorEnum.SIGN_SN_HAS_REVOKE_APPLY_NOT_CLOSED);
                return result;
            }
        } else if (applyType == 4) {
            int unClosedRecoveryApplyNum = this.recoveryApplyDao.getUnClosedRecoveryApplyNum(signSn);
            if (unClosedRecoveryApplyNum > 0) {
                result.setError(ErrorEnum.SIGN_SN_HAS_RECOVERY_APPLY_NOT_CLOSED);
                return result;
            }
            UserCertDO userCertDO = this.userCertDao.getUserCertBaseInfoBySignSn(signSn);
            if (userCertDO.getCertType() == 1) {
                this.logger.info("\u5355\u8bc1\u4e0d\u652f\u6301\u5bc6\u94a5\u6062\u590d");
                result.setError(ErrorEnum.SINGLE_CERT_NOT_RECOVERY_APPLY);
                return result;
            }
        } else if ((applyType == 5 || applyType == 6) && (unClosedFreezeApplyNum = this.freezeApplyDao.getUnClosedFreezeApplyNum(signSn)) > 0) {
            this.logger.info("\u8be5sn\u5df2\u5b58\u5728\u672a\u7ed3\u675f\u7684\u51bb\u7ed3\u89e3\u51bb\u7533\u8bf7");
            result.setError(ErrorEnum.SIGN_SN_HAS_FREEZE_APPLY_NOT_CLOSED);
            return result;
        }
        return result;
    }

    @Transactional
    public Result issueCert(String systemFlag, IssueApplyDTO issueApplyDTO, byte[] issueBytes, String adminCertDn) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("systemFlag:[{}]", (Object)systemFlag);
        }
        Result result = new Result();
        Integer applyType = 1;
        String applyNo = issueApplyDTO.getApplyNo();
        String raDN = this.getRAServiceDnName();
        String caDN = this.getCAServiceDnName();
        String raTransId = this.raSdkCache.getIncCaCmpTransId();
        this.raSdkCache.cacheCaTransId(applyNo, raTransId);
        Result issueResult = this.certLifeCycleManager.issueUserCert(applyNo, null, issueBytes, raDN, caDN, raTransId, issueApplyDTO.getTempNo(), issueApplyDTO.getTempParas(), issueApplyDTO.getSignAlg(), issueApplyDTO.getCertValidity().intValue(), issueApplyDTO.getCertDn(), null);
        if (!issueResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(issueApplyDTO.getCertDn(), applyNo, 4, issueApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new RuntimeException();
            }
            if (!systemFlag.equals("V2X")) {
                this.certApplyService.insertCertApplyRecordScep(applyType.intValue(), 5, applyNo, adminCertDn, 4, issueResult.getErrorBean().getErrMsg(), 7, false, true);
            } else {
                this.certApplyService.insertCertApplyRecord(applyType.intValue(), 5, applyNo, systemFlag, 4, issueResult.getErrorBean().getErrMsg(), 7, false, true);
            }
            this.logger.error("\u8c03\u7528CA\uff0c\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25:{} ", (Object)issueResult.getErrorBean().getErrMsg());
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)issueResult.getInfo();
        Result certInsertResult = this.insertUserCertInfo(issueApplyDTO.getUserId(), issueApplyDTO.getApplyId(), issueApplyDTO.getTempId(), issueApplyDTO.getTempNo(), issueApplyDTO.getSignAlg(), issueApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.setError(certInsertResult.getError());
            return result;
        }
        result.setInfo((Object)userCertInfo);
        return result;
    }

    public Result updateCert(UpdateApplyDTO updateApplyDTO, byte[] issueBytes) {
        Result result = new Result();
        Integer applyType = 2;
        String applyNo = updateApplyDTO.getApplyNo();
        String raDN = this.getRAServiceDnName();
        String caDN = this.getCAServiceDnName();
        String raTransId = this.raSdkCache.getIncCaCmpTransId();
        this.raSdkCache.cacheCaTransId(applyNo, raTransId);
        byte[] publicKeyByte = null;
        if (updateApplyDTO.getUpdateKey().booleanValue()) {
            if (issueBytes == null) {
                this.logger.info("\u66f4\u65b0\u5bc6\u94a5\u65f6\uff0c\u5fc5\u987b\u4e0a\u4f20p10\u6587\u4ef6");
                result.setError(ErrorEnum.UPDATE_KEY_NEED_P10_FILE);
                return result;
            }
            this.logger.info("\u5728\u7ebf\u66f4\u65b0\u7533\u8bf7\u66f4\u65b0\u79d8\u94a5");
            publicKeyByte = issueBytes;
        } else {
            this.logger.info("\u5728\u7ebf\u66f4\u65b0\u7533\u8bf7\u4e0d\u66f4\u65b0\u79d8\u94a5");
            publicKeyByte = null;
        }
        String userCertDN = updateApplyDTO.getCertDn();
        Result updateResult = this.certLifeCycleManager.updateUserCert(applyNo, null, publicKeyByte, raDN, caDN, raTransId, updateApplyDTO.getTempNo(), updateApplyDTO.getTempParas(), updateApplyDTO.getSignAlg(), updateApplyDTO.getCertValidity().intValue(), userCertDN, updateApplyDTO.getSignSn(), updateApplyDTO.getUpdateKey().booleanValue(), null);
        if (!updateResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(updateApplyDTO.getCertDn(), applyNo, 4, updateApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new ServiceException("\u8bc1\u4e66\u66f4\u65b0\u5931\u8d25");
            }
            this.certApplyService.insertCertApplyRecord(applyType.intValue(), 5, applyNo, null, 4, updateApplyDTO.getApplyReason(), 7, false, true);
            this.logger.info("\u8c03\u7528CA\uff0c\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25 ");
            result.setErrorBean(updateResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)updateResult.getInfo();
        Result certInsertResult = this.insertUserCertInfo(updateApplyDTO.getUserId(), updateApplyDTO.getApplyId(), updateApplyDTO.getTempId(), updateApplyDTO.getTempNo(), updateApplyDTO.getSignAlg(), updateApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            throw new ServiceException("\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
        }
        result.setInfo((Object)userCertInfo);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result issueUserCert(Integer index, String password, Integer certFormatType, int applyType, String applyNo, String systemFlag, String cardNo, byte[] issueBytes, int issueType, boolean isOnlineIssue, boolean isTboxIssue, Map<String, Object> extParam, Integer keyFormat) {
        String raServiceDnName;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("certApplyCarry applyType:[{}] applyNo:[{}]", (Object)applyType, (Object)applyNo);
        }
        Result result = new Result();
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                this.logger.warn("[CertApplyServiceImpl#issueUserCert] applyNo:{} can't find current login admin", (Object)applyNo);
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(5)) {
                this.logger.warn("[CertApplyServiceImpl#issueUserCert]applyNo:{}current login admin role is error", (Object)applyNo);
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }
        if (StringUtils.isBlank((CharSequence)(raServiceDnName = this.getRAServiceDnName()))) {
            this.logger.info("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            this.logger.info("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        CertApplyDO certApplyInfo = this.certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyInfo == null) {
            this.logger.info("\u4e0d\u5b58\u5728\u5f53\u524d\u7533\u8bf7\u7f16\u53f7\u5bf9\u5e94\u7684\u7533\u8bf7\u8bb0\u5f55 applyNo:{}", (Object)applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }
        if ("RSA".equalsIgnoreCase(CommonVariable.getKeyAlgName()) && Constants.KEY_FORMAT_0016_2.equals(keyFormat)) {
            this.logger.info("RSA\u7b97\u6cd5\u4e0d\u63d0\u4f9b0016\u7684\u79c1\u94a5\u683c\u5f0f keyAlgName:{}", (Object)CommonVariable.getKeyAlgName());
            result.setError(ErrorEnum.RSA_ALG_CANNOT_BUILD_0016_KEY_FORMAT);
            return result;
        }
        result.setLogContent("\uff0c\u8bc1\u4e66\u4e3b\u4f53=" + certApplyInfo.getCertDn());
        int applyStatus = certApplyInfo.getApplyStatus();
        if (3 != applyStatus) {
            this.logger.info("\u5f53\u524d\u7533\u8bf7\u72b6\u6001\u4e0d\u53ef\u53d1\u8d77\u7b7e\u53d1 applyStatus:{}", (Object)applyStatus);
            result.setError(ErrorEnum.APPLY_STATUS_NOT_SUPPORT_ISSUE_CERT);
            return result;
        }
        String raTransId = this.raSdkCache.getIncCaCmpTransId();
        this.raSdkCache.cacheCaTransId(applyNo, raTransId);
        String oldCertSignSn = null;
        if (applyType == 1) {
            Result issueApplyResult = this.issueApplyHandler(certFormatType, applyNo, systemFlag, cardNo, issueBytes, raServiceDnName, caServiceDnName, raTransId, issueType, isOnlineIssue, isTboxIssue, extParam, keyFormat);
            if (!issueApplyResult.isSuccess()) {
                this.logger.info("\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u5904\u7406\u5931\u8d25");
                result.setErrorBean(issueApplyResult.getErrorBean());
                return result;
            }
            result.setInfo(issueApplyResult.getInfo());
        } else if (applyType == 2) {
            Result updateApplyResult = this.updateApplyHandler(certFormatType, applyNo, systemFlag, cardNo, issueBytes, raServiceDnName, caServiceDnName, raTransId, issueType, isOnlineIssue, isTboxIssue, extParam, keyFormat);
            if (!updateApplyResult.isSuccess()) {
                this.logger.info("\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u5904\u7406\u5931\u8d25");
                result.setErrorBean(updateApplyResult.getErrorBean());
                return result;
            }
            result.setInfo(updateApplyResult.getInfo());
            UpdateApplyDTO updateApplyDTO = this.updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
            oldCertSignSn = updateApplyDTO.getSignSn();
        } else if (applyType == 4) {
            Result recoveryApplyResult = this.recoveryApplyHandler(certFormatType, applyNo, systemFlag, cardNo, issueBytes, raServiceDnName, caServiceDnName, raTransId, issueType, isOnlineIssue, keyFormat);
            if (!recoveryApplyResult.isSuccess()) {
                this.logger.info("\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u5904\u7406\u5931\u8d25");
                result.setErrorBean(recoveryApplyResult.getErrorBean());
                return result;
            }
            result.setInfo(recoveryApplyResult.getInfo());
            RecoveryApplyDTO recoveryApplyDTO = this.recoveryApplyDao.getRecoveryApplyInfoByApplyNo(applyNo);
            oldCertSignSn = recoveryApplyDTO.getSignSn();
        }
        this.logger.info("UserCertInfo>>>>>>result:{}", (Object)JsonUtils.object2Json((Object)result));
        UserCertInfo certInfo = (UserCertInfo)result.getInfo();
        if (issueType == 1 || isOnlineIssue) {
            result.setInfo((Object)certInfo);
            return result;
        }
        Integer certPatterm = null;
        try {
            certPatterm = this.certApplyDao.getCertPatterm(applyNo);
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        ArrayList list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)certInfo.getEncPriKey())) {
            HashMap<String, Object> priKeyMap = new HashMap<String, Object>();
            priKeyMap.put("name", "EncPrivateKey");
            priKeyMap.put("suffix", "pem");
            byte[] priKeyByte = certInfo.getEncPriKey().getBytes();
            priKeyMap.put("buffer", priKeyByte);
            list.add(priKeyMap);
        }
        String extraCertsP7b = certInfo.getExtraCertsP7b();
        if (certFormatType == 4) {
            HashMap<String, Object> signMap = new HashMap<String, Object>();
            signMap.put("name", "UserCert");
            if (certPatterm != 1) {
                HashMap<String, Object> encMap = new HashMap<String, Object>();
                encMap.put("name", "EncCert");
                encMap.put("suffix", "p7b");
                byte[] encByte = certInfo.getEncCert().getBytes();
                encMap.put("buffer", encByte);
                list.add(encMap);
                signMap.put("name", "SignCert");
            }
            signMap.put("suffix", "p7b");
            byte[] signByte = certInfo.getSignCert().getBytes();
            signMap.put("buffer", signByte);
            list.add(signMap);
            HashMap<String, Object> caCertMap = new HashMap<String, Object>();
            caCertMap.put("name", "CACert");
            caCertMap.put("suffix", "p7b");
            byte[] caByte = extraCertsP7b.getBytes();
            caCertMap.put("buffer", caByte);
            list.add(caCertMap);
        } else {
            OutputStream oS = null;
            OutputStream caOS = null;
            try {
                if (index == null) {
                    BksIndexDO bksIndexDO = this.certApplyDao.getBksIndex(oldCertSignSn);
                    if (null != bksIndexDO) {
                        index = bksIndexDO.getBksIndex();
                        password = bksIndexDO.getBksPassword();
                        password = HsmUtils.getDecrypt((String)password);
                    } else {
                        String path = PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + oldCertSignSn + "/index.txt";
                        String indexAndPassword = FileUtils.read((String)path);
                        String[] split = indexAndPassword.split("-");
                        index = Integer.valueOf(split[0]);
                        if (split.length == 2) {
                            password = split[1];
                            password = HsmUtils.getDecrypt((String)password);
                        } else {
                            password = null;
                        }
                    }
                }
                X509Certificate signCert = CertUtils.getCertFromStr((String)certInfo.getSignCert());
                String signSn = signCert.getSerialNumber().toString(16).toLowerCase();
                HashMap<String, Object> caCertMap = new HashMap<String, Object>();
                caCertMap.put("name", "CACert");
                caCertMap.put("suffix", "p7b");
                caCertMap.put("buffer", extraCertsP7b.getBytes());
                list.add(caCertMap);
                if (certPatterm != 1) {
                    SdfPrivateKey sdfPrivateKey;
                    HashMap<String, Object> encCertMap = new HashMap<String, Object>();
                    encCertMap.put("name", "EncCert");
                    encCertMap.put("suffix", "cer");
                    encCertMap.put("buffer", certInfo.getEncCert().getBytes());
                    list.add(encCertMap);
                    X509Certificate encCert = CertUtils.getCertFromStr((String)certInfo.getEncCert());
                    if (StringUtils.isNotBlank((CharSequence)password)) {
                        sdfPrivateKey = new SdfPrivateKey(index.intValue(), password.getBytes());
                    } else {
                        sdfPrivateKey = new SdfPrivateKey(index.intValue());
                        password = "";
                    }
                    File file = new File(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + applyNo);
                    if (file.exists() && !file.delete()) {
                        result.setError(ErrorEnum.USE_HSM_GENERATE_BKS_KEYSTORE_ERROR);
                        Result result2 = result;
                        return result2;
                    }
                    if (!file.mkdirs()) {
                        result.setError(ErrorEnum.USE_HSM_GENERATE_BKS_KEYSTORE_ERROR);
                        Result result3 = result;
                        return result3;
                    }
                    String keyPwd = KeyStoreUtils.getStringRandom((int)8);
                    List trustCerts = Pkcs7Utils.resolveCertChain((String)extraCertsP7b);
                    KeyStore keyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType((String)keyPwd, (List)trustCerts, (String)(applyNo + "_sign"), (PrivateKey)sdfPrivateKey, (X509Certificate)signCert, (String)(applyNo + "_enc"), (PrivateKey)sdfPrivateKey, (X509Certificate)encCert, (String)"BKS");
                    oS = new FileOutputStream(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + applyNo + "/signAndEncCert_" + keyPwd + ".bks");
                    keyStore.store(oS, keyPwd.toCharArray());
                    oS.close();
                    HashMap<String, Object> signAndEncMap = new HashMap<String, Object>();
                    signAndEncMap.put("name", "signAndEncCert_" + keyPwd);
                    signAndEncMap.put("suffix", "bks");
                    signAndEncMap.put("buffer", FileUtils.readByBinary((String)(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + applyNo + "/signAndEncCert_" + keyPwd + ".bks")));
                    list.add(signAndEncMap);
                    X509Certificate[] rootCACerts = trustCerts.toArray(new X509Certificate[trustCerts.size()]);
                    KeyStore keyStoreCA = GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithBKS((X509Certificate[])rootCACerts);
                    if (null == keyStoreCA) {
                        result.setError(ErrorEnum.USE_HSM_GENERATE_BKS_KEYSTORE_ERROR);
                        Result result4 = result;
                        return result4;
                    }
                    String caPwd = KeyStoreUtils.getStringRandom((int)8);
                    caOS = new FileOutputStream(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + applyNo + "/ca_" + caPwd + ".bks");
                    keyStoreCA.store(caOS, caPwd.toCharArray());
                    caOS.close();
                    HashMap<String, Object> caRootMap = new HashMap<String, Object>();
                    caRootMap.put("name", "ca_" + caPwd);
                    caRootMap.put("suffix", "bks");
                    caRootMap.put("buffer", FileUtils.readByBinary((String)(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + applyNo + "/ca_" + caPwd + ".bks")));
                    list.add(caRootMap);
                    FileUtils.deleteFile((File)new File(PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "/" + applyNo));
                    BksIndexDO bksIndexDO = new BksIndexDO();
                    bksIndexDO.setBksIndex(index);
                    if (Constants.DATA_IS_ENCRYPTION_1.equals(CommonVariable.getIsEncrypt())) {
                        password = HsmUtils.getEncrypt((String)password);
                    }
                    bksIndexDO.setBksPassword(password);
                    bksIndexDO.setSignSn(signSn);
                    bksIndexDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
                    bksIndexDO.setGmtModified(new Timestamp(System.currentTimeMillis()));
                    this.certApplyDao.insertBksIndex(bksIndexDO);
                }
            }
            catch (Exception e) {
                this.logger.error("\u4f7f\u7528\u5bc6\u7801\u673a\u751f\u6210keyStore\u5931\u8d25", (Throwable)e);
                result.setError(ErrorEnum.USE_HSM_GENERATE_BKS_KEYSTORE_ERROR);
                Result result5 = result;
                return result5;
            }
            finally {
                try {
                    if (null != oS) {
                        oS.close();
                    }
                    if (null != caOS) {
                        caOS.close();
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        result.setInfo(list);
        return result;
    }

    public Result issueUserCertByKeyStore(int certFormatType, String applyNo, int applyType, boolean isOnlineIssue, Integer keyFormat) {
        Result updateApplyResult;
        String raServiceDnName;
        Result result = new Result();
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(5)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }
        if (StringUtils.isBlank((CharSequence)(raServiceDnName = this.getRAServiceDnName()))) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        CertApplyDO certApplyInfo = this.certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyInfo == null) {
            this.logger.info("\u4e0d\u5b58\u5728\u5f53\u524d\u7533\u8bf7\u7f16\u53f7\u5bf9\u5e94\u7684\u7533\u8bf7\u8bb0\u5f55 applyNo:" + applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }
        result.setLogContent("\uff0c\u8bc1\u4e66\u4e3b\u4f53=" + certApplyInfo.getCertDn());
        int applyStatus = certApplyInfo.getApplyStatus();
        if (3 != applyStatus) {
            this.logger.info("\u5f53\u524d\u7533\u8bf7\u72b6\u6001\u4e0d\u53ef\u53d1\u8d77\u7b7e\u53d1 applyStatus:" + applyStatus);
            result.setError(ErrorEnum.APPLY_STATUS_NOT_SUPPORT_ISSUE_CERT);
            return result;
        }
        String raTransId = this.raSdkCache.getIncCaCmpTransId();
        this.raSdkCache.cacheCaTransId(applyNo, raTransId);
        if (applyType == 1) {
            Result issueApplyResult = this.issueApplyHandlerByKeyStore(applyNo, raServiceDnName, caServiceDnName, raTransId, certFormatType, isOnlineIssue, keyFormat);
            if (!issueApplyResult.isSuccess()) {
                this.logger.info("\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u5904\u7406\u5931\u8d25");
                result.setErrorBean(issueApplyResult.getErrorBean());
                return result;
            }
            result.setInfo(issueApplyResult.getInfo());
        } else if (applyType == 2) {
            updateApplyResult = this.updateApplyHandlerByKeyStore(applyNo, raServiceDnName, caServiceDnName, raTransId, certFormatType, isOnlineIssue, keyFormat);
            if (!updateApplyResult.isSuccess()) {
                this.logger.info("\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u5904\u7406\u5931\u8d25");
                result.setErrorBean(updateApplyResult.getErrorBean());
                return result;
            }
            result.setInfo(updateApplyResult.getInfo());
        } else if (applyType == 4) {
            updateApplyResult = this.recoveryApplyHandlerByKeyStore(applyNo, raServiceDnName, caServiceDnName, raTransId, certFormatType, isOnlineIssue, keyFormat);
            if (!updateApplyResult.isSuccess()) {
                this.logger.info("\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u5904\u7406\u5931\u8d25");
                result.setErrorBean(updateApplyResult.getErrorBean());
                return result;
            }
            result.setInfo(updateApplyResult.getInfo());
        }
        Integer certPatterm = null;
        try {
            certPatterm = this.certApplyDao.getCertPatterm(applyNo);
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        Map keyStores = (Map)result.getInfo();
        String suffix = "jks";
        if (certFormatType == 1) {
            suffix = "p12";
        } else if (certFormatType == 2) {
            suffix = "jks";
        } else if (certFormatType == 3) {
            suffix = "bks";
        }
        ArrayList list = new ArrayList();
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("name", "UserCert_" + new String((byte[])keyStores.get("signStorePwd")));
        if (certPatterm != 1) {
            HashMap<String, Object> encMap = new HashMap<String, Object>();
            encMap.put("name", "EncCert_" + new String((byte[])keyStores.get("encStorePwd")));
            encMap.put("suffix", suffix);
            byte[] encByte = (byte[])keyStores.get("encStore");
            encMap.put("buffer", encByte);
            list.add(encMap);
            HashMap<String, Object> andMap = new HashMap<String, Object>();
            andMap.put("name", "signAndEncCert_" + new String((byte[])keyStores.get("signAndEncPwd")));
            andMap.put("suffix", suffix);
            byte[] andByte = (byte[])keyStores.get("signAndEncStore");
            andMap.put("buffer", andByte);
            list.add(andMap);
            signMap.put("name", "SignCert_" + new String((byte[])keyStores.get("signStorePwd")));
        }
        signMap.put("suffix", suffix);
        byte[] signByte = (byte[])keyStores.get("signStore");
        signMap.put("buffer", signByte);
        list.add(signMap);
        HashMap<String, String> caCertMap = new HashMap<String, String>();
        caCertMap.put("name", "CACert");
        caCertMap.put("suffix", "p7b");
        caCertMap.put("buffer", (String)keyStores.get("caCert"));
        list.add(caCertMap);
        HashMap<String, Object> caCertMap2 = new HashMap<String, Object>();
        caCertMap2.put("name", "ca_" + new String((byte[])keyStores.get("caPwd")));
        caCertMap2.put("suffix", suffix);
        byte[] caByte = (byte[])keyStores.get("keyStoreCA");
        caCertMap2.put("buffer", caByte);
        list.add(caCertMap2);
        result.setInfo(list);
        return result;
    }

    public Result issueUserCertBatch(String applyIds) {
        StringBuilder logContent;
        Result result = new Result();
        String path = PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "userCertBatch/";
        File file1 = new File(path);
        if (file1.exists()) {
            FileUtils.deleteFile((File)file1);
        }
        if (!file1.mkdirs()) {
            this.logger.error("\u521b\u5efa\u6587\u4ef6\u76ee\u5f55\u5931\u8d25");
        }
        ExecutorService executorService = DatabaseTypeEnum.MYSQL.type == Constants.SYSTEM_DATABASE_TYPE ? Executors.newWorkStealingPool() : Executors.newSingleThreadExecutor();
        ArrayList<Future<Result>> listFuture = new ArrayList<Future<Result>>();
        int success = 0;
        String[] ids = applyIds.split(",");
        for (int i = 0; i < ids.length; ++i) {
            Long l = Long.valueOf(ids[i]);
            CertApplyThread certApplyThread = new CertApplyThread(l);
            Result resultFuture = new Result();
            Future<Result> submit = executorService.submit(certApplyThread, resultFuture);
            listFuture.add(submit);
        }
        executorService.shutdown();
        for (Future future : listFuture) {
            try {
                Result submitResult = (Result)future.get();
                boolean isSuccess = submitResult.isSuccess();
                if (!isSuccess) continue;
                ++success;
            }
            catch (Exception e) {
                this.logger.error("\u6279\u91cf\u7b7e\u53d1\u7ebf\u7a0b\u83b7\u53d6\u8fd4\u56de\u503c\u5f02\u5e38 ", (Throwable)e);
            }
        }
        if (success != ids.length) {
            logContent = new StringBuilder("\uff0c\u6210\u529f\u6761\u6570=" + success + "\uff0c\u5931\u8d25\u6761\u6570=" + (ids.length - success));
            result.setCode(-1);
        } else {
            logContent = new StringBuilder("\uff0c\u6210\u529f\u6761\u6570=" + success);
        }
        result.setLogContent(logContent.toString());
        try {
            String string = PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "userCertBatch.zip";
            ZipUtils.doCompress((String)path, (String)string);
            byte[] fileBytes = FileUtils.readByBinary((String)string);
            result.setInfo((Object)fileBytes);
            return result;
        }
        catch (Exception exception) {
            this.logger.error("\u6279\u91cf\u7b7e\u53d1\u8bc1\u4e66\u538b\u7f29\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    public Result issueUserCertBatchOne(Long applyId) {
        int certFormatType = 2;
        int applyType = 1;
        String path = PathConstants.USER_CERT_KEYSTORE_FILE_PATH + "userCertBatch/";
        String applyNo = this.certApplyDao.getCertApplyNo(applyId.longValue());
        Result resultIssue = this.certApplyService.issueUserCertByKeyStore(certFormatType, applyNo, applyType, false, null);
        if (resultIssue.isSuccess()) {
            Result resultResp = this.certApplyService.issueUserCertResp(applyNo, null, false);
            if (resultResp.isSuccess()) {
                List list = (List)resultIssue.getInfo();
                Long userId = this.certApplyDao.getUserIdByApplyNo(applyNo);
                BaseUserDO baseUserInfo = this.baseUserDao.getBaseUserInfo(userId.longValue());
                String file = null;
                try {
                    file = baseUserInfo.getUserType() == 3 ? HsmUtils.getDecrypt((String)baseUserInfo.getLicenseNumber()) : baseUserInfo.getUserName();
                }
                catch (Exception e) {
                    this.logger.error("\u7528\u6237\u4fe1\u606f\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
                }
                for (int j = 0; j < list.size(); ++j) {
                    String name = (String)((Map)list.get(j)).get("name");
                    String suffix = (String)((Map)list.get(j)).get("suffix");
                    byte[] by = (byte[])((Map)list.get(j)).get("buffer");
                    String fileName = name + "." + suffix;
                    String filePath = path + "/" + file + "/" + fileName;
                    FileUtils.saveFile((byte[])by, (String)filePath);
                }
                return Result.success();
            }
            this.logger.error("\u6279\u91cf\u7b7e\u53d1\u672c\u6761\u786e\u8ba4\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)resultResp.getErrorBean().getErrMsg());
            return resultResp;
        }
        this.logger.error("\u6279\u91cf\u7b7e\u53d1\u672c\u6761\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)resultIssue.getErrorBean().getErrMsg());
        return resultIssue;
    }

    public Result formatUserCertInfo(String userCertInfo) {
        Result result = new Result();
        UserCertInfo certInfo = (UserCertInfo)JsonUtils.json2Object((String)userCertInfo, UserCertInfo.class);
        ArrayList list = new ArrayList();
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("name", "SignCert");
        signMap.put("suffix", "p7b");
        byte[] signByte = certInfo.getSignCert().getBytes();
        signMap.put("buffer", signByte);
        list.add(signMap);
        HashMap<String, Object> encMap = new HashMap<String, Object>();
        encMap.put("name", "EncCert");
        encMap.put("suffix", "p7b");
        byte[] encByte = certInfo.getEncCert().getBytes();
        encMap.put("buffer", encByte);
        list.add(encMap);
        HashMap<String, Object> priKeyMap = new HashMap<String, Object>();
        priKeyMap.put("name", "EncPrivateKey");
        priKeyMap.put("suffix", "pem");
        byte[] priKeyByte = certInfo.getEncPriKey().getBytes();
        priKeyMap.put("buffer", priKeyByte);
        list.add(priKeyMap);
        result.setInfo(list);
        return result;
    }

    public Result listApplyRecord(String applyNo) {
        Result result = new Result();
        List applyRecordDOS = this.applyRecordDao.listApplyRecord(applyNo);
        if (CollectionUtils.isEmpty((Collection)applyRecordDOS)) {
            this.logger.info(applyNo + " \u8be5sn\u4e0d\u5b58\u5728\u7533\u8bf7\u8bb0\u5f55");
            result.setError(ErrorEnum.SIGN_NO_NOT_HAVE_APPLY_RECORD);
            return result;
        }
        ArrayList<ApplyRecordVO> list = new ArrayList<ApplyRecordVO>();
        for (ApplyRecordDO applyRecordDO : applyRecordDOS) {
            ApplyRecordVO applyRecordVO = new ApplyRecordVO();
            BeanUtils.copyProperties((Object)applyRecordDO, (Object)applyRecordVO);
            applyRecordVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(applyRecordDO.getGmtCreate()));
            applyRecordVO.setRemark(applyRecordDO.getRemark() == null ? "" : applyRecordDO.getRemark());
            list.add(applyRecordVO);
        }
        result.setInfo(list);
        return result;
    }

    public Result checkUserCertApply(String applyNo, String systemFlag, int applyType, boolean pass, String checkInfo, boolean isOnlineIssue) {
        CertApplyDO certApplyInfo;
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(4)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }
        if ((certApplyInfo = this.certApplyDao.getCertApplyInfo(applyNo, Integer.valueOf(applyType))) == null) {
            this.logger.info("\u8be5\u7533\u8bf7\u7c7b\u578b\u4e0b\u4e0d\u5b58\u5728\u5f53\u524d\u7533\u8bf7\u7f16\u53f7\u5bf9\u5e94\u7684\u7533\u8bf7\u8bb0\u5f55 applyNo:{}", (Object)applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }
        BaseUserDO baseUserInfo = this.baseUserDao.getBaseUserInfo(certApplyInfo.getUserId().longValue());
        if (baseUserInfo.getId() != null) {
            result.setLogContent("\uff0c\u7528\u6237ID=" + baseUserInfo.getId());
        }
        result.setLogContent(result.getLogContent() + "\uff0c\u8bc1\u4e66\u4e3b\u4f53=" + certApplyInfo.getCertDn());
        if (1 != certApplyInfo.getApplyStatus()) {
            this.logger.info("\u5f53\u524d\u7533\u8bf7\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001 status:{}", (Object)certApplyInfo.getApplyStatus());
            result.setError(ErrorEnum.CERT_APPLY_TYPE_IS_NOT_NO_CHECK_1);
            return result;
        }
        int applyStatus = 0;
        int operateResultType = 0;
        if (!pass) {
            applyStatus = 2;
            operateResultType = 3;
            result = this.certApplyService.updateCertApplyInfo(null, applyNo, applyStatus, null);
            if (!result.isSuccess()) {
                return result;
            }
            this.certApplyService.insertCertApplyRecord(applyType, 3, applyNo, systemFlag, applyStatus, checkInfo, operateResultType, false, isOnlineIssue);
            return result;
        }
        if (3 == applyType) {
            RevokeApplyDTO revokeApplyDTO = null;
            try {
                revokeApplyDTO = this.revokeApplyDao.getRevokeApplyInfoByApplyNo(applyNo);
            }
            catch (EmptyResultDataAccessException e) {
                this.logger.info("getRevokeApplyInfo.applyNo:{} \u67e5\u8be2\u64a4\u9500\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a", (Object)applyNo);
                this.logger.info("\u83b7\u53d6\u64a4\u9500\u8bc1\u4e66\u7533\u8bf7\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
                result.setError(ErrorEnum.GET_REVOKE_APPLY_INFO_IS_EMPTY);
                return result;
            }
            this.certApplyService.insertCertApplyRecord(3, 3, applyNo, systemFlag, 0, checkInfo, 4, false, isOnlineIssue);
            Result revokeResult = this.certLifeCycleManager.revokeUserCert(applyNo, raServiceDnName, caServiceDnName, revokeApplyDTO.getSignSn(), revokeApplyDTO.getCertDn(), revokeApplyDTO.getRevokeReason().intValue(), revokeApplyDTO.getApplyReason());
            if (!revokeResult.isSuccess()) {
                this.logger.info("\u53d1\u8d77\u8bc1\u4e66\u64a4\u9500\u5931\u8d25 errorCode:{} ", (Object)revokeResult.getErrorBean().getErrCode());
                result.setErrorBean(revokeResult.getErrorBean());
                applyStatus = 6;
                this.certApplyService.insertCertApplyRecord(3, 4, applyNo, systemFlag, applyStatus, "\u8bc1\u4e66\u64a4\u9500\u5931\u8d25code:" + revokeResult.getErrorBean().getErrCode(), 5, false, isOnlineIssue);
            } else {
                applyStatus = 7;
                this.certApplyService.insertCertApplyRecord(3, 4, applyNo, systemFlag, applyStatus, revokeApplyDTO.getApplyReason(), 6, false, isOnlineIssue);
                Result updateStatusResult = this.userCertService.updateUserCertStatus(3, revokeApplyDTO.getSignSn());
                if (!updateStatusResult.isSuccess()) {
                    this.logger.info("\u66f4\u65b0\u8bc1\u4e66\u72b6\u6001\u9519\u8bef::{} ", (Object)JsonUtils.object2Json((Object)updateStatusResult));
                    result.setError(updateStatusResult.getError());
                    throw new RuntimeException();
                }
            }
            Result updateResult = this.certApplyService.updateCertApplyInfo(null, applyNo, applyStatus, null);
            if (!updateResult.isSuccess()) {
                result.setError(updateResult.getError());
                return result;
            }
        } else if (5 == applyType || 6 == applyType) {
            FreezeApplyDTO freezeApplyDTO = this.freezeApplyDao.getFreezeApplyInfoByApplyNo(applyNo);
            if (freezeApplyDTO == null) {
                this.logger.info(ErrorEnum.GET_FREEZE_UNFREEZE_APPLY_INFO_IS_EMPTY.desc);
                result.setError(ErrorEnum.GET_FREEZE_UNFREEZE_APPLY_INFO_IS_EMPTY);
                return result;
            }
            this.certApplyService.insertCertApplyRecord(freezeApplyDTO.getApplyType().intValue(), 3, applyNo, systemFlag, 0, checkInfo, 4, false, isOnlineIssue);
            CertLifeInfo certLifeInfo = new CertLifeInfo();
            certLifeInfo.setApplyNo(applyNo);
            certLifeInfo.setRaDN(raServiceDnName);
            certLifeInfo.setCaDN(caServiceDnName);
            certLifeInfo.setSignSn(freezeApplyDTO.getSignSn());
            certLifeInfo.setUserCertDN(freezeApplyDTO.getCertDn());
            Result freezeResult = this.certLifeCycleManager.freezeUserCert(certLifeInfo, applyType, freezeApplyDTO.getApplyReason());
            if (!freezeResult.isSuccess()) {
                int operatorRepType;
                int operatorType;
                this.logger.info("\u53d1\u8d77\u8bc1\u4e66\u51bb\u7ed3\u89e3\u51bb\u5931\u8d25 errorCode:{} ", (Object)freezeResult.getErrorBean().getErrCode());
                result.setErrorBean(freezeResult.getErrorBean());
                if (applyType == ApplyTypeEnum.FREEZE_APPLY.id) {
                    applyStatus = 8;
                    operatorType = 6;
                    operatorRepType = 9;
                } else {
                    applyStatus = 10;
                    operatorType = 7;
                    operatorRepType = 11;
                }
                this.certApplyService.insertCertApplyRecord(applyType, operatorType, applyNo, systemFlag, applyStatus, "\u8bc1\u4e66\u51bb\u7ed3/\u89e3\u51bb\u5931\u8d25code:" + freezeResult.getErrorBean().getErrCode(), operatorRepType, false, isOnlineIssue);
            } else {
                int certStatus;
                int operatorRepType;
                int operatorType;
                if (applyType == ApplyTypeEnum.FREEZE_APPLY.id) {
                    applyStatus = 9;
                    operatorType = 6;
                    operatorRepType = 10;
                    certStatus = 4;
                } else {
                    applyStatus = 11;
                    operatorType = 7;
                    operatorRepType = 12;
                    certStatus = 1;
                }
                this.certApplyService.insertCertApplyRecord(applyType, operatorType, applyNo, systemFlag, applyStatus, freezeApplyDTO.getApplyReason(), operatorRepType, false, isOnlineIssue);
                Result updateStatusResult = this.userCertService.updateUserCertStatus(certStatus, freezeApplyDTO.getSignSn());
                if (!updateStatusResult.isSuccess()) {
                    this.logger.info("\u51bb\u7ed3\u89e3\u51bb\u8bc1\u4e66\u72b6\u6001\u9519\u8bef::{} ", (Object)JsonUtils.object2Json((Object)updateStatusResult));
                    result.setError(updateStatusResult.getError());
                    throw new RuntimeException();
                }
            }
            Result updateResult = this.certApplyService.updateCertApplyInfo(null, applyNo, applyStatus, null);
            if (!updateResult.isSuccess()) {
                result.setError(updateResult.getError());
                return result;
            }
        } else if (3 != applyType) {
            if (baseUserInfo == null || baseUserInfo.getStatus() == 1) {
                this.logger.info("\u5f53\u524d\u7533\u8bf7\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001 status:{}", (Object)certApplyInfo.getApplyStatus());
                result.setError(ErrorEnum.USER_STATUS_CANNOT_CHECK_PASS);
                return result;
            }
            applyStatus = 3;
            operateResultType = 4;
            result = this.certApplyService.updateCertApplyInfo(null, applyNo, applyStatus, null);
            if (!result.isSuccess()) {
                return result;
            }
            if (!baseUserInfo.getSystemFlag().equals("RA") && !isOnlineIssue) {
                DoubleCodeDO doubleCodeDO = new DoubleCodeDO();
                doubleCodeDO.setRefCode(baseUserInfo.getId());
                doubleCodeDO.setAuthCode(applyNo);
                doubleCodeDO.setIsUse(Integer.valueOf(DoubleCodeUseEnum.NOT_USE.id));
                this.doubleCodeDao.InsertDouble(doubleCodeDO);
            }
            this.certApplyService.insertCertApplyRecord(applyType, 3, applyNo, systemFlag, applyStatus, checkInfo, operateResultType, false, isOnlineIssue);
        }
        return result;
    }

    @Transactional
    public Result issueUserCertRespScep(String applyNo, String adminCertDn) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String raTransId = this.raSdkCache.getCaTransId(applyNo);
        if (raTransId == null) {
            this.logger.info("\u83b7\u53d6\u672c\u5730\u7f13\u5b58\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_LOCAL_CACHE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        CertApplyDO certApplyDO = this.certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyDO == null) {
            this.logger.info("\u4e0d\u5b58\u5728\u5f53\u524d\u7533\u8bf7\u7f16\u53f7\u5bf9\u5e94\u7684\u7533\u8bf7\u8bb0\u5f55 applyNo:" + applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }
        Result issueResult = this.certLifeCycleManager.issueCertResp(raServiceDnName, caServiceDnName, 1, raTransId);
        if (!issueResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, 4, certApplyDO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new RuntimeException();
            }
            this.certApplyService.insertCertApplyRecordScep(certApplyDO.getApplyType().intValue(), 5, applyNo, adminCertDn, 4, issueResult.getErrorBean().getErrMsg(), 7, false, true);
            this.logger.info("\u7b7e\u53d1\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u51fa\u9519");
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        List certSnList = null;
        try {
            certSnList = this.certApplyDao.getCertSnByApplyNo(applyNo);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u7533\u8bf7\u7f16\u53f7{}\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u53d1\u8bc1\u4e66sn", (Object)applyNo);
            result.setError(ErrorEnum.CANNOT_GET_CERT_SN_BY_APPLY_NO);
            return result;
        }
        Result updateStatusResult = this.userCertService.updateUserCertStatus(1, (String)certSnList.get(0));
        if (!updateStatusResult.isSuccess()) {
            result.setError(updateStatusResult.getError());
            return result;
        }
        this.certApplyService.insertCertApplyRecordScep(1, 5, applyNo, adminCertDn, 5, "\u7528\u6237\u8bc1\u4e66-\u6210\u529f\u7b7e\u53d1", 8, false, true);
        Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, 5, certApplyDO.getTempId());
        if (issueCertApplyResult.getCode() != 0) {
            this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u5931\u8d25:" + JsonUtils.object2Json((Object)issueCertApplyResult));
            throw new RuntimeException();
        }
        return result;
    }

    @Transactional
    public Result issueUserCertResp(String applyNo, String systemFlag, boolean isOnlineIssue) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(5)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }
        String raTransId = this.raSdkCache.getCaTransId(applyNo);
        CertApplyDO certApplyDO = this.certApplyDao.getCertApplyInfo(applyNo);
        if (raTransId == null) {
            if (certApplyDO == null) {
                this.logger.info("\u4e0d\u5b58\u5728\u5f53\u524d\u7533\u8bf7\u7f16\u53f7\u5bf9\u5e94\u7684\u7533\u8bf7\u8bb0\u5f55 applyNo:{}", (Object)applyNo);
                result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
                return result;
            }
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, 4, certApplyDO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)issueCertApplyResult));
                }
                throw new ServiceException("\u64cd\u4f5c\u7b7e\u53d1\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u5931\u8d25!");
            }
            this.certApplyService.insertCertApplyRecord(certApplyDO.getApplyType().intValue(), 5, applyNo, systemFlag, 4, ErrorEnum.GET_LOCAL_CACHE_APPLY_INFO_IS_EMPTY.desc, 7, false, isOnlineIssue);
            this.logger.error("\u83b7\u53d6\u672c\u5730\u7f13\u5b58\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_LOCAL_CACHE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        Result issueResult = this.certLifeCycleManager.issueCertResp(raServiceDnName, caServiceDnName, 1, raTransId);
        if (!issueResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, 4, certApplyDO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)issueCertApplyResult));
                }
                throw new ServiceException("\u64cd\u4f5c\u7b7e\u53d1\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u5931\u8d25!");
            }
            this.certApplyService.insertCertApplyRecord(certApplyDO.getApplyType().intValue(), 5, applyNo, systemFlag, 4, issueResult.getErrorBean().getErrMsg(), 7, false, isOnlineIssue);
            this.logger.error("\u7b7e\u53d1\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u51fa\u9519");
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        List certSnList = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (2 == certApplyDO.getApplyType()) {
            UpdateApplyDTO updateApplyDTO = null;
            try {
                updateApplyDTO = this.updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
            }
            catch (EmptyResultDataAccessException e) {
                this.logger.info("getUpdateApplyInfoByApplyNo.applyNo:{} \u67e5\u8be2\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a", (Object)applyNo);
            }
            if (updateApplyDTO == null) {
                this.logger.info("\u83b7\u53d6\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
                result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
                return result;
            }
            try {
                this.userCertDao.updateDoubleUserCertStatus(3, updateApplyDTO.getSignSn());
            }
            catch (Exception e) {
                this.logger.error("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38", (Throwable)e);
                throw new ServiceException("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38");
            }
            try {
                certSnList = this.certApplyDao.getCertSnByApplyNo(applyNo);
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636e\u7533\u8bf7\u7f16\u53f7{}\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u53d1\u8bc1\u4e66sn", (Object)applyNo);
                result.setError(ErrorEnum.CANNOT_GET_CERT_SN_BY_APPLY_NO);
                return result;
            }
            Result updateStatusResult = this.userCertService.updateUserCertStatus(1, (String)certSnList.get(0));
            if (!updateStatusResult.isSuccess()) {
                result.setError(updateStatusResult.getError());
                return result;
            }
        } else if (4 == certApplyDO.getApplyType()) {
            RecoveryApplyDTO recoveryApplyDTO = null;
            try {
                recoveryApplyDTO = this.recoveryApplyDao.getRecoveryApplyInfoByApplyNo(applyNo);
            }
            catch (EmptyResultDataAccessException e) {
                this.logger.info("getIssueApplyInfoByApplyNo.applyNo:" + applyNo + " \u67e5\u8be2\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a");
            }
            if (recoveryApplyDTO == null) {
                this.logger.info("\u83b7\u53d6\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
                result.setError(ErrorEnum.GET_RECOVERY_APPLY_INFO_IS_EMPTY);
                return result;
            }
            UserCertDO oldSignCertInfo = this.userCertDao.getUserCertBaseInfo(recoveryApplyDTO.getSignSn());
            UserCertDO oldEncCertInfo = this.userCertDao.getUserCertBaseInfo(recoveryApplyDTO.getEncSn());
            try {
                certSnList = this.certApplyDao.getCertSnByApplyNo(applyNo);
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636e\u7533\u8bf7\u7f16\u53f7{}\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u53d1\u8bc1\u4e66sn", (Object)applyNo);
                result.setError(ErrorEnum.CANNOT_GET_CERT_SN_BY_APPLY_NO);
                return result;
            }
            UserCertDO newSignCertInfo = this.userCertDao.getUserCertBaseInfo((String)certSnList.get(0));
            oldEncCertInfo.setPairCertIndex(newSignCertInfo.getPairCertIndex());
            oldEncCertInfo.setApplyId(newSignCertInfo.getApplyId());
            this.userCertDao.updateUserCert(oldEncCertInfo);
            oldSignCertInfo.setCertStatus(Integer.valueOf(3));
            oldSignCertInfo.setIsRecovery(1);
            this.userCertDao.updateUserCert(oldSignCertInfo);
            newSignCertInfo.setCertStatus(Integer.valueOf(1));
            this.userCertDao.updateUserCert(newSignCertInfo);
            stringBuilder.append("\uff0c\u8bc1\u4e66\u7684SN=" + (String)certSnList.get(0));
        } else {
            try {
                certSnList = this.certApplyDao.getCertSnByApplyNo(applyNo);
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636e\u7533\u8bf7\u7f16\u53f7{}\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u53d1\u8bc1\u4e66sn", (Object)applyNo);
                result.setError(ErrorEnum.CANNOT_GET_CERT_SN_BY_APPLY_NO);
                return result;
            }
            Result updateStatusResult = this.userCertService.updateUserCertStatus(1, (String)certSnList.get(0));
            if (!updateStatusResult.isSuccess()) {
                result.setError(updateStatusResult.getError());
                return result;
            }
            stringBuilder.append("\uff0c\u8bc1\u4e66\u7684SN=" + (String)certSnList.get(0));
        }
        this.certApplyService.insertCertApplyRecord(1, 5, applyNo, systemFlag, 5, "\u7528\u6237\u8bc1\u4e66-\u6210\u529f\u7b7e\u53d1", 8, false, isOnlineIssue);
        result.setLogContent(stringBuilder.toString());
        result.setLogContent(stringBuilder.append("\uff0c\u8bc1\u4e66\u4e3b\u4f53=" + certApplyDO.getCertDn()).toString());
        Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, 5, certApplyDO.getTempId());
        if (issueCertApplyResult.getCode() != 0) {
            this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u5931\u8d25:" + JsonUtils.object2Json((Object)issueCertApplyResult));
            throw new RuntimeException();
        }
        return result;
    }

    public Result getUserCertStatus(String applyNo) {
        Result result = new Result();
        List certSnList = null;
        try {
            certSnList = this.certApplyDao.getCertSnByApplyNo(applyNo);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u7533\u8bf7\u7f16\u53f7{}\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u53d1\u8bc1\u4e66sn", (Object)applyNo);
            result.setError(ErrorEnum.CANNOT_GET_CERT_SN_BY_APPLY_NO);
            return result;
        }
        String certSn = (String)certSnList.get(0);
        Result certStatusResult = this.caBusinessManager.getCertStatus(certSn);
        if (!certStatusResult.isSuccess()) {
            return certStatusResult;
        }
        int status = (Integer)certStatusResult.getInfo();
        if (status != 0) {
            try {
                this.userCertDao.updateDoubleUserCertStatus(status, certSn);
            }
            catch (Exception e) {
                this.logger.error("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.UPDATE_USER_CERT_STATUS_EXCEPTION);
                return result;
            }
        }
        result.setInfo((Object)status);
        return result;
    }

    public Result genErrorMsgContent(String applyNo, int errorCode, String errorMsg, boolean isOnlineIssue) {
        String raServiceDnName;
        Result result = new Result();
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(5)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }
        if (StringUtils.isBlank((CharSequence)(raServiceDnName = this.getRAServiceDnName()))) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String raTransId = this.raSdkCache.getCaTransId(applyNo);
        if (raTransId == null) {
            this.logger.info("\u83b7\u53d6\u672c\u5730\u7f13\u5b58\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_LOCAL_CACHE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        CertApplyDO certApplyDO = this.certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyDO == null) {
            this.logger.info("\u4e0d\u5b58\u5728\u5f53\u524d\u7533\u8bf7\u7f16\u53f7\u5bf9\u5e94\u7684\u7533\u8bf7\u8bb0\u5f55 applyNo:" + applyNo);
            result.setError(ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
            return result;
        }
        Result errResult = this.certLifeCycleManager.sendErrorCMPMessage(raServiceDnName, caServiceDnName, 1, raTransId, errorCode, errorMsg);
        if (!errResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, 4, certApplyDO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new RuntimeException();
            }
            this.certApplyService.insertCertApplyRecord(certApplyDO.getApplyType().intValue(), 5, applyNo, null, 4, errResult.getErrorBean().getErrMsg(), 7, false, isOnlineIssue);
            this.logger.info("\u9519\u8bef\u786e\u8ba4\u6d88\u606f\u51fa\u9519\uff1a" + JsonUtils.object2Json((Object)errResult));
            result.setErrorBean(errResult.getErrorBean());
            return result;
        }
        Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(certApplyDO.getCertDn(), applyNo, 4, certApplyDO.getTempId());
        if (issueCertApplyResult.getCode() != 0) {
            this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)issueCertApplyResult));
            throw new RuntimeException();
        }
        this.certApplyService.insertCertApplyRecord(certApplyDO.getApplyType().intValue(), 5, applyNo, null, 4, errorMsg, 7, false, isOnlineIssue);
        return result;
    }

    public Result defaultContainer(String defaultContainer) {
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            config.setDefaultContainer(defaultContainer);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u9ed8\u8ba4\u5bb9\u5668\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        return result;
    }

    public Result getDefaultContainer() {
        Result result = new Result();
        Config config = null;
        try {
            config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                this.logger.error("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u4e3a\u7a7a");
                result.setError(ErrorEnum.GET_DEFAULT_CONTAINER_IS_EMPTY);
                return result;
            }
        }
        catch (Exception e) {
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        String defaultContainer = config.getDefaultContainer();
        this.logger.info("\u9ed8\u8ba4\u5bb9\u5668\u4e3a \uff1a " + defaultContainer);
        result.setInfo((Object)config);
        return result;
    }

    public Result getBaseDn(String tempNo) {
        String tempBaseDn = null;
        try {
            tempBaseDn = this.certApplyDao.getBaseDnByTempNo(tempNo);
        }
        catch (DataAccessException e) {
            this.logger.info("\u901a\u8fc7\u6a21\u677f\u7f16\u53f7\u672a\u83b7\u53d6\u5230\u6a21\u677fbaseDn");
        }
        Result raBaseDnResult = this.getRaBaseDn();
        if (!raBaseDnResult.isSuccess()) {
            return raBaseDnResult;
        }
        String raBaseDn = raBaseDnResult.getInfo().toString();
        BaseDn baseDn = new BaseDn(raBaseDn, tempBaseDn);
        return Result.success((Object)baseDn);
    }

    public Result getRaBaseDn() {
        String raBaseDn = CommonVariable.getRaBaseDn();
        if (!StringUtils.isBlank((CharSequence)raBaseDn)) {
            return Result.success((Object)raBaseDn);
        }
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            raBaseDn = config.getRaBaseDn();
            if (StringUtils.isNotBlank((CharSequence)raBaseDn)) {
                return Result.success((Object)raBaseDn);
            }
            result = this.caBusinessManager.getRaBaseDN();
            if (!result.isSuccess()) {
                return result;
            }
            raBaseDn = (String)result.getInfo();
            config.setRaBaseDn(raBaseDn);
            this.systemService.updateConfigFile(config);
            CommonVariable.setConfig((Config)config);
            CommonVariable.setRaBaseDn((String)raBaseDn);
            return Result.success((Object)raBaseDn);
        }
        catch (Exception e) {
            this.logger.error("\u5199\u5165raBaseDn\u670d\u52a1\u64cd\u4f5cconfig.json\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
    }

    private Result insertUserCertInfo(long userId, long applyId, long tempId, String tempNo, String signAlg, int privateKeyLength, UserCertInfo userCertInfo) {
        Result result = new Result();
        String signCert = userCertInfo.getSignCert();
        if (StringUtils.isBlank((CharSequence)signCert)) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u4e3a\u7a7a");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_INFO_IS_EMPTY);
            return result;
        }
        X509Certificate signCertStr = CertUtils.getCertFromStr((String)signCert);
        if (signCertStr == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u9519\u8bef");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
            return result;
        }
        long pairCertIndex = this.raSdkCache.getIncPairCertIndex();
        UserCertDO signCertDO = new UserCertDO();
        signCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        if (StringUtils.isBlank((CharSequence)userCertInfo.getEncCert())) {
            signCertDO.setCertType(Integer.valueOf(1));
        } else {
            signCertDO.setCertType(Integer.valueOf(2));
        }
        signCertDO.setCertStatus(Integer.valueOf(0));
        signCertDO.setUserId(Long.valueOf(userId));
        signCertDO.setApplyId(Long.valueOf(applyId));
        signCertDO.setTempId(Long.valueOf(tempId));
        signCertDO.setTempNo(tempNo);
        signCertDO.setSignAlg(signAlg);
        signCertDO.setPrivateKeyLength(Integer.valueOf(privateKeyLength));
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            this.logger.info("\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        signCertDO.setCaCertId(newCaCertInfo.getId());
        signCertDO.setCertSn(signCertStr.getSerialNumber().toString(16).toLowerCase());
        signCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCertStr));
        Date startDate = signCertStr.getNotBefore();
        Date endDate = signCertStr.getNotAfter();
        signCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        signCertDO.setFailureTime(new Timestamp(endDate.getTime()));
        int certDays = (int)((endDate.getTime() - startDate.getTime()) / 86400000L);
        signCertDO.setCertValidity(Integer.valueOf(certDays));
        int priKeyDays = (int)((newCaCertInfo.getFailureTime().getTime() - startDate.getTime()) / 86400000L);
        signCertDO.setEncKeyValidity(Integer.valueOf(priKeyDays));
        Date date = new Date();
        signCertDO.setGmtCreate(new Timestamp(date.getTime()));
        signCertDO.setGmtUpdate(new Timestamp(date.getTime()));
        UserCertDO userSignCertDO = this.userCertDao.insertUserCertInfo(signCertDO);
        String encCert = userCertInfo.getEncCert();
        if (StringUtils.isNotBlank((CharSequence)encCert)) {
            UserCertDO encCertDO = new UserCertDO();
            encCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
            encCertDO.setCertType(Integer.valueOf(3));
            encCertDO.setCertStatus(Integer.valueOf(0));
            encCertDO.setUserId(Long.valueOf(userId));
            encCertDO.setApplyId(Long.valueOf(applyId));
            encCertDO.setTempId(Long.valueOf(tempId));
            encCertDO.setTempNo(tempNo);
            encCertDO.setSignAlg(signAlg);
            encCertDO.setPrivateKeyLength(Integer.valueOf(privateKeyLength));
            encCertDO.setCaCertId(newCaCertInfo.getId());
            encCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
            encCertDO.setFailureTime(new Timestamp(endDate.getTime()));
            encCertDO.setCertValidity(Integer.valueOf(certDays));
            encCertDO.setEncKeyValidity(Integer.valueOf(priKeyDays));
            X509Certificate encCertStr = CertUtils.getCertFromStr((String)encCert);
            if (encCertStr == null) {
                this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u52a0\u5bc6\u8bc1\u4e66\u9519\u8bef");
                result.setError(ErrorEnum.CA_RESPONSE_USER_ENC_CERT_ERROR);
                return result;
            }
            encCertDO.setGmtCreate(new Timestamp(date.getTime()));
            encCertDO.setGmtUpdate(new Timestamp(date.getTime()));
            encCertDO.setCertSn(encCertStr.getSerialNumber().toString(16).toLowerCase());
            encCertDO.setSignCertSn(userSignCertDO.getCertSn());
            try {
                encCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)encCertStr));
                this.userCertDao.insertUserCertInfo(encCertDO);
            }
            catch (Exception e) {
                this.logger.info("\u624b\u52a8\u5904\u7406manager\u5c42\u7684\u63d2\u5165\u5f02\u5e38");
                this.userCertDao.deleteUserCert(userSignCertDO.getId().longValue());
            }
        }
        return result;
    }

    private Result issueApplyHandler(Integer certFormatType, String applyNo, String systemFlag, String cardNo, byte[] issueBytes, String raDN, String caDN, String transId, int issueType, boolean isOnlineIssue, boolean isTboxIssue, Map<String, Object> extParam, Integer keyFormat) {
        IssueApplyDTO issueApplyDTO;
        Result result = new Result();
        try {
            issueApplyDTO = this.issueApplyDao.getIssueApplyInfoByApplyNo(applyNo);
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int certValidity = issueApplyDTO.getCertValidity();
        String signAlg = issueApplyDTO.getSignAlg();
        String tempNo = issueApplyDTO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank((CharSequence)issueApplyDTO.getTempParas())) {
            tempParas = issueApplyDTO.getTempParas();
        }
        String userCertDN = this.chooseUserCertDn(extParam, issueApplyDTO.getCertDn());
        byte[] publicKeyByte = null;
        try {
            PublicKey publicKey;
            if (!isOnlineIssue) {
                String userP10Str = new String(issueBytes);
                publicKey = SdkP10Utils.p10ToPublicKey((String)userP10Str);
                publicKeyByte = publicKey.getEncoded();
            } else {
                publicKeyByte = issueBytes;
                publicKey = CertUtils.getPublicKeyBySubjectPublicInfo((String)Base64.toBase64String((byte[])issueBytes));
            }
            result = this.checkApplyMsgEqualP10(publicKey, tempNo);
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u4eceP10\u4e2d\u83b7\u53d6\u516c\u94a5\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
            return result;
        }
        Result issueResult = this.certLifeCycleManager.issueUserCert(applyNo, cardNo, publicKeyByte, raDN, caDN, transId, tempNo, tempParas, signAlg, certValidity, userCertDN, keyFormat);
        if (!issueResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(issueApplyDTO.getCertDn(), applyNo, 4, issueApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new RuntimeException();
            }
            this.certApplyService.insertCertApplyRecord(1, 5, applyNo, systemFlag, 4, issueResult.getErrorBean().getErrMsg(), 7, false, isOnlineIssue);
            this.logger.error("\u8c03\u7528CA\uff0c\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25");
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)issueResult.getInfo();
        Result certInsertResult = this.insertUserCertInfo(issueApplyDTO.getUserId(), issueApplyDTO.getApplyId(), issueApplyDTO.getTempId(), issueApplyDTO.getTempNo(), signAlg, issueApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.setError(certInsertResult.getError());
            return result;
        }
        if (issueType == 1 || isOnlineIssue || certFormatType == 5) {
            result.setInfo((Object)userCertInfo);
            return result;
        }
        try {
            String extraCertsP7b = userCertInfo.getExtraCertsP7b();
            List caTrust = Pkcs7Utils.resolveCertChain((String)extraCertsP7b);
            X509Certificate signCert = CertUtils.getCertFromStr((String)userCertInfo.getSignCert());
            caTrust.add(signCert);
            String signTrustCert = SignedDataUtils.createCertChainByCerts((List)caTrust);
            userCertInfo.setSignCert(signTrustCert);
            if (issueApplyDTO.getCertPatterm() != 1) {
                caTrust.remove(signCert);
                X509Certificate encCert = CertUtils.getCertFromStr((String)userCertInfo.getEncCert());
                caTrust.add(encCert);
                String encTrustCert = SignedDataUtils.createCertChainByCerts((List)caTrust);
                userCertInfo.setEncCert(encTrustCert);
            }
        }
        catch (Exception e) {
            this.logger.error("sdk\u63a5\u53e3-\u5c01\u88c5\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.BUILD_TRAIN_CERT_P7b_IS_ERROR);
            return result;
        }
        result.setInfo((Object)userCertInfo);
        return result;
    }

    private Result updateApplyHandler(Integer certFormatType, String applyNo, String systemFlag, String cardNo, byte[] issueBytes, String raDN, String caDN, String transId, int issueType, boolean isOnlineIssue, boolean isTboxIssue, Map<String, Object> extParam, Integer keyFormat) {
        Result result = new Result();
        UpdateApplyDTO updateApplyDTO = null;
        try {
            updateApplyDTO = this.updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("\u67e5\u8be2\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a getUpdateApplyInfo.applyNo:{}", (Object)applyNo);
        }
        if (updateApplyDTO == null) {
            this.logger.info("\u83b7\u53d6\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int certValidity = 0;
        if (updateApplyDTO.getUpdateValidity().booleanValue()) {
            certValidity = updateApplyDTO.getCertValidity();
        }
        String tempNo = updateApplyDTO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank((CharSequence)updateApplyDTO.getTempParas())) {
            tempParas = updateApplyDTO.getTempParas();
        }
        byte[] publicKeyByte = null;
        PublicKey publicKey = null;
        if (!isOnlineIssue) {
            if (updateApplyDTO.getUpdateKey().booleanValue()) {
                try {
                    String userP10Str = new String(issueBytes);
                    publicKey = SdkP10Utils.p10ToPublicKey((String)userP10Str);
                    if (publicKey == null) {
                        this.logger.info("\u66f4\u65b0\u5bc6\u94a5\u65f6\uff0c\u5fc5\u987b\u4e0a\u4f20p10\u6587\u4ef6");
                        result.setError(ErrorEnum.UPDATE_KEY_NEED_P10_FILE);
                        return result;
                    }
                    publicKeyByte = publicKey.getEncoded();
                }
                catch (Exception e) {
                    this.logger.info("\u4eceP10\u4e2d\u83b7\u53d6\u516c\u94a5\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
                    return result;
                }
            }
        } else if (updateApplyDTO.getUpdateKey().booleanValue()) {
            if (issueBytes == null) {
                this.logger.info("\u66f4\u65b0\u5bc6\u94a5\u65f6\uff0c\u5fc5\u987b\u4e0a\u4f20p10\u6587\u4ef6");
                result.setError(ErrorEnum.UPDATE_KEY_NEED_P10_FILE);
                return result;
            }
            this.logger.info("\u5728\u7ebf\u66f4\u65b0\u7533\u8bf7\u66f4\u65b0\u79d8\u94a5");
            publicKeyByte = issueBytes;
            publicKey = CertUtils.getPublicKeyBySubjectPublicInfo((String)Base64.toBase64String((byte[])issueBytes));
        } else {
            this.logger.info("\u5728\u7ebf\u66f4\u65b0\u7533\u8bf7\u4e0d\u66f4\u65b0\u79d8\u94a5");
            publicKeyByte = null;
        }
        if (null != publicKey && !(result = this.checkApplyMsgEqualP10(publicKey, tempNo)).isSuccess()) {
            return result;
        }
        String userCertDN = this.chooseUserCertDn(extParam, updateApplyDTO.getCertDn());
        Result updateResult = this.certLifeCycleManager.updateUserCert(applyNo, cardNo, publicKeyByte, raDN, caDN, transId, tempNo, tempParas, updateApplyDTO.getSignAlg(), certValidity, userCertDN, updateApplyDTO.getSignSn(), updateApplyDTO.getUpdateKey().booleanValue(), keyFormat);
        if (!updateResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(updateApplyDTO.getCertDn(), applyNo, 4, updateApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u5931\u8d25:" + JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new RuntimeException();
            }
            this.certApplyService.insertCertApplyRecord(2, 5, applyNo, systemFlag, 4, updateApplyDTO.getApplyReason(), 7, false, isOnlineIssue);
            this.logger.info("\u8c03\u7528CA\uff0c\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25");
            result.setErrorBean(updateResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)updateResult.getInfo();
        Result certInsertResult = this.insertUserCertInfo(updateApplyDTO.getUserId(), updateApplyDTO.getApplyId(), updateApplyDTO.getTempId(), updateApplyDTO.getTempNo(), updateApplyDTO.getSignAlg(), updateApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            throw new RuntimeException();
        }
        if (issueType == 1 || isOnlineIssue || certFormatType == 5) {
            result.setInfo((Object)userCertInfo);
            return result;
        }
        try {
            String extraCertsP7b = userCertInfo.getExtraCertsP7b();
            List caTrust = Pkcs7Utils.resolveCertChain((String)extraCertsP7b);
            X509Certificate signCert = CertUtils.getCertFromStr((String)userCertInfo.getSignCert());
            caTrust.add(signCert);
            String signTrustCert = SignedDataUtils.createCertChainByCerts((List)caTrust);
            userCertInfo.setSignCert(signTrustCert);
            if (updateApplyDTO.getCertPatterm() != 1) {
                caTrust.remove(signCert);
                X509Certificate encCert = CertUtils.getCertFromStr((String)userCertInfo.getEncCert());
                caTrust.add(encCert);
                String encTrustCert = SignedDataUtils.createCertChainByCerts((List)caTrust);
                userCertInfo.setEncCert(encTrustCert);
            }
        }
        catch (Exception e) {
            this.logger.error("sdk\u63a5\u53e3-\u5c01\u88c5\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.BUILD_TRAIN_CERT_P7b_IS_ERROR);
            return result;
        }
        result.setInfo((Object)userCertInfo);
        return result;
    }

    private Result recoveryApplyHandler(Integer certFormatType, String applyNo, String systemFlag, String cardNo, byte[] issueBytes, String raDN, String caDN, String transId, int issueType, boolean isOnlineIssue, Integer keyFormat) {
        PublicKey publicKey;
        Result result = new Result();
        RecoveryApplyDTO recoveryApplyDTO = null;
        try {
            recoveryApplyDTO = this.recoveryApplyDao.getRecoveryApplyInfoByApplyNo(applyNo);
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        byte[] publicKeyByte = null;
        if (!isOnlineIssue) {
            try {
                String userP10Str = new String(issueBytes);
                publicKey = SdkP10Utils.p10ToPublicKey((String)userP10Str);
                publicKeyByte = publicKey.getEncoded();
            }
            catch (Exception e) {
                this.logger.info("\u4eceP10\u4e2d\u83b7\u53d6\u516c\u94a5\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
                return result;
            }
        } else {
            publicKeyByte = issueBytes;
            publicKey = CertUtils.getPublicKeyBySubjectPublicInfo((String)Base64.toBase64String((byte[])issueBytes));
        }
        result = this.checkApplyMsgEqualP10(publicKey, recoveryApplyDTO.getTempNo());
        if (!result.isSuccess()) {
            return result;
        }
        String signAlg = recoveryApplyDTO.getSignAlg();
        String userCertDN = recoveryApplyDTO.getCertDn();
        Result recoveryResult = this.certLifeCycleManager.recoveryUserCert(applyNo, raDN, caDN, publicKeyByte, recoveryApplyDTO.getSignSn(), transId, signAlg, userCertDN, keyFormat);
        if (!recoveryResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(recoveryApplyDTO.getCertDn(), applyNo, 4, Long.valueOf(recoveryApplyDTO.getTempId()));
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u6062\u590d\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new RuntimeException();
            }
            this.certApplyService.insertCertApplyRecord(4, 5, applyNo, systemFlag, 4, recoveryResult.getErrorBean().getErrMsg(), 7, false, isOnlineIssue);
            this.logger.info("\u8c03\u7528CA\uff0c\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25");
            result.setErrorBean(recoveryResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)recoveryResult.getInfo();
        Result certInsertResult = this.insertUserCertInfoByRecovery(recoveryApplyDTO.getUserId(), recoveryApplyDTO.getApplyId(), recoveryApplyDTO.getTempId(), recoveryApplyDTO.getTempNo(), signAlg, recoveryApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.setError(certInsertResult.getError());
            return result;
        }
        if (issueType == 1 || isOnlineIssue || certFormatType == 5) {
            result.setInfo((Object)userCertInfo);
            return result;
        }
        try {
            String extraCertsP7b = userCertInfo.getExtraCertsP7b();
            List caTrust = Pkcs7Utils.resolveCertChain((String)extraCertsP7b);
            X509Certificate signCert = CertUtils.getCertFromStr((String)userCertInfo.getSignCert());
            caTrust.add(signCert);
            String signTrustCert = SignedDataUtils.createCertChainByCerts((List)caTrust);
            userCertInfo.setSignCert(signTrustCert);
            caTrust.remove(signCert);
            X509Certificate encCert = CertUtils.getCertFromStr((String)userCertInfo.getEncCert());
            caTrust.add(encCert);
            String encTrustCert = SignedDataUtils.createCertChainByCerts((List)caTrust);
            userCertInfo.setEncCert(encTrustCert);
        }
        catch (Exception e) {
            this.logger.error("sdk\u63a5\u53e3-\u5c01\u88c5\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.BUILD_TRAIN_CERT_P7b_IS_ERROR);
            return result;
        }
        result.setInfo((Object)userCertInfo);
        return result;
    }

    private String chooseUserCertDn(Map<String, Object> extParam, String applyCertDn) {
        String userCertDN;
        if (MapUtils.isNotEmpty(extParam) && extParam.containsKey("certDn")) {
            userCertDN = (String)extParam.get("certDn");
            try {
                userCertDN = DnUtil.getRFC4519X500Name((String)userCertDN).toString();
            }
            catch (NamingException e) {
                this.logger.info("\u79bb\u7ebf\u7b7e\u53d1\u4f7f\u7528\u7528\u6237\u81ea\u5b9a\u4e49\u7684DN\u683c\u5f0f\u5f02\u5e38", (Throwable)e);
            }
            this.logger.info("[CertApplyServiceImpl#chooseUserCertDn] \u79bb\u7ebf\u5f62\u5f0f\u7684\u7b7e\u53d1\u8bc1\u4e66\uff0c\u4f7f\u7528\u7528\u6237\u4f20\u5165\u7684\u81ea\u5b9a\u4e49 certDn ={} \u5236\u8bc1", (Object)userCertDN);
        } else {
            userCertDN = applyCertDn;
            this.logger.info("[CertApplyServiceImpl#chooseUserCertDn] \u4f7f\u7528\u7533\u8bf7\u4e66\u4e2d certDn ={} \u5236\u8bc1", (Object)userCertDN);
        }
        return userCertDN;
    }

    private Result checkApplyMsgEqualP10(PublicKey publicKey, String tempNo) {
        String algorithm;
        this.logger.info("\u5f00\u59cb\u6821\u9a8c\u7533\u8bf7\u4e2d\u7684\u516c\u94a5\u4fe1\u606f\u548c\u6a21\u677f\u8981\u6c42\u662f\u5426\u4e00\u81f4");
        Result result = new Result();
        CertTempDO certTempInfoByTempNo = this.certTempCache.getCertTempInfoByTempNo(tempNo);
        String publicKeyAlg = certTempInfoByTempNo.getPublicKeyAlg();
        Integer privateKeyLength = certTempInfoByTempNo.getPrivateKeyLength();
        SubjectPublicKeyInfo instance = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        ASN1Encodable asn1Encodable = instance.getAlgorithmId().getParameters();
        if ("RSA".equals(publicKey.getAlgorithm())) {
            algorithm = "RSA";
        } else {
            ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(asn1Encodable.toString());
            if (oid.equals((Object)SM2ObjectIdentifiers.sm2256)) {
                algorithm = "SM2";
            } else if (oid.equals((Object)NISTObjectIdentifiers.nist256)) {
                algorithm = "ECC";
            } else {
                this.logger.info("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
                result.setError(ErrorEnum.NOT_SUPPORTED_SIGN_ALG);
                return result;
            }
        }
        this.logger.info("\u7533\u8bf7\u4e66\u4e2d\u7684\u7528\u6237\u7b97\u6cd5\u4e3a:{}", (Object)algorithm);
        if (!algorithm.equalsIgnoreCase(publicKeyAlg)) {
            this.logger.info("\u7528\u6237\u8bc1\u4e66\u7b97\u6cd5\u548c\u5f53\u524d\u6a21\u677f\u516c\u94a5\u7b97\u6cd5\u4e0d\u4e00\u81f4");
            result.setError(ErrorEnum.USER_CERT_KEY_ALG_NOT_SAME_WITH_TEMP);
            return result;
        }
        try {
            X509EncodedKeySpec eks = new X509EncodedKeySpec(new DERBitString((ASN1Encodable)instance).getBytes());
            if (algorithm.equalsIgnoreCase("SM2") || algorithm.equalsIgnoreCase("ECC")) {
                KeyFactory kf = KeyFactory.getInstance("EC", "BC");
                BCECPublicKey bcecPublicKey = (BCECPublicKey)kf.generatePublic(eks);
                int length = bcecPublicKey.getW().getAffineX().bitLength();
                this.logger.info("\u8bc1\u4e66\u5bc6\u94a5\u7b97\u6cd5\u957f\u5ea6\u4e3a:{}", (Object)length);
                if (privateKeyLength != 256) {
                    this.logger.error("\u7528\u6237\u8bc1\u4e66\u79d8\u94a5\u7b97\u6cd5\u957f\u5ea6\u548c\u6a21\u677f\u79d8\u94a5\u957f\u5ea6\u4e0d\u4e00\u81f4");
                    result.setError(ErrorEnum.USER_CERT_KEY_ALG_LENGTH_NOT_SAME_WITH_TEMP);
                    return result;
                }
            } else {
                KeyFactory kf = KeyFactory.getInstance("RSA", "BC");
                BCRSAPublicKey bcrsaPublicKey = (BCRSAPublicKey)kf.generatePublic(eks);
                if (privateKeyLength.intValue() != bcrsaPublicKey.getModulus().bitLength()) {
                    this.logger.info("\u7528\u6237\u8bc1\u4e66\u79d8\u94a5\u7b97\u6cd5\u957f\u5ea6\u548c\u6a21\u677f\u79d8\u94a5\u957f\u5ea6\u4e0d\u4e00\u81f4");
                    result.setError(ErrorEnum.USER_CERT_KEY_ALG_LENGTH_NOT_SAME_WITH_TEMP);
                    return result;
                }
            }
        }
        catch (Exception e) {
            this.logger.info("[CertApplyServiceImpl#checkApplyMsgEqualP10] \u7533\u8bf7\u4fe1\u606f\u548cP10\u4e00\u81f4\u6027\u6821\u9a8c IOException", (Throwable)e);
            result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
            return result;
        }
        return Result.success();
    }

    private Result issueApplyHandlerByKeyStore(String applyNo, String raDN, String caDN, String transId, int certFormatType, boolean isOnlineIssue, Integer keyFormat) {
        KeyPair signKeyPair;
        Result result = new Result();
        IssueApplyDTO issueApplyDTO = null;
        try {
            issueApplyDTO = this.issueApplyDao.getIssueApplyInfoByApplyNo(applyNo);
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int certValidity = issueApplyDTO.getCertValidity();
        String signAlg = issueApplyDTO.getSignAlg();
        String tempNo = issueApplyDTO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank((CharSequence)issueApplyDTO.getTempParas())) {
            tempParas = issueApplyDTO.getTempParas();
        }
        String userCertDN = issueApplyDTO.getCertDn();
        String keyAlgName = issueApplyDTO.getKeyAlg();
        int keyLength = issueApplyDTO.getPrivateKeyLength();
        this.logger.info("\u5bc6\u94a5\u7b97\u6cd5\uff1a" + keyAlgName + " \u5bc6\u94a5\u957f\u5ea6\uff1a" + keyLength);
        try {
            signKeyPair = KeyUtils.genKeyPair((String)keyAlgName, (int)keyLength);
        }
        catch (Exception e) {
            this.logger.info("\u751f\u6210\u7528\u6237\u7b7e\u540d\u516c\u79c1\u94a5\u5931\u8d25");
            result.setError(ErrorEnum.GEN_USER_CERT_SIGN_KEY_FAIL);
            return result;
        }
        Result issueResult = this.certLifeCycleManager.issueUserCert(applyNo, null, signKeyPair.getPublic().getEncoded(), raDN, caDN, transId, tempNo, tempParas, signAlg, certValidity, userCertDN, keyFormat);
        if (!issueResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(issueApplyDTO.getCertDn(), applyNo, 4, issueApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u5931\u8d25:" + JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new RuntimeException();
            }
            this.certApplyService.insertCertApplyRecord(1, 5, applyNo, null, 4, issueResult.getErrorBean().getErrMsg(), 7, false, isOnlineIssue);
            this.logger.error("\u8c03\u7528CA\uff0c\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25");
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)issueResult.getInfo();
        Result certInsertResult = this.insertUserCertInfo(issueApplyDTO.getUserId(), issueApplyDTO.getApplyId(), issueApplyDTO.getTempId(), issueApplyDTO.getTempNo(), signAlg, issueApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.setError(certInsertResult.getError());
            return result;
        }
        PrivateKey encPriKey = null;
        if (issueApplyDTO.getCertPatterm() != 1) {
            try {
                byte[] data;
                this.logger.info("\u7b7e\u540d\u79c1\u94a5\uff1a{}", (Object)Base64.toBase64String((byte[])signKeyPair.getPrivate().getEncoded()));
                this.logger.info("\u79c1\u94a5\u4fe1\u5c01\uff1a{}", (Object)userCertInfo.getEncPriKey());
                String encPriKeyStr = CertUtils.getDataFromSignedAndEnvelopedDataByBc((byte[])signKeyPair.getPrivate().getEncoded(), (byte[])userCertInfo.getEncPriKey().getBytes(), (String)CommonVariable.getKeyAlgName());
                this.logger.info("\u52a0\u5bc6\u79c1\u94a5\uff1a{}", (Object)encPriKeyStr);
                byte[] decode = Base64.decode((String)encPriKeyStr);
                if (CommonVariable.getKeyAlgName().equalsIgnoreCase("SM2")) {
                    data = new byte[32];
                    System.arraycopy(decode, 32, data, 0, 32);
                    encPriKey = GMSSLX509Utils.convertSM2PrivateKey((byte[])data);
                } else if (CommonVariable.getKeyAlgName().equalsIgnoreCase("RSA")) {
                    KeyFactory keyFactory = KeyFactory.getInstance(RsaObjectIdentifiers.rsaEncryption.getId(), (Provider)new BouncyCastleProvider());
                    encPriKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decode));
                } else {
                    data = new byte[32];
                    System.arraycopy(decode, 32, data, 0, 32);
                    encPriKey = GMSSLX509Utils.convertPrivateKeyEncode((byte[])data);
                }
            }
            catch (Exception e) {
                this.logger.error("\u4eceP7b\u683c\u5f0f\u4e2d\u83b7\u53d6\u52a0\u5bc6\u79c1\u94a5\u5931\u8d25", (Throwable)e);
                result.setError(ErrorEnum.GET_ENC_PUBLIC_KEY_FROM_P7B_FAIL);
                return result;
            }
        }
        Map keyStores = null;
        try {
            int i;
            String extraCertsP7b = userCertInfo.getExtraCertsP7b();
            List trustCaCerts = Pkcs7Utils.resolveCertChain((String)extraCertsP7b);
            trustCaCerts = CertUtils.sortCerts((List)trustCaCerts);
            int length = trustCaCerts.size();
            X509Certificate[] caCerts = new X509Certificate[length];
            trustCaCerts.toArray(caCerts);
            for (int i2 = 0; i2 < caCerts.length; ++i2) {
                X509Certificate caCert = caCerts[i2];
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("caCert.length {}", (Object)caCerts.length);
                this.logger.debug("caCert issuer{}", (Object)CertUtils.getIssuerByX509Cert((X509Certificate)caCert));
                this.logger.debug("caCert subjcet:{}", (Object)CertUtils.getSubjectByX509Cert((X509Certificate)caCert));
            }
            X509Certificate[] signCert = new X509Certificate[caCerts.length + 1];
            signCert[0] = CertUtils.getCertFromStr((String)userCertInfo.getSignCert());
            for (i = 1; i < signCert.length; ++i) {
                signCert[i] = caCerts[i - 1];
            }
            for (i = 0; i < signCert.length; ++i) {
                X509Certificate x509Certificate = signCert[i];
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("signCert.length {}", (Object)signCert.length);
                this.logger.debug("signCert issuer{}", (Object)CertUtils.getIssuerByX509Cert((X509Certificate)x509Certificate));
                this.logger.debug("signCert subjcet:{}", (Object)CertUtils.getSubjectByX509Cert((X509Certificate)x509Certificate));
            }
            X509Certificate[] encCert = null;
            if (issueApplyDTO.getCertPatterm() != 1) {
                encCert = new X509Certificate[caCerts.length + 1];
                encCert[0] = CertUtils.getCertFromStr((String)userCertInfo.getEncCert());
                for (int i3 = 1; i3 < encCert.length; ++i3) {
                    encCert[i3] = caCerts[i3 - 1];
                }
            }
            keyStores = KeyStoreUtils.generateDoubleCertByKeyStore((boolean)false, (X509Certificate[])signCert, (X509Certificate[])encCert, (PrivateKey)signKeyPair.getPrivate(), (PrivateKey)encPriKey, (int)certFormatType, (String)applyNo, (String)PathConstants.USER_CERT_KEYSTORE_FILE_PATH, (X509Certificate[])caCerts);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u7528\u6237keyStore\u7c7b\u578b\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GEN_USER_CERT_KEY_STORE_FILE_FAIL);
            return result;
        }
        result.setInfo((Object)keyStores);
        return result;
    }

    private Result updateApplyHandlerByKeyStore(String applyNo, String raDN, String caDN, String transId, int certFormatType, boolean isOnlineIssue, Integer keyFormat) {
        Map keyStores;
        KeyPair signKeyPair;
        int keyLength;
        String keyAlgName;
        Result result = new Result();
        UpdateApplyDTO updateApplyDTO = null;
        try {
            updateApplyDTO = this.updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("getUpdateApplyInfo.applyNo:" + applyNo + " \u67e5\u8be2\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a");
        }
        if (updateApplyDTO == null) {
            this.logger.info("\u83b7\u53d6\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int certValidity = updateApplyDTO.getCertValidity();
        String tempNo = updateApplyDTO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank((CharSequence)updateApplyDTO.getTempParas())) {
            tempParas = updateApplyDTO.getTempParas();
        }
        if ("SM3withSM2".equalsIgnoreCase(updateApplyDTO.getSignAlg())) {
            keyAlgName = "SM2";
            keyLength = 256;
        } else if ("SHA256withECDSA".equalsIgnoreCase(updateApplyDTO.getSignAlg())) {
            keyAlgName = "NISTP256";
            keyLength = 256;
        } else {
            keyAlgName = "RSA";
            keyLength = 2048;
        }
        try {
            signKeyPair = KeyUtils.genKeyPair((String)keyAlgName, (int)keyLength);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u7528\u6237\u7b7e\u540d\u516c\u79c1\u94a5\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GEN_USER_CERT_SIGN_KEY_FAIL);
            return result;
        }
        String userCertDN = updateApplyDTO.getCertDn();
        Result updateResult = this.certLifeCycleManager.updateUserCert(applyNo, null, signKeyPair.getPublic().getEncoded(), raDN, caDN, transId, tempNo, tempParas, updateApplyDTO.getSignAlg(), certValidity, userCertDN, updateApplyDTO.getSignSn(), updateApplyDTO.getUpdateKey().booleanValue(), keyFormat);
        if (!updateResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(updateApplyDTO.getCertDn(), applyNo, 4, updateApplyDTO.getTempId());
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u7b7e\u53d1\u5931\u8d25:" + JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new RuntimeException();
            }
            this.certApplyService.insertCertApplyRecord(2, 5, applyNo, null, 4, updateApplyDTO.getApplyReason(), 7, false, isOnlineIssue);
            this.logger.info("\u8c03\u7528CA\uff0c\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25");
            result.setErrorBean(updateResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)updateResult.getInfo();
        Result certInsertResult = this.insertUserCertInfo(updateApplyDTO.getUserId(), updateApplyDTO.getApplyId(), updateApplyDTO.getTempId(), updateApplyDTO.getTempNo(), updateApplyDTO.getSignAlg(), updateApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            throw new RuntimeException();
        }
        if (userCertInfo.getEncPriKey() == null) {
            this.logger.info("CA\u672a\u8fd4\u56de\u52a0\u5bc6\u79c1\u94a5\u4fe1\u5c01");
            throw new RuntimeException();
        }
        PrivateKey encPriKey = null;
        if (updateApplyDTO.getCertPatterm() != 1) {
            try {
                byte[] data;
                String encPriKeyStr = CertUtils.getDataFromSignedAndEnvelopedDataByBc((byte[])signKeyPair.getPrivate().getEncoded(), (byte[])userCertInfo.getEncPriKey().getBytes(), (String)CommonVariable.getKeyAlgName());
                byte[] decode = Base64.decode((String)encPriKeyStr);
                if (CommonVariable.getKeyAlgName().equalsIgnoreCase("SM2")) {
                    data = new byte[32];
                    System.arraycopy(decode, 32, data, 0, 32);
                    encPriKey = GMSSLX509Utils.convertSM2PrivateKey((byte[])data);
                } else if (CommonVariable.getKeyAlgName().equalsIgnoreCase("RSA")) {
                    KeyFactory keyFactory = KeyFactory.getInstance(RsaObjectIdentifiers.rsaEncryption.getId(), (Provider)new BouncyCastleProvider());
                    encPriKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decode));
                } else {
                    data = new byte[32];
                    System.arraycopy(decode, 32, data, 0, 32);
                    encPriKey = GMSSLX509Utils.convertPrivateKeyEncode((byte[])data);
                }
            }
            catch (Exception e) {
                this.logger.error("\u4eceP7b\u683c\u5f0f\u4e2d\u83b7\u53d6\u52a0\u5bc6\u79c1\u94a5\u5931\u8d25", (Throwable)e);
                result.setError(ErrorEnum.GET_ENC_PUBLIC_KEY_FROM_P7B_FAIL);
                return result;
            }
        }
        try {
            String extraCertsP7b = userCertInfo.getExtraCertsP7b();
            List trustCaCerts = Pkcs7Utils.resolveCertChain((String)extraCertsP7b);
            trustCaCerts = CertUtils.sortCerts((List)trustCaCerts);
            int length = trustCaCerts.size();
            X509Certificate[] caCerts = new X509Certificate[length];
            trustCaCerts.toArray(caCerts);
            X509Certificate[] signCert = new X509Certificate[caCerts.length + 1];
            signCert[0] = CertUtils.getCertFromStr((String)userCertInfo.getSignCert());
            for (int i = 1; i < signCert.length; ++i) {
                signCert[i] = caCerts[i - 1];
            }
            X509Certificate[] encCert = null;
            if (updateApplyDTO.getCertPatterm() != 1) {
                encCert = new X509Certificate[caCerts.length + 1];
                encCert[0] = CertUtils.getCertFromStr((String)userCertInfo.getEncCert());
                for (int i = 1; i < encCert.length; ++i) {
                    encCert[i] = caCerts[i - 1];
                }
            }
            keyStores = KeyStoreUtils.generateDoubleCertByKeyStore((boolean)false, (X509Certificate[])signCert, (X509Certificate[])encCert, (PrivateKey)signKeyPair.getPrivate(), (PrivateKey)encPriKey, (int)certFormatType, (String)applyNo, (String)PathConstants.USER_CERT_KEYSTORE_FILE_PATH, (X509Certificate[])caCerts);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u7528\u6237keyStore\u7c7b\u578b\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GEN_USER_CERT_KEY_STORE_FILE_FAIL);
            return result;
        }
        result.setInfo((Object)keyStores);
        return result;
    }

    private Result recoveryApplyHandlerByKeyStore(String applyNo, String raDN, String caDN, String transId, int certFormatType, boolean isOnlineIssue, Integer keyFormat) {
        Map keyStores;
        KeyPair signKeyPair;
        String keyAlgName;
        Result result = new Result();
        RecoveryApplyDTO recoveryApplyDTO = null;
        try {
            recoveryApplyDTO = this.recoveryApplyDao.getRecoveryApplyInfoByApplyNo(applyNo);
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_RECOVERY_APPLY_INFO_IS_EMPTY);
            return result;
        }
        if (recoveryApplyDTO == null) {
            this.logger.info("\u83b7\u53d6\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_RECOVERY_APPLY_INFO_IS_EMPTY);
            return result;
        }
        String signAlg = recoveryApplyDTO.getSignAlg();
        String userCertDN = recoveryApplyDTO.getCertDn();
        int keyLength = 256;
        if ("SM3withSM2".equalsIgnoreCase(signAlg)) {
            keyAlgName = "SM2";
        } else if ("SHA256withECDSA".equalsIgnoreCase(signAlg)) {
            keyAlgName = "NISTP256";
        } else {
            keyAlgName = "RSA";
            keyLength = recoveryApplyDTO.getPrivateKeyLength();
        }
        try {
            signKeyPair = KeyUtils.genKeyPair((String)keyAlgName, (int)keyLength);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u7528\u6237\u7b7e\u540d\u516c\u79c1\u94a5\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GEN_USER_CERT_SIGN_KEY_FAIL);
            return result;
        }
        Result recoveryResult = this.certLifeCycleManager.recoveryUserCert(applyNo, raDN, caDN, signKeyPair.getPublic().getEncoded(), recoveryApplyDTO.getSignSn(), transId, signAlg, userCertDN, keyFormat);
        if (!recoveryResult.isSuccess()) {
            Result issueCertApplyResult = this.certApplyService.updateCertApplyInfo(recoveryApplyDTO.getCertDn(), applyNo, 4, Long.valueOf(recoveryApplyDTO.getTempId()));
            if (issueCertApplyResult.getCode() != 0) {
                this.logger.info("\u64cd\u4f5c\u6062\u590d\u5931\u8d25:" + JsonUtils.object2Json((Object)issueCertApplyResult));
                throw new RuntimeException();
            }
            this.certApplyService.insertCertApplyRecord(4, 5, applyNo, null, 4, recoveryResult.getErrorBean().getErrMsg(), 7, false, isOnlineIssue);
            this.logger.error("\u8c03\u7528CA\uff0c\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25");
            result.setErrorBean(recoveryResult.getErrorBean());
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)recoveryResult.getInfo();
        Result certInsertResult = this.insertUserCertInfoByRecovery(recoveryApplyDTO.getUserId(), recoveryApplyDTO.getApplyId(), recoveryApplyDTO.getTempId(), recoveryApplyDTO.getTempNo(), signAlg, recoveryApplyDTO.getPrivateKeyLength(), userCertInfo);
        if (!certInsertResult.isSuccess()) {
            this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.setError(certInsertResult.getError());
            return result;
        }
        if (userCertInfo.getEncPriKey() == null) {
            this.logger.info("CA\u672a\u8fd4\u56de\u52a0\u5bc6\u79c1\u94a5\u4fe1\u5c01");
            throw new RuntimeException();
        }
        PrivateKey encPriKey = null;
        try {
            byte[] data;
            this.logger.info("\u7b7e\u540d\u79c1\u94a5\uff1a" + Base64.toBase64String((byte[])signKeyPair.getPrivate().getEncoded()) + " \u79c1\u94a5\u4fe1\u5c01\uff1a" + userCertInfo.getEncPriKey());
            String encPriKeyStr = CertUtils.getDataFromSignedAndEnvelopedDataByBc((byte[])signKeyPair.getPrivate().getEncoded(), (byte[])userCertInfo.getEncPriKey().getBytes(), (String)CommonVariable.getKeyAlgName());
            this.logger.info("\u52a0\u5bc6\u79c1\u94a5\uff1a" + encPriKeyStr);
            byte[] decode = Base64.decode((String)encPriKeyStr);
            if (CommonVariable.getKeyAlgName().equalsIgnoreCase("SM2")) {
                data = new byte[32];
                System.arraycopy(decode, 32, data, 0, 32);
                encPriKey = GMSSLX509Utils.convertSM2PrivateKey((byte[])data);
            } else if (CommonVariable.getKeyAlgName().equalsIgnoreCase("RSA")) {
                KeyFactory keyFactory = KeyFactory.getInstance(RsaObjectIdentifiers.rsaEncryption.getId(), (Provider)new BouncyCastleProvider());
                encPriKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decode));
            } else {
                data = new byte[32];
                System.arraycopy(decode, 32, data, 0, 32);
                encPriKey = GMSSLX509Utils.convertPrivateKeyEncode((byte[])data);
            }
        }
        catch (Exception e) {
            this.logger.error("\u4eceP7b\u683c\u5f0f\u4e2d\u83b7\u53d6\u52a0\u5bc6\u79c1\u94a5\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GET_ENC_PUBLIC_KEY_FROM_P7B_FAIL);
            return result;
        }
        try {
            String extraCertsP7b = userCertInfo.getExtraCertsP7b();
            List trustCaCerts = Pkcs7Utils.resolveCertChain((String)extraCertsP7b);
            trustCaCerts = CertUtils.sortCerts((List)trustCaCerts);
            int length = trustCaCerts.size();
            X509Certificate[] caCerts = new X509Certificate[length];
            trustCaCerts.toArray(caCerts);
            X509Certificate[] signCert = new X509Certificate[caCerts.length + 1];
            signCert[0] = CertUtils.getCertFromStr((String)userCertInfo.getSignCert());
            for (int i = 1; i < signCert.length; ++i) {
                signCert[i] = caCerts[i - 1];
            }
            X509Certificate[] encCert = new X509Certificate[caCerts.length + 1];
            encCert[0] = CertUtils.getCertFromStr((String)userCertInfo.getEncCert());
            for (int i = 1; i < encCert.length; ++i) {
                encCert[i] = caCerts[i - 1];
            }
            keyStores = KeyStoreUtils.generateDoubleCertByKeyStore((boolean)false, (X509Certificate[])signCert, (X509Certificate[])encCert, (PrivateKey)signKeyPair.getPrivate(), (PrivateKey)encPriKey, (int)certFormatType, (String)applyNo, (String)PathConstants.USER_CERT_KEYSTORE_FILE_PATH, (X509Certificate[])caCerts);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u7528\u6237keyStore\u7c7b\u578b\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GEN_USER_CERT_KEY_STORE_FILE_FAIL);
            return result;
        }
        result.setInfo((Object)keyStores);
        return result;
    }

    private Result insertUserCertInfoByRecovery(long userId, long applyId, long tempId, String tempNo, String signAlg, int privateKeyLength, UserCertInfo userCertInfo) {
        Result result = new Result();
        String signCert = userCertInfo.getSignCert();
        if (StringUtils.isBlank((CharSequence)signCert)) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u4e3a\u7a7a");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_INFO_IS_EMPTY);
            return result;
        }
        long pairCertIndex = this.raSdkCache.getIncPairCertIndex();
        UserCertDO signCertDO = new UserCertDO();
        signCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        signCertDO.setCertType(Integer.valueOf(2));
        signCertDO.setCertStatus(Integer.valueOf(0));
        signCertDO.setUserId(Long.valueOf(userId));
        signCertDO.setApplyId(Long.valueOf(applyId));
        signCertDO.setTempId(Long.valueOf(tempId));
        signCertDO.setTempNo(tempNo);
        signCertDO.setSignAlg(signAlg);
        signCertDO.setPrivateKeyLength(Integer.valueOf(privateKeyLength));
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            this.logger.info("\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        signCertDO.setCaCertId(newCaCertInfo.getId());
        X509Certificate signCertStr = CertUtils.getCertFromStr((String)signCert);
        if (signCertStr == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u9519\u8bef");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
            return result;
        }
        signCertDO.setCertSn(signCertStr.getSerialNumber().toString(16).toLowerCase());
        signCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCertStr));
        Date startDate = signCertStr.getNotBefore();
        Date endDate = signCertStr.getNotAfter();
        signCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        signCertDO.setFailureTime(new Timestamp(endDate.getTime()));
        int certDays = (int)((endDate.getTime() - startDate.getTime()) / 86400000L);
        signCertDO.setCertValidity(Integer.valueOf(certDays));
        int priKeyDays = (int)((newCaCertInfo.getFailureTime().getTime() - startDate.getTime()) / 86400000L);
        signCertDO.setEncKeyValidity(Integer.valueOf(priKeyDays));
        Date date = new Date();
        signCertDO.setGmtCreate(new Timestamp(date.getTime()));
        signCertDO.setGmtUpdate(new Timestamp(date.getTime()));
        this.userCertDao.insertUserCertInfo(signCertDO);
        return result;
    }

    private String getRAServiceDnName() {
        X509Certificate certFromStr = CommonVariable.getRaServiceCert();
        String raServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return raServiceDnName;
    }

    private String getCAServiceDnName() {
        X509Certificate certFromStr = CommonVariable.getCaServiceCert();
        String caServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return caServiceDnName;
    }
}

