/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.core.exception.ServiceException;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.asn1.NISTObjectIdentifiers;
import com.xdja.pki.ra.core.asn1.SM2ObjectIdentifiers;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.DoubleCodeUseEnum;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.DoubleCodeDao;
import com.xdja.pki.ra.manager.dao.IssueApplyDao;
import com.xdja.pki.ra.manager.dao.UpdateApplyDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.DoubleCodeDO;
import com.xdja.pki.ra.manager.dao.model.IssueApplyDO;
import com.xdja.pki.ra.manager.dao.model.UpdateApplyDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.CertApplyServiceIssue;
import com.xdja.pki.ra.service.manager.certapply.bean.DoubleCode;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CertApplyServiceIssueImpl
implements CertApplyServiceIssue {
    private Logger logger = LoggerFactory.getLogger(CertApplyServiceIssueImpl.class);
    @Autowired
    private BaseUserDao baseUserDao;
    @Autowired
    private CertApplyDao certApplyDao;
    @Autowired
    private DoubleCodeDao doubleCodeDao;
    @Autowired
    private IssueApplyDao issueApplyDao;
    @Autowired
    private UpdateApplyDao updateApplyDao;
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    private UserCertDao userCertDao;
    @Autowired
    private CertLifeCycleManager certLifeCycleManager;
    @Autowired
    private CertApplyService certApplyService;
    @Autowired
    private RaSdkCache raSdkCache;
    @Autowired
    CertTempCache certTempCache;

    public Result certApplyCarry(int applyType, String systemFlag, String applyNo, DoubleCode doubleCode, byte[] issueBytes, Integer keyFormat) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("certApplyCarry applyType:[{}] applyNo:[{}]", (Object)applyType, (Object)applyNo);
        }
        String cardNo = null;
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            return Result.failure((ErrorEnum)ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66DN\u540d\u5b57\u9519\u8bef");
            return Result.failure((ErrorEnum)ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
        }
        if ("RSA".equalsIgnoreCase(CommonVariable.getKeyAlgName()) && Constants.KEY_FORMAT_0016_2.equals(keyFormat)) {
            this.logger.error("RSA\u7b97\u6cd5\u4e0d\u63d0\u4f9b0016\u7684\u79c1\u94a5\u683c\u5f0f keyAlgName:{}", (Object)CommonVariable.getKeyAlgName());
            return Result.failure((ErrorEnum)ErrorEnum.RSA_ALG_CANNOT_BUILD_0016_KEY_FORMAT);
        }
        BaseUserDO baseUserDO = this.baseUserDao.getBaseUserInfo((long)Integer.parseInt(doubleCode.getRefCode()));
        if (baseUserDO == null || !systemFlag.equals(baseUserDO.getSystemFlag())) {
            this.logger.error("\u6b64\u7528\u6237\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.THE_USER_IS_NOT_EXIT);
        }
        CertApplyDO certApplyInfo = this.certApplyDao.getCertApplyInfo(applyNo);
        if (certApplyInfo == null || applyType != certApplyInfo.getApplyType()) {
            this.logger.error("\u4e0d\u5b58\u5728\u5f53\u524d\u7533\u8bf7\u7f16\u53f7\u5bf9\u5e94\u7684\u7533\u8bf7\u8bb0\u5f55 applyNo:{}", (Object)applyNo);
            return Result.failure((ErrorEnum)ErrorEnum.CANNOT_FIND_APPLY_BY_NO);
        }
        if (3 != certApplyInfo.getApplyStatus()) {
            this.logger.error("\u5f53\u524d\u7533\u8bf7\u72b6\u6001\u4e0d\u53ef\u53d1\u8d77\u7b7e\u53d1 applyStatus:{}", (Object)certApplyInfo.getApplyStatus());
            return Result.failure((ErrorEnum)ErrorEnum.APPLY_STATUS_NOT_SUPPORT_ISSUE_CERT);
        }
        DoubleCodeDO doubleCodeDO = this.doubleCodeDao.getDoubleCode(applyNo);
        if (doubleCodeDO == null || DoubleCodeUseEnum.IS_USE.id == doubleCodeDO.getIsUse() || !String.valueOf(doubleCodeDO.getRefCode()).equals(doubleCode.getRefCode())) {
            return Result.failure((ErrorEnum)ErrorEnum.DOUBLE_CODE_HAS_USED);
        }
        String raTransId = this.raSdkCache.getIncCaCmpTransId();
        this.raSdkCache.cacheCaTransId(applyNo, raTransId);
        if (1 == applyType) {
            result = this.issueApplyHandler(applyNo, systemFlag, cardNo, issueBytes, raServiceDnName, caServiceDnName, raTransId, true, keyFormat, certApplyInfo);
        } else if (2 == applyType) {
            result = this.updateApplyHandler(applyNo, systemFlag, cardNo, issueBytes, raServiceDnName, caServiceDnName, raTransId, true, keyFormat, certApplyInfo);
        }
        if (result.isSuccess()) {
            this.doubleCodeDao.updateStatus(doubleCode.getRefCode(), doubleCode.getAuthCode());
        } else {
            this.logger.error("\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u5904\u7406\u5931\u8d25");
        }
        return result;
    }

    private Result issueApplyHandler(String applyNo, String systemFlag, String cardNo, byte[] issueBytes, String raDN, String caDN, String transId, boolean isOnlineIssue, Integer keyFormat, CertApplyDO certApplyInfo) {
        IssueApplyDO issueApplyDO = this.issueApplyDao.getIssueApplyInfoByApplyId(certApplyInfo.getId().longValue());
        CertTempDO certTempDO = this.certTempCache.getCertTempInfoByTempId(certApplyInfo.getTempId().longValue());
        if (issueApplyDO == null || certTempDO == null) {
            this.logger.error("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            return Result.failure((ErrorEnum)ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
        }
        PublicKey publicKey = CertUtils.getPublicKeyBySubjectPublicInfo((String)Base64.toBase64String((byte[])issueBytes));
        Result result = this.checkApplyMsgEqualP10(publicKey, certTempDO);
        if (!result.isSuccess()) {
            return result;
        }
        int certValidity = issueApplyDO.getCertValidity();
        String signAlg = issueApplyDO.getSignAlg();
        String tempNo = certTempDO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank((CharSequence)issueApplyDO.getTempParas())) {
            tempParas = issueApplyDO.getTempParas();
        }
        if ((result = this.certLifeCycleManager.issueUserCert(applyNo, cardNo, issueBytes, raDN, caDN, transId, tempNo, tempParas, signAlg, certValidity, certApplyInfo.getCertDn(), keyFormat)).isSuccess()) {
            UserCertInfo userCertInfo = (UserCertInfo)result.getInfo();
            Result certInsertResult = this.insertUserCertInfo(certApplyInfo.getUserId(), issueApplyDO.getApplyId(), certApplyInfo.getTempId(), certTempDO.getTempNo(), signAlg, issueApplyDO.getPrivateKeyLength(), userCertInfo);
            if (!certInsertResult.isSuccess()) {
                this.logger.error("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
                return certInsertResult;
            }
        } else {
            certApplyInfo.setAdminId(Long.valueOf(666L));
            certApplyInfo.setAdminCertDn("CN=\u5f53\u524d\u767b\u5f55\u7684\u7ba1\u7406\u5458\uff0cO=**\u7701\u516c\u5b89\u5385\uff0cC=CN");
            certApplyInfo.setApplyStatus(Integer.valueOf(4));
            certApplyInfo.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
            int updateCertApplyStatusResult = this.certApplyDao.updateCertApply(certApplyInfo);
            if (updateCertApplyStatusResult <= 0) {
                this.logger.error("\u66f4\u65b0\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
                return Result.failure((ErrorEnum)ErrorEnum.UPDATE_CERT_APPLY_INFO_FAIL);
            }
            this.certApplyService.insertCertApplyRecord(1, 5, applyNo, systemFlag, 4, result.getErrorBean().getErrMsg(), 7, false, isOnlineIssue);
            this.logger.error("\u8c03\u7528CA\uff0c\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25");
        }
        return result;
    }

    private Result updateApplyHandler(String applyNo, String systemFlag, String cardNo, byte[] issueBytes, String raDN, String caDN, String transId, boolean isOnlineIssue, Integer keyFormat, CertApplyDO certApplyInfo) {
        Result result;
        boolean updateKey;
        UpdateApplyDO updateApplyDO = this.updateApplyDao.getUpdateApplyInfoByApplyId(certApplyInfo.getId().longValue());
        CertTempDO certTempDO = this.certTempCache.getCertTempInfoByTempId(certApplyInfo.getTempId().longValue());
        if (updateApplyDO == null || certTempDO == null) {
            this.logger.error("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            return Result.failure((ErrorEnum)ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
        }
        int certValidity = updateApplyDO.getCertValidity();
        String signAlg = updateApplyDO.getSignAlg();
        String tempNo = certTempDO.getTempNo();
        String tempParas = null;
        if (StringUtils.isNotBlank((CharSequence)updateApplyDO.getTempParas())) {
            tempParas = updateApplyDO.getTempParas();
        }
        boolean bl = updateKey = updateApplyDO.getIsUpdateKey() == 1;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("updateApplyDO.getIsUpdateKey() :[{}]", (Object)updateApplyDO.getIsUpdateKey());
            this.logger.debug("updateKey :[{}]", (Object)updateKey);
        }
        if (updateKey) {
            if (null == issueBytes) {
                this.logger.info("\u66f4\u65b0\u5bc6\u94a5\u65f6\uff0c\u5fc5\u987b\u4e0a\u4f20p10\u6587\u4ef6");
                return Result.failure((ErrorEnum)ErrorEnum.UPDATE_KEY_NEED_P10_FILE);
            }
            PublicKey publicKey = CertUtils.getPublicKeyBySubjectPublicInfo((String)Base64.toBase64String((byte[])issueBytes));
            result = this.checkApplyMsgEqualP10(publicKey, certTempDO);
            if (!result.isSuccess()) {
                return result;
            }
        }
        if ((result = this.certLifeCycleManager.updateUserCert(applyNo, cardNo, issueBytes, raDN, caDN, transId, tempNo, tempParas, signAlg, certValidity, certApplyInfo.getCertDn(), updateApplyDO.getSignSn(), updateKey, keyFormat)).isSuccess()) {
            UserCertInfo userCertInfo = (UserCertInfo)result.getInfo();
            Result certInsertResult = this.insertUserCertInfo(certApplyInfo.getUserId(), updateApplyDO.getApplyId(), certApplyInfo.getTempId(), tempNo, signAlg, updateApplyDO.getPrivateKeyLength(), userCertInfo);
            if (!certInsertResult.isSuccess()) {
                this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
                return certInsertResult;
            }
        } else {
            certApplyInfo.setAdminId(Long.valueOf(666L));
            certApplyInfo.setAdminCertDn("CN=\u5f53\u524d\u767b\u5f55\u7684\u7ba1\u7406\u5458\uff0cO=**\u7701\u516c\u5b89\u5385\uff0cC=CN");
            certApplyInfo.setApplyStatus(Integer.valueOf(4));
            certApplyInfo.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
            int updateCertApplyStatusResult = this.certApplyDao.updateCertApply(certApplyInfo);
            if (updateCertApplyStatusResult <= 0) {
                this.logger.info("\u66f4\u65b0\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)certApplyInfo));
                throw new ServiceException("\u66f4\u65b0\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25");
            }
            this.certApplyService.insertCertApplyRecord(2, 5, applyNo, systemFlag, 4, updateApplyDO.getApplyReason(), 7, false, isOnlineIssue);
            this.logger.info("\u8c03\u7528CA\uff0c\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25");
        }
        return result;
    }

    private Result checkApplyMsgEqualP10(PublicKey publicKey, CertTempDO certTemp) {
        String algorithm;
        this.logger.info("\u5f00\u59cb\u6821\u9a8c\u7533\u8bf7\u4e2d\u7684\u516c\u94a5\u4fe1\u606f\u548c\u6a21\u677f\u8981\u6c42\u662f\u5426\u4e00\u81f4");
        Result result = new Result();
        String publicKeyAlg = certTemp.getPublicKeyAlg();
        Integer privateKeyLength = certTemp.getPrivateKeyLength();
        SubjectPublicKeyInfo instance = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        ASN1Encodable asn1Encodable = instance.getAlgorithmId().getParameters();
        if ("RSA".equals(publicKey.getAlgorithm())) {
            algorithm = "RSA";
        } else {
            ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(asn1Encodable.toString());
            if (oid.equals((Object)SM2ObjectIdentifiers.sm2256)) {
                algorithm = "SM2";
            } else if (oid.equals((Object)NISTObjectIdentifiers.nist256)) {
                algorithm = "ECC";
            } else {
                this.logger.info("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
                result.setError(ErrorEnum.NOT_SUPPORTED_SIGN_ALG);
                return result;
            }
        }
        this.logger.info("\u7533\u8bf7\u4e66\u4e2d\u7684\u7528\u6237\u7b97\u6cd5\u4e3a:{}", (Object)algorithm);
        if (!algorithm.equalsIgnoreCase(publicKeyAlg)) {
            this.logger.info("\u7528\u6237\u8bc1\u4e66\u7b97\u6cd5\u548c\u5f53\u524d\u6a21\u677f\u516c\u94a5\u7b97\u6cd5\u4e0d\u4e00\u81f4");
            result.setError(ErrorEnum.USER_CERT_KEY_ALG_NOT_SAME_WITH_TEMP);
            return result;
        }
        try {
            X509EncodedKeySpec eks = new X509EncodedKeySpec(new DERBitString((ASN1Encodable)instance).getBytes());
            if (algorithm.equalsIgnoreCase("SM2") || algorithm.equalsIgnoreCase("ECC")) {
                KeyFactory kf = KeyFactory.getInstance("EC", "BC");
                BCECPublicKey bcecPublicKey = (BCECPublicKey)kf.generatePublic(eks);
                int length = bcecPublicKey.getW().getAffineX().bitLength();
                this.logger.info("\u8bc1\u4e66\u5bc6\u94a5\u7b97\u6cd5\u957f\u5ea6\u4e3a:{}", (Object)length);
                if (privateKeyLength != 256) {
                    this.logger.error("\u7528\u6237\u8bc1\u4e66\u79d8\u94a5\u7b97\u6cd5\u957f\u5ea6\u548c\u6a21\u677f\u79d8\u94a5\u957f\u5ea6\u4e0d\u4e00\u81f4");
                    result.setError(ErrorEnum.USER_CERT_KEY_ALG_LENGTH_NOT_SAME_WITH_TEMP);
                    return result;
                }
            } else {
                KeyFactory kf = KeyFactory.getInstance("RSA", "BC");
                BCRSAPublicKey bcrsaPublicKey = (BCRSAPublicKey)kf.generatePublic(eks);
                if (privateKeyLength.intValue() != bcrsaPublicKey.getModulus().bitLength()) {
                    this.logger.info("\u7528\u6237\u8bc1\u4e66\u79d8\u94a5\u7b97\u6cd5\u957f\u5ea6\u548c\u6a21\u677f\u79d8\u94a5\u957f\u5ea6\u4e0d\u4e00\u81f4");
                    result.setError(ErrorEnum.USER_CERT_KEY_ALG_LENGTH_NOT_SAME_WITH_TEMP);
                    return result;
                }
            }
        }
        catch (Exception e) {
            this.logger.info("[CertApplyServiceImpl#checkApplyMsgEqualP10] \u7533\u8bf7\u4fe1\u606f\u548cP10\u4e00\u81f4\u6027\u6821\u9a8c IOException", (Throwable)e);
            result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
            return result;
        }
        return Result.success();
    }

    private Result insertUserCertInfo(long userId, long applyId, long tempId, String tempNo, String signAlg, int privateKeyLength, UserCertInfo userCertInfo) {
        Result result = new Result();
        String signCert = userCertInfo.getSignCert();
        if (StringUtils.isBlank((CharSequence)signCert)) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u4e3a\u7a7a");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_INFO_IS_EMPTY);
            return result;
        }
        X509Certificate signCertStr = CertUtils.getCertFromStr((String)signCert);
        if (signCertStr == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u9519\u8bef");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
            return result;
        }
        long pairCertIndex = this.raSdkCache.getIncPairCertIndex();
        UserCertDO signCertDO = new UserCertDO();
        signCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        if (StringUtils.isBlank((CharSequence)userCertInfo.getEncCert())) {
            signCertDO.setCertType(Integer.valueOf(1));
        } else {
            signCertDO.setCertType(Integer.valueOf(2));
        }
        signCertDO.setCertStatus(Integer.valueOf(0));
        signCertDO.setUserId(Long.valueOf(userId));
        signCertDO.setApplyId(Long.valueOf(applyId));
        signCertDO.setTempId(Long.valueOf(tempId));
        signCertDO.setTempNo(tempNo);
        signCertDO.setSignAlg(signAlg);
        signCertDO.setPrivateKeyLength(Integer.valueOf(privateKeyLength));
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            this.logger.info("\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        signCertDO.setCaCertId(newCaCertInfo.getId());
        signCertDO.setCertSn(signCertStr.getSerialNumber().toString(16).toLowerCase());
        signCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCertStr));
        Date startDate = signCertStr.getNotBefore();
        Date endDate = signCertStr.getNotAfter();
        signCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        signCertDO.setFailureTime(new Timestamp(endDate.getTime()));
        int certDays = (int)((endDate.getTime() - startDate.getTime()) / 86400000L);
        signCertDO.setCertValidity(Integer.valueOf(certDays));
        int priKeyDays = (int)((newCaCertInfo.getFailureTime().getTime() - startDate.getTime()) / 86400000L);
        signCertDO.setEncKeyValidity(Integer.valueOf(priKeyDays));
        Date date = new Date();
        signCertDO.setGmtCreate(new Timestamp(date.getTime()));
        signCertDO.setGmtUpdate(new Timestamp(date.getTime()));
        UserCertDO userSignCertDO = this.userCertDao.insertUserCertInfo(signCertDO);
        String encCert = userCertInfo.getEncCert();
        if (StringUtils.isNotBlank((CharSequence)encCert)) {
            UserCertDO encCertDO = new UserCertDO();
            encCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
            encCertDO.setCertType(Integer.valueOf(3));
            encCertDO.setCertStatus(Integer.valueOf(0));
            encCertDO.setUserId(Long.valueOf(userId));
            encCertDO.setApplyId(Long.valueOf(applyId));
            encCertDO.setTempId(Long.valueOf(tempId));
            encCertDO.setTempNo(tempNo);
            encCertDO.setSignAlg(signAlg);
            encCertDO.setPrivateKeyLength(Integer.valueOf(privateKeyLength));
            encCertDO.setCaCertId(newCaCertInfo.getId());
            encCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
            encCertDO.setFailureTime(new Timestamp(endDate.getTime()));
            encCertDO.setCertValidity(Integer.valueOf(certDays));
            encCertDO.setEncKeyValidity(Integer.valueOf(priKeyDays));
            X509Certificate encCertStr = CertUtils.getCertFromStr((String)encCert);
            if (encCertStr == null) {
                this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u52a0\u5bc6\u8bc1\u4e66\u9519\u8bef");
                result.setError(ErrorEnum.CA_RESPONSE_USER_ENC_CERT_ERROR);
                return result;
            }
            encCertDO.setGmtCreate(new Timestamp(date.getTime()));
            encCertDO.setGmtUpdate(new Timestamp(date.getTime()));
            encCertDO.setCertSn(encCertStr.getSerialNumber().toString(16).toLowerCase());
            encCertDO.setSignCertSn(userSignCertDO.getCertSn());
            try {
                encCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)encCertStr));
                this.userCertDao.insertUserCertInfo(encCertDO);
            }
            catch (Exception e) {
                this.logger.info("\u624b\u52a8\u5904\u7406manager\u5c42\u7684\u63d2\u5165\u5f02\u5e38");
                this.userCertDao.deleteUserCert(userSignCertDO.getId().longValue());
            }
        }
        return result;
    }

    private String getRAServiceDnName() {
        X509Certificate certFromStr = CommonVariable.getRaServiceCert();
        return CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
    }

    private String getCAServiceDnName() {
        X509Certificate certFromStr = CommonVariable.getCaServiceCert();
        return CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
    }
}

