/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.certapply;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.pki.core.exception.JSONException;
import com.xdja.pki.core.utils.JsonMapper;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyStatusEnum;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.DoubleCodeUseEnum;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.commonenum.ExtensionAttrTypeEnum;
import com.xdja.pki.ra.core.commonenum.KeyLengthEnum;
import com.xdja.pki.ra.core.commonenum.PersonIdentificationCodeEnum;
import com.xdja.pki.ra.core.commonenum.RevokeReasonEnum;
import com.xdja.pki.ra.core.commonenum.SignAlgEnum;
import com.xdja.pki.ra.core.commonenum.SubjectReplacementNameEnum;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.manager.dao.ApplyRecordDao;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.CustomerDao;
import com.xdja.pki.ra.manager.dao.DoubleCodeDao;
import com.xdja.pki.ra.manager.dao.IssueApplyDao;
import com.xdja.pki.ra.manager.dao.RevokeApplyDao;
import com.xdja.pki.ra.manager.dao.UpdateApplyDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.DoubleCodeDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.FreezeApplyDTO;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import com.xdja.pki.ra.manager.dto.RecoveryApplyDTO;
import com.xdja.pki.ra.manager.dto.RevokeApplyDTO;
import com.xdja.pki.ra.manager.dto.UpdateApplyDTO;
import com.xdja.pki.ra.service.manager.CommonService;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import com.xdja.pki.ra.service.manager.certapply.CertApplyManagerService;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.CertApplyServiceIssue;
import com.xdja.pki.ra.service.manager.certapply.FreezeApplyService;
import com.xdja.pki.ra.service.manager.certapply.IssueApplyService;
import com.xdja.pki.ra.service.manager.certapply.RecoveryApplyService;
import com.xdja.pki.ra.service.manager.certapply.RevokeApplyService;
import com.xdja.pki.ra.service.manager.certapply.UpdateApplyService;
import com.xdja.pki.ra.service.manager.certapply.bean.ApplyLaunch;
import com.xdja.pki.ra.service.manager.certapply.bean.ApplyRep;
import com.xdja.pki.ra.service.manager.certapply.bean.AttrType;
import com.xdja.pki.ra.service.manager.certapply.bean.BaseCertApply;
import com.xdja.pki.ra.service.manager.certapply.bean.CertApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.CheckApply;
import com.xdja.pki.ra.service.manager.certapply.bean.DoubleCode;
import com.xdja.pki.ra.service.manager.certapply.bean.EditCertApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.ErrorMsg;
import com.xdja.pki.ra.service.manager.certapply.bean.Extension;
import com.xdja.pki.ra.service.manager.certapply.bean.ExtensionAttr;
import com.xdja.pki.ra.service.manager.certapply.bean.FreezeApply;
import com.xdja.pki.ra.service.manager.certapply.bean.FreezeApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.IssueApply;
import com.xdja.pki.ra.service.manager.certapply.bean.IssueApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.RecoveryApply;
import com.xdja.pki.ra.service.manager.certapply.bean.RecoveryApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.RevokeApply;
import com.xdja.pki.ra.service.manager.certapply.bean.RevokeApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.TemplateInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.UpdateApply;
import com.xdja.pki.ra.service.manager.certapply.bean.UpdateApplyInfo;
import com.xdja.pki.ra.service.manager.template.CertTempService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CertApplyServiceManagerImpl
implements CertApplyManagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    BaseUserService baseUserService;
    @Autowired
    private IssueApplyService issueApplyService;
    @Autowired
    private UpdateApplyService updateApplyService;
    @Autowired
    private RevokeApplyService revokeApplyService;
    @Autowired
    private RecoveryApplyService recoveryApplyService;
    @Autowired
    private CertApplyService certApplyService;
    @Autowired
    private CertApplyServiceIssue certApplyServiceIssue;
    @Autowired
    private FreezeApplyService freezeApplyService;
    @Autowired
    private BaseUserDao baseUserDao;
    @Autowired
    private UserCertDao userCertDao;
    @Autowired
    private DoubleCodeDao doubleCodeDao;
    @Autowired
    private CertApplyDao certApplyDao;
    @Autowired
    private CommonService commonService;
    @Autowired
    private CustomerDao customerDao;
    @Autowired
    private CertTempService certTempService;
    @Autowired
    UpdateApplyDao updateApplyDao;
    @Autowired
    RevokeApplyDao revokeApplyDao;
    @Autowired
    ApplyRecordDao applyRecordDao;
    @Autowired
    IssueApplyDao issueApplyDao;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    RaSdkCache raSdkCache;
    @Autowired
    CertTempCache certTempCache;

    public Result getRABaseDn() {
        Result result = this.certApplyService.getRaBaseDn();
        return result;
    }

    public Result getTemplateInfoList(String systemName) {
        Result result = new Result();
        ArrayList<TemplateInfo> templateInfos = new ArrayList<TemplateInfo>();
        List certTempDOList = null;
        try {
            certTempDOList = this.customerDao.getTempNoList(systemName);
            if (null == certTempDOList || CollectionUtils.isEmpty((Collection)certTempDOList)) {
                result.setInfo(templateInfos);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6a21\u677f\u5217\u8868\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_TEMP_LIST_IS_EMPTY);
            return result;
        }
        for (CertTempDO certTempDO : certTempDOList) {
            TemplateInfo templateInfo = new TemplateInfo();
            templateInfo.setKeyLength(certTempDO.getPrivateKeyLength());
            templateInfo.setSignAlg(certTempDO.getSignAlg());
            templateInfo.setTempCertValidity(certTempDO.getMaxValidity());
            templateInfo.setTempNo(certTempDO.getTempNo());
            templateInfo.setCheckStrategy(certTempDO.getCheckStrategy());
            templateInfo.setBaseDn(certTempDO.getBaseDn());
            templateInfo.setUserCA(certTempDO.getUserCA());
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            List<ExtensionAttr> extensionAttrs = this.formatExtensionJon(certTempDO.getTempParas());
            for (ExtensionAttr extensionAttr : extensionAttrs) {
                Extension extension = new Extension();
                extension.setAttrOid(extensionAttr.getAttrOid());
                extension.setAttrName(extensionAttr.getAttrName());
                extension.setAttrRequired(extensionAttr.getAttrRequired());
                extension.setAttrCustomize(extensionAttr.getAttrCustomize());
                ArrayList<AttrType> attrTypes = new ArrayList<AttrType>();
                String[] types = extensionAttr.getAttrType().split("#");
                for (int i = 0; i < types.length; ++i) {
                    AttrType attrType = new AttrType();
                    attrType.setAttrTypeNo(types[i]);
                    if (extensionAttr.getAttrOid().equals(ExtensionAttrTypeEnum.PERSONAL_IDENTIFICATION_CODE.oid)) {
                        attrType.setAttrTypeName(PersonIdentificationCodeEnum.getNameFormId((String)types[i]));
                    } else if (extensionAttr.getAttrOid().equals(ExtensionAttrTypeEnum.SUBJECT_REPLACEMENT_NAME.oid)) {
                        attrType.setAttrTypeName(SubjectReplacementNameEnum.getNameFormId((String)types[i]));
                    } else {
                        attrType.setAttrTypeName("");
                    }
                    attrType.setAttrTypeValue("");
                    attrTypes.add(attrType);
                }
                extension.setAttrTypeList(attrTypes);
                extensions.add(extension);
            }
            templateInfo.setExtensions(extensions);
            templateInfos.add(templateInfo);
        }
        result.setInfo(templateInfos);
        return result;
    }

    @Transactional
    public Result issueApplyLaunch(IssueApply issueApply, String systemFlag) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("issueApplyLaunch---------------------\u7b7e\u53d1\u7533\u8bf7-\u53d1\u8d77");
        }
        ApplyLaunch applyLaunch = new ApplyLaunch();
        applyLaunch.setApplyType(Integer.valueOf(ApplyTypeEnum.ISSUE_APPLY.id));
        Result result = this.checkValidity(issueApply.getCertValidity(), true, null, issueApply.getTempNo());
        if (!result.isSuccess()) {
            return result;
        }
        issueApply.setCertValidity((Integer)result.getInfo());
        result = this.checkParameter(issueApply.getPrivateKeyLength(), issueApply.getSignAlg());
        if (!result.isSuccess()) {
            return result;
        }
        List certTempDOList = this.customerDao.getTempNoList(systemFlag);
        boolean flag = false;
        String baseDn = null;
        for (CertTempDO certTempDO : certTempDOList) {
            if (!certTempDO.getTempNo().equals(issueApply.getTempNo())) continue;
            flag = true;
            baseDn = certTempDO.getBaseDn();
        }
        if (!flag) {
            this.logger.error("\u6a21\u677f:[{}]\u672a\u6388\u6743\u7ed9\u8be5\u7b2c\u4e09\u65b9\u7cfb\u7edf:[{}]", (Object)issueApply.getTempNo(), (Object)systemFlag);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_TEMPLATE_IS_NOT_AUTHORIZATION);
        }
        int count = this.baseUserService.queryUserExist(issueApply.getLicenseType(), issueApply.getLicenseNumber(), issueApply.getUserType(), systemFlag);
        if (count == 0) {
            this.logger.error("\u6b64\u7528\u6237\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.THE_USER_IS_NOT_EXIT);
        }
        applyLaunch.setIssueApply(issueApply);
        result = this.getApplyLaunchResult(systemFlag, applyLaunch, baseDn);
        return result;
    }

    @Transactional
    public Result updateApplyLaunch(UpdateApply updateApply, String systemFlag) {
        String certDn;
        int unClosedApplyNum;
        String signSn = updateApply.getSignSn();
        UserCertDO userCertDO = this.userCertDao.getUserCertBaseInfo(signSn);
        if (userCertDO == null) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_CERT_IS_NOT_EXIT);
        }
        long time = userCertDO.getFailureTime().getTime() - System.currentTimeMillis();
        if (1 != userCertDO.getCertStatus() || time < 0L) {
            return Result.failure((ErrorEnum)ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
        }
        String tempNo = userCertDO.getTempNo();
        Long userId = userCertDO.getUserId();
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(tempNo);
        if (certTempInfo == null) {
            return Result.failure((ErrorEnum)ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
        }
        if (certTempInfo.getTempStatus() != 2 || certTempInfo.getTempBound() != 1) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_TEMP_STATUS_IS_NOT_NORMAL);
        }
        boolean updateValidity = updateApply.getUpdateValidity();
        if (updateValidity) {
            Integer validity = updateApply.getCertValidity();
            if (validity == null || validity <= 0) {
                return Result.failure((ErrorEnum)ErrorEnum.APPLY_VALIDITY_IS_NOT_POSITIVE_INTEGER);
            }
            int min = Math.min(validity, certTempInfo.getMaxValidity());
            this.logger.debug("\u7528\u6237\u6a21\u677f:{},\u6a21\u677f\u6700\u5927\u6709\u6548\u671f:{}", (Object)tempNo, (Object)certTempInfo.getMaxValidity());
            if (!updateApply.getUpdateKey().booleanValue()) {
                min = Math.min(userCertDO.getEncKeyValidity(), min);
                this.logger.debug("\u4e0d\u66f4\u65b0\u79d8\u94a5\uff0c\u52a0\u5bc6\u5bc6\u94a5\u6700\u5927\u6709\u6548\u671f:{}", (Object)userCertDO.getEncKeyValidity());
            }
            updateApply.setCertValidity(Integer.valueOf(min));
        }
        if ((unClosedApplyNum = this.updateApplyDao.getUnClosedUpdateApplyNum(signSn)) > 0) {
            return Result.failure((ErrorEnum)ErrorEnum.SIGN_SN_HAS_UPDATE_APPLY_NOT_CLOSED);
        }
        BaseUserDO baseUserDO = this.baseUserDao.getBaseUserInfo(userId.longValue());
        if (!baseUserDO.getSystemFlag().equals(systemFlag)) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_USER_IS_NOT_EXIT);
        }
        if (baseUserDO.getStatus() == 1) {
            return Result.failure((ErrorEnum)ErrorEnum.UPDATE_APPLY_USER_STATUS_IS_STOP);
        }
        String baseDn = certTempInfo.getBaseDn();
        Result result = this.checkDn(baseDn, certDn = updateApply.getCertDn(), userId, null);
        if (!result.isSuccess()) {
            this.logger.error("\u7528\u6237\u66f4\u65b0\u7533\u8bf7DN\u9519\u8bef\uff0cDN[{}]", (Object)certDn);
            return result;
        }
        UpdateApplyDTO updateApplyDTO = new UpdateApplyDTO();
        BeanUtils.copyProperties((Object)updateApply, (Object)updateApplyDTO);
        updateApplyDTO.setUserId(userId);
        updateApplyDTO.setTempNo(tempNo);
        updateApplyDTO.setSignAlg(certTempInfo.getSignAlg());
        updateApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength());
        String encSn = this.userCertDao.getEncSnBySignSn(signSn);
        updateApplyDTO.setEncSn(encSn == null ? "" : encSn);
        String applyNo = this.raSdkCache.getIncApplyNo();
        updateApplyDTO.setApplyNo(applyNo);
        result = this.updateApplyService.insertCertUpdateApply(updateApplyDTO, userCertDO, certTempInfo, true);
        this.certApplyService.insertCertApplyRecord(2, 1, applyNo, systemFlag, 1, updateApplyDTO.getApplyReason(), 1, false, true);
        if (1 == certTempInfo.getCheckStrategy()) {
            this.certApplyService.insertCertApplyRecord(2, 3, applyNo, systemFlag, 3, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, true);
        }
        boolean certTempIsAutoStrategy = certTempInfo.getCheckStrategy() == 1;
        ApplyRep applyRep = new ApplyRep();
        applyRep.setNeedCheck(Boolean.valueOf(!certTempIsAutoStrategy));
        if (result.isSuccess()) {
            applyRep.setApplyNo(applyNo);
            if (certTempIsAutoStrategy) {
                DoubleCodeDO doubleCodeDO = new DoubleCodeDO();
                doubleCodeDO.setRefCode(userId);
                doubleCodeDO.setAuthCode(applyNo);
                doubleCodeDO.setIsUse(Integer.valueOf(DoubleCodeUseEnum.NOT_USE.id));
                this.doubleCodeDao.InsertDouble(doubleCodeDO);
                DoubleCode doubleCode = new DoubleCode();
                doubleCode.setRefCode(String.valueOf(userId));
                doubleCode.setAuthCode(applyNo);
                applyRep.setDoubleCode(doubleCode);
            }
            result.setInfo((Object)applyRep);
        }
        return result;
    }

    private boolean certIsExit(String signSn, String systemFlag) {
        boolean flag = this.baseUserDao.isAuthorize(systemFlag, signSn);
        if (!flag) {
            this.logger.info("\u6b64\u8bc1\u4e66\u4e0d\u5b58\u5728");
            return true;
        }
        return false;
    }

    private Result checkCertApply(String signSn, Integer applyType) {
        return this.certApplyService.verifyUserCertApply(signSn, applyType.intValue());
    }

    private Result checkSn(String signSn) {
        UserCertDO userCertDO = this.userCertDao.getUserCertBaseInfoBySignSn(signSn);
        if (null == userCertDO) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_SN_IS_INVALID);
        }
        return new Result();
    }

    public Result revokeApplyLaunch(RevokeApply revokeApply, String systemFlag) {
        ApplyLaunch applyLaunch = new ApplyLaunch();
        Result result = this.checkSn(revokeApply.getSignSn());
        if (!result.isSuccess()) {
            return result;
        }
        result = this.checkCertApply(revokeApply.getSignSn(), ApplyTypeEnum.REVOKE_APPLY.id);
        if (!result.isSuccess()) {
            return result;
        }
        if (this.certIsExit(revokeApply.getSignSn(), systemFlag)) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_CERT_IS_NOT_EXIT);
        }
        applyLaunch.setApplyType(Integer.valueOf(ApplyTypeEnum.REVOKE_APPLY.id));
        applyLaunch.setRevokeApply(revokeApply);
        return this.getApplyLaunchResult(systemFlag, applyLaunch, null);
    }

    public Result recoveryApplyLaunch(RecoveryApply recoveryApply, String systemFlag) {
        ApplyLaunch applyLaunch = new ApplyLaunch();
        Result result = this.checkSn(recoveryApply.getSignSn());
        if (!result.isSuccess()) {
            return result;
        }
        result = this.checkCertApply(recoveryApply.getSignSn(), ApplyTypeEnum.RECOVERY_APPLY.id);
        if (!result.isSuccess()) {
            return result;
        }
        if (this.certIsExit(recoveryApply.getSignSn(), systemFlag)) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_CERT_IS_NOT_EXIT);
        }
        applyLaunch.setApplyType(Integer.valueOf(ApplyTypeEnum.RECOVERY_APPLY.id));
        applyLaunch.setRecoveryApply(recoveryApply);
        return this.getApplyLaunchResult(systemFlag, applyLaunch, null);
    }

    public Result freezeApplyLaunch(FreezeApply freezeApply, String systemFlag) {
        ApplyLaunch applyLaunch = new ApplyLaunch();
        Result result = this.checkSn(freezeApply.getSignSn());
        if (!result.isSuccess()) {
            return result;
        }
        applyLaunch.setFreezeApply(freezeApply);
        int applyType = freezeApply.getFreeze() != false ? ApplyTypeEnum.FREEZE_APPLY.id : ApplyTypeEnum.UNFREEZE_APPLY.id;
        applyLaunch.setApplyType(Integer.valueOf(applyType));
        result = this.checkCertApply(freezeApply.getSignSn(), applyType);
        if (!result.isSuccess()) {
            return result;
        }
        if (this.certIsExit(freezeApply.getSignSn(), systemFlag)) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_CERT_IS_NOT_EXIT);
        }
        Long id = this.userCertDao.getUserId(freezeApply.getSignSn());
        if (id == null) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_CERT_IS_NOT_EXIT);
        }
        BaseUserDO baseUserDO = this.baseUserDao.getBaseUserInfo(id.longValue(), systemFlag);
        if (baseUserDO == null) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_CERT_IS_NOT_EXIT);
        }
        Integer n = baseUserDO.getStatus();
        return this.getFreezeApplyLaunchResult(systemFlag, applyLaunch);
    }

    public Result applyCheck(Integer applyType, String applyNo, CheckApply checkApply, String systemFlag) {
        if (this.applyIsExit(applyNo, systemFlag, applyType)) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_APPLY_IS_NOT_EXIT);
        }
        Result result = this.certApplyService.checkUserCertApply(applyNo, systemFlag, applyType.intValue(), checkApply.getPass().booleanValue(), checkApply.getCheckInfo(), true);
        if (result.isSuccess() && checkApply.getPass().booleanValue() && applyType != ApplyTypeEnum.REVOKE_APPLY.id && applyType != ApplyTypeEnum.FREEZE_APPLY.id && applyType != ApplyTypeEnum.UNFREEZE_APPLY.id) {
            result.setInfo((Object)this.commonService.createDoubleCode(applyNo));
        }
        return result;
    }

    private boolean applyIsExit(String applyNo, String systemFlag, Integer applyType) {
        boolean flag = this.baseUserDao.isAuthorizeByApplyNo(systemFlag, applyNo, applyType);
        if (!flag) {
            this.logger.error("\u6b64\u7533\u8bf7\u4e0d\u5b58\u5728");
            return true;
        }
        return false;
    }

    @Transactional
    public Result certApplyCarry(String systemFlag, Integer applyType, String applyNo, DoubleCode doubleCode, byte[] publickey, Integer keyFormat) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("certApplyCarry applyType:[{}] applyNo:[{}]", (Object)applyType, (Object)applyNo);
        }
        if (1 == applyType || 2 == applyType) {
            return this.certApplyServiceIssue.certApplyCarry(applyType.intValue(), systemFlag, applyNo, doubleCode, publickey, keyFormat);
        }
        boolean flag = this.baseUserDao.isAuthorize(systemFlag, Integer.valueOf(Integer.parseInt(doubleCode.getRefCode())));
        if (!flag) {
            this.logger.error("\u6b64\u7528\u6237\u4e0d\u5b58\u5728");
            Result result = new Result();
            result.setError(ErrorEnum.THE_USER_IS_NOT_EXIT);
            return result;
        }
        flag = this.baseUserDao.isAuthorizeByApplyNo(systemFlag, applyNo, applyType);
        if (!flag) {
            this.logger.error("\u6b64\u7533\u8bf7\u4e0d\u5b58\u5728");
            Result result = new Result();
            result.setError(ErrorEnum.THE_APPLY_IS_NOT_EXIT);
            return result;
        }
        boolean checkResult = this.doubleCodeDao.checkDoubleCode(doubleCode.getRefCode(), doubleCode.getAuthCode());
        if (!checkResult) {
            return Result.failure((ErrorEnum)ErrorEnum.DOUBLE_CODE_HAS_USED);
        }
        Result result = this.certApplyService.issueUserCert(null, null, Integer.valueOf(4), applyType.intValue(), applyNo, systemFlag, null, publickey, 2, true, false, null, keyFormat);
        if (result.isSuccess()) {
            this.doubleCodeDao.updateStatus(doubleCode.getRefCode(), doubleCode.getAuthCode());
        }
        return result;
    }

    public Result certIssueConfirmMsg(String applyNo) {
        try {
            return this.certApplyService.issueUserCertResp(applyNo, null, true);
        }
        catch (Exception e) {
            throw new ServiceException("\u8bc1\u4e66\u7b7e\u53d1\u786e\u8ba4\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public Result certApplyErrorMsg(String applyNo, ErrorMsg errorMsg) {
        try {
            return this.certApplyService.genErrorMsgContent(applyNo, errorMsg.getErrorCode().intValue(), errorMsg.getErrorMsg(), true);
        }
        catch (Exception e) {
            throw new ServiceException("\u8bc1\u4e66\u7b7e\u53d1\u9519\u8bef\u6d88\u606f", (Throwable)e);
        }
    }

    public Result certApplyQuery(Integer applyType, String applyNo, String systemFlag) {
        Result result;
        CertApplyInfo certApplyInfo = new CertApplyInfo();
        if (this.applyIsExit(applyNo, systemFlag, applyType)) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_APPLY_IS_NOT_EXIT);
        }
        if (applyType == ApplyTypeEnum.ISSUE_APPLY.id) {
            result = this.issueApplyService.getIssueApplyInfo(applyNo);
            if (!result.isSuccess()) {
                return result;
            }
            IssueApplyInfo issueApplyInfo = new IssueApplyInfo();
            BeanUtils.copyProperties((Object)result.getInfo(), (Object)issueApplyInfo);
            certApplyInfo.setIssueApplyInfo(issueApplyInfo);
        } else if (applyType == ApplyTypeEnum.UPDATE_APPLY.id) {
            result = this.updateApplyService.getUpdateApplyInfo(applyNo);
            if (!result.isSuccess()) {
                return result;
            }
            UpdateApplyInfo updateApplyInfo = new UpdateApplyInfo();
            BeanUtils.copyProperties((Object)result.getInfo(), (Object)updateApplyInfo);
            certApplyInfo.setUpdateApplyInfo(updateApplyInfo);
        } else if (applyType == ApplyTypeEnum.REVOKE_APPLY.id) {
            result = this.revokeApplyService.getRevokeApplyInfo(applyNo);
            if (!result.isSuccess()) {
                return result;
            }
            RevokeApplyInfo revokeApplyInfo = new RevokeApplyInfo();
            BeanUtils.copyProperties((Object)result.getInfo(), (Object)revokeApplyInfo);
            certApplyInfo.setRevokeApplyInfo(revokeApplyInfo);
        } else if (applyType == ApplyTypeEnum.RECOVERY_APPLY.id) {
            result = this.recoveryApplyService.getRecoveryApplyInfo(applyNo);
            if (!result.isSuccess()) {
                return result;
            }
            RecoveryApplyInfo recoveryApplyInfo = new RecoveryApplyInfo();
            BeanUtils.copyProperties((Object)result.getInfo(), (Object)recoveryApplyInfo);
            certApplyInfo.setRecoveryApplyInfo(recoveryApplyInfo);
        } else {
            result = this.freezeApplyService.getFreezeApplyInfo(applyNo);
            if (!result.isSuccess()) {
                return result;
            }
            FreezeApplyInfo freezeApplyInfo = new FreezeApplyInfo();
            BeanUtils.copyProperties((Object)result.getInfo(), (Object)freezeApplyInfo);
            certApplyInfo.setFreezeApplyInfo(freezeApplyInfo);
        }
        result.setInfo((Object)certApplyInfo);
        return result;
    }

    public Result certApplyQuery(String applyNo, String systemFlag) {
        BaseCertApply baseCertApply = new BaseCertApply();
        Result result = new Result();
        if (this.applyIsExit(applyNo, systemFlag, null)) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_APPLY_IS_NOT_EXIT);
        }
        CertApplyDO certApplyDO = this.certApplyDao.getCertApplyInfo(applyNo);
        Integer applyStatus = certApplyDO.getApplyStatus();
        baseCertApply.setApplyStatus(applyStatus);
        if (applyStatus == ApplyStatusEnum.PENDING_ISSUANCE.id) {
            DoubleCodeDO doubleCode = this.doubleCodeDao.getDoubleCode(applyNo);
            DoubleCode doubleCode1 = new DoubleCode();
            doubleCode1.setRefCode(String.valueOf(doubleCode.getRefCode()));
            doubleCode1.setAuthCode(String.valueOf(doubleCode.getAuthCode()));
            baseCertApply.setDoubleCode(doubleCode1);
        }
        if (applyStatus == ApplyStatusEnum.REVIEW_FAILED.id || applyStatus == ApplyStatusEnum.ISSUING_FAILED.id || applyStatus == ApplyStatusEnum.CANCELLATION_FAILED.id || applyStatus == ApplyStatusEnum.FREEZE_FAILED.id || applyStatus == ApplyStatusEnum.UN_FREEZE_FAILED.id) {
            String applyFailedReason = this.applyRecordDao.getApplyFailedReason(applyNo, applyStatus.intValue());
            baseCertApply.setFailReason(applyFailedReason);
        }
        result.setInfo((Object)baseCertApply);
        return result;
    }

    public Result certApplyUpdate(Integer applyType, String applyNo, EditCertApplyInfo editCertApplyInfo, String systemFlag) {
        Result result;
        if (this.applyIsExit(applyNo, systemFlag, applyType)) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_APPLY_IS_NOT_EXIT);
        }
        long userId = this.certApplyDao.getUserIdByApplyNo(applyNo);
        if (applyType == ApplyTypeEnum.ISSUE_APPLY.id) {
            IssueApplyDTO issueApplyDTO = new IssueApplyDTO();
            BeanUtils.copyProperties((Object)editCertApplyInfo.getEditIssueApplyInfo(), (Object)issueApplyDTO);
            result = this.checkValidity(issueApplyDTO.getCertValidity(), true, null, issueApplyDTO.getTempNo());
            if (!result.isSuccess()) {
                return result;
            }
            issueApplyDTO.setCertValidity((Integer)result.getInfo());
            IssueApplyDTO issueApplyInfoByApplyNo = this.issueApplyDao.getIssueApplyInfoByApplyNo(applyNo);
            result = this.checkDn(issueApplyInfoByApplyNo.getBaseDn(), issueApplyDTO.getCertDn(), userId, applyNo);
            if (!result.isSuccess()) {
                this.logger.error("\u7528\u6237\u4fee\u6539\u7b7e\u53d1\u7533\u8bf7DN\u9519\u8bef\uff0cDN[{}]", (Object)issueApplyDTO.getCertDn());
                return result;
            }
            issueApplyDTO.setUserId(Long.valueOf(userId));
            issueApplyDTO.setTempParas(this.conversion(editCertApplyInfo.getEditIssueApplyInfo().getExtensionList()));
            result = this.issueApplyService.updateUserCertIssueApply(systemFlag, applyNo, issueApplyDTO, false, true);
        } else if (applyType == ApplyTypeEnum.UPDATE_APPLY.id) {
            UpdateApplyDTO updateApplyDTO = new UpdateApplyDTO();
            BeanUtils.copyProperties((Object)editCertApplyInfo.getEditUpdateApplyInfo(), (Object)updateApplyDTO);
            UpdateApplyDTO updateApplyInfoByApplyNo = this.updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
            updateApplyDTO.setTempNo(updateApplyInfoByApplyNo.getTempNo());
            updateApplyDTO.setSignSn(updateApplyInfoByApplyNo.getSignSn());
            updateApplyDTO.setEncSn(updateApplyInfoByApplyNo.getEncSn());
            updateApplyDTO.setUserId(Long.valueOf(userId));
            if (editCertApplyInfo.getEditUpdateApplyInfo().getUpdateValidity().booleanValue()) {
                result = this.checkValidity(updateApplyDTO.getCertValidity(), updateApplyDTO.getUpdateKey(), null, updateApplyDTO.getTempNo());
                if (!result.isSuccess()) {
                    return result;
                }
                updateApplyDTO.setCertValidity((Integer)result.getInfo());
            }
            if (!(result = this.checkDn(updateApplyInfoByApplyNo.getBaseDn(), updateApplyDTO.getCertDn(), userId, applyNo)).isSuccess()) {
                this.logger.error("\u7528\u6237\u4fee\u6539\u66f4\u65b0\u7533\u8bf7DN\u9519\u8bef\uff0cDN[{}]", (Object)updateApplyDTO.getCertDn());
                return result;
            }
            result = this.updateApplyService.updateUserCertUpdateApply(systemFlag, applyNo, updateApplyDTO, true);
        } else {
            RevokeApplyDTO revokeApplyDTO = new RevokeApplyDTO();
            BeanUtils.copyProperties((Object)editCertApplyInfo.getEditRevokeApplyInfo(), (Object)revokeApplyDTO);
            if (!RevokeReasonEnum.contain((int)revokeApplyDTO.getRevokeReason())) {
                return Result.failure((ErrorEnum)ErrorEnum.REVOKE_REASON_IS_NOT_SUPPORT);
            }
            RevokeApplyDTO revokeApplyInfoByApplyNo = this.revokeApplyDao.getRevokeApplyInfoByApplyNo(applyNo);
            revokeApplyDTO.setTempNo(revokeApplyInfoByApplyNo.getTempNo());
            revokeApplyDTO.setSignSn(revokeApplyInfoByApplyNo.getSignSn());
            revokeApplyDTO.setEncSn(revokeApplyInfoByApplyNo.getEncSn());
            revokeApplyDTO.setUserId(Long.valueOf(userId));
            result = this.revokeApplyService.updateUserCertRevokeApply(systemFlag, applyNo, revokeApplyDTO, true);
        }
        return result;
    }

    private Result getFreezeApplyLaunchResult(String systemFlag, ApplyLaunch applyLaunch) {
        ApplyRep applyRep = new ApplyRep();
        FreezeApply freezeApply = applyLaunch.getFreezeApply();
        String signSn = freezeApply.getSignSn();
        FreezeApplyDTO freezeApplyDTO = new FreezeApplyDTO();
        freezeApplyDTO.setSignSn(signSn);
        freezeApplyDTO.setApplyReason(freezeApply.getApplyReason());
        freezeApplyDTO.setUserId(this.userCertDao.getUserId(signSn));
        Result tempNoResult = this.getTempNo(signSn);
        if (!tempNoResult.isSuccess()) {
            return tempNoResult;
        }
        freezeApplyDTO.setTempNo(tempNoResult.getInfo().toString());
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(freezeApplyDTO.getTempNo());
        freezeApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength());
        freezeApplyDTO.setSignAlg(certTempInfo.getSignAlg());
        String encSn = this.userCertDao.getEncSnBySignSn(signSn);
        freezeApplyDTO.setEncSn(encSn == null ? "" : encSn);
        freezeApplyDTO.setApplyType(applyLaunch.getApplyType());
        Result result = this.freezeApplyService.insertUserCertFreezeApply(systemFlag, freezeApplyDTO, true, true);
        boolean certTempIsAutoStrategy = certTempInfo.getCheckStrategy() == 1;
        applyRep.setNeedCheck(Boolean.valueOf(!certTempIsAutoStrategy));
        if (result.isSuccess()) {
            applyRep.setApplyNo(result.getInfo().toString());
            result.setInfo((Object)applyRep);
        }
        return result;
    }

    private Result getApplyLaunchResult(String systemFlag, ApplyLaunch applyLaunch, String baseDn) {
        CertTempDO certTempInfo;
        Result result;
        ApplyRep applyRep = new ApplyRep();
        if (applyLaunch.getApplyType() == ApplyTypeEnum.ISSUE_APPLY.id) {
            IssueApply issueApply = applyLaunch.getIssueApply();
            IssueApplyDTO issueApplyDTO = new IssueApplyDTO();
            BeanUtils.copyProperties((Object)issueApply, (Object)issueApplyDTO);
            Long userId = this.baseUserService.queryUserId(issueApply.getUserType().intValue(), systemFlag, issueApply.getLicenseType(), issueApply.getLicenseNumber());
            if (null == userId) {
                this.logger.error("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff1auserType:[{}],identType:[{}],licenseNumber:[{}]", new Object[]{issueApply.getUserType(), issueApply.getLicenseType(), issueApply.getLicenseNumber()});
                return Result.failure((ErrorEnum)ErrorEnum.GET_PERSON_USER_INFO_IS_EMPTY);
            }
            result = this.checkDn(baseDn, issueApply.getCertDn(), userId, null);
            if (!result.isSuccess()) {
                this.logger.error("\u7528\u6237\u7b7e\u53d1\u7533\u8bf7DN\u9519\u8bef\uff0cDN[{}]", (Object)issueApply.getCertDn());
                return result;
            }
            issueApplyDTO.setUserId(userId);
            issueApplyDTO.setTempParas(this.conversion(issueApply.getExtensionList()));
            certTempInfo = this.certTempCache.getCertTempInfoByTempNo(issueApplyDTO.getTempNo());
            issueApplyDTO.setSignAlg(certTempInfo.getSignAlg());
            issueApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength());
            issueApplyDTO.setCertValidity(issueApply.getCertValidity());
            result = this.issueApplyService.insertUserCertIssueApply(systemFlag, issueApplyDTO, true, true);
        } else if (applyLaunch.getApplyType() == ApplyTypeEnum.UPDATE_APPLY.id) {
            UpdateApply updateApply = applyLaunch.getUpdateApply();
            UpdateApplyDTO updateApplyDTO = new UpdateApplyDTO();
            BeanUtils.copyProperties((Object)updateApply, (Object)updateApplyDTO);
            Long userId = this.userCertDao.getUserId(updateApply.getSignSn());
            updateApplyDTO.setUserId(userId);
            Result tempNoResult = this.getTempNo(updateApply.getSignSn());
            if (!tempNoResult.isSuccess()) {
                return tempNoResult;
            }
            updateApplyDTO.setTempNo(tempNoResult.getInfo().toString());
            certTempInfo = this.certTempCache.getCertTempInfoByTempNo(updateApplyDTO.getTempNo());
            baseDn = certTempInfo.getBaseDn();
            result = this.checkDn(baseDn, updateApply.getCertDn(), userId, null);
            if (!result.isSuccess()) {
                this.logger.error("\u7528\u6237\u66f4\u65b0\u7533\u8bf7DN\u9519\u8bef\uff0cDN[{}]", (Object)updateApply.getCertDn());
                return result;
            }
            updateApplyDTO.setSignAlg(certTempInfo.getSignAlg());
            updateApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength());
            String encSn = this.userCertDao.getEncSnBySignSn(updateApply.getSignSn());
            updateApplyDTO.setEncSn(encSn == null ? "" : encSn);
            result = this.updateApplyService.insertUserCertUpdateApply(systemFlag, updateApplyDTO, true, true);
        } else if (applyLaunch.getApplyType() == ApplyTypeEnum.REVOKE_APPLY.id) {
            RevokeApply revokeApply = applyLaunch.getRevokeApply();
            RevokeApplyDTO revokeApplyDTO = new RevokeApplyDTO();
            BeanUtils.copyProperties((Object)revokeApply, (Object)revokeApplyDTO);
            revokeApplyDTO.setUserId(this.userCertDao.getUserId(revokeApply.getSignSn()));
            Result tempNoResult = this.getTempNo(revokeApply.getSignSn());
            if (!tempNoResult.isSuccess()) {
                return tempNoResult;
            }
            revokeApplyDTO.setTempNo(tempNoResult.getInfo().toString());
            certTempInfo = this.certTempCache.getCertTempInfoByTempNo(revokeApplyDTO.getTempNo());
            revokeApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength());
            revokeApplyDTO.setSignAlg(certTempInfo.getSignAlg());
            String encSn = this.userCertDao.getEncSnBySignSn(revokeApply.getSignSn());
            revokeApplyDTO.setEncSn(encSn == null ? "" : encSn);
            result = this.revokeApplyService.insertUserCertRevokeApply(systemFlag, revokeApplyDTO, true, true);
        } else {
            RecoveryApply recoveryApply = applyLaunch.getRecoveryApply();
            RecoveryApplyDTO recoveryApplyDTO = new RecoveryApplyDTO();
            recoveryApplyDTO.setSignSn(recoveryApply.getSignSn());
            recoveryApplyDTO.setApplyReason(recoveryApply.getApplyReason());
            recoveryApplyDTO.setUserId(this.userCertDao.getUserId(recoveryApply.getSignSn()).longValue());
            Result tempNoResult = this.getTempNo(recoveryApply.getSignSn());
            if (!tempNoResult.isSuccess()) {
                return tempNoResult;
            }
            recoveryApplyDTO.setTempNo(tempNoResult.getInfo().toString());
            certTempInfo = this.certTempCache.getCertTempInfoByTempNo(recoveryApplyDTO.getTempNo());
            recoveryApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength().intValue());
            recoveryApplyDTO.setSignAlg(certTempInfo.getSignAlg());
            String encSn = this.userCertDao.getEncSnBySignSn(recoveryApply.getSignSn());
            recoveryApplyDTO.setEncSn(encSn == null ? "" : encSn);
            result = this.recoveryApplyService.insertUserCertRecoveryApply(systemFlag, recoveryApplyDTO, true);
        }
        boolean certTempIsAutoStrategy = certTempInfo.getCheckStrategy() == 1;
        applyRep.setNeedCheck(Boolean.valueOf(!certTempIsAutoStrategy));
        if (result.isSuccess()) {
            applyRep.setApplyNo(result.getInfo().toString());
            if (certTempIsAutoStrategy && applyLaunch.getApplyType() != ApplyTypeEnum.REVOKE_APPLY.id) {
                applyRep.setDoubleCode(this.commonService.createDoubleCode(result.getInfo().toString()));
            }
            result.setInfo((Object)applyRep);
        }
        return result;
    }

    private String conversion(List<Extension> extensionList) {
        if (null == extensionList || extensionList.isEmpty()) {
            return "[]";
        }
        ArrayList<ExtensionAttr> extensionAttrs = new ArrayList<ExtensionAttr>();
        for (Extension extension : extensionList) {
            ExtensionAttr extensionAttr = new ExtensionAttr();
            BeanUtils.copyProperties((Object)extension, (Object)extensionAttr);
            String type = "";
            String value = "";
            for (AttrType attrType : extension.getAttrTypeList()) {
                type = type + "#" + attrType.getAttrTypeNo();
                value = value + "#" + attrType.getAttrTypeValue();
            }
            extensionAttr.setAttrType(type.substring(1));
            extensionAttr.setAttrValue(value.substring(1));
            extensionAttrs.add(extensionAttr);
        }
        return JSON.toJSONString(extensionAttrs);
    }

    private Result getTempNo(String signSn) {
        UserCertDO userCertDO = this.userCertDao.getUserCertBaseInfo(signSn);
        if (userCertDO == null) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_CERT_IS_NOT_EXIT);
        }
        return Result.success((Object)userCertDO.getTempNo());
    }

    private Result checkDn(String baseDn, String dn, long userId, String applyNo) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u6a21\u677f\u83b7\u53d6baseDn\u4e3a:{}", (Object)baseDn);
        }
        if (null != baseDn && dn.endsWith(baseDn)) {
            return this.certApplyService.verifyUserCertApplyDn(dn, userId, applyNo);
        }
        if (!dn.endsWith(CommonVariable.getRaBaseDn())) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_APPLY_DN_IS_ERROR);
        }
        return this.certApplyService.verifyUserCertApplyDn(dn, userId, applyNo);
    }

    public List<ExtensionAttr> formatExtensionJon(String json) {
        try {
            List atrList = (List)JsonMapper.alwaysMapper().fromJson(json, (TypeReference)new TypeReference<List<ExtensionAttr>>(){});
            return atrList;
        }
        catch (JSONException e) {
            this.logger.error("\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38 ", (Throwable)e);
            return null;
        }
    }

    private Result checkParameter(Integer privateKeyLength, String signAlg) {
        Result result = new Result();
        if (null != privateKeyLength && !KeyLengthEnum.contain((int)privateKeyLength)) {
            return Result.failure((ErrorEnum)ErrorEnum.KEY_LENGTH_IS_NOT_SUPPORT);
        }
        if (null != signAlg && !SignAlgEnum.contain((String)signAlg)) {
            return Result.failure((ErrorEnum)ErrorEnum.SIGN_ALG_IS_NOT_SUPPORT);
        }
        return result;
    }

    private Result checkValidity(Integer validity, boolean isUpdateKey, String signSn, String tempNo) {
        Result result;
        this.logger.info("checkValidity---------------------\u6821\u9a8c\u7533\u8bf7\u6709\u6548\u671f");
        if (validity == null || validity <= 0) {
            return Result.failure((ErrorEnum)ErrorEnum.APPLY_VALIDITY_IS_NOT_POSITIVE_INTEGER);
        }
        if (null != tempNo) {
            result = this.certTempService.getCertApplyMaxValidity(tempNo, 1, null, true);
        } else {
            Result tempNoResult = this.getTempNo(signSn);
            if (!tempNoResult.isSuccess()) {
                return tempNoResult;
            }
            result = this.certTempService.getCertApplyMaxValidity(tempNoResult.getInfo().toString(), isUpdateKey ? 1 : 0, signSn, true);
        }
        if (!result.isSuccess()) {
            this.logger.error("\u6821\u9a8c\u7533\u8bf7\u6709\u6548\u671f\u9519\u8bef\uff0csignSn[{}]", (Object)signSn);
            return result;
        }
        int maxValidity = (Integer)result.getInfo();
        if (validity > maxValidity) {
            this.logger.info("\u7533\u8bf7\u7684\u6709\u6548\u671f\u4e3a:{} \u6700\u5927\u6709\u6548\u671f\u4e3a:{} \u7a0b\u5e8f\u81ea\u52a8\u5c06\u7533\u8bf7\u7684\u6700\u5927\u6709\u6548\u671f\u66f4\u65b0\u4e3a:{}", new Object[]{validity, maxValidity, maxValidity});
            validity = maxValidity;
        }
        return Result.success((Object)validity);
    }
}

