/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.core.util.time.DateUtils;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.FreezeApplyDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.FreezeApplyDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.FreezeApplyDTO;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.manager.sdk.cmp.bean.CertLifeInfo;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyHelperService;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.FreezeApplyService;
import com.xdja.pki.ra.service.manager.certapply.bean.FreezeApplyVO;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.util.OperatorUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.apache.shiro.dao.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FreezeApplyServiceImpl
implements FreezeApplyService {
    private static final Logger log = LoggerFactory.getLogger(FreezeApplyServiceImpl.class);
    @Autowired
    private CertApplyHelperService certApplyHelperService;
    @Autowired
    private CertApplyService certApplyService;
    @Autowired
    private UserCertService userCertService;
    @Autowired
    private BaseUserDao baseUserDao;
    @Autowired
    private CertLifeCycleManager certLifeCycleManager;
    @Autowired
    private CertApplyDao certApplyDao;
    @Autowired
    private FreezeApplyDao freezeApplyDao;
    @Autowired
    private RaSdkCache raSdkCache;
    @Autowired
    CertTempCache certTempCache;

    public Result getFreezeApplyInfo(String applyNo) {
        FreezeApplyDTO freezeApplyDTO;
        Result result = new Result();
        FreezeApplyVO freezeApplyVO = new FreezeApplyVO();
        try {
            freezeApplyDTO = this.freezeApplyDao.getFreezeApplyInfoByApplyNo(applyNo);
        }
        catch (EmptyResultDataAccessException e) {
            log.info("getFreezeApplyInfo.applyNo:" + applyNo + " \u67e5\u8be2\u51bb\u7ed3\u89e3\u51bb\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a");
            log.info("\u83b7\u53d6\u51bb\u7ed3\u89e3\u51bb\u8bc1\u4e66\u7533\u8bf7\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_FREEZE_UNFREEZE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        BeanUtils.copyProperties((Object)freezeApplyDTO, (Object)freezeApplyVO);
        String decryptLicenseNumber = null;
        try {
            decryptLicenseNumber = DecryptUserInfo.getDecryptString((String)freezeApplyVO.getLicenseNumber());
        }
        catch (Exception e) {
            decryptLicenseNumber = freezeApplyVO.getLicenseNumber();
        }
        freezeApplyVO.setLicenseNumber(decryptLicenseNumber);
        Timestamp gmtCreate = freezeApplyDTO.getGmtCreate();
        freezeApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
        result.setInfo((Object)freezeApplyVO);
        return result;
    }

    @Transactional
    public Result insertUserCertFreezeApply(String systemFlag, FreezeApplyDTO freezeApplyDTO, boolean isOnline, boolean isNormal) {
        BaseUserDO baseUserDO;
        Integer applyType;
        String signSn = freezeApplyDTO.getSignSn();
        Result result = this.certApplyHelperService.checkBeforeSaveApplyRecord(signSn, applyType = freezeApplyDTO.getApplyType());
        if (!result.isSuccess()) {
            return result;
        }
        Map dnNameMap = (Map)result.getInfo();
        CertApplyDO certApplyDO = new CertApplyDO();
        certApplyDO.setApplyType(applyType);
        Result userCertInfoResult = this.userCertService.getUserCertBaseInfo(signSn);
        if (!userCertInfoResult.isSuccess()) {
            return userCertInfoResult;
        }
        UserCertDO userCertDO = (UserCertDO)userCertInfoResult.getInfo();
        if (isOnline && !isNormal) {
            String licenseNumber;
            try {
                licenseNumber = this.baseUserDao.getLicenseNumberById(userCertDO.getUserId().longValue());
            }
            catch (DataAccessException e) {
                log.info("\u67e5\u8be2\u8bc1\u4e66\u5bf9\u5e94\u7684\u8bbe\u5907\u7f16\u53f7\u4e3a\u7a7a", (Throwable)e);
                result.setError(ErrorEnum.ONLINE_DEVICE_INFO_NOT_EXIST);
                return result;
            }
            if (!licenseNumber.equals(freezeApplyDTO.getLicenseNumber())) {
                log.info("\u8bbe\u5907\u7f16\u53f7\u548csn\u5bf9\u5e94\u8bc1\u4e66\u4e0d\u5339\u914d");
                result.setError(ErrorEnum.ONLINE_DEVICE_NO_GET_CERT_ERROR);
                return result;
            }
            certApplyDO.setUserId(userCertDO.getUserId());
        }
        if (!isOnline) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
            long adminId = currentAdminInfo.getId();
            String adminCertDn = currentAdminInfo.getCertDn();
            certApplyDO.setAdminId(Long.valueOf(adminId));
            certApplyDO.setAdminCertDn(adminCertDn);
        }
        certApplyDO.setCertDn(userCertDO.getCertDn());
        if (certApplyDO.getUserId() == null) {
            certApplyDO.setUserId(userCertDO.getUserId());
        }
        try {
            baseUserDO = this.baseUserDao.getBaseUserInfo(freezeApplyDTO.getUserId().longValue());
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u5f02\u5e38");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (baseUserDO == null) {
            log.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }
        if (freezeApplyDTO.getApplyType() == 6 && baseUserDO.getStatus() == 1) {
            log.info("\u53d1\u8d77\u8bc1\u4e66\u89e3\u51bb\u7533\u8bf7\u7684\u7528\u6237\u5df2\u505c\u7528");
            result.setError(ErrorEnum.APPLY_USER_STATUS_IS_STOP);
            return result;
        }
        String applyDO = this.raSdkCache.getIncApplyNo();
        certApplyDO.setApplyNo(applyDO);
        result.setLogContent("\uff0c\u7533\u8bf7\u7f16\u53f7=" + certApplyDO.getApplyNo());
        Timestamp timestamp = new Timestamp(DateUtils.getCurrentTimeMillis());
        certApplyDO.setGmtCreate(timestamp);
        certApplyDO.setGmtUpdate(timestamp);
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(freezeApplyDTO.getTempNo());
        if (certTempInfo == null) {
            log.info("\u8bc1\u4e66\u53d1\u8d77\u51bb\u7ed3/\u89e3\u51bb\u65f6\uff0c\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        log.info("\u8bc1\u4e66\u53d1\u8d77\u51bb\u7ed3/\u89e3\u51bb\u65f6\uff0c\u5bf9\u5e94\u6a21\u677f\u7f16\u53f7\u4e3a{},\u5ba1\u6838\u7b56\u7565\u4e3a\u3010{}\u3011", (Object)certTempInfo.getTempNo(), (Object)(certTempInfo.getCheckStrategy() == 1 ? "\u81ea\u52a8" : "\u624b\u52a8"));
        this.certApplyService.insertCertApplyRecord(applyType.intValue(), 1, certApplyDO.getApplyNo(), systemFlag, 1, freezeApplyDTO.getApplyReason(), 1, false, isOnline);
        int applyStatus = 1;
        if (1 == certTempInfo.getCheckStrategy() || isOnline && !isNormal) {
            this.certApplyService.insertCertApplyRecord(applyType.intValue(), 3, certApplyDO.getApplyNo(), systemFlag, 0, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, isOnline);
            CertLifeInfo certLifeInfo = this.convertCertLifeInfo(freezeApplyDTO, dnNameMap, certApplyDO);
            Result freezeResult = this.certLifeCycleManager.freezeUserCert(certLifeInfo, applyType.intValue(), freezeApplyDTO.getApplyReason());
            if (!freezeResult.isSuccess()) {
                int operatorRepType;
                int operatorType;
                log.info("\u53d1\u8d77\u8bc1\u4e66\u51bb\u7ed3/\u89e3\u51bb\u5931\u8d25 errorCode:{}", (Object)freezeResult.getErrorBean().getErrCode());
                result.setErrorBean(freezeResult.getErrorBean());
                if (applyType == ApplyTypeEnum.FREEZE_APPLY.id) {
                    applyStatus = 8;
                    operatorType = 6;
                    operatorRepType = 9;
                } else {
                    applyStatus = 10;
                    operatorType = 7;
                    operatorRepType = 11;
                }
                this.certApplyService.insertCertApplyRecord(applyType.intValue(), operatorType, certApplyDO.getApplyNo(), systemFlag, applyStatus, "\u8bc1\u4e66\u51bb\u7ed3/\u89e3\u51bb\u5931\u8d25code:" + freezeResult.getErrorBean().getErrCode(), operatorRepType, false, isOnline);
            } else {
                int certStatus;
                int operatorRepType;
                int operatorType;
                if (applyType == ApplyTypeEnum.FREEZE_APPLY.id) {
                    applyStatus = 9;
                    operatorType = 6;
                    operatorRepType = 10;
                    certStatus = 4;
                } else {
                    applyStatus = 11;
                    operatorType = 7;
                    operatorRepType = 12;
                    certStatus = 1;
                }
                this.certApplyService.insertCertApplyRecord(applyType.intValue(), operatorType, certApplyDO.getApplyNo(), systemFlag, applyStatus, freezeApplyDTO.getApplyReason(), operatorRepType, false, isOnline);
                Result updateStatusResult = this.userCertService.updateUserCertStatus(certStatus, freezeApplyDTO.getSignSn());
                if (!updateStatusResult.isSuccess()) {
                    log.info("\u66f4\u65b0\u8bc1\u4e66\u72b6\u6001\u9519\u8bef:" + JsonUtils.object2Json((Object)updateStatusResult));
                    result.setError(updateStatusResult.getError());
                    return result;
                }
            }
        }
        certApplyDO.setApplyStatus(Integer.valueOf(applyStatus));
        certApplyDO.setTempId(certTempInfo.getId());
        CertApplyDO addCertApply = this.certApplyDao.insertCertApply(certApplyDO);
        FreezeApplyDO freezeApplyDO = new FreezeApplyDO();
        freezeApplyDO.setApplyId(addCertApply.getId());
        freezeApplyDO.setSignSn(freezeApplyDTO.getSignSn());
        freezeApplyDO.setEncSn(freezeApplyDTO.getEncSn());
        freezeApplyDO.setApplyReason(freezeApplyDTO.getApplyReason());
        freezeApplyDO.setSignAlg(userCertDO.getSignAlg());
        freezeApplyDO.setPrivateKeyLength(userCertDO.getPrivateKeyLength());
        freezeApplyDO.setCertValidity(userCertDO.getCertValidity());
        freezeApplyDO.setTempNo(userCertDO.getTempNo());
        freezeApplyDO.setGmtUpdate(timestamp);
        freezeApplyDO.setGmtCreate(timestamp);
        freezeApplyDO.setApplyType(applyType);
        this.freezeApplyDao.insertFreezeApply(freezeApplyDO);
        result.setInfo((Object)addCertApply.getApplyNo());
        return result;
    }

    private CertLifeInfo convertCertLifeInfo(FreezeApplyDTO freezeApplyDTO, Map<String, String> dnNameMap, CertApplyDO certApplyDO) {
        CertLifeInfo certLifeInfo = new CertLifeInfo();
        certLifeInfo.setApplyNo(certApplyDO.getApplyNo());
        certLifeInfo.setRaDN(dnNameMap.get("raServiceDnName"));
        certLifeInfo.setCaDN(dnNameMap.get("caServiceDnName"));
        certLifeInfo.setSignSn(freezeApplyDTO.getSignSn());
        certLifeInfo.setUserCertDN(freezeApplyDTO.getCertDn());
        return certLifeInfo;
    }

    public Result updateUserCertFreezeApply(String applyNo, FreezeApplyDTO freezeApplyDTO, boolean isOnlineRevoke) {
        return null;
    }
}

