/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.ca.utils.DnUtil;
import com.xdja.pki.core.bean.DatabaseTypeEnum;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.ApplyRecordDao;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.IssueApplyDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.IssueApplyDO;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import com.xdja.pki.ra.manager.dto.TempInfoDTO;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.IssueApplyService;
import com.xdja.pki.ra.service.manager.certapply.bean.IssueApplyVO;
import com.xdja.pki.ra.service.manager.certapply.thread.IssueApplyThread;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.util.OperatorUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.naming.NamingException;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IssueApplyServiceImpl
implements IssueApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CertApplyDao certApplyDao;
    @Autowired
    IssueApplyDao issueApplyDao;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    CertTempDao certTempDao;
    @Autowired
    ApplyRecordDao applyRecordDao;
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    private RaSdkCache raSdkCache;
    @Autowired
    CertTempCache certTempCache;

    public Result getIssueApplyInfo(String applyNo) {
        Result result = new Result();
        IssueApplyVO issueApplyVO = new IssueApplyVO();
        IssueApplyDTO issueApplyInfoByApplyNo = null;
        try {
            issueApplyInfoByApplyNo = this.issueApplyDao.getIssueApplyInfoByApplyNo(applyNo);
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("getIssueApplyInfo.applyNo:" + applyNo + " \u67e5\u8be2\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a");
        }
        if (issueApplyInfoByApplyNo == null) {
            this.logger.info("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        BeanUtils.copyProperties((Object)issueApplyInfoByApplyNo, (Object)issueApplyVO);
        String licenseNumber = issueApplyVO.getLicenseNumber();
        String decryptLicenseNumber = null;
        try {
            decryptLicenseNumber = DecryptUserInfo.getDecryptString((String)licenseNumber);
        }
        catch (Exception e) {
            decryptLicenseNumber = licenseNumber;
        }
        issueApplyVO.setLicenseNumber(decryptLicenseNumber);
        Timestamp gmtCreate = issueApplyInfoByApplyNo.getGmtCreate();
        issueApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
        result.setInfo((Object)issueApplyVO);
        return result;
    }

    @Transactional
    public Result insertCertIssueApply(Integer applyStatus, String adminCertDn, IssueApplyDTO issueApplyDTO, CertTempDO certTempInfo) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("insertCertIssueApply");
        }
        Result result = new Result();
        CertApplyDO certApplyDO = new CertApplyDO();
        certApplyDO.setApplyNo(issueApplyDTO.getApplyNo());
        certApplyDO.setUserId(issueApplyDTO.getUserId());
        certApplyDO.setApplyType(Integer.valueOf(1));
        certApplyDO.setCertDn(issueApplyDTO.getCertDn());
        certApplyDO.setAdminCertDn(adminCertDn);
        certApplyDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        certApplyDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        certApplyDO.setApplyStatus(applyStatus);
        certApplyDO.setTempId(certTempInfo.getId());
        CertApplyDO addCertApply = this.certApplyDao.insertCertApply(certApplyDO);
        if (addCertApply == null) {
            this.logger.info("\u6dfb\u52a0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_CERT_APPLY_INFO_FAIL);
            return result;
        }
        IssueApplyDO issueApplyDO = new IssueApplyDO();
        issueApplyDO.setApplyId(addCertApply.getId());
        issueApplyDO.setSignAlg(issueApplyDTO.getSignAlg());
        issueApplyDO.setPrivateKeyLength(issueApplyDTO.getPrivateKeyLength());
        issueApplyDO.setCertValidity(issueApplyDTO.getCertValidity());
        issueApplyDO.setApplyReason(issueApplyDTO.getApplyReason());
        issueApplyDO.setTempParas(issueApplyDTO.getTempParas());
        Date date = new Date();
        issueApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        issueApplyDO.setGmtCreate(new Timestamp(date.getTime()));
        IssueApplyDO addIssueApply = this.issueApplyDao.insertIssueApply(issueApplyDO);
        if (addIssueApply == null) {
            this.logger.info("\u6dfb\u52a0\u7b7e\u53d1\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_ISSUE_CERT_APPLY_INFO_FAIL);
            throw new RuntimeException();
        }
        result.setInfo((Object)addCertApply.getId());
        return result;
    }

    @Transactional
    public Result insertUserCertIssueApply(String systemFlag, IssueApplyDTO issueApplyDTO, boolean isOnlineIssue, boolean isNormal) {
        Result result = new Result();
        CertApplyDO certApplyDO = new CertApplyDO();
        String applyNo = this.raSdkCache.getIncApplyNo();
        certApplyDO.setApplyNo(applyNo);
        certApplyDO.setUserId(issueApplyDTO.getUserId());
        certApplyDO.setApplyType(Integer.valueOf(1));
        X500Name x500Name = null;
        try {
            x500Name = DnUtil.getRFC4519X500Name((String)issueApplyDTO.getCertDn());
        }
        catch (Exception e) {
            this.logger.info("certDn\u4e0d\u6b63\u786e{}", (Object)e.getMessage());
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        certApplyDO.setCertDn(x500Name.toString());
        try {
            result.setLogContent("\uff0c\u8bc1\u4e66\u4e3b\u4f53=" + x500Name.toString() + "\uff0c\u7533\u8bf7\u7f16\u53f7=" + certApplyDO.getApplyNo());
        }
        catch (Exception e) {
            this.logger.info("\u52a0\u5165\u65e5\u5fd7\u5ba1\u8ba1\u5931\u8d25", (Throwable)e);
        }
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
            certApplyDO.setAdminId(currentAdminInfo.getId());
            certApplyDO.setAdminCertDn(currentAdminInfo.getCertDn());
        }
        BaseUserDO baseUserDO = null;
        try {
            baseUserDO = this.baseUserDao.getBaseUserInfo(issueApplyDTO.getUserId().longValue());
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u5f02\u5e38");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (baseUserDO == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }
        result.setLogContent(result.getLogContent() + "\uff0c\u7528\u6237ID=" + baseUserDO.getId());
        if (baseUserDO.getStatus() == 1) {
            this.logger.info("\u53d1\u8d77\u8bc1\u4e66\u7b7e\u53d1\u7533\u8bf7\u7684\u7528\u6237\u5df2\u505c\u7528");
            result.setError(ErrorEnum.ISSUE_APPLY_USER_STATUS_IS_STOP);
            return result;
        }
        certApplyDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        certApplyDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(issueApplyDTO.getTempNo());
        if (certTempInfo == null) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        if (certTempInfo.getTempStatus() != 2 || certTempInfo.getTempBound() != 1) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u72b6\u6001\u4e0d\u53ef\u7528" + JsonUtils.object2Json((Object)certTempInfo));
            result.setError(ErrorEnum.CERT_TEMP_STATUS_IS_NOT_NORMAL);
            return result;
        }
        int applyStatus = 1;
        if (1 == certTempInfo.getCheckStrategy() || isOnlineIssue && !isNormal) {
            applyStatus = 3;
        }
        certApplyDO.setApplyStatus(Integer.valueOf(applyStatus));
        certApplyDO.setTempId(certTempInfo.getId());
        CertApplyDO addCertApply = this.certApplyDao.insertCertApply(certApplyDO);
        if (addCertApply == null) {
            this.logger.info("\u6dfb\u52a0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_CERT_APPLY_INFO_FAIL);
            return result;
        }
        IssueApplyDO issueApplyDO = new IssueApplyDO();
        issueApplyDO.setApplyId(addCertApply.getId());
        issueApplyDO.setSignAlg(issueApplyDTO.getSignAlg());
        issueApplyDO.setPrivateKeyLength(issueApplyDTO.getPrivateKeyLength());
        issueApplyDO.setCertValidity(issueApplyDTO.getCertValidity());
        issueApplyDO.setApplyReason(issueApplyDTO.getApplyReason());
        issueApplyDO.setTempParas(issueApplyDTO.getTempParas());
        Date date = new Date();
        issueApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        issueApplyDO.setGmtCreate(new Timestamp(date.getTime()));
        IssueApplyDO addIssueApply = this.issueApplyDao.insertIssueApply(issueApplyDO);
        if (addIssueApply == null) {
            this.logger.info("\u6dfb\u52a0\u7b7e\u53d1\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_ISSUE_CERT_APPLY_INFO_FAIL);
            throw new RuntimeException();
        }
        this.certApplyService.insertCertApplyRecord(1, 1, addCertApply.getApplyNo(), systemFlag, 1, issueApplyDTO.getApplyReason(), 1, false, isOnlineIssue);
        if (1 == certTempInfo.getCheckStrategy()) {
            this.certApplyService.insertCertApplyRecord(1, 3, addCertApply.getApplyNo(), systemFlag, 3, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, isOnlineIssue);
        }
        result.setInfo((Object)addCertApply.getApplyNo());
        return result;
    }

    @Transactional
    public Result updateUserCertIssueApply(String systemFlag, String applyNo, IssueApplyDTO issueApplyDTO, boolean isIgnoreApplyStatus, boolean isOnlineIssue) {
        String dnName;
        CertApplyDO certApplyDO;
        Result result = new Result();
        if (!isOnlineIssue) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }
        if ((certApplyDO = this.certApplyDao.getCertApplyInfo(applyNo)) == null) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int nowApplyStatus = certApplyDO.getApplyStatus();
        if (nowApplyStatus != 2) {
            this.logger.info("\u5f53\u524d\u7533\u8bf7\u72b6\u6001\uff0c\u4e0d\u53ef\u4fee\u6539\u7533\u8bf7\u4fe1\u606f");
            result.setError(ErrorEnum.APPLY_STATUS_CANNOT_UPDATE_INFO);
            return result;
        }
        BaseUserDO baseUserDO = null;
        try {
            baseUserDO = this.baseUserDao.getBaseUserInfo(issueApplyDTO.getUserId().longValue());
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u5f02\u5e38");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (baseUserDO == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }
        result.setLogContent("\uff0c\u7528\u6237ID=" + baseUserDO.getId());
        if (baseUserDO.getStatus() == 1) {
            this.logger.info("\u4fee\u6539\u8bc1\u4e66\u7b7e\u53d1\u7533\u8bf7\u7684\u7528\u6237\u5df2\u505c\u7528");
            result.setError(ErrorEnum.UPDATE_ISSUE_APPLY_USER_STATUS_IS_STOP);
            return result;
        }
        long applyId = certApplyDO.getId();
        IssueApplyDO issueApplyDO = this.issueApplyDao.getIssueApplyInfoByApplyId(applyId);
        if (issueApplyDO == null) {
            this.logger.info("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        issueApplyDO.setCertValidity(issueApplyDTO.getCertValidity());
        issueApplyDO.setApplyReason(issueApplyDTO.getApplyReason());
        issueApplyDO.setTempParas(issueApplyDTO.getTempParas());
        issueApplyDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        int updateIssueApplyResult = this.issueApplyDao.updateIssueApply(issueApplyDO);
        if (updateIssueApplyResult <= 0) {
            this.logger.info("\u66f4\u65b0\u7b7e\u53d1\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.UPDATE_ISSUE_CERT_APPLY_INFO_FAIL);
            return result;
        }
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(issueApplyDTO.getTempNo());
        if (certTempInfo == null) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        if (certTempInfo.getTempStatus() != 2 || certTempInfo.getTempBound() != 1) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u72b6\u6001\u4e0d\u53ef\u7528" + JsonUtils.object2Json((Object)certTempInfo));
            result.setError(ErrorEnum.CERT_TEMP_STATUS_IS_NOT_NORMAL);
            return result;
        }
        int applyStatus = 1;
        if (1 == certTempInfo.getCheckStrategy() || isIgnoreApplyStatus) {
            applyStatus = 3;
        }
        try {
            dnName = DnUtil.getRFC4519X500Name((String)issueApplyDTO.getCertDn()).toString();
        }
        catch (NamingException e) {
            result.setError(ErrorEnum.CERT_DN_IS_NOT_FORMAT);
            return result;
        }
        Result updateCertApplyResult = this.certApplyService.updateCertApplyInfo(dnName, applyNo, applyStatus, certTempInfo.getId());
        if (updateCertApplyResult.getCode() != 0) {
            this.logger.info("\u66f4\u65b0\u7533\u8bf7\u4fe1\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)updateCertApplyResult));
            throw new RuntimeException();
        }
        this.certApplyService.insertCertApplyRecord(1, 2, applyNo, systemFlag, 1, issueApplyDTO.getApplyReason(), 2, false, isOnlineIssue);
        if (1 == certTempInfo.getCheckStrategy()) {
            this.certApplyService.insertCertApplyRecord(1, 3, applyNo, systemFlag, 3, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, isOnlineIssue);
        }
        return result;
    }

    public Result insertIssueApplyBatch(TempInfoDTO tempInfoDTO, String userIds) {
        StringBuilder logContent;
        ExecutorService executorService = DatabaseTypeEnum.MYSQL.type == Constants.SYSTEM_DATABASE_TYPE ? Executors.newWorkStealingPool() : Executors.newSingleThreadExecutor();
        ArrayList<Future<Result>> listFuture = new ArrayList<Future<Result>>();
        Result result = new Result();
        String[] split = userIds.split(",");
        int success = 0;
        for (int i = 0; i < split.length; ++i) {
            Long l = Long.valueOf(split[i]);
            IssueApplyThread issueApplyThread = new IssueApplyThread(tempInfoDTO, l);
            Result resultFuture = new Result();
            Future<Result> submit = executorService.submit(issueApplyThread, resultFuture);
            listFuture.add(submit);
        }
        executorService.shutdown();
        for (Future future : listFuture) {
            try {
                Result submitResult = (Result)future.get();
                boolean isSuccess = submitResult.isSuccess();
                if (!isSuccess) continue;
                ++success;
            }
            catch (Exception e) {
                this.logger.error("\u6279\u91cf\u53d1\u8d77\u7ebf\u7a0b\u83b7\u53d6\u8fd4\u56de\u503c\u5f02\u5e38 ", (Throwable)e);
            }
        }
        if (success != split.length) {
            logContent = new StringBuilder("\uff0c\u6210\u529f\u6761\u6570=" + success + "\uff0c\u5931\u8d25\u6761\u6570=" + (split.length - success));
            result.setCode(-1);
        } else {
            logContent = new StringBuilder("\uff0c\u6210\u529f\u6761\u6570=" + success);
        }
        result.setLogContent(logContent.toString());
        return result;
    }

    public Result insertIssueApplyBatchOne(TempInfoDTO tempInfoDTO, Long userId) {
        Result result = new Result();
        IssueApplyDTO issueApplyDTO = new IssueApplyDTO();
        BeanUtils.copyProperties((Object)tempInfoDTO, (Object)issueApplyDTO);
        issueApplyDTO.setUserId(userId);
        BaseUserDO baseUserInfo = this.baseUserDao.getBaseUserInfo(userId.longValue());
        String certDn = "CN=";
        try {
            certDn = baseUserInfo.getUserType() == 3 ? certDn + HsmUtils.getDecrypt((String)baseUserInfo.getLicenseNumber()) : certDn + baseUserInfo.getUserName();
        }
        catch (Exception e) {
            this.logger.error("\u6279\u91cf\u53d1\u8d77\u7533\u8bf7\u5f02\u5e38DN\u6784\u9020\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
            return result;
        }
        certDn = certDn + tempInfoDTO.getBaseDn();
        issueApplyDTO.setCertDn(certDn);
        result = this.insertUserCertIssueApply(null, issueApplyDTO, false, false);
        return result;
    }
}

