/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.ca.utils.DnUtil;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.RecoveryApplyDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import com.xdja.pki.ra.manager.dao.model.RecoveryApplyDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.RecoveryApplyDTO;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.RecoveryApplyService;
import com.xdja.pki.ra.service.manager.certapply.bean.RecoveryApplyVO;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.util.OperatorUtil;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecoveryApplyServiceImpl
implements RecoveryApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RecoveryApplyDao recoveryApplyDao;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    RaCertDao raCertDao;
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    CertTempDao certTempDao;
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    CertApplyDao certApplyDao;
    @Autowired
    RaSdkCache raSdkCache;
    @Autowired
    CertTempCache certTempCache;

    public Result getRecoveryApplyInfo(String applyNo) {
        String decryptLicenseNumber;
        Result result = new Result();
        RecoveryApplyVO recoveryApplyVO = new RecoveryApplyVO();
        RecoveryApplyDTO recoveryApplyDTO = null;
        try {
            recoveryApplyDTO = this.recoveryApplyDao.getRecoveryApplyInfoByApplyNo(applyNo);
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("getIssueApplyInfoByApplyNo.applyNo:" + applyNo + " \u67e5\u8be2\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a");
        }
        if (recoveryApplyDTO == null) {
            this.logger.info("\u83b7\u53d6\u6062\u590d\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_RECOVERY_APPLY_INFO_IS_EMPTY);
            return result;
        }
        BeanUtils.copyProperties((Object)recoveryApplyDTO, (Object)recoveryApplyVO);
        try {
            decryptLicenseNumber = DecryptUserInfo.getDecryptString((String)recoveryApplyVO.getLicenseNumber());
        }
        catch (Exception e) {
            decryptLicenseNumber = recoveryApplyVO.getLicenseNumber();
        }
        recoveryApplyVO.setLicenseNumber(decryptLicenseNumber);
        Timestamp gmtCreate = recoveryApplyDTO.getGmtCreate();
        recoveryApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
        result.setInfo((Object)recoveryApplyVO);
        return result;
    }

    @Transactional
    public Result insertUserCertRecoveryApply(String systemFlag, RecoveryApplyDTO recoveryApplyDTO, boolean isOnlineRecovery) {
        String raServiceDnName;
        Result result = new Result();
        CertApplyDO certApplyDO = new CertApplyDO();
        if (!isOnlineRecovery) {
            Operator operator = OperatorUtil.getOperator();
            CurrentAdminInfo currentAdminInfo = new CurrentAdminInfo();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
            long adminId = currentAdminInfo.getId();
            String adminCertDn = currentAdminInfo.getCertDn();
            certApplyDO.setAdminId(Long.valueOf(adminId));
            certApplyDO.setAdminCertDn(adminCertDn);
        }
        if (StringUtils.isBlank((CharSequence)(raServiceDnName = this.getRAServiceDnName()))) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        BaseUserDO baseUserDO = null;
        try {
            baseUserDO = this.baseUserDao.getBaseUserInfo(recoveryApplyDTO.getUserId());
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (baseUserDO == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }
        if (baseUserDO.getStatus() == 1) {
            this.logger.info("\u5df2\u505c\u7528\u7528\u6237\u4e0d\u652f\u6301\u5bc6\u94a5\u6062\u590d\u7533\u8bf7");
            result.setError(ErrorEnum.RECOVERY_APPLY_USER_STATUS_IS_STOP);
            return result;
        }
        result.setLogContent("\uff0c\u7528\u6237ID=" + baseUserDO.getId());
        UserCertDO userCertBaseInfo = this.userCertDao.getUserCertBaseInfo(recoveryApplyDTO.getSignSn());
        if (userCertBaseInfo == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        long time = userCertBaseInfo.getFailureTime().getTime() - System.currentTimeMillis();
        if (1 != userCertBaseInfo.getCertStatus() || time < 0L) {
            this.logger.info("\u7528\u6237\u8bc1\u4e66\u4e0d\u662f\u6b63\u5e38\u72b6\u6001");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }
        String applyDO = this.raSdkCache.getIncApplyNo();
        certApplyDO.setApplyNo(applyDO);
        certApplyDO.setUserId(Long.valueOf(recoveryApplyDTO.getUserId()));
        certApplyDO.setApplyType(Integer.valueOf(4));
        try {
            certApplyDO.setCertDn(DnUtil.getRFC4519X500Name((String)userCertBaseInfo.getCertDn()).toString());
        }
        catch (NamingException e) {
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        result.setInfo((Object)certApplyDO.getApplyNo());
        result.setLogContent("\uff0c\u7533\u8bf7\u7f16\u53f7=" + certApplyDO.getApplyNo());
        long current = System.currentTimeMillis();
        certApplyDO.setGmtCreate(new Timestamp(current));
        certApplyDO.setGmtUpdate(new Timestamp(current));
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(recoveryApplyDTO.getTempNo());
        if (certTempInfo == null) {
            this.logger.info("\u8bc1\u4e66\u53d1\u8d77\u6062\u590d\u65f6\uff0c\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        this.logger.info("\u8bc1\u4e66\u53d1\u8d77\u6062\u590d\u65f6\uff0c\u5bf9\u5e94\u6a21\u677f\u7f16\u53f7\u4e3a{},\u5ba1\u6838\u7b56\u7565\u4e3a\u3010{}\u3011", (Object)certTempInfo.getTempNo(), (Object)(certTempInfo.getCheckStrategy() == 1 ? "\u81ea\u52a8" : "\u624b\u52a8"));
        int applyStatus = 1;
        if (1 == certTempInfo.getCheckStrategy()) {
            applyStatus = 3;
        }
        certApplyDO.setApplyStatus(Integer.valueOf(applyStatus));
        certApplyDO.setTempId(certTempInfo.getId());
        CertApplyDO addCertApply = this.certApplyDao.insertCertApply(certApplyDO);
        if (addCertApply == null) {
            this.logger.info("\u6dfb\u52a0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_CERT_APPLY_INFO_FAIL);
            return result;
        }
        RecoveryApplyDO recoveryApplyDO = new RecoveryApplyDO();
        BeanUtils.copyProperties((Object)recoveryApplyDTO, (Object)recoveryApplyDO);
        recoveryApplyDO.setApplyId(addCertApply.getId().longValue());
        recoveryApplyDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        recoveryApplyDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        recoveryApplyDO.setSignAlg(userCertBaseInfo.getSignAlg());
        recoveryApplyDO.setCertValidity(userCertBaseInfo.getCertValidity().intValue());
        recoveryApplyDO.setPrivateKeyLength(userCertBaseInfo.getPrivateKeyLength().intValue());
        RecoveryApplyDO addRecoveryApply = this.recoveryApplyDao.insertRecoveryApply(recoveryApplyDO);
        if (addRecoveryApply == null) {
            this.logger.info("\u6dfb\u52a0\u6062\u590d\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_RECOVERY_CERT_APPLY_INFO_FAIL);
            throw new RuntimeException();
        }
        this.certApplyService.insertCertApplyRecord(4, 1, addCertApply.getApplyNo(), systemFlag, 1, recoveryApplyDTO.getApplyReason(), 1, false, isOnlineRecovery);
        if (1 == certTempInfo.getCheckStrategy()) {
            this.certApplyService.insertCertApplyRecord(4, 3, addCertApply.getApplyNo(), systemFlag, 3, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, isOnlineRecovery);
        }
        return result;
    }

    private String getRAServiceDnName() {
        RaCertDO newRaCertInfo = null;
        try {
            newRaCertInfo = this.raCertDao.getNewRaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
        if (newRaCertInfo == null) {
            return null;
        }
        String certInfo = newRaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        String raServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return raServiceDnName;
    }

    private String getCAServiceDnName() {
        CaCertDO newCaCertInfo = null;
        try {
            newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
        if (newCaCertInfo == null) {
            return null;
        }
        String certInfo = newCaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        String caServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return caServiceDnName;
    }
}

