/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.certapply;

import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.ApplyRecordDao;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.RevokeApplyDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import com.xdja.pki.ra.manager.dao.model.RevokeApplyDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.RevokeApplyDTO;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.RevokeApplyService;
import com.xdja.pki.ra.service.manager.certapply.bean.RevokeApplyVO;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.ra.service.manager.system.CaService;
import com.xdja.pki.ra.service.manager.system.RaServer;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.util.OperatorUtil;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RevokeApplyServiceImpl
implements RevokeApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RaServer raServer;
    @Autowired
    CaService caService;
    @Autowired
    CertApplyDao certApplyDao;
    @Autowired
    RevokeApplyDao revokeApplyDao;
    @Autowired
    CertTempDao certTempDao;
    @Autowired
    ApplyRecordDao applyRecordDao;
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    UserCertService userCertService;
    @Autowired
    CertLifeCycleManager certLifeCycleManager;
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    RaCertDao raCertDao;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    RaSdkCache raSdkCache;
    @Autowired
    CertTempCache certTempCache;

    public Result getRevokeApplyInfo(String applyNo) {
        Result result = new Result();
        RevokeApplyVO revokeApplyVO = new RevokeApplyVO();
        RevokeApplyDTO revokeApplyInfoByApplyNo = null;
        try {
            revokeApplyInfoByApplyNo = this.revokeApplyDao.getRevokeApplyInfoByApplyNo(applyNo);
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("getRevokeApplyInfo.applyNo:" + applyNo + " \u67e5\u8be2\u64a4\u9500\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a");
        }
        if (revokeApplyInfoByApplyNo == null) {
            this.logger.info("\u83b7\u53d6\u64a4\u9500\u8bc1\u4e66\u7533\u8bf7\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_REVOKE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        BeanUtils.copyProperties((Object)revokeApplyInfoByApplyNo, (Object)revokeApplyVO);
        String decryptLicenseNumber = null;
        try {
            decryptLicenseNumber = DecryptUserInfo.getDecryptString((String)revokeApplyVO.getLicenseNumber());
        }
        catch (Exception e) {
            decryptLicenseNumber = revokeApplyVO.getLicenseNumber();
        }
        revokeApplyVO.setLicenseNumber(decryptLicenseNumber);
        Timestamp gmtCreate = revokeApplyInfoByApplyNo.getGmtCreate();
        revokeApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
        result.setInfo((Object)revokeApplyVO);
        return result;
    }

    @Transactional
    public Result insertUserCertRevokeApply(String systemFlag, RevokeApplyDTO revokeApplyDTO, boolean isOnlineRevoke, boolean isNormal) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        UserCertDO userCertDO = this.userCertDao.getUserCertBaseInfo(revokeApplyDTO.getSignSn());
        if (userCertDO == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        long time = userCertDO.getFailureTime().getTime() - System.currentTimeMillis();
        if (1 != userCertDO.getCertStatus() && 4 != userCertDO.getCertStatus() || time < 0L) {
            this.logger.info("\u7528\u6237\u8bc1\u4e66\u4e0d\u662f\u53ef\u64a4\u9500\u72b6\u6001");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }
        CertApplyDO certApplyDO = new CertApplyDO();
        if (isOnlineRevoke && !isNormal) {
            String licenseNumber;
            try {
                licenseNumber = this.baseUserDao.getLicenseNumberById(userCertDO.getUserId().longValue());
                licenseNumber = DecryptUserInfo.getDecryptString((String)licenseNumber);
            }
            catch (Exception e) {
                this.logger.info("\u67e5\u8be2\u8bc1\u4e66\u5bf9\u5e94\u7684\u8bbe\u5907\u7f16\u53f7\u4e3a\u7a7a", (Throwable)e);
                result.setError(ErrorEnum.ONLINE_DEVICE_INFO_NOT_EXIST);
                return result;
            }
            if (!licenseNumber.equals(revokeApplyDTO.getLicenseNumber())) {
                this.logger.info("\u8bbe\u5907\u7f16\u53f7\u548csn\u5bf9\u5e94\u8bc1\u4e66\u4e0d\u5339\u914d");
                result.setError(ErrorEnum.ONLINE_DEVICE_NO_GET_CERT_ERROR);
                return result;
            }
            certApplyDO.setUserId(userCertDO.getUserId());
        }
        if (!isOnlineRevoke) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
            long adminId = currentAdminInfo.getId();
            String adminCertDn = currentAdminInfo.getCertDn();
            certApplyDO.setAdminId(Long.valueOf(adminId));
            certApplyDO.setAdminCertDn(adminCertDn);
        }
        certApplyDO.setCertDn(userCertDO.getCertDn());
        if (certApplyDO.getUserId() == null) {
            certApplyDO.setUserId(revokeApplyDTO.getUserId());
        }
        String applyDO = this.raSdkCache.getIncApplyNo();
        certApplyDO.setApplyNo(applyDO);
        certApplyDO.setApplyType(Integer.valueOf(3));
        result.setLogContent("\uff0c\u7533\u8bf7\u7f16\u53f7=" + certApplyDO.getApplyNo());
        certApplyDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        certApplyDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(revokeApplyDTO.getTempNo());
        if (certTempInfo == null) {
            this.logger.info("\u8bc1\u4e66\u53d1\u8d77\u64a4\u9500\u65f6\uff0c\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        this.logger.info("\u8bc1\u4e66\u53d1\u8d77\u64a4\u9500\u65f6\uff0c\u5bf9\u5e94\u6a21\u677f\u7f16\u53f7\u4e3a{},\u5ba1\u6838\u7b56\u7565\u4e3a\u3010{}\u3011", (Object)certTempInfo.getTempNo(), (Object)(certTempInfo.getCheckStrategy() == 1 ? "\u81ea\u52a8" : "\u624b\u52a8"));
        this.certApplyService.insertCertApplyRecord(3, 1, certApplyDO.getApplyNo(), systemFlag, 1, revokeApplyDTO.getApplyReason(), 1, false, isOnlineRevoke);
        int applyStatus = 1;
        if (1 == certTempInfo.getCheckStrategy() || isOnlineRevoke && !isNormal) {
            this.certApplyService.insertCertApplyRecord(3, 3, certApplyDO.getApplyNo(), systemFlag, 0, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, isOnlineRevoke);
            Result revokeResult = this.certLifeCycleManager.revokeUserCert(certApplyDO.getApplyNo(), raServiceDnName, caServiceDnName, revokeApplyDTO.getSignSn(), revokeApplyDTO.getCertDn(), revokeApplyDTO.getRevokeReason().intValue(), revokeApplyDTO.getApplyReason());
            if (!revokeResult.isSuccess()) {
                this.logger.info("\u53d1\u8d77\u8bc1\u4e66\u64a4\u9500\u5931\u8d25 errorCode:" + revokeResult.getErrorBean().getErrCode());
                result.setErrorBean(revokeResult.getErrorBean());
                applyStatus = 6;
                this.certApplyService.insertCertApplyRecord(3, 4, certApplyDO.getApplyNo(), systemFlag, applyStatus, "\u8bc1\u4e66\u64a4\u9500\u5931\u8d25code:" + revokeResult.getErrorBean().getErrCode(), 5, false, isOnlineRevoke);
            } else {
                applyStatus = 7;
                this.certApplyService.insertCertApplyRecord(3, 4, certApplyDO.getApplyNo(), systemFlag, applyStatus, revokeApplyDTO.getApplyReason(), 6, false, isOnlineRevoke);
                Result updateStatusResult = this.userCertService.updateUserCertStatus(3, revokeApplyDTO.getSignSn());
                if (!updateStatusResult.isSuccess()) {
                    this.logger.info("\u66f4\u65b0\u8bc1\u4e66\u72b6\u6001\u9519\u8bef:" + JsonUtils.object2Json((Object)updateStatusResult));
                    result.setError(updateStatusResult.getError());
                    return result;
                }
            }
        }
        certApplyDO.setApplyStatus(Integer.valueOf(applyStatus));
        certApplyDO.setTempId(certTempInfo.getId());
        CertApplyDO addCertApply = this.certApplyDao.insertCertApply(certApplyDO);
        RevokeApplyDO revokeApplyDO = new RevokeApplyDO();
        revokeApplyDO.setSignSn(revokeApplyDTO.getSignSn());
        revokeApplyDO.setEncSn(revokeApplyDTO.getEncSn());
        revokeApplyDO.setApplyId(addCertApply.getId());
        revokeApplyDO.setRevokeReason(revokeApplyDTO.getRevokeReason());
        revokeApplyDO.setApplyReason(revokeApplyDTO.getApplyReason());
        revokeApplyDO.setSignAlg(userCertDO.getSignAlg());
        revokeApplyDO.setPrivateKeyLength(userCertDO.getPrivateKeyLength());
        revokeApplyDO.setCertValidity(userCertDO.getCertValidity());
        Date date = new Date();
        revokeApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        revokeApplyDO.setGmtCreate(new Timestamp(date.getTime()));
        this.revokeApplyDao.insertRevokeApply(revokeApplyDO);
        result.setInfo((Object)addCertApply.getApplyNo());
        return result;
    }

    @Transactional
    public Result updateUserCertRevokeApply(String systemFlag, String applyNo, RevokeApplyDTO revokeApplyDTO, boolean isOnlineRevoke) {
        Result updateCertApplyResult;
        CertApplyDO certApplyDO;
        Result result = new Result();
        if (!isOnlineRevoke) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }
        if ((certApplyDO = this.certApplyDao.getCertApplyInfo(applyNo)) == null) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int nowApplyStatus = certApplyDO.getApplyStatus();
        if (nowApplyStatus != 2) {
            this.logger.info("\u5f53\u524d\u7533\u8bf7\u72b6\u6001\uff0c\u4e0d\u53ef\u4fee\u6539\u7533\u8bf7\u4fe1\u606f");
            result.setError(ErrorEnum.APPLY_STATUS_CANNOT_UPDATE_INFO);
            return result;
        }
        UserCertDO userCertBaseInfo = this.userCertDao.getUserCertBaseInfo(revokeApplyDTO.getSignSn());
        if (userCertBaseInfo == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        long time = userCertBaseInfo.getFailureTime().getTime() - System.currentTimeMillis();
        if (1 != userCertBaseInfo.getCertStatus() && 4 != userCertBaseInfo.getCertStatus() || time < 0L) {
            this.logger.info("\u7528\u6237\u8bc1\u4e66\u4e0d\u662f\u53ef\u64a4\u9500\u72b6\u6001");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }
        long applyId = certApplyDO.getId();
        RevokeApplyDO revokeApplyDO = this.revokeApplyDao.getRevokeApplyInfoByApplyId(applyId);
        if (revokeApplyDO == null) {
            this.logger.info("\u83b7\u53d6\u64a4\u9500\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_REVOKE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        revokeApplyDO.setApplyReason(revokeApplyDTO.getApplyReason());
        revokeApplyDO.setRevokeReason(revokeApplyDTO.getRevokeReason());
        revokeApplyDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        int updateRevokeApplyResult = this.revokeApplyDao.updateRevokeApply(revokeApplyDO);
        if (updateRevokeApplyResult <= 0) {
            this.logger.info("\u66f4\u65b0\u64a4\u9500\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.UPDATE_REVOKE_CERT_APPLY_INFO_FAIL);
            return result;
        }
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(revokeApplyDTO.getTempNo());
        if (certTempInfo == null) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        this.certApplyService.insertCertApplyRecord(3, 2, applyNo, systemFlag, 1, revokeApplyDTO.getApplyReason(), 2, false, isOnlineRevoke);
        int applyStatus = 1;
        if (1 == certTempInfo.getCheckStrategy()) {
            this.certApplyService.insertCertApplyRecord(3, 3, certApplyDO.getApplyNo(), systemFlag, 0, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, isOnlineRevoke);
            String raServiceDnName = this.getRAServiceDnName();
            if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
                result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
                return result;
            }
            String caServiceDnName = this.getCAServiceDnName();
            if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
                result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
                return result;
            }
            Result revokeResult = this.certLifeCycleManager.revokeUserCert(applyNo, raServiceDnName, caServiceDnName, revokeApplyDTO.getSignSn(), revokeApplyDTO.getCertDn(), revokeApplyDTO.getRevokeReason().intValue(), revokeApplyDTO.getApplyReason());
            if (!revokeResult.isSuccess()) {
                this.logger.info("\u53d1\u8d77\u8bc1\u4e66\u64a4\u9500\u5931\u8d25 errorCode:" + revokeResult.getErrorBean().getErrCode());
                result.setErrorBean(revokeResult.getErrorBean());
                applyStatus = 6;
                this.certApplyService.insertCertApplyRecord(3, 4, applyNo, systemFlag, applyStatus, "\u8bc1\u4e66\u64a4\u9500\u5931\u8d25code:" + revokeResult.getErrorBean().getErrCode(), 5, false, isOnlineRevoke);
            } else {
                applyStatus = 7;
                this.certApplyService.insertCertApplyRecord(3, 4, applyNo, systemFlag, applyStatus, revokeApplyDTO.getApplyReason(), 6, false, isOnlineRevoke);
            }
        }
        if (!(updateCertApplyResult = this.certApplyService.updateCertApplyInfo(revokeApplyDTO.getCertDn(), applyNo, applyStatus, certTempInfo.getId())).isSuccess()) {
            this.logger.info("\u66f4\u65b0\u7533\u8bf7\u4fe1\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)updateCertApplyResult));
            throw new RuntimeException();
        }
        return result;
    }

    private String getRAServiceDnName() {
        RaCertDO newRaCertInfo = null;
        try {
            newRaCertInfo = this.raCertDao.getNewRaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
        if (newRaCertInfo == null) {
            return null;
        }
        String certInfo = newRaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        String raServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return raServiceDnName;
    }

    private String getCAServiceDnName() {
        CaCertDO newCaCertInfo = null;
        try {
            newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
        if (newCaCertInfo == null) {
            return null;
        }
        String certInfo = newCaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        String caServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return caServiceDnName;
    }
}

