/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.certapply;

import com.alibaba.fastjson.JSONObject;
import com.xdja.ca.utils.DnUtil;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.ApplyRecordDao;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.UpdateApplyDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.UpdateApplyDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.UpdateApplyDTO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.baseuser.bean.DecryptUserInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.UpdateApplyService;
import com.xdja.pki.ra.service.manager.certapply.bean.UpdateApplyVO;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.util.OperatorUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpdateApplyServiceImpl
implements UpdateApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UpdateApplyDao updateApplyDao;
    @Autowired
    CertApplyDao certApplyDao;
    @Autowired
    CertTempDao certTempDao;
    @Autowired
    ApplyRecordDao applyRecordDao;
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    RaSdkCache raSdkCache;
    @Autowired
    CertTempCache certTempCache;

    public Result getUpdateApplyInfo(String applyNo) {
        UpdateApplyDTO updateApplyInfoByApplyNo;
        Result result = new Result();
        UpdateApplyVO updateApplyVO = new UpdateApplyVO();
        try {
            updateApplyInfoByApplyNo = this.updateApplyDao.getUpdateApplyInfoByApplyNo(applyNo);
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("getUpdateApplyInfo.applyNo:" + applyNo + " \u67e5\u8be2\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a");
            throw new RuntimeException(e);
        }
        if (updateApplyInfoByApplyNo == null) {
            this.logger.info("\u83b7\u53d6\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        BeanUtils.copyProperties((Object)updateApplyInfoByApplyNo, (Object)updateApplyVO);
        String decryptLicenseNumber = null;
        try {
            decryptLicenseNumber = DecryptUserInfo.getDecryptString((String)updateApplyVO.getLicenseNumber());
        }
        catch (Exception e) {
            decryptLicenseNumber = updateApplyVO.getLicenseNumber();
        }
        updateApplyVO.setLicenseNumber(decryptLicenseNumber);
        int leftDates = (int)((updateApplyInfoByApplyNo.getFailureTime().getTime() - System.currentTimeMillis()) / 86400000L);
        updateApplyVO.setLeftValidity(Integer.valueOf(leftDates));
        updateApplyVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(updateApplyInfoByApplyNo.getGmtCreate()));
        updateApplyVO.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(updateApplyInfoByApplyNo.getEffectiveTime()));
        updateApplyVO.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(updateApplyInfoByApplyNo.getFailureTime()));
        String signSn = updateApplyInfoByApplyNo.getSignSn();
        Result certDetailResult = this.caBusinessManager.getCertDetailInfoBySingSn(signSn);
        if (!certDetailResult.isSuccess()) {
            return certDetailResult;
        }
        JSONObject json = JSONObject.parseObject((String)String.valueOf(certDetailResult.getInfo()));
        String oldSubject = json.getString("subject");
        if (!updateApplyVO.getCertDn().equals(oldSubject)) {
            updateApplyVO.setOldCertDn(oldSubject);
        }
        String notafter = json.getString("notafter");
        String notbefore = json.getString("notbefore");
        if (updateApplyInfoByApplyNo.getUpdateValidity().booleanValue()) {
            notbefore = notbefore.substring(0, 10).replace(".", "-");
            notafter = notafter.substring(0, 10).replace(".", "-");
            updateApplyVO.setOldNotBefore(notbefore);
            updateApplyVO.setOldNotAfter(notafter);
        } else {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                int time = (int)((sdf.parse(notafter).getTime() - sdf.parse(notbefore).getTime()) / 86400000L);
                updateApplyVO.setCertValidity(Integer.valueOf(time));
            }
            catch (ParseException e) {
                this.logger.info("getUpdateApplyInfo.applyNo:" + applyNo + " \u8ba1\u7b97\u539f\u8bc1\u4e66\u6709\u6548\u671f\u5f02\u5e38");
                throw new RuntimeException(e);
            }
        }
        result.setInfo((Object)updateApplyVO);
        return result;
    }

    public Result insertCertUpdateApply(UpdateApplyDTO updateApplyDTO, UserCertDO userCertDO, CertTempDO certTempInfo, boolean isNormal) {
        Result result = new Result();
        CertApplyDO certApplyDO = new CertApplyDO();
        certApplyDO.setApplyNo(updateApplyDTO.getApplyNo());
        certApplyDO.setUserId(updateApplyDTO.getUserId());
        certApplyDO.setApplyType(Integer.valueOf(2));
        certApplyDO.setCertDn(updateApplyDTO.getCertDn());
        certApplyDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        certApplyDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        if (1 == certTempInfo.getCheckStrategy() || !isNormal) {
            certApplyDO.setApplyStatus(Integer.valueOf(3));
        } else {
            certApplyDO.setApplyStatus(Integer.valueOf(1));
        }
        certApplyDO.setTempId(certTempInfo.getId());
        CertApplyDO addCertApply = this.certApplyDao.insertCertApply(certApplyDO);
        if (addCertApply == null) {
            this.logger.info("\u6dfb\u52a0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_CERT_APPLY_INFO_FAIL);
            return result;
        }
        UpdateApplyDO updateApplyDO = new UpdateApplyDO();
        updateApplyDO.setApplyId(addCertApply.getId());
        updateApplyDO.setSignSn(updateApplyDTO.getSignSn());
        updateApplyDO.setEncSn(updateApplyDTO.getEncSn());
        updateApplyDO.setSignAlg(updateApplyDTO.getSignAlg());
        updateApplyDO.setPrivateKeyLength(updateApplyDTO.getPrivateKeyLength());
        updateApplyDO.setApplyReason(updateApplyDTO.getApplyReason());
        updateApplyDO.setTempParas(updateApplyDTO.getTempParas());
        updateApplyDO.setIsUpdateKey(Integer.valueOf(updateApplyDTO.getUpdateKey() != false ? 1 : 0));
        updateApplyDO.setIsUpdateValidity(Integer.valueOf(updateApplyDTO.getUpdateValidity() != false ? 1 : 0));
        Date date = new Date();
        if (updateApplyDTO.getUpdateValidity().booleanValue() && updateApplyDTO.getCertValidity() != null) {
            updateApplyDO.setEffectiveTime(new Timestamp(date.getTime()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, updateApplyDTO.getCertValidity());
            updateApplyDO.setFailureTime(new Timestamp(calendar.getTime().getTime()));
            updateApplyDO.setCertValidity(updateApplyDTO.getCertValidity());
        } else {
            updateApplyDO.setEffectiveTime(userCertDO.getEffectiveTime());
            updateApplyDO.setFailureTime(userCertDO.getFailureTime());
            updateApplyDO.setCertValidity(userCertDO.getCertValidity());
        }
        updateApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        updateApplyDO.setGmtCreate(new Timestamp(date.getTime()));
        UpdateApplyDO addUpdateApply = this.updateApplyDao.insertUpdateApply(updateApplyDO);
        if (addUpdateApply == null) {
            this.logger.info("\u6dfb\u52a0\u66f4\u65b0\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_UPDATE_CERT_APPLY_INFO_FAIL);
            throw new RuntimeException();
        }
        result.setInfo((Object)addCertApply.getId());
        return result;
    }

    public static void main(String[] args) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String notbefore = "2023-03-27 15:56:43";
        notbefore = notbefore.substring(0, 10).replace(".", "-");
        long time = sdf.parse(notbefore).getTime();
        System.out.println(time);
    }

    @Transactional
    public Result insertUserCertUpdateApply(String systemFlag, UpdateApplyDTO updateApplyDTO, boolean isOnlineUpdate, boolean isNormal) {
        String dnName;
        BaseUserDO baseUserDO;
        Result result = new Result();
        CurrentAdminInfo currentAdminInfo = null;
        if (!isOnlineUpdate) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }
        try {
            baseUserDO = this.baseUserDao.getBaseUserInfo(updateApplyDTO.getUserId().longValue());
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u5f02\u5e38");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (baseUserDO == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }
        if (baseUserDO.getStatus() == 1) {
            this.logger.info("\u53d1\u8d77\u8bc1\u4e66\u66f4\u65b0\u7533\u8bf7\u7684\u7528\u6237\u5df2\u505c\u7528");
            result.setError(ErrorEnum.UPDATE_APPLY_USER_STATUS_IS_STOP);
            return result;
        }
        result.setLogContent("\uff0c\u7528\u6237ID=" + baseUserDO.getId());
        UserCertDO userCertBaseInfo = this.userCertDao.getUserCertBaseInfo(updateApplyDTO.getSignSn());
        if (userCertBaseInfo == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        long time = userCertBaseInfo.getFailureTime().getTime() - System.currentTimeMillis();
        if (1 != userCertBaseInfo.getCertStatus() || time < 0L) {
            this.logger.info("\u7528\u6237\u8bc1\u4e66\u4e0d\u662f\u6b63\u5e38\u72b6\u6001");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }
        CertApplyDO certApplyDO = new CertApplyDO();
        String applyDO = this.raSdkCache.getIncApplyNo();
        certApplyDO.setApplyNo(applyDO);
        certApplyDO.setUserId(updateApplyDTO.getUserId());
        certApplyDO.setApplyType(Integer.valueOf(2));
        try {
            dnName = DnUtil.getRFC4519X500Name((String)updateApplyDTO.getCertDn()).toString();
        }
        catch (NamingException e) {
            this.logger.info("certDn\u4e0d\u6b63\u786e{}", (Object)e.getMessage());
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        certApplyDO.setCertDn(dnName);
        result.setLogContent(result.getLogContent() + "\uff0c\u7533\u8bf7\u7f16\u53f7=" + certApplyDO.getApplyNo());
        if (!isOnlineUpdate) {
            long adminId = currentAdminInfo.getId();
            String adminCertDn = currentAdminInfo.getCertDn();
            certApplyDO.setAdminId(Long.valueOf(adminId));
            certApplyDO.setAdminCertDn(adminCertDn);
        }
        certApplyDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        certApplyDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(updateApplyDTO.getTempNo());
        if (certTempInfo == null) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        if (certTempInfo.getTempStatus() != 2 || certTempInfo.getTempBound() != 1) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u72b6\u6001\u4e0d\u53ef\u7528" + JsonUtils.object2Json((Object)certTempInfo));
            result.setError(ErrorEnum.CERT_TEMP_STATUS_IS_NOT_NORMAL);
            return result;
        }
        int applyStatus = 1;
        if (1 == certTempInfo.getCheckStrategy() || isOnlineUpdate && !isNormal) {
            applyStatus = 3;
        }
        certApplyDO.setApplyStatus(Integer.valueOf(applyStatus));
        certApplyDO.setTempId(certTempInfo.getId());
        CertApplyDO addCertApply = this.certApplyDao.insertCertApply(certApplyDO);
        if (addCertApply == null) {
            this.logger.info("\u6dfb\u52a0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_CERT_APPLY_INFO_FAIL);
            return result;
        }
        result.setInfo((Object)addCertApply.getApplyNo());
        UpdateApplyDO updateApplyDO = new UpdateApplyDO();
        updateApplyDO.setApplyId(addCertApply.getId());
        updateApplyDO.setSignSn(updateApplyDTO.getSignSn());
        updateApplyDO.setEncSn(updateApplyDTO.getEncSn());
        updateApplyDO.setSignAlg(updateApplyDTO.getSignAlg());
        updateApplyDO.setPrivateKeyLength(updateApplyDTO.getPrivateKeyLength());
        updateApplyDO.setApplyReason(updateApplyDTO.getApplyReason());
        updateApplyDO.setTempParas(updateApplyDTO.getTempParas());
        updateApplyDO.setIsUpdateKey(Integer.valueOf(updateApplyDTO.getUpdateKey() != false ? 1 : 0));
        updateApplyDO.setIsUpdateValidity(Integer.valueOf(updateApplyDTO.getUpdateValidity() != false ? 1 : 0));
        Date date = new Date();
        if (updateApplyDTO.getUpdateValidity().booleanValue() && updateApplyDTO.getCertValidity() != null) {
            updateApplyDO.setEffectiveTime(new Timestamp(date.getTime()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, updateApplyDTO.getCertValidity());
            updateApplyDO.setFailureTime(new Timestamp(calendar.getTime().getTime()));
            updateApplyDO.setCertValidity(updateApplyDTO.getCertValidity());
        } else {
            updateApplyDO.setEffectiveTime(userCertBaseInfo.getEffectiveTime());
            updateApplyDO.setFailureTime(userCertBaseInfo.getFailureTime());
            updateApplyDO.setCertValidity(userCertBaseInfo.getCertValidity());
        }
        updateApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        updateApplyDO.setGmtCreate(new Timestamp(date.getTime()));
        UpdateApplyDO addUpdateApply = this.updateApplyDao.insertUpdateApply(updateApplyDO);
        if (addUpdateApply == null) {
            this.logger.info("\u6dfb\u52a0\u66f4\u65b0\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.INSERT_UPDATE_CERT_APPLY_INFO_FAIL);
            throw new RuntimeException();
        }
        this.certApplyService.insertCertApplyRecord(2, 1, addCertApply.getApplyNo(), systemFlag, 1, updateApplyDTO.getApplyReason(), 1, false, isOnlineUpdate);
        if (1 == certTempInfo.getCheckStrategy()) {
            this.certApplyService.insertCertApplyRecord(2, 3, addCertApply.getApplyNo(), systemFlag, 3, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, isOnlineUpdate);
        }
        return result;
    }

    @Transactional
    public Result updateUserCertUpdateApply(String systemFlag, String applyNo, UpdateApplyDTO updateApplyDTO, boolean isOnlineUpdate) {
        String dnName;
        CertApplyDO certApplyDO;
        Result result = new Result();
        if (!isOnlineUpdate) {
            Operator operator = OperatorUtil.getOperator();
            if (operator == null || operator.getCurrUser() == null) {
                result.setError(ErrorEnum.CANNOT_FIND_CURRENT_LOGIN_ADMIN);
                return result;
            }
            CurrentAdminInfo currentAdminInfo = (CurrentAdminInfo)operator.getCurrUser();
            List roleList = currentAdminInfo.getRoleList();
            if (!roleList.contains(3)) {
                result.setError(ErrorEnum.CURRENT_ADMIN_ROLE_IS_ERROR);
                return result;
            }
        }
        if ((certApplyDO = this.certApplyDao.getCertApplyInfo(applyNo)) == null) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_APPLY_INFO_IS_EMPTY);
            return result;
        }
        int nowApplyStatus = certApplyDO.getApplyStatus();
        if (nowApplyStatus != 2) {
            this.logger.info("\u5f53\u524d\u7533\u8bf7\u72b6\u6001\uff0c\u4e0d\u53ef\u4fee\u6539\u7533\u8bf7\u4fe1\u606f");
            result.setError(ErrorEnum.APPLY_STATUS_CANNOT_UPDATE_INFO);
            return result;
        }
        BaseUserDO baseUserDO = null;
        try {
            baseUserDO = this.baseUserDao.getBaseUserInfo(updateApplyDTO.getUserId().longValue());
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u5f02\u5e38");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EXCEPTION);
            return result;
        }
        if (baseUserDO == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8868\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_BASE_USER_INFO_IS_EMPTY);
            return result;
        }
        if (baseUserDO.getStatus() == 1) {
            this.logger.info("\u4fee\u6539\u8bc1\u4e66\u66f4\u65b0\u7533\u8bf7\u7684\u7528\u6237\u5df2\u505c\u7528");
            result.setError(ErrorEnum.UPDATE_UPDATE_APPLY_USER_STATUS_IS_STOP);
            return result;
        }
        result.setLogContent("\uff0c\u7528\u6237ID=" + baseUserDO.getId());
        UserCertDO userCertBaseInfo = this.userCertDao.getUserCertBaseInfo(updateApplyDTO.getSignSn());
        if (userCertBaseInfo == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        long time = userCertBaseInfo.getFailureTime().getTime() - System.currentTimeMillis();
        if (1 != userCertBaseInfo.getCertStatus() || time < 0L) {
            this.logger.info("\u7528\u6237\u8bc1\u4e66\u4e0d\u662f\u6b63\u5e38\u72b6\u6001");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }
        long applyId = certApplyDO.getId();
        UpdateApplyDO updateApplyDO = this.updateApplyDao.getUpdateApplyInfoByApplyId(applyId);
        if (updateApplyDO == null) {
            this.logger.info("\u83b7\u53d6\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_UPDATE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        updateApplyDO.setSignSn(updateApplyDTO.getSignSn());
        updateApplyDO.setEncSn(updateApplyDTO.getEncSn());
        updateApplyDO.setCertValidity(updateApplyDTO.getCertValidity());
        updateApplyDO.setApplyReason(updateApplyDTO.getApplyReason());
        updateApplyDO.setTempParas(updateApplyDTO.getTempParas());
        updateApplyDO.setIsUpdateKey(Integer.valueOf(updateApplyDTO.getUpdateKey() == true ? 1 : 0));
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(5, updateApplyDTO.getCertValidity());
        updateApplyDO.setFailureTime(new Timestamp(calendar.getTime().getTime()));
        updateApplyDO.setGmtUpdate(new Timestamp(date.getTime()));
        int updateApplyResult = this.updateApplyDao.updateUpdateApply(updateApplyDO);
        if (updateApplyResult <= 0) {
            this.logger.info("\u66f4\u65b0\u7b7e\u53d1\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            result.setError(ErrorEnum.UPDATE_UPDATE_CERT_APPLY_INFO_FAIL);
            return result;
        }
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(updateApplyDTO.getTempNo());
        if (certTempInfo == null) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        if (certTempInfo.getTempStatus() != 2 || certTempInfo.getTempBound() != 1) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u72b6\u6001\u4e0d\u53ef\u7528" + JsonUtils.object2Json((Object)certTempInfo));
            result.setError(ErrorEnum.CERT_TEMP_STATUS_IS_NOT_NORMAL);
            return result;
        }
        int applyStatus = 1;
        if (1 == certTempInfo.getCheckStrategy()) {
            applyStatus = 3;
        }
        try {
            dnName = DnUtil.getRFC4519X500Name((String)updateApplyDTO.getCertDn()).toString();
        }
        catch (NamingException e) {
            this.logger.info("certDn\u4e0d\u6b63\u786e{}", (Object)e.getMessage());
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        Result updateCertApplyResult = this.certApplyService.updateCertApplyInfo(dnName, applyNo, applyStatus, certTempInfo.getId());
        if (!updateCertApplyResult.isSuccess()) {
            this.logger.info("\u66f4\u65b0\u7533\u8bf7\u4fe1\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)updateCertApplyResult));
            throw new RuntimeException();
        }
        this.certApplyService.insertCertApplyRecord(2, 2, applyNo, systemFlag, 1, updateApplyDTO.getApplyReason(), 2, false, isOnlineUpdate);
        if (1 == certTempInfo.getCheckStrategy()) {
            this.certApplyService.insertCertApplyRecord(2, 3, applyNo, systemFlag, 3, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, isOnlineUpdate);
        }
        return result;
    }
}

